/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/

#include "qzyre.h"

///
//  Copy-construct to return the proper wrapped c types
QZyreEvent::QZyreEvent (zyre_event_t *self, QObject *qObjParent) : QObject (qObjParent)
{
    this->self = self;
}


///
//  Constructor: receive an event from the zyre node, wraps zyre_recv.
//  The event may be a control message (ENTER, EXIT, JOIN, LEAVE) or  
//  data (WHISPER, SHOUT).                                            
QZyreEvent::QZyreEvent (QZyre *node, QObject *qObjParent) : QObject (qObjParent)
{
    this->self = zyre_event_new (node->self);
}

///
//  Destructor; destroys an event instance
QZyreEvent::~QZyreEvent ()
{
    zyre_event_destroy (&self);
}

///
//  Returns event type, as printable uppercase string. Choices are:   
//  "ENTER", "EXIT", "JOIN", "LEAVE", "EVASIVE", "WHISPER" and "SHOUT"
//  and for the local node: "STOP"                                    
const QString QZyreEvent::type ()
{
    const QString rv = QString (zyre_event_type (self));
    return rv;
}

///
//  Return the sending peer's uuid as a string
const QString QZyreEvent::peerUuid ()
{
    const QString rv = QString (zyre_event_peer_uuid (self));
    return rv;
}

///
//  Return the sending peer's public name as a string
const QString QZyreEvent::peerName ()
{
    const QString rv = QString (zyre_event_peer_name (self));
    return rv;
}

///
//  Return the sending peer's ipaddress as a string
const QString QZyreEvent::peerAddr ()
{
    const QString rv = QString (zyre_event_peer_addr (self));
    return rv;
}

///
//  Returns the event headers, or NULL if there are none
QZhash * QZyreEvent::headers ()
{
    QZhash *rv = new QZhash (zyre_event_headers (self));
    return rv;
}

///
//  Returns value of a header from the message headers   
//  obtained by ENTER. Return NULL if no value was found.
const QString QZyreEvent::header (const QString &name)
{
    const QString rv = QString (zyre_event_header (self, name.toUtf8().data()));
    return rv;
}

///
//  Returns the group name that a SHOUT event was sent to
const QString QZyreEvent::group ()
{
    const QString rv = QString (zyre_event_group (self));
    return rv;
}

///
//  Returns the incoming message payload; the caller can modify the
//  message but does not own it and should not destroy it.         
QZmsg * QZyreEvent::msg ()
{
    QZmsg *rv = new QZmsg (zyre_event_msg (self));
    return rv;
}

///
//  Returns the incoming message payload, and pass ownership to the   
//  caller. The caller must destroy the message when finished with it.
//  After called on the given event, further calls will return NULL.  
QZmsg * QZyreEvent::getMsg ()
{
    QZmsg *rv = new QZmsg (zyre_event_get_msg (self));
    return rv;
}

///
//  Print event to zsys log
void QZyreEvent::print ()
{
    zyre_event_print (self);
    
}

///
//  Self test of this class.
void QZyreEvent::test (bool verbose)
{
    zyre_event_test (verbose);
    
}
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/
