/*
 * Copyright (C) by Daniel Molkentin <danimo@owncloud.com>, ownCloud Inc.
 */

#ifndef TESTPILOTS_THEME_H
#define TESTPILOTS_THEME_H

#include "theme.h"

#include <QString>
#include <QDebug>
#include <QPixmap>
#include <QIcon>
#include <QApplication>

#ifndef Q_DECL_OVERRIDE
# define Q_DECL_OVERRIDE
#endif

namespace OCC {

class TestpilotCloudTheme : public Theme
{
public:
    TestpilotCloudTheme() : Theme() {}

    QString configFileName()     const Q_DECL_OVERRIDE { return QLatin1String("testpilotcloud.cfg"); }
    QIcon   applicationIcon()    const Q_DECL_OVERRIDE { return themeIcon( QLatin1String("testpilotcloud-icon") ); }
    bool wizardSelectiveSyncDefaultNothing() const Q_DECL_OVERRIDE { return true; }
//    Add a default remote folder to the testpilot to help testing #2788
//    QString defaultServerFolder() const Q_DECL_OVERRIDE { return QLatin1String("/documents"); }
    QString defaultServerFolder() const Q_DECL_OVERRIDE { return QLatin1String("/"); }
};

} // namespace OCC

#endif // TESTPILOTS_THEME_H
