#!/bin/bash

# Put the conf here:
ocsite="owncloud_vhost.conf"
vhost_conf_dir="/etc/apache2/sites-available"

certfile="/etc/ssl/certs/certificate.pem"
keyfile="/etc/ssl/private/private_key.pem"
chainfile="/etc/ssl/certs/intermediates.pem"

if [ ! -e /etc/ssl/certs/certificate.pem ]; then
  gen_self_signed_cert /usr/local/share/openssl/oc_appliance.cnf.tmpl
  sslFiles="SSLCertificateFile /etc/ssl/certs/self_signed.crt
    SSLCertificateKeyFile /etc/ssl/private/self_signed.key
    Header add Strict-Transport-Security: \"max-age=15768000;includeSubdomains\""
else
  sslFiles="SSLCertificateFile $certfile
    SSLCertificateKeyFile $keyfile"

  if [ -e $chainfile ]; then
    sslFiles="\n    SSLCertificateChainFile $chainfile"
  fi
fi

cat << SSL_CREATE > "$vhost_conf_dir/$ocsite"
<VirtualHost *:80>
    DocumentRoot /var/www/owncloud

    # This appliance has two use cases:
    #
    # 1) NAT/Port forward mode: HTTP port is not the default
    #    -> redirect to HTTPS port 4443
    RewriteEngine On
    RewriteCond %{HTTPS} off
    RewriteCond %{HTTP_HOST} ^([^:]+)(:[0-9]+)?$
    RewriteCond %2 "!^$"
    RewriteCond %{HTTP_HOST} ^([^:]+)(:[0-9]+)?$
    RewriteRule (.*) https://%1:4443%{REQUEST_URI} [L]

    # 2) Bridge mode: HTTP port is default
    #    -> redirect to default HTTPS port (443)
    RewriteCond %{HTTP_HOST} ^([^:]+)(:[0-9]+)?$
    RewriteRule (.*) https://%1%{REQUEST_URI} [L]

    ErrorLog /var/log/apache2/error.log
    CustomLog /var/log/apache2/access.log combined
</VirtualHost>

<VirtualHost *:443>
    DocumentRoot /var/www/owncloud
    <Directory /var/www/owncloud>
        AllowOverride All
        Require all granted
    </Directory>

    SSLEngine on
    $sslFiles

    ErrorLog /var/log/apache2/error.log
    CustomLog /var/log/apache2/access.log combined
</VirtualHost>

SSL_CREATE

a2ensite $ocsite
a2dissite 000-default
service apache2 restart
