#!/bin/bash
#
# check-init.sh
#
# Done here, if owncloud is found uninitialized:
# * generate random password,
# * change password of owncloud shell users.
# * initialize owncloud.
# * set secure permissions
# * rm owncloud.log for clean logs

#exec 3>&1 1>>/var/log/check-init.log 2>&1

PATH=/bin:/usr/bin:/usr/local/bin:/sbin:/usr/sbin:/usr/local/sbin

mysql_pass=admin	# KEEP in sync with build-ubuntu-vm.sh
cred_file_dir=/var/scripts/www
cred_file=$cred_file_dir/init-credentials.sh
oc=/var/www/owncloud
ocdata=/var/lib/owncloud

# initialize owncloud and populate $cred_file (only on firstboot...)
if (sudo -u www-data php $oc/occ status 2>&1 | grep -q ' is not installed '); then

  password=$(pwgen -B 10 1)
  # Keep the oc prefix, id's starting in numbers can break OC
  instanceid=oc$(pwgen -B 20 1)

  mkdir -p $cred_file_dir
  chown www-data $cred_file_dir
  chmod 775 $cred_file_dir

  mkdir -p $ocdata
  chown www-data $ocdata
  chmod 755 $ocdata

  echo Your new owncloud password will be $password | tee /dev/fd/3
  echo -e "root:$password\nowncloud:$password" | chpasswd
  echo -e "user=owncloud\npassword=$password" > $cred_file

  occ maintenance:install --database mysql --database-name=oc --database-host=localhost --database-user=root --database-pass=admin --no-interaction --no-ansi --admin-pass=$password --data-dir=$ocdata

  # Move log out of data dir
  occ config:system:set 'logfile' --value '/var/log/owncloud.log'
  # check now.
  occ status
fi

## one address to rule them all, or something ...
GATEWAY=$(ip r | grep default | sed -e 's@.* dev \(\S\S*\) .*@\1@')
ADDRESS=$(ip r | grep ${GATEWAY:-src} | grep src | head -n 1 | cut -d' ' -f12)

# set secure permissions
bash /var/scripts/secure-permissions.sh

# we want clean logs
rm $ocdata/owncloud.log

# Prepare /etc/issue and /etc/motd with hints.
# Hint: Disable this by erasing $cred_file after changing the password.
if [ -s $cred_file ]; then
  . $cred_file
  ocVersion=$(head -n1 /var/www/owncloud/.htaccess)
  test -f /etc/issue.orig || mv /etc/issue /etc/issue.orig
  vers20=$(printf "%-20s" "$ocVersion")
  addr40=$(printf "%-40s" "https://$ADDRESS/")
  user40=$(printf "%-40s" "$user")
  pass40=$(printf "%-40s" "$password")
  distro=$(lsb_release -d|cut -b14-)
  cat > /etc/issue << ISSUE
          $distro\n \l

    +----------------------------------------------------------------------+
    |                                                                      |
    |           Welcome to ownCloud!          $vers20         |
    |                                                                      |
    |  This server is reachable at $addr40|
    |  Initial ownCloud login:  admin                                      |
    |  Initial console login:   $user40   |
    |  Initial password:        $pass40   |
    +----------------------------------------------------------------------+
    |  Access: ownCloud web interface: https://localhost:4443              |
    |          Appliance SSH access: localhost, port 2222                  |
    +----------------------------------------------------------------------+
    |  Login to the console for further setup options.                     |
    +----------------------------------------------------------------------+
    |  For more information, please read the ownCloud Appliance            |
    |  Documentation at https://doc.owncloud.com/appliance.                |
    +----------------------------------------------------------------------+
    |  If the virtual machine is run with NAT, please review the port      |
    |  forwarding of the network adapter, or try http://localhost:4443     |
    +----------------------------------------------------------------------+
ISSUE
fi
