--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

-- CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;
CREATE LANGUAGE plpgsql;

--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

-- COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: update_notification(); Type: FUNCTION; Schema: public; Owner: packagemanager
--

CREATE FUNCTION update_notification() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
   BEGIN
        UPDATE notification SET serial = NEXTVAL('notification_serial_seq') WHERE id = 1;
 
        RETURN NEW;
    END;
$$;


ALTER FUNCTION public.update_notification() OWNER TO packagemanager;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: notification; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE notification (
    id integer NOT NULL,
    serial integer NOT NULL,
    ack integer
);


ALTER TABLE public.notification OWNER TO packagemanager;

--
-- Name: notification_serial_seq; Type: SEQUENCE; Schema: public; Owner: packagemanager
--

CREATE SEQUENCE notification_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notification_serial_seq OWNER TO packagemanager;

--
-- Name: notification_serial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: packagemanager
--

ALTER SEQUENCE notification_serial_seq OWNED BY notification.serial;



--
-- Name: package_lists; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE package_lists (
    id integer NOT NULL,
    name character varying(128),
    origin integer,
    priority integer,
    approvalrequired boolean,
    approved boolean,
    atomic boolean,
    owner character varying(80),
    autoupdate boolean,
    description character varying(128)
);


ALTER TABLE public.package_lists OWNER TO packagemanager;

--
-- Name: package_lists_id_seq; Type: SEQUENCE; Schema: public; Owner: packagemanager
--

CREATE SEQUENCE package_lists_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.package_lists_id_seq OWNER TO packagemanager;

--
-- Name: package_lists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: packagemanager
--

ALTER SEQUENCE package_lists_id_seq OWNED BY package_lists.id;


--
-- Name: packages; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE packages (
    id integer NOT NULL,
    name character varying(80),
    version character varying(64),
    description character varying(80),
    install boolean,
    arch character varying(20),
    list_id integer
);


ALTER TABLE public.packages OWNER TO packagemanager;

--
-- Name: packages_id_seq; Type: SEQUENCE; Schema: public; Owner: packagemanager
--

CREATE SEQUENCE packages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.packages_id_seq OWNER TO packagemanager;

--
-- Name: packages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: packagemanager
--

ALTER SEQUENCE packages_id_seq OWNED BY packages.id;


--
-- Name: profile_members; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE profile_members (
    profile_id integer NOT NULL,
    list_id integer NOT NULL
);


ALTER TABLE public.profile_members OWNER TO packagemanager;

--
-- Name: profiles; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE profiles (
    id integer NOT NULL,
    name character varying(80) NOT NULL,
    alternateprofile character varying(80),
    owner character varying(80),
    description character varying(128),
    config_extras character varying(256)
);


ALTER TABLE public.profiles OWNER TO packagemanager;

--
-- Name: profiles_id_seq; Type: SEQUENCE; Schema: public; Owner: packagemanager
--

CREATE SEQUENCE profiles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.profiles_id_seq OWNER TO packagemanager;

--
-- Name: profiles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: packagemanager
--

ALTER SEQUENCE profiles_id_seq OWNED BY profiles.id;


--
-- Name: repo_list_members; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE repo_list_members (
    repo_id integer NOT NULL,
    list_id integer NOT NULL
);


ALTER TABLE public.repo_list_members OWNER TO packagemanager;

--
-- Name: repositories; Type: TABLE; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE TABLE repositories (
    id integer NOT NULL,
    name character varying(80),
    url character varying(256),
    dist character varying(80),
    arch character varying(16),
    component character varying(16),
    priority integer,
    autoupdate boolean,
    description character varying(128),
    type character varying(32)
);


ALTER TABLE public.repositories OWNER TO packagemanager;

--
-- Name: repositories_id_seq; Type: SEQUENCE; Schema: public; Owner: packagemanager
--

CREATE SEQUENCE repositories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.repositories_id_seq OWNER TO packagemanager;

--
-- Name: repositories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: packagemanager
--

ALTER SEQUENCE repositories_id_seq OWNED BY repositories.id;



CREATE TABLE computers (name VARCHAR(80) PRIMARY KEY,description VARCHAR(128),
	ip_address VARCHAR(45), mac_address VARCHAR(17),
	options VARCHAR(128),
	owner VARCHAR(80),
	profile_id INTEGER,
	status INTEGER,
	CONSTRAINT profile_id_fkey FOREIGN KEY (profile_id) REFERENCES profiles(id));

CREATE TABLE clients (name VARCHAR(80) PRIMARY KEY,
	ip_address VARCHAR(45), mac_address VARCHAR(17),
	server VARCHAR(80),
	owner VARCHAR(80),
	hardware_type VARCHAR(32),
	manufacturer VARCHAR(20),
	model VARCHAR(40),
	serial VARCHAR(40),
	location VARCHAR(40),
	room_no VARCHAR(16),
	purchase_date DATE,
	warranty DATE,
	order_no VARCHAR(32),
	inventory_no VARCHAR(32));

CREATE TABLE status_count (name VARCHAR(80), category VARCHAR(32),value INTEGER,
        PRIMARY KEY (name,category));

CREATE TABLE groups (id SERIAL PRIMARY KEY, name VARCHAR(64) UNIQUE, description VARCHAR(128), owner VARCHAR(80));

CREATE TABLE properties (id SERIAL PRIMARY KEY, key VARCHAR(128), value VARCHAR(128), category VARCHAR(16),
	type_hint VARCHAR(32), 
	owner VARCHAR(80), computer VARCHAR(80), profile_id INTEGER, group_id INTEGER,
	CONSTRAINT prop_profile_fkey FOREIGN KEY (profile_id) REFERENCES profiles(id),
	CONSTRAINT prop_group_fkey FOREIGN KEY (group_id) REFERENCES groups(id),
	UNIQUE (key,category,computer),
	UNIQUE (key,category,profile_id)
);

--
-- Name: serial; Type: DEFAULT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY notification ALTER COLUMN serial SET DEFAULT nextval('notification_serial_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY package_lists ALTER COLUMN id SET DEFAULT nextval('package_lists_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY packages ALTER COLUMN id SET DEFAULT nextval('packages_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY profiles ALTER COLUMN id SET DEFAULT nextval('profiles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY repositories ALTER COLUMN id SET DEFAULT nextval('repositories_id_seq'::regclass);


--
-- Name: notification_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY notification
    ADD CONSTRAINT notification_pkey PRIMARY KEY (id);


--
-- Name: package_lists_name_key; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY package_lists
    ADD CONSTRAINT package_lists_name_key UNIQUE (name);


--
-- Name: package_lists_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY package_lists
    ADD CONSTRAINT package_lists_pkey PRIMARY KEY (id);


--
-- Name: packages_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY packages
    ADD CONSTRAINT packages_pkey PRIMARY KEY (id);


--
-- Name: profile_members_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY profile_members
    ADD CONSTRAINT profile_members_pkey PRIMARY KEY (profile_id, list_id);


--
-- Name: profiles_name_key; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY profiles
    ADD CONSTRAINT profiles_name_key UNIQUE (name);


--
-- Name: profiles_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY profiles
    ADD CONSTRAINT profiles_pkey PRIMARY KEY (id);


--
-- Name: repo_list_members_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY repo_list_members
    ADD CONSTRAINT repo_list_members_pkey PRIMARY KEY (repo_id, list_id);


--
-- Name: repositories_name_key; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY repositories
    ADD CONSTRAINT repositories_name_key UNIQUE (name);


--
-- Name: repositories_pkey; Type: CONSTRAINT; Schema: public; Owner: packagemanager; Tablespace: 
--

ALTER TABLE ONLY repositories
    ADD CONSTRAINT repositories_pkey PRIMARY KEY (id);


--
-- Name: package_lists_name; Type: INDEX; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE INDEX package_lists_name ON package_lists USING btree (name);


--
-- Name: packages_nal; Type: INDEX; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE INDEX packages_nal ON packages USING btree (name, arch, list_id);


--
-- Name: packages_nval; Type: INDEX; Schema: public; Owner: packagemanager; Tablespace: 
--

CREATE INDEX packages_nval ON packages USING btree (name, version, arch, list_id);


--
-- Name: notification_trigger; Type: TRIGGER; Schema: public; Owner: packagemanager
--

CREATE TRIGGER notification_trigger AFTER INSERT OR UPDATE ON packages FOR EACH STATEMENT EXECUTE PROCEDURE update_notification();


--
-- Name: notification_trigger; Type: TRIGGER; Schema: public; Owner: packagemanager
--

CREATE TRIGGER notification_trigger AFTER INSERT OR UPDATE ON package_lists FOR EACH STATEMENT EXECUTE PROCEDURE update_notification();


--
-- Name: notification_trigger; Type: TRIGGER; Schema: public; Owner: packagemanager
--

CREATE TRIGGER notification_trigger AFTER INSERT OR UPDATE ON profiles FOR EACH STATEMENT EXECUTE PROCEDURE update_notification();


CREATE TRIGGER notification_trigger AFTER INSERT OR UPDATE ON computers FOR EACH STATEMENT EXECUTE PROCEDURE update_notification();

CREATE TRIGGER notification_trigger AFTER INSERT OR UPDATE ON clients FOR EACH STATEMENT EXECUTE PROCEDURE update_notification();
--
-- Name: packages_list_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY packages
    ADD CONSTRAINT packages_list_id_fkey FOREIGN KEY (list_id) REFERENCES package_lists(id);


--
-- Name: profile_members_list_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY profile_members
    ADD CONSTRAINT profile_members_list_id_fkey FOREIGN KEY (list_id) REFERENCES package_lists(id);


--
-- Name: profile_members_profile_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY profile_members
    ADD CONSTRAINT profile_members_profile_id_fkey FOREIGN KEY (profile_id) REFERENCES profiles(id);


--
-- Name: repo_list_members_list_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY repo_list_members
    ADD CONSTRAINT repo_list_members_list_id_fkey FOREIGN KEY (list_id) REFERENCES package_lists(id);


--
-- Name: repo_list_members_repo_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: packagemanager
--

ALTER TABLE ONLY repo_list_members
    ADD CONSTRAINT repo_list_members_repo_id_fkey FOREIGN KEY (repo_id) REFERENCES repositories(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

