package de.insignificance;
/*
   Copyright 2012,2013 Sebastian Lederer

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

import java.sql.ResultSet;
import java.sql.SQLException;

import de.dassit.dbwrapper.Entry;

public class User extends Entry {
	String name;
	int uidNumber;
	int gidNumber;
	String givenName;
	String surname;
	String description;
	String telephoneNumber;
	String roomNumber;

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(givenName);
		verifySqlString(surname);
		verifySqlString(description);
		verifySqlString(telephoneNumber);
		verifySqlString(roomNumber);
	}

	@Override
	public String getSelectStatement() {
		return "SELECT * FROM users";
	}

	public String getWhereClause(String key) {
		return "WHERE name='" + key + "'";
	}

	@Override
	public String getInsertStatement() {
		String sql = "INSERT INTO users VALUES('" + name + "'," + uidNumber
				+ "," + gidNumber + ",'" + givenName + "','" + surname + "','"
				+ description + "','" + telephoneNumber + "','" + roomNumber
				+ "')";
		return sql;
	}

	@Override
	public String getUpdateStatement() {
		return "UPDATE users SET name='" + name + "', uidNumber=" + uidNumber
				+ "," + "gidNumber=" + gidNumber + ",givenName='" + givenName
				+ "', surname='" + surname + "',description='" + description
				+ "',telephoneNumber='" + telephoneNumber + "',roomNumber='"
				+ roomNumber + "'" + " WHERE name='" + name + "'";
	}

	@Override
	public String getDeleteStatement() {
		return "DELETE FROM users WHERE name='" + name + "'";
	}

	public String getRenameStatement(String newName) {
		return "UPDATE users SET name='" + newName + "' WHERE name='" + name
				+ "'";
	}

	@Override
	public String getCreateStatement() {
		return "CREATE TABLE users (name VARCHAR(64) PRIMARY KEY, "
				+ "uidNumber INT, gidNumber INT, givenName VARCHAR(128),"
				+ "surname VARCHAR(128),description VARCHAR(128),"
				+ "telephoneNumber VARCHAR(32),roomNumber VARCHAR(32))";
	}

	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		name = rs.getString(1);
		uidNumber = rs.getInt(2);
		gidNumber = rs.getInt(3);
		givenName = rs.getString(4);
		surname = rs.getString(5);
		description = rs.getString(6);
		telephoneNumber = rs.getString(7);
		roomNumber = rs.getString(8);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		User u = new User();
		u.initFromQuery(rs);
		return (Entry) u;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getUidNumber() {
		return uidNumber;
	}

	public void setUidNumber(int uidNumber) {
		this.uidNumber = uidNumber;
	}

	public int getGidNumber() {
		return gidNumber;
	}

	public void setGidNumber(int gidNumber) {
		this.gidNumber = gidNumber;
	}

	public String getGivenName() {
		return givenName;
	}

	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	public String getSurname() {
		return surname;
	}

	public void setSurname(String surname) {
		this.surname = surname;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getTelephoneNumber() {
		return telephoneNumber;
	}

	public void setTelephoneNumber(String telephoneNumber) {
		this.telephoneNumber = telephoneNumber;
	}

	public String getRoomNumber() {
		return roomNumber;
	}

	public void setRoomNumber(String roomNumber) {
		this.roomNumber = roomNumber;
	}

}
