package de.insignificance;

import java.sql.ResultSet;
import java.sql.SQLException;

import de.dassit.dbwrapper.Entry;

public class Status extends Entry {
	String name;
	String category;
	int value;

	static String defaultCategory;

	public Status() {
		keyName = "name";
		tableName = "status_count";
	}
	
	public void setDefaultCategory(String s) {
		defaultCategory = s;
	}

	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		name = rs.getString(1);
		category = rs.getString(2);
		value = rs.getInt(3);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Status s = new Status();
		s.initFromQuery(rs);
		return (Entry) s;
	}

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(category);
	}

	@Override
	public String getRenameStatement(String newName) {
		return "UPDATE status_count SET " + sqlStringValue(newName, "name")
				+ getWhereClause(name);
	}

	public String getSelectStatement() {
		return "SELECT * FROM status_count";
	}

	public String getWhereClause(String key) {
		if (category == null)
			category = defaultCategory;
		return "WHERE " + sqlStringValue(key, "name") + " AND "
				+ sqlStringValue(category, "category");
	}

	public String getInsertStatement() {
		return "INSERT INTO status (name,category,value) " + "VALUES("
				+ sqlStringValueComma(name) + sqlStringValueComma(category)
				+ " value=" + value;
	}

	public String getUpdateStatement() {
		return "UPDATE status SET " + sqlStringValueComma(name, "name")
				+ sqlStringValueComma(category, "category") + " value=" + value
				+ " " + getWhereClause(name);
	}

	public String getCreateStatement() {
		return "CREATE TABLE status_count (name VARCHAR(80), category VARCHAR(32),"
				+ "value integer, PRIMARY KEY (name,category))";
	}

	public String getDeleteStatement() {
		return "DELETE FROM status_count " + getWhereClause(name);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}

	public static String getDefaultCategory() {
		return defaultCategory;
	}
}
