package de.insignificance;

/*
 Copyright 2012,2013 Sebastian Lederer

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Repository extends Entry {
	int id;
	String name;
	String description;
	String url;
	String type;
	String dist;
	String arch;
	String component;
	boolean autoupdate;
	int priority;

	public Repository() {
		keyName = "id";
		tableName = "repositories";
	}

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(description);
		verifySqlString(url);
		verifySqlString(type);
		verifySqlString(dist);
		verifySqlString(arch);
		verifySqlString(component);
	}

	@Override
	public void initFromQuery(ResultSet queryResult) throws SQLException {
		id = queryResult.getInt(1);
		name = queryResult.getString(2);
		url = queryResult.getString(3);
		dist = queryResult.getString(4);
		arch = queryResult.getString(5);
		component = queryResult.getString(6);
		priority = queryResult.getInt(7);
		autoupdate = queryResult.getBoolean(8);
		description = queryResult.getString(9);
		type = queryResult.getString(10);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Repository r = new Repository();
		r.initFromQuery(rs);
		return (Entry) r;
	}

	@Override
	public String getSelectStatement() {
		return "SELECT * FROM repositories";
	}

	@Override
	public String getWhereClause(String key) {
		return "WHERE name='" + key + "'";
	}

	@Override
	public String getInsertStatement() {
		return "INSERT INTO repositories (name,url,dist,arch,component,priority,autoupdate,description,type) "
				+ "VALUES("
				+ sqlStringValueComma(name)
				+ sqlStringValueComma(url)
				+ sqlStringValueComma(dist)
				+ sqlStringValueComma(arch)
				+ sqlStringValueComma(component)
				+ priority
				+ ","
				+ autoupdate
				+ ","
				+ sqlStringValueComma(description) + sqlStringValue(type) + ")";
	}

	@Override
	public String getUpdateStatement() {
		return "UPDATE repositories SET " + sqlStringValueComma(name, "name")
				+ sqlStringValueComma(url, "url")
				+ sqlStringValueComma(dist, "dist")
				+ sqlStringValueComma(arch, "arch")
				+ sqlStringValueComma(component, "component") + "priority="
				+ priority + ",autoupdate=" + autoupdate + ","
				+ sqlStringValueComma(description, "description")
				+ sqlStringValue(type, "type") + " WHERE name='" + name + "'";
	}

	@Override
	public String getDeleteStatement() {
		return "DELETE FROM repositories WHERE name='" + name + "'";
	}

	@Override
	public String getCreateStatement() {
		return "DROP TABLE IF EXISTS repositories;CREATE TABLE repositories"
				+ " (id INTEGER AUTO_INCREMENT, name VARCHAR(80) PRIMARY KEY,"
				+ "url VARCHAR(256), dist VARCHAR(80), arch VARCHAR(20),"
				+ "component VARCHAR(32), priority INTEGER, autoupdate BOOLEAN,"
				+ "description VARCHAR(80), type VARCHAR(32))";
	}

	@Override
	public String getRenameStatement(String newName) {
		return "UPDATE repositories SET " + sqlStringValue(newName, "name")
				+ " WHERE id=" + id;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param url
	 *            the url to set
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the arch
	 */
	public String getArch() {
		return arch;
	}

	/**
	 * @param arch
	 *            the arch to set
	 */
	public void setArch(String arch) {
		this.arch = arch;
	}

	/**
	 * @return the subrepo
	 */
	public String getSubrepo() {
		return component;
	}

	/**
	 * @param subrepo
	 *            the subrepo to set
	 */
	public void setSubrepo(String subrepo) {
		this.component = subrepo;
	}

	/**
	 * @return the autoupdate
	 */
	public boolean isAutoupdate() {
		return autoupdate;
	}

	/**
	 * @param autoupdate
	 *            the autoupdate to set
	 */
	public void setAutoupdate(boolean autoupdate) {
		this.autoupdate = autoupdate;
	}

	public List<Entry> getPackageLists() throws SQLException {
		List<Entry> result = new ArrayList<Entry>();

		RepoListMembership fac = new RepoListMembership();
		List<Entry> memberships = fac.getMembersForRepo(this);
		for (Entry e : memberships) {
			RepoListMembership m = (RepoListMembership) e;
			PackageList p = new PackageList();
			Entry r = p.fetch("WHERE id=" + m.listId).get(0);
			result.add(r);
		}
		return result;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getDist() {
		return dist;
	}

	public void setDist(String dist) {
		this.dist = dist;
	}

	public String getComponent() {
		return component;
	}

	public void setComponent(String component) {
		this.component = component;
	}

	public int getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}
}
