package de.insignificance;

/*
 Copyright 2012,2013 Sebastian Lederer

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class RepoListMembership extends Entry {
	int listId;
	int repoId;

	public RepoListMembership() {
		keyName = "list_id";
		tableName = "repo_list_members";
	}

	@Override
	public void validate() throws SQLException {
	}

	@Override
	public String getSelectStatement() {
		return "SELECT * FROM repo_list_members";
	}

	@Override
	public String getWhereClause(String key) {
		int id = Integer.parseInt(key);
		return "WHERE repo_id=" + id;
	}

	@Override
	public String getInsertStatement() {
		return "INSERT INTO repo_list_members VALUES(" + repoId + "," + listId
				+ ")";
	}

	@Override
	public String getUpdateStatement() {
		return "NOT IMPLEMENTED";
	}

	@Override
	public String getCreateStatement() {
		return "DROP TABLE repo_list_members;CREATE TABLE repo_list_members (repo_id INTEGER, list_id INTEGER)";
	}

	@Override
	public String getDeleteStatement() {
		return "DELETE FROM repo_list_members WHERE list_id=" + listId
				+ " AND repo_id=" + repoId;
	}

	@Override
	public String getRenameStatement(String newName) {
		return "NOT IMPLEMENTED";
	}

	@Override
	public void initFromQuery(ResultSet queryResult) throws SQLException {
		repoId = queryResult.getInt(1);
		listId = queryResult.getInt(2);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		RepoListMembership u = new RepoListMembership();
		u.initFromQuery(rs);
		return (Entry) u;
	}

	public List<Entry> getMembersForList(PackageList pl) throws SQLException {
		// System.out.println("fetching packages for list id " + pl.id);
		return fetch("WHERE list_id=" + pl.id);
	}

	public List<Entry> getMembersForRepo(Repository r) throws SQLException {
		// System.out.println("fetching packages for list id " + pl.id);
		return fetch("WHERE repo_id=" + r.id);
	}
}
