package de.insignificance;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Property extends Entry {
	long id;
	String name;
	String value;
	String category;
	String owner;
	String typeHint;
	int profileId;
	String computer;

	public Property() {
		String[] myFieldNames = { "id", "key", "value", "category",
				"type_hint", "owner", "computer", "profile_id", };

		fieldNames = myFieldNames;
		keyName = "id";
		autoIdField = "id";
		tableName = "properties";
	}

	@Override
	protected Object[] getValues() {
		Object p = null;
		if (profileId != 0) {
			p = new Long(profileId);
		}

		return new Object[] { id, name, value, category, typeHint, owner,
				computer, p };
	}

	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		id = rs.getLong(1);
		name = rs.getString(2);
		value = rs.getString(3);
		category = rs.getString(4);
		typeHint = rs.getString(5);
		owner = rs.getString(6);
		computer = rs.getString(7);
		profileId = rs.getInt(8);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Property p = new Property();
		p.initFromQuery(rs);
		return (Entry) p;
	}

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(value);
		verifySqlString(category);
		verifySqlString(typeHint);
		verifySqlString(owner);
		verifySqlString(computer);
	}

	public List<Entry> fetchForProfile(Profile p) throws SQLException {
		return fetch("WHERE "
				+ sqlStringValue(Integer.toString(p.id), "profile_id"));
	}

	public List<Entry> fetchForComputer(Computer c) throws SQLException {
		return fetchForComputerName(c.name);
	}

	public List<Entry> fetchForProfileName(String p) throws SQLException {
		Profile profile = new Profile();
		profile.load(p);

		return fetchForProfile(profile);
	}

	public List<Entry> fetchForComputerName(String c) throws SQLException {
		verifySqlString(c);
		return fetch("WHERE " + sqlStringValue(c, "computer"));
	}

	public Property getComputerProperty(String c, String propName)
			throws SQLException {
		verifySqlString(c);
		verifySqlString(propName);
		
		List<Entry> results =  fetch("WHERE " + sqlStringValue(c, "computer") + " AND "
				+ sqlStringValue(propName, "key"));
		
		if(results.size()>0) {
			return (Property) results.get(0);
		}
		else {
			Property p = new Property();
			p.name = propName;
			p.computer = c;
			
			return p;
		}
			
	}

	public void setProfile(Profile p) {
		profileId = p.getId();
	}

	public Profile getProfile() throws SQLException {
		Profile p = new Profile();
		if (p.load(Long.toString(profileId)))
			return p;
		else
			return null;
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * @return the key
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param key
	 *            the key to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the type
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setCategory(String type) {
		this.category = type;
	}

	/**
	 * @return the owner
	 */
	public String getOwner() {
		return owner;
	}

	/**
	 * @param owner
	 *            the owner to set
	 */
	public void setOwner(String owner) {
		this.owner = owner;
	}

	/**
	 * @return the profileId
	 */
	public int getProfileId() {
		return profileId;
	}

	/**
	 * @param profileId
	 *            the profileId to set
	 */
	public void setProfileId(int profileId) {
		this.profileId = profileId;
	}

	public String getTypeHint() {
		return typeHint;
	}

	public void setTypeHint(String typeHint) {
		this.typeHint = typeHint;
	}

	public String getComputer() {
		return computer;
	}

	public void setComputer(String computer) {
		this.computer = computer;
	}
}
