package de.insignificance;
/*
   Copyright 2012,2013 Sebastian Lederer

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class ProfileMembership extends Entry {
	int profileId;
	int packageListId;
	
	public ProfileMembership() {
		keyName="profile_id";
		tableName="profile_members";
	}
	
	@Override
	public void validate() throws SQLException {
	}
	
	@Override
	public String getSelectStatement() {
		return "SELECT * FROM profile_members";
	}

	@Override
	public String getWhereClause(String key) {
		int id=Integer.parseInt(key);
		return "WHERE profileId="+id;
	}

	@Override
	public String getInsertStatement() {
		return "INSERT INTO profile_members VALUES(" + profileId + "," + packageListId
				+ ")";
	}

	@Override
	public String getUpdateStatement() {
		return "NOT IMPLEMENTED";
	}

	@Override
	public String getCreateStatement() {
		return "DROP TABLE IF EXISTS profile_members;"
				+ "CREATE TABLE profile_members (profile_id INTEGER , list_id INTEGER)";
	}

	@Override
	public String getDeleteStatement() {
		return "DELETE FROM profile_members WHERE profile_id=" + profileId
				+ " AND list_id=" + packageListId;
	}

	@Override
	public String getRenameStatement(String newName) {
		return "NOT IMPLEMENTED";
	}
	
	@Override
	public void initFromQuery(ResultSet queryResult) throws SQLException {
		profileId = queryResult.getInt(1);
		packageListId = queryResult.getInt(2);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		ProfileMembership u = new ProfileMembership();
		u.initFromQuery(rs);
		return (Entry) u;
	}

	public List<Entry> getMembersForProfile(Profile p) throws SQLException {
		// System.out.println("fetching packages for list id " + pl.id);
		return fetch("WHERE profile_id=" + p.id);
	}
}
