package de.insignificance;
/*
   Copyright 2012,2013 Sebastian Lederer

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Package extends Entry {
	long id;
	String name;
	String version;
	String description;
	boolean install;
	String arch;
	int packageListId;
	
	public Package() {
		keyName = "id";
		tableName = "packages";
	}
	
	@Override
	public void initFromQuery(ResultSet queryResult) throws SQLException {
		id = queryResult.getInt(1);
		name = queryResult.getString(2);
		version = queryResult.getString(3);
		description = queryResult.getString(4);
		install = queryResult.getBoolean(5);
		arch = queryResult.getString(6);
		packageListId = queryResult.getInt(7);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Package p = new Package();
		p.initFromQuery(rs);
		return (Entry) p;
	}

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(version);
		verifySqlString(description);
		verifySqlString(arch);
	}

	@Override
	public String getSelectStatement() {
		return "SELECT * FROM packages";
	}

	@Override
	public String getWhereClause(String key) {
		return "WHERE id=" + key;
	}

	@Override
	public String getInsertStatement() {
		return "INSERT INTO packages (name,version,description,install,arch,list_id) "
				+ "VALUES("
				+ sqlStringValueComma(name)
				+ sqlStringValueComma(version)
				+ sqlStringValueComma(description)
				+ install
				+ ","
				+ sqlStringValueComma(arch) + packageListId + ")";
	}

	@Override
	public String getUpdateStatement() {
		return "UPDATE packages SET "
				+ sqlStringValueComma(name,"name")
				+ sqlStringValueComma(version,"version")
				+ sqlStringValueComma(description,"description")
				+ "install="+install+","
				+ sqlStringValueComma(arch,"arch")
				+ "list_id="+packageListId
				+ " WHERE id=" + id;
	}

	@Override
	public String getDeleteStatement() {
		return "DELETE FROM packages WHERE id=" + id;
	}

	@Override
	public String getCreateStatement() {
		return "DROP TABLE packages;CREATE TABLE packages (id INTEGER PRIMARY KEY AUTO_INCREMENT, name VARCHAR(80), "
				+ "version VARCHAR(64), description VARCHAR(80),"
				+ "install BOOLEAN, arch VARCHAR(20),list_id INTEGER)";
	}
	
	@Override
	public String getRenameStatement(String newName) {
		return "UPDATE packages SET "+sqlStringValue(newName,"name")
				+ " WHERE id="+id;
	}
	
	public PackageList getPackageList() throws SQLException {
		PackageList pl=new PackageList();
		List<Entry> results=pl.fetch("WHERE id="+packageListId);
		if(results.isEmpty()) return null;
		return (PackageList) results.get(0);
	}

	public boolean updateFrom(int packageListId) throws SQLException {
		validate();

		List<Entry> results=fetch("WHERE list_id="+packageListId+
				" AND "+sqlStringValue(name, "name")+" AND "+
				sqlStringValue(arch,"arch"));
		if(results.isEmpty()) return false;
		Package p=(Package) results.get(0);
		version=p.version;
		install=p.install;
		description=p.description;
		save();
		return true;
	}
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * @param version
	 *            the version to set
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @return the install
	 */
	public boolean isInstall() {
		return install;
	}

	/**
	 * @param install
	 *            the install to set
	 */
	public void setInstall(boolean install) {
		this.install = install;
	}

	/**
	 * @return the arch
	 */
	public String getArch() {
		return arch;
	}

	/**
	 * @param arch
	 *            the arch to set
	 */
	public void setArch(String arch) {
		this.arch = arch;
	}

	public void deleteAllFrom(int packageListId) throws SQLException {
		Statement s = getStatement();
		
		String sql = "DELETE FROM packages WHERE list_id="
				 + packageListId;
		
		s.execute(sql);
		releaseStatement(s);
	}
}
