package de.insignificance;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Group extends Entry {
	int id;
	String name;
	String description;
	String owner;

	public Group() {
		String[] myFieldNames = { "id", "name", "description", "owner" };

		fieldNames = myFieldNames;
		keyName = "id";
		autoIdField = "id";
		tableName = "groups";
	}

	@Override
	protected Object[] getValues() {
		return new Object[] { id, name, description, owner };
	}

	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		id = rs.getInt(1);
		name = rs.getString(2);
		description = rs.getString(3);
		owner = rs.getString(4);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Group p = new Group();
		p.initFromQuery(rs);
		return (Entry) p;
	}

	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(description);
		verifySqlString(owner);
	}

	public Group getByName(String n) throws SQLException {
		verifySqlString(n);
		List<Entry> results = fetch("WHERE " + sqlStringValue(n, "name"));
		if(results.size()>0)
			return (Group) results.get(0);
		else
			return null;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public int getId() {
		return id;
	}
}
