package de.insignificance;

/*
 Copyright 2012,2013 Sebastian Lederer

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Computer extends Entry {
	String name;
	String description;
	String ipAddress;
	String macAddress;
	String options;
	String owner;
	int profileId;
	int status;

	public Computer() {
		keyName = "name";
		tableName = "computers";
	}
	
	@Override
	public void validate() throws SQLException {
		verifySqlString(name);
		verifySqlString(description);
		verifySqlString(ipAddress);
		verifySqlString(macAddress);
		verifySqlString(options);
		verifySqlString(owner);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.insignificance.Entry#initFromQuery(java.sql.ResultSet)
	 */
	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		name = rs.getString(1);
		description = rs.getString(2);
		ipAddress = rs.getString(3);
		macAddress = rs.getString(4);
		options = rs.getString(5);
		owner = rs.getString(6);
		profileId = rs.getInt(7);
		status = rs.getInt(8);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.insignificance.Entry#newFromQuery(java.sql.ResultSet)
	 */
	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Computer newComputer = new Computer();
		newComputer.initFromQuery(rs);
		return (Entry) newComputer;
	}

	@Override
	public String getRenameStatement(String newName) {
		return "UPDATE computers SET " + sqlStringValue(newName, "name")
				+ " WHERE name=" + sqlStringValue(name);
	}

	public String getSelectStatement() {
		return "SELECT * FROM computers";
	}

	public String getWhereClause(String key) {
		return "WHERE " + sqlStringValue(key,"name");
	}

	public String getInsertStatement() {
		return "INSERT INTO computers (name,description,ip_address,mac_address,options,owner,profile_id,status) "
				+ "VALUES("
				+ sqlStringValueComma(name)
				+ sqlStringValueComma(description)
				+ sqlStringValueComma(ipAddress)
				+ sqlStringValueComma(macAddress)
				+ sqlStringValueComma(options)
				+ sqlStringValueComma(owner)
				+ profileId + "," + status + ")";
	}

	public String getUpdateStatement() {
		return "UPDATE computers SET " + sqlStringValueComma(name, "name")
				+ sqlStringValueComma(description, "description")
				+ sqlStringValueComma(ipAddress, "ip_address")
				+ sqlStringValueComma(macAddress, "mac_address")
				+ sqlStringValueComma(options, "options")
				+ sqlStringValueComma(owner,"owner")
				+ "profile_id="
				+ profileId+","+ "status="
				+ status+" "+getWhereClause(name);
	}

	public String getCreateStatement() {
		return "CREATE TABLE computers (name VARCHAR(80) PRIMARY KEY,description VARCHAR(128)," +
				"ip_address VARCHAR(45),mac_address VARCHAR(11), options VARCHAR(128)," +
				"owner VARCHAR(80), profile_id INTEGER, status INTEGER)";
	}

	public String getDeleteStatement() {
		return "DELETE FROM computers WHERE "+sqlStringValue(name,"name");
	}

	public Profile getProfile() throws SQLException {
		Profile p=new Profile();
		List<Entry> result = new ArrayList<Entry>();
		result = p.fetch("WHERE id=" + profileId);
		if (result.isEmpty())
			return null;
		return (Profile) result.get(0);		
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public String getMacAddress() {
		return macAddress;
	}

	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	public String getOptions() {
		return options;
	}

	public void setOptions(String options) {
		this.options = options;
	}

	public int getProfileId() {
		return profileId;
	}

	public void setProfileId(int profileId) {
		this.profileId = profileId;
	}

	public String getOwner() {
		return owner;
	}

	public void setOwner(String owner) {
		this.owner = owner;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}
}
