package de.insignificance;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import de.dassit.dbwrapper.Entry;

public class Client extends Entry {
	String name;
	String ipAddress;
	String macAddress;
	String server;
	String owner;
	String hardwareType;
	String manufacturer;
	String model;
	String serial;
	String location;
	String roomNumber;
	String purchaseDate;
	String warranty;
	String orderNumber;
	String inventoryNumber;

	public Client() {
		String[] myFieldNames = { "name", "ip_address", "mac_address",
				"server", "owner", "hardware_type", "manufacturer", "model",
				"serial", "location", "room_no", "purchase_date", "warranty",
				"order_no", "inventory_no" };

		fieldNames = myFieldNames;
		keyName = "name";
		tableName = "clients";
	}

	@Override
	protected Object[] getValues() {
		return new Object[] { name, ipAddress, macAddress, server, owner,
				hardwareType, manufacturer, model, serial, location,
				roomNumber, purchaseDate, warranty, orderNumber,
				inventoryNumber };
	}

	@Override
	public void initFromQuery(ResultSet rs) throws SQLException {
		int i = 1;
		name = rs.getString(i++);
		ipAddress = rs.getString(i++);
		macAddress = rs.getString(i++);
		server = rs.getString(i++);
		owner = rs.getString(i++);
		hardwareType = rs.getString(i++);
		manufacturer = rs.getString(i++);
		model = rs.getString(i++);
		serial = rs.getString(i++);
		location = rs.getString(i++);
		roomNumber = rs.getString(i++);
		purchaseDate = rs.getString(i++);
		warranty = rs.getString(i++);
		orderNumber = rs.getString(i++);
		inventoryNumber = rs.getString(i++);
	}

	@Override
	public Entry newFromQuery(ResultSet rs) throws SQLException {
		Client p = new Client();
		p.initFromQuery(rs);
		return (Entry) p;
	}

	@Override
	public void validate() throws SQLException {
		Object[] o = getValues();
		
		for(int i=1;i<o.length;i++) {
			String s = (String) o[i];
			verifySqlString(s);
		}
	}

	public List<Entry> fetchForComputer(Computer c) throws SQLException {
		return fetchForComputerName(c.name);
	}

	public List<Entry> fetchForComputerName(String c) throws SQLException {
		verifySqlString(c);
		return fetch("WHERE " + sqlStringValue(c, "server"));
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the ipAddress
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * @param ipAddress the ipAddress to set
	 */
	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	/**
	 * @return the macAddress
	 */
	public String getMacAddress() {
		return macAddress;
	}

	/**
	 * @param macAddress the macAddress to set
	 */
	public void setMacAddress(String macAddress) {
		this.macAddress = macAddress;
	}

	/**
	 * @return the server
	 */
	public String getServer() {
		return server;
	}

	/**
	 * @param server the server to set
	 */
	public void setServer(String server) {
		this.server = server;
	}

	/**
	 * @return the owner
	 */
	public String getOwner() {
		return owner;
	}

	/**
	 * @param owner the owner to set
	 */
	public void setOwner(String owner) {
		this.owner = owner;
	}

	/**
	 * @return the hardwareType
	 */
	public String getHardwareType() {
		return hardwareType;
	}

	/**
	 * @param hardwareType the hardwareType to set
	 */
	public void setHardwareType(String hardwareType) {
		this.hardwareType = hardwareType;
	}

	/**
	 * @return the manufacturer
	 */
	public String getManufacturer() {
		return manufacturer;
	}

	/**
	 * @param manufacturer the manufacturer to set
	 */
	public void setManufacturer(String manufacturer) {
		this.manufacturer = manufacturer;
	}

	/**
	 * @return the model
	 */
	public String getModel() {
		return model;
	}

	/**
	 * @param model the model to set
	 */
	public void setModel(String model) {
		this.model = model;
	}

	/**
	 * @return the serial
	 */
	public String getSerial() {
		return serial;
	}

	/**
	 * @param serial the serial to set
	 */
	public void setSerial(String serial) {
		this.serial = serial;
	}

	/**
	 * @return the location
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * @param location the location to set
	 */
	public void setLocation(String location) {
		this.location = location;
	}

	/**
	 * @return the roomNumber
	 */
	public String getRoomNumber() {
		return roomNumber;
	}

	/**
	 * @param roomNumber the roomNumber to set
	 */
	public void setRoomNumber(String roomNumber) {
		this.roomNumber = roomNumber;
	}

	/**
	 * @return the purchaseDate
	 */
	public String getPurchaseDate() {
		return purchaseDate;
	}

	/**
	 * @param purchaseDate the purchaseDate to set
	 */
	public void setPurchaseDate(String purchaseDate) {
		this.purchaseDate = purchaseDate;
	}

	/**
	 * @return the warranty
	 */
	public String getWarranty() {
		return warranty;
	}

	/**
	 * @param warranty the warranty to set
	 */
	public void setWarranty(String warranty) {
		this.warranty = warranty;
	}

	/**
	 * @return the orderNumber
	 */
	public String getOrderNumber() {
		return orderNumber;
	}

	/**
	 * @param orderNumber the orderNumber to set
	 */
	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}

	/**
	 * @return the inventoryNumber
	 */
	public String getInventoryNumber() {
		return inventoryNumber;
	}

	/**
	 * @param inventoryNumber the inventoryNumber to set
	 */
	public void setInventoryNumber(String inventoryNumber) {
		this.inventoryNumber = inventoryNumber;
	}
}
