#!/bin/sh
set -e
basedir=/var/lib/VPNCA
subdirs="req certs keys newcerts certsbyname"

mkdir $basedir

umask 077
sed -n -e '/^## ------------$/,$ p' $0 >$basedir/openssl.cnf
umask 022

cd $basedir
for d in $subdirs
do
	mkdir $d
done

chmod o-rwx,g=srx keys

umask 077

openssl req -new -x509 -days 3650 -config openssl.cnf -keyform PEM -keyout cakey.pem -outform PEM -out cacert.pem

umask 007


echo 00 >serial
touch index.txt

id puppet && chgrp puppet certsbyname keys

chmod a+r cacert.pem

exit

## ------------
[ ca ]
default_ca = CA_default

[ CA_default ]
dir = /var/lib/VPNCA
certs = $dir/certs
crl_dir = $dir/crl
database = $dir/index.txt
new_certs_dir = $dir/certs
certificate = $dir/cacert.pem
serial = $dir/serial
private_key = $dir/cakey.pem
x509_extensions = v3_ca
default_days = 3650
default_md = sha1
preserve = no
policy = policy_match
nameopt = default_ca
certopt = default_ca
copy_extensions = none
crl_extensions = v3_crl
unique_subject = no

[ policy_match ]
countryName = match
stateOrProvinceName = match
localityName = match
organizationName = match
organizationalUnitName = optional
commonName = supplied
emailAddress = optional

[ req ]
default_bits = 4096
default_keyfile = cakey.pem
distinguished_name = req_distinguished_name
attributes = req_attributes
x509_extensions = v3_ca
string_mask = utf8only
req_extensions = v3_req

[ req_attributes ]

[ req_distinguished_name ]
countryName = Country Name (2 letter code)
countryName_default = DE
countryName_min = 2
countryName_max = 2
stateOrProvinceName = State or Province Name (full name)
stateOrProvinceName_default = Germany
localityName = Locality Name (city, district)
organizationName = Organization Name (company)
organizationalUnitName = Organizational Unit Name (department, division)
commonName = Common Name (hostname, FQDN, IP, or your name)
commonName_max = 64
emailAddress = Email Address
emailAddress_max = 40

[ v3_client ]
basicConstraints= CA:FALSE
subjectKeyIdentifier=hash
authorityKeyIdentifier=keyid,issuer:always
nsComment = ''OpenSSL Generated Certificate''
subjectAltName=email:copy
issuerAltName=issuer:copy

[ v3_req ]
basicConstraints = CA:FALSE
keyUsage = nonRepudiation, digitalSignature, keyEncipherment

[ v3_ca ]
subjectKeyIdentifier = hash
authorityKeyIdentifier = keyid:always,issuer:always
basicConstraints = CA:TRUE
