#!/bin/sh
name=dasspackagemanager
debversion=$(head -1 debian/changelog | sed 's/.*[(]\(.*\)[)].*/\1/')
rpmversion=$(head -1 debian/changelog | sed 's/.*(\(.*\)-.*/\1/')
version=$rpmversion
debversion=$rpmversion
debtar=${name}_$version.tar.gz
ant clean
rm -f webapp/WEB-INF/lib/PackageManager.jar
rm -f build-stamp
rm -rf debian/$name debian/$name.debhelper.log debian/dasspackagemanager.substvars

#(cd ..;tar cjf /tmp/$name-$version.tar.bz2 --exclude .svn PackageManager)
(cd ..;tar czf /tmp/$debtar --exclude .svn PackageManager)
filesize=$(ls -l /tmp/$debtar | awk '{ print $5 }')
md5sum=$(md5sum /tmp/$debtar | awk '{ print $1}')
sha1sum=$(sha1sum /tmp/$debtar  | awk '{ print $1}')
sha256sum=$(sha256sum /tmp/$debtar  | awk '{ print $1}')
cat >/tmp/${name}.dsc << EOF
Format: 1.0
Source: $name
Binary: $name
Architecture: all
Version: $debversion
Maintainer: Sebastian Lederer <slederer@dass-it.de>
Standards-Version: 3.6.1
Build-Depends: debhelper (>= 4.0.0), ant (>= 1.6.5), sun-java6-jdk | java6-sdk
Build-Conflicts: gcj-4.3, gcj-4.3-base, java-gcj-compat, java-gcj-compat-dev
Package-List: 
 $name deb contrib/admin optional
Checksums-Sha1: 
 $sha1sum $filesize $debtar
Checksums-Sha256: 
 $sha256sum $filesize $debtar
Files: 
 $md5sum $filesize $debtar
EOF
sed -e "s/@@@VERSION@@@/$rpmversion/" $name.spec >/tmp/$name.spec
ls -l /tmp/$name*
