/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.largeobject.LargeObject;

public class BlobInputStream
extends InputStream {
    private LargeObject lo;
    private byte[] buffer;
    private int bpos;
    private int bsize;
    private int mpos = 0;

    public BlobInputStream(LargeObject lo) {
        this(lo, 1024);
    }

    public BlobInputStream(LargeObject lo, int bsize) {
        this.lo = lo;
        this.buffer = null;
        this.bpos = 0;
        this.bsize = bsize;
    }

    public int read() throws IOException {
        block5: {
            this.checkClosed();
            try {
                if (this.buffer == null || this.bpos >= this.buffer.length) {
                    this.buffer = this.lo.read(this.bsize);
                    this.bpos = 0;
                }
                if (this.bpos < this.buffer.length) break block5;
                return -1;
            }
            catch (SQLException se) {
                throw new IOException(se.toString());
            }
        }
        int ret = this.buffer[this.bpos] & 0x7F;
        if ((this.buffer[this.bpos] & 0x80) == 128) {
            ret |= 0x80;
        }
        ++this.bpos;
        return ret;
    }

    public void close() throws IOException {
        if (this.lo != null) {
            try {
                this.lo.close();
                this.lo = null;
            }
            catch (SQLException se) {
                throw new IOException(se.toString());
            }
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            this.mpos = this.lo.tell();
        }
        catch (SQLException sQLException) {}
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        try {
            this.lo.seek(this.mpos);
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }

    private void checkClosed() throws IOException {
        if (this.lo == null) {
            throw new IOException("BlobOutputStream is closed");
        }
    }
}

