/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Array {
    private BaseConnection connection = null;
    private int oid;
    private String fieldString = null;
    private final boolean useObjects;
    private final boolean haveMinServer82;
    private PgArrayList arrayList;

    public AbstractJdbc2Array(BaseConnection connection, int oid, String fieldString) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.fieldString = fieldString;
        this.useObjects = connection.haveMinimumCompatibleVersion("8.3");
        this.haveMinServer82 = connection.haveMinimumServerVersion("8.2");
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public Object getArrayImpl(long index, int count, Map map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(this.arrayList.size())}), PSQLState.DATA_ERROR);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void buildArrayList() throws SQLException {
        block20: {
            if (this.arrayList != null) {
                return;
            }
            this.arrayList = new PgArrayList();
            delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
            if (this.fieldString == null) break block20;
            chars = this.fieldString.toCharArray();
            buffer = null;
            insideString = false;
            wasInsideString = false;
            dims = new Vector<PgArrayList>();
            curArray = this.arrayList;
            startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            i = startOffset;
            while (i < chars.length) {
                block22: {
                    block21: {
                        if (chars[i] != '\\') break block21;
                        ++i;
                        ** GOTO lbl-1000
                    }
                    if (!insideString && chars[i] == '{') {
                        if (dims.size() == 0) {
                            dims.add(this.arrayList);
                        } else {
                            a = new PgArrayList();
                            p = (PgArrayList)dims.lastElement();
                            p.add(a);
                            dims.add(a);
                        }
                        curArray = (PgArrayList)dims.lastElement();
                        t = i + 1;
                        while (t < chars.length) {
                            if (!Character.isWhitespace(chars[t])) {
                                if (chars[t] != '{') break;
                                ++curArray.dimensionsCount;
                            }
                            ++t;
                        }
                        buffer = new StringBuffer();
                    } else if (chars[i] == '\"') {
                        insideString = insideString == false;
                        wasInsideString = true;
                    } else if (insideString || !Character.isWhitespace(chars[i])) {
                        ** if ((insideString || chars[i] != delim && chars[i] != '}') && i != chars.length - 1) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                                buffer.append((char)chars[i]);
                            } else {
                                ** GOTO lbl54
                            }
lbl54:
                            // 3 sources

                            v0 = b = buffer == null ? null : buffer.toString();
                            if (b != null && (b.length() > 0 || wasInsideString)) {
                                curArray.add(wasInsideString == false && this.haveMinServer82 != false && b.equals((Object)"NULL") != false ? null : b);
                            } else {
                                ** GOTO lbl58
                            }
lbl58:
                            // 3 sources

                            wasInsideString = false;
                            buffer = new StringBuffer();
                            if (chars[i] == '}') {
                                dims.remove((int)(dims.size() - 1));
                                if (dims.size() > 0) {
                                    curArray = (PgArrayList)dims.lastElement();
                                } else {
                                    ** GOTO lbl65
                                }
lbl65:
                                // 3 sources

                                buffer = null;
                            } else {
                                ** GOTO lbl66
                            }
lbl66:
                            // 3 sources

                            ** GOTO lbl71
                        }
                    }
                    break block22;
lbl-1000:
                    // 2 sources

                    {
                        if (buffer != null) {
                            buffer.append(chars[i]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Object buildArray(PgArrayList input, int index, int count) throws SQLException {
        int[] dimsLength;
        if (count < 0) {
            count = input.size();
        }
        Object[] ret = null;
        int dims = input.dimensionsCount;
        int[] nArray = dimsLength = dims > 1 ? new int[dims] : null;
        if (dims > 1) {
            int i = 0;
            while (i < dims) {
                dimsLength[i] = i == 0 ? count : 0;
                ++i;
            }
        }
        int length = 0;
        int type = this.connection.getTypeInfo().getSQLType(this.connection.getTypeInfo().getPGArrayElement(this.oid));
        if (type == -7) {
            boolean[] pa = null;
            Object[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Boolean.class : Boolean.TYPE, dimsLength) : new Boolean[count];
                ret = oa;
            } else {
                pa = new boolean[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Boolean(AbstractJdbc2ResultSet.toBoolean((String)o)));
                } else {
                    pa[length++] = o == null ? false : AbstractJdbc2ResultSet.toBoolean((String)o);
                }
                --count;
            }
        } else if (type == 5 || type == 4) {
            int[] pa = null;
            Object[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Integer.class : Integer.TYPE, dimsLength) : new Integer[count];
                ret = oa;
            } else {
                pa = new int[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Integer(AbstractJdbc2ResultSet.toInt((String)o)));
                } else {
                    pa[length++] = o == null ? 0 : AbstractJdbc2ResultSet.toInt((String)o);
                }
                --count;
            }
        } else if (type == -5) {
            long[] pa = null;
            Object[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Long.class : Long.TYPE, dimsLength) : new Long[count];
                ret = oa;
            } else {
                pa = new long[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Long(AbstractJdbc2ResultSet.toLong((String)o)));
                } else {
                    pa[length++] = o == null ? 0L : AbstractJdbc2ResultSet.toLong((String)o);
                }
                --count;
            }
        } else if (type == 2) {
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsLength) : new BigDecimal[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : AbstractJdbc2ResultSet.toBigDecimal((String)v, -1));
                --count;
            }
        } else if (type == 7) {
            float[] pa = null;
            Object[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Float.class : Float.TYPE, dimsLength) : new Float[count];
                ret = oa;
            } else {
                pa = new float[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Float(AbstractJdbc2ResultSet.toFloat((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0f : AbstractJdbc2ResultSet.toFloat((String)o);
                }
                --count;
            }
        } else if (type == 8) {
            double[] pa = null;
            Object[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Double.class : Double.TYPE, dimsLength) : new Double[count];
                ret = oa;
            } else {
                pa = new double[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Double(AbstractJdbc2ResultSet.toDouble((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0 : AbstractJdbc2ResultSet.toDouble((String)o);
                }
                --count;
            }
        } else if (type == 1 || type == 12) {
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(String.class, dimsLength) : new String[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : v;
                --count;
            }
        } else if (type == 91) {
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Date.class, dimsLength) : new Date[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toDate(null, (String)v));
                --count;
            }
        } else if (type == 92) {
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Time.class, dimsLength) : new Time[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTime(null, (String)v));
                --count;
            }
        } else if (type == 93) {
            Object[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsLength) : new Timestamp[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTimestamp(null, (String)v));
                --count;
            }
        } else {
            if (this.connection.getLogger().logDebug()) {
                this.connection.getLogger().debug("getArrayImpl(long,int,Map) with " + this.getBaseTypeName());
            }
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        return ret;
    }

    public int getBaseType() throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        this.buildArrayList();
        int elementOID = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        return this.connection.getTypeInfo().getPGType(elementOID);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long index, int count, Map map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(this.arrayList.size())}), PSQLState.DATA_ERROR);
        }
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        if (this.arrayList.dimensionsCount <= 1) {
            int baseOid = this.connection.getTypeInfo().getPGArrayElement(this.oid);
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", baseOid);
            int i = 0;
            while (i < count) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                String v = (String)this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(v);
                rows.add(t);
                ++i;
            }
        } else {
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", this.oid);
            int i = 0;
            while (i < count) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                Object v = this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(this.toString((PgArrayList)v));
                rows.add(t);
                ++i;
            }
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        return this.fieldString;
    }

    private String toString(PgArrayList list) throws SQLException {
        StringBuffer b = new StringBuffer().append('{');
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        int i = 0;
        while (i < list.size()) {
            Object v = list.get(i);
            if (i > 0) {
                b.append(delim);
            }
            if (v == null) {
                b.append("NULL");
            } else if (v instanceof PgArrayList) {
                b.append(this.toString((PgArrayList)v));
            } else {
                AbstractJdbc2Array.escapeArrayElement(b, (String)v);
            }
            ++i;
        }
        b.append('}');
        return b.toString();
    }

    public static void escapeArrayElement(StringBuffer b, String s) {
        b.append('\"');
        int j = 0;
        while (j < s.length()) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
            ++j;
        }
        b.append('\"');
    }

    private static class PgArrayList
    extends ArrayList {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private PgArrayList() {
        }
    }
}

