/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.security.PrivilegedAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;

class GssAction
implements PrivilegedAction {
    private final PGStream pgStream;
    private final String host;
    private final String user;
    private final String password;
    private final String kerberosServerName;
    private final Logger logger;

    public GssAction(PGStream pgStream, String host, String user, String password, String kerberosServerName, Logger logger) {
        this.pgStream = pgStream;
        this.host = host;
        this.user = user;
        this.password = password;
        this.kerberosServerName = kerberosServerName;
        this.logger = logger;
    }

    public Object run() {
        try {
            Oid[] desiredMechs = new Oid[]{new Oid("1.2.840.113554.1.2.2")};
            GSSManager manager = GSSManager.getInstance();
            GSSName clientName = manager.createName(this.user, GSSName.NT_USER_NAME);
            GSSCredential clientCreds = manager.createCredential(clientName, 28800, desiredMechs, 1);
            GSSName serverName = manager.createName(String.valueOf(this.kerberosServerName) + "@" + this.host, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = manager.createContext(serverName, desiredMechs[0], clientCreds, 0);
            secContext.requestMutualAuth(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            boolean established = false;
            while (!established) {
                outToken = secContext.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" FE=> Password(GSS Authentication Token)");
                    }
                    this.pgStream.SendChar(112);
                    this.pgStream.SendInteger4(4 + outToken.length);
                    this.pgStream.Send(outToken);
                    this.pgStream.flush();
                }
                if (!secContext.isEstablished()) {
                    int response = this.pgStream.ReceiveChar();
                    if (response == 69) {
                        int l_elen = this.pgStream.ReceiveInteger4();
                        ServerErrorMessage l_errorMsg = new ServerErrorMessage(this.pgStream.ReceiveString(l_elen - 4), this.logger.getLogLevel());
                        if (this.logger.logDebug()) {
                            this.logger.debug(" <=BE ErrorMessage(" + l_errorMsg + ")");
                        }
                        return new PSQLException(l_errorMsg);
                    }
                    if (response == 82) {
                        if (this.logger.logDebug()) {
                            this.logger.debug(" <=BE AuthenticationGSSContinue");
                        }
                        int len = this.pgStream.ReceiveInteger4();
                        this.pgStream.ReceiveInteger4();
                        inToken = this.pgStream.Receive(len - 8);
                        continue;
                    }
                    return new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                established = true;
            }
        }
        catch (IOException e) {
            return e;
        }
        catch (GSSException gsse) {
            return new PSQLException(GT.tr("GSS Authentication failed"), PSQLState.CONNECTION_FAILURE, (Throwable)gsse);
        }
        return null;
    }
}

