/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.ref.PhantomReference;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3Query;

class SimpleQuery
implements V3Query {
    private final String[] fragments;
    private final ProtocolConnectionImpl protoConnection;
    private String statementName;
    private byte[] encodedStatementName;
    private Field[] fields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private PhantomReference cleanupRef;
    private int[] preparedTypes;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(String[] fragments, ProtocolConnectionImpl protoConnection) {
        this.fragments = fragments;
        this.protoConnection = protoConnection;
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.protoConnection);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        int i = 1;
        while (i < this.fragments.length) {
            if (parameters == null) {
                sbuf.append('?');
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
            ++i;
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        this.unprepare();
    }

    public SimpleQuery[] getSubqueries() {
        return null;
    }

    String[] getFragments() {
        return this.fragments;
    }

    void setStatementName(String statementName) {
        this.statementName = statementName;
        this.encodedStatementName = Utils.encodeUTF8(statementName);
    }

    void setStatementTypes(int[] paramTypes) {
        this.preparedTypes = paramTypes;
    }

    int[] getStatementTypes() {
        return this.preparedTypes;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] paramTypes) {
        if (this.statementName == null) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            if (paramTypes[i] != 0 && paramTypes[i] != this.preparedTypes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        int i = 0;
        while (i < this.preparedTypes.length) {
            if (this.preparedTypes[i] == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
    }

    Field[] getFields() {
        return this.fields;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean portalDescribed) {
        this.portalDescribed = portalDescribed;
    }

    boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean statementDescribed) {
        this.statementDescribed = statementDescribed;
    }

    void setCleanupRef(PhantomReference cleanupRef) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = cleanupRef;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
    }
}

