/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        int i = 0;
        while (i < data.length) {
            sb.append(Integer.toHexString(data[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i] & 0xF));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        ByteBuffer buf = utf8Charset.encode(CharBuffer.wrap(str));
        byte[] b = new byte[buf.limit()];
        buf.get(b, 0, buf.limit());
        return b;
    }

    public static StringBuffer appendEscapedLiteral(StringBuffer sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(value.length() * 11 / 10);
        }
        if (standardConformingStrings) {
            int i = 0;
            while (i < value.length()) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\'') {
                    sbuf.append('\'');
                }
                sbuf.append(ch);
                ++i;
            }
        } else {
            int i = 0;
            while (i < value.length()) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\\' || ch == '\'') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
                ++i;
            }
        }
        return sbuf;
    }

    public static StringBuffer appendEscapedIdentifier(StringBuffer sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(2 + value.length() * 11 / 10);
        }
        sbuf.append('\"');
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '\u0000') {
                throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers."), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (ch == '\"') {
                sbuf.append(ch);
            }
            sbuf.append(ch);
            ++i;
        }
        sbuf.append('\"');
        return sbuf;
    }
}

