/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

public class Parser {
    /*
     * Unable to fully structure code
     */
    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        block10: {
            if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
                standardConformingStrings = false;
            }
            if (!standardConformingStrings) ** GOTO lbl16
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        break;
                    }
                    case '\'': {
                        return offset;
                    }
                }
lbl16:
                // 3 sources

                ** while (++offset < query.length)
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                int d = offset + 2;
                while (d < query.length) {
                    if (query[d] == '$') {
                        endIdx = d;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d])) break;
                    ++d;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '-') {
            while (++offset < query.length) {
                if (query[offset] == '\r' || query[offset] == '\n') break;
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static boolean isOperatorChar(char c) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c) != -1;
    }

    public static boolean isIdentifierStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isIdentifierContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9' || c == '$';
    }

    public static boolean charTerminatesIdentifier(char c) {
        return c == '\"' || Parser.isSpace(c) || Parser.isOperatorChar(c);
    }

    public static boolean isDollarQuoteStartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f';
    }

    public static boolean isDollarQuoteContChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c > '\u007f' || c >= '0' && c <= '9';
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (arr[offA + i] != arr[offB + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

