################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
from .zyre_cffi import ffi
from .zyre_py_destructors import lib as libwrapper
from .build_zyre_cffi import lib
from .utils import *


class Zyre(object):
    """
    An open-source framework for proximity-based P2P apps
    """

    def __init__(self, name):
        """
        Constructor, creates a new Zyre node. Note that until you start the
        node it is silent and invisible to other nodes on the network.     
        The node name is provided to other nodes during discovery. If you  
        specify NULL, Zyre generates a randomized node name from the UUID. 
        """
        p = lib.zyre_new(to_bytes(name))
        if p == ffi.NULL:
            raise MemoryError("Could not allocate person")

        # ffi.gc returns a copy of the cdata object which will have the
        # destructor called when the Python object is GC'd:
        # https://cffi.readthedocs.org/en/latest/using.html#ffi-interface
        self._p = ffi.gc(p, libwrapper.zyre_destroy_py)

    def uuid(self):
        """
        Return our node UUID string, after successful initialization
        """
        return lib.zyre_uuid(self._p)

    def name(self):
        """
        Return our node name, after successful initialization. First 6
        characters of UUID by default.                                
        """
        return lib.zyre_name(self._p)

    def set_name(self, name):
        """
        Set the public name of this node overriding the default. The name is
        provide during discovery and come in each ENTER message.            
        """
        return lib.zyre_set_name(self._p, to_bytes(name))

    def set_header(self, name, ):
        """
        Set node header; these are provided to other nodes during discovery
        and come in each ENTER message.                                    
        """
        return lib.zyre_set_header(self._p, to_bytes(name), )

    def set_verbose(self):
        """
        Set verbose mode; this tells the node to log all traffic as well as
        all major events.                                                  
        """
        return lib.zyre_set_verbose(self._p)

    def set_port(self, port_nbr):
        """
        Set UDP beacon discovery port; defaults to 5670, this call overrides
        that so you can create independent clusters on the same network, for
        e.g. development vs. production. Has no effect after zyre_start().  
        """
        return lib.zyre_set_port(self._p, port_nbr)

    def set_evasive_timeout(self, interval):
        """
        Set the peer evasiveness timeout, in milliseconds. Default is 5000.
        This can be tuned in order to deal with expected network conditions
        and the response time expected by the application. This is tied to 
        the beacon interval and rate of messages received.                 
        """
        return lib.zyre_set_evasive_timeout(self._p, interval)

    def set_expired_timeout(self, interval):
        """
        Set the peer expiration timeout, in milliseconds. Default is 30000.
        This can be tuned in order to deal with expected network conditions
        and the response time expected by the application. This is tied to 
        the beacon interval and rate of messages received.                 
        """
        return lib.zyre_set_expired_timeout(self._p, interval)

    def set_interval(self, interval):
        """
        Set UDP beacon discovery interval, in milliseconds. Default is instant
        beacon exploration followed by pinging every 1,000 msecs.             
        """
        return lib.zyre_set_interval(self._p, interval)

    def set_interface(self, value):
        """
        Set network interface for UDP beacons. If you do not set this, CZMQ will
        choose an interface for you. On boxes with several interfaces you should
        specify which one you want to use, or strange things can happen.        
        """
        return lib.zyre_set_interface(self._p, to_bytes(value))

    def set_endpoint(self, ):
        """
        By default, Zyre binds to an ephemeral TCP port and broadcasts the local 
        host name using UDP beaconing. When you call this method, Zyre will use  
        gossip discovery instead of UDP beaconing. You MUST set-up the gossip    
        service separately using zyre_gossip_bind() and _connect(). Note that the
        endpoint MUST be valid for both bind and connect operations. You can use 
        inproc://, ipc://, or tcp:// transports (for tcp://, use an IP address   
        that is meaningful to remote as well as local nodes). Returns 0 if       
        the bind was successful, else -1.                                        
        """
        return lib.zyre_set_endpoint(self._p, )

    def gossip_bind(self, ):
        """
        Set-up gossip discovery of other nodes. At least one node in the cluster
        must bind to a well-known gossip endpoint, so other nodes can connect to
        it. Note that gossip endpoints are completely distinct from Zyre node   
        endpoints, and should not overlap (they can use the same transport).    
        """
        return lib.zyre_gossip_bind(self._p, )

    def gossip_connect(self, ):
        """
        Set-up gossip discovery of other nodes. A node may connect to multiple
        other nodes, for redundancy paths. For details of the gossip network  
        design, see the CZMQ zgossip class.                                   
        """
        return lib.zyre_gossip_connect(self._p, )

    def start(self):
        """
        Start node, after setting header values. When you start a node it
        begins discovery and connection. Returns 0 if OK, -1 if it wasn't
        possible to start the node.                                      
        """
        return lib.zyre_start(self._p)

    def stop(self):
        """
        Stop node; this signals to other peers that this node will go away.
        This is polite; however you can also just destroy the node without 
        stopping it.                                                       
        """
        return lib.zyre_stop(self._p)

    def join(self, group):
        """
        Join a named group; after joining a group you can send messages to
        the group and all Zyre nodes in that group will receive them.     
        """
        return lib.zyre_join(self._p, to_bytes(group))

    def leave(self, group):
        """
        Leave a group
        """
        return lib.zyre_leave(self._p, to_bytes(group))

    def recv(self):
        """
        Receive next message from network; the message may be a control
        message (ENTER, EXIT, JOIN, LEAVE) or data (WHISPER, SHOUT).   
        Returns zmsg_t object, or NULL if interrupted                  
        """
        return lib.zyre_recv(self._p)

    def whisper(self, peer, msg_p):
        """
        Send message to single peer, specified as a UUID string
        Destroys message after sending                         
        """
        return lib.zyre_whisper(self._p, to_bytes(peer), msg_p._p)

    def shout(self, group, msg_p):
        """
        Send message to a named group 
        Destroys message after sending
        """
        return lib.zyre_shout(self._p, to_bytes(group), msg_p._p)

    def whispers(self, peer, ):
        """
        Send formatted string to a single peer specified as UUID string
        """
        return lib.zyre_whispers(self._p, to_bytes(peer), )

    def shouts(self, group, ):
        """
        Send formatted string to a named group
        """
        return lib.zyre_shouts(self._p, to_bytes(group), )

    def peers(self):
        """
        Return zlist of current peer ids.
        """
        return lib.zyre_peers(self._p)

    def peers_by_group(self, name):
        """
        Return zlist of current peers of this group.
        """
        return lib.zyre_peers_by_group(self._p, to_bytes(name))

    def own_groups(self):
        """
        Return zlist of currently joined groups.
        """
        return lib.zyre_own_groups(self._p)

    def peer_groups(self):
        """
        Return zlist of groups known through connected peers.
        """
        return lib.zyre_peer_groups(self._p)

    def peer_address(self, peer):
        """
        Return the endpoint of a connected peer.
        """
        return lib.zyre_peer_address(self._p, to_bytes(peer))

    def peer_header_value(self, peer, name):
        """
        Return the value of a header of a conected peer.
        Returns null if peer or key doesn't exits.      
        """
        return lib.zyre_peer_header_value(self._p, to_bytes(peer), to_bytes(name))

    def socket(self):
        """
        Return socket for talking to the Zyre node, for polling
        """
        return lib.zyre_socket(self._p)

    def print(self):
        """
        Print zyre node information to stdout
        """
        return lib.zyre_print(self._p)

    def version():
        """
        Return the Zyre version for run-time API detection; returns
        major * 10000 + minor * 100 + patch, as a single integer.  
        """
        return lib.zyre_version()

    def test(verbose):
        """
        Self test of this class.
        """
        return lib.zyre_test(verbose)

