# -*- coding: utf-8 -*-
#
# ccwatcher (http://ccwatcher.sourceforge.net/)
# Copyright (C) 2009-2013 Xaver Wurzenberger <xaverxn at users.sourceforge.net>
#
# This program is free software; you can redistribute and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

"""ccwatcher_gui/ccw_setup_gui.py
"""

import ccwatcher_py.ccw_setup_cli
from PyQt4 import QtGui, QtCore
import os


class ccwsetup_mainwin(QtGui.QDialog):#QMessageBox):

    def __init__(self, parent = None):
        super(ccwsetup_mainwin, self).__init__(parent)

        self.rawtext, self.avopath, self.gnupath, self.plotsystem =  ccwatcher_py.ccw_setup_cli.main(bool_silent = True,  onlyread = True)

        self.convertText()
        
        self.ccsetuplabel = QtGui.QLabel(self.htmltext)
        hrule = QtGui.QFrame()
        hrule.setFrameShape(QtGui.QFrame.HLine)
        hrule.setFrameShadow(QtGui.QFrame.Sunken)
        hrule2 = QtGui.QFrame()
        hrule2.setFrameShape(QtGui.QFrame.HLine)
        hrule2.setFrameShadow(QtGui.QFrame.Sunken)
        self.gnupathEdit = QtGui.QLineEdit()
        if self.gnupath:
            self.gnupathEdit.insert(self.gnupath)
        self.gnupathLabel = QtGui.QLabel("&Gnuplot path:")
        self.gnupathLabel.setBuddy(self.gnupathEdit)
        self.gnuchoosebutton = QtGui.QPushButton("Open...")
        self.avopathEdit = QtGui.QLineEdit()
        if self.avopath:
            self.avopathEdit.insert(self.avopath)
        self.avopathLabel = QtGui.QLabel("&Avogadro path:")
        self.avopathLabel.setBuddy(self.avopathEdit)
        self.avochoosebutton = QtGui.QPushButton("Open...")
        self.prefergnulabel = QtGui.QLabel("Prefer Gnuplot over Qwt?")
        self.prefergnubox = QtGui.QCheckBox()
        self.checkbutton = QtGui.QPushButton("Re-check")
        self.buttonBox = QtGui.QDialogButtonBox(QtGui.QDialogButtonBox.Save|QtGui.QDialogButtonBox.Cancel)
        
        gnulayout = QtGui.QHBoxLayout()
        gnulayout.addWidget(self.gnupathLabel)
        gnulayout.addWidget(self.gnupathEdit)
        gnulayout.addWidget(self.gnuchoosebutton)
        gnulayout.addWidget(self.prefergnulabel)
        gnulayout.addWidget(self.prefergnubox)

        avolayout = QtGui.QHBoxLayout()
        avolayout.addWidget(self.avopathLabel)
        avolayout.addWidget(self.avopathEdit)
        avolayout.addWidget(self.avochoosebutton)
        
        cclayout = QtGui.QVBoxLayout()
        cclayout.addWidget(self.ccsetuplabel)
        cclayout.addWidget(hrule)
        cclayout.addLayout(gnulayout)
        cclayout.addLayout(avolayout)
        cclayout.addWidget(self.checkbutton)
        cclayout.addWidget(hrule2)
        cclayout.addWidget(self.buttonBox)
        self.setLayout(cclayout)
        
        self.connect(self.buttonBox, QtCore.SIGNAL("accepted()"), QtCore.SLOT("accept()"))
        self.connect(self.buttonBox, QtCore.SIGNAL("rejected()"), QtCore.SLOT("reject()"))
        self.connect(self.avochoosebutton, QtCore.SIGNAL("clicked()"), self.getAvoPath)
        self.connect(self.gnuchoosebutton, QtCore.SIGNAL("clicked()"), self.getGnuPath)
        self.connect(self.prefergnubox, QtCore.SIGNAL("stateChanged(int)"), self.gnuPref)
        self.connect(self.checkbutton, QtCore.SIGNAL("clicked()"), self.recheck)
        
        self.show()

                
    def getAvoPath(self):
        self.avopath = QtGui.QFileDialog.getOpenFileName(self, "", "Open file ...", "All files (*.*)") #type: QString
        self.avopathEdit.clear()
        self.avopathEdit.insert(self.avopath)


    def getGnuPath(self):
        self.gnupath = QtGui.QFileDialog.getOpenFileName(self, "", "Open file ...", "All files (*.*)") #type: QString
        self.gnupathEdit.clear()
        self.gnupathEdit.insert(self.gnupath)
        
        
    def gnuPref(self):
        if self.prefergnubox.checkState() == 2:
            if self.gnupathEdit.text() and os.path.exists(self.gnupathEdit.text()):
                self.plotsystem = 'gnuplot'
            else:
                QtGui.QMessageBox.critical(self,  "Gnuplot executable not existant",  "Can't find the entered gnuplot path!")
                self.prefergnubox.setCheckState(0)
        else:
            pass


    def recheck(self):
        if len(self.gnupathEdit.text()) and not os.path.exists(self.gnupathEdit.text()):
            QtGui.QMessageBox.critical(self,  "Gnuplot executable not existant",  "Can't find the entered gnuplot path!\nUsing auto-search")
            self.gnupathEdit.clear()
        if len(self.avopathEdit.text()) and not os.path.exists(self.avopathEdit.text()):
            QtGui.QMessageBox.critical(self,  "Avogadro executable not existant",  "Can't find the entered avogadro path!\nUsing auto-search")
            self.avopathEdit.clear()
        self.rawtext, self.avopath, self.gnupath, self.plotsystem =  ccwatcher_py.ccw_setup_cli.main(bool_silent = True,  onlyread = True,  avo = self.avopathEdit.text(),  gnu = self.gnupathEdit.text(),  plot = self.plotsystem)
        self.convertText()
        self.ccsetuplabel.setText(self.htmltext)
        self.gnupathEdit.clear()
        self.avopathEdit.clear()
        self.gnupathEdit.insert(self.gnupath)
        self.avopathEdit.insert(self.avopath)
        


    def convertText(self):
        self.text = self.rawtext.replace("\n", "        ")
        self.htmltext = ''
        for line in self.rawtext.split("\n"):
            if line.strip()[0:2] == "OK":
                self.htmltext += "<p align='center'><font color = '#00C000'>"
                self.htmltext += line
                self.htmltext += "</font></p>"
            elif line.strip()[0:7] == "WARNING":
                self.htmltext += "<p align='center'><font color = '#FF0000'>"
                self.htmltext += line
                self.htmltext += "</font></p>"
            elif line.strip()[0:5] == "CHECK":
                self.htmltext += "<p><i>"
                self.htmltext += line
                self.htmltext += "</i></p>"
            else:
                self.htmltext += "<p align='center'>"
                self.htmltext += line
                self.htmltext += "</p>"
