#!/usr/bin/python2
# -*- coding: utf-8 -*-
#
# ccwatcher (http://ccwatcher.sourceforge.net/)
# Copyright (C) 2009-2013 Xaver Wurzenberger <xaverxn at users.sourceforge.net>
#
# This program is free software; you can redistribute and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.


from ccwatcher_py import ccw_setup_cli
import sys

if __name__ == '__main__':
    
    try:
        
        from ccwatcher_gui import ccw_setup_gui
        setupapp = ccw_setup_gui.QtGui.QApplication(sys.argv)
        
    except:
        print "No graphical interface found - Starting CLI setup ..."
        ccw_setup_cli.main()        
        
    else:
        setupapp.setOrganizationName("ccwatcher")
        setupapp.setOrganizationDomain("http://sourceforge.net/projects/ccwatcher/")
        setupapp.setApplicationName("ccwatcher")
        csmainwin = ccw_setup_gui.ccwsetup_mainwin() # assignment to a variable is necessary despite what eric5 says
        setupapp.exec_()
        if csmainwin.result():
            avopath = csmainwin.avopathEdit.text()
            gnuplotpath = csmainwin.gnupathEdit.text()
            plotsystem = csmainwin.plotsystem
            messages = ccw_setup_cli.write_ini(avopath, gnuplotpath, plotsystem)
            ccw_setup_gui.QtGui.QMessageBox.information(csmainwin,"Saving ccwatcher settings", messages)

        



