gdjs.SceneStack = function(runtimeGame) {
    if (!runtimeGame) {
    	throw "SceneStack must be constructed with a gdjs.RuntimeGame."
    }

    this._runtimeGame = runtimeGame;
	this._stack = [];
};

gdjs.SceneStack.prototype.onRendererResized = function() {
	for(var i = 0;i < this._stack.length; ++i) {
		this._stack[i].onCanvasResized();
	}
};

gdjs.SceneStack.prototype.step = function(elapsedTime) {
	if (this._stack.length === 0) return false;

	var currentScene = this._stack[this._stack.length - 1];
    if (currentScene.renderAndStep(elapsedTime)) {
    	var request = currentScene.getRequestedChange();
        //Something special was requested by the current scene.
        if (request === gdjs.RuntimeScene.STOP_GAME) {
            return false;
        } else if (request === gdjs.RuntimeScene.POP_SCENE) {
        	this.pop();
        } else if (request === gdjs.RuntimeScene.PUSH_SCENE) {
        	this.push(currentScene.getRequestedScene());
        } else if (request === gdjs.RuntimeScene.REPLACE_SCENE) {
            this.replace(currentScene.getRequestedScene());
        } else if (request === gdjs.RuntimeScene.CLEAR_SCENES) {
        	this.replace(currentScene.getRequestedScene(), true);
        } else {
        	console.error("Unrecognized change in scene stack.");
        	return false;
        }
    }

    return true;
};

gdjs.SceneStack.prototype.pop = function() {
	if (this._stack.length <= 1) return null;

    var scene = this._stack.pop();
    scene.unloadScene();
	return scene;
};

gdjs.SceneStack.prototype.push = function(newSceneName, externalLayoutName) {
    var newScene = new gdjs.RuntimeScene(this._runtimeGame);
    newScene.loadFromScene(this._runtimeGame.getSceneData(newSceneName));

    //Optionally create the objects from an external layout.
    if (externalLayoutName) {
        var externalLayoutData = this._runtimeGame.getExternalLayoutData(externalLayoutName);
        if (externalLayoutData)
            newScene.createObjectsFrom(externalLayoutData.instances, 0, 0);
    }

    this._stack.push(newScene);
    return newScene;
};

gdjs.SceneStack.prototype.replace = function(newSceneName, clear) {
	if (!!clear) {
        while (this._stack.length !== 0) {
            var scene = this._stack.pop();
            scene.unloadScene();
        }
    } else {
        if (this._stack.length !== 0) {
            var scene = this._stack.pop();
            scene.unloadScene();
        }
    }

	return this.push(newSceneName);
};
