/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.JMenuItemFormatted;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import utils.PopupMouseListener;

public class PopupMenuTrait
extends JPopupMenu {
    public static final int POPUP_RELOAD = 4;
    public static final int POPUP_FLOATINGCOPY = 6;
    public static final int POPUP_SAVE = 8;
    public static final int POPUP_PDF = 10;
    protected JMenuItemFormatted menuItemReload;
    protected Integer[] popups;
    protected List<Integer> listPopups;
    protected JMenuItemFormatted[] menuItems;
    protected JPopupMenu popupMenu;

    public PopupMenuTrait(Integer[] integerArray) {
        this.popups = integerArray;
        this.listPopups = Arrays.asList(integerArray);
        this.menuItems = new JMenuItemFormatted[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            this.addPopup(integerArray[i]);
        }
    }

    protected void addPopup(int n) {
        switch (n) {
            case 4: {
                int n2 = this.listPopups.indexOf(n);
                this.menuItems[n2] = new JMenuItemFormatted(configed.getResourceValue("PopupMenuTrait.reload"), Globals.createImageIcon("images/reload16.png", ""));
                this.addItem(n);
                break;
            }
            case 6: {
                int n3 = this.listPopups.indexOf(n);
                this.menuItems[n3] = new JMenuItemFormatted(configed.getResourceValue("PopupMenuTrait.floatingInstance"), Globals.createImageIcon("images/edit-copy.png", ""));
                this.addSeparator();
                this.addItem(n);
                break;
            }
            case 8: {
                int n4 = this.listPopups.indexOf(n);
                this.menuItems[n4] = new JMenuItemFormatted(configed.getResourceValue("PopupMenuTrait.save"));
                this.addItem(n);
                break;
            }
            case 10: {
                int n5 = this.listPopups.indexOf(n);
                this.menuItems[n5] = new JMenuItemFormatted(configed.getResourceValue("FGeneralDialog.pdf"), Globals.createImageIcon("images/acrobat_reader16.png", ""));
                this.addItem(n);
                break;
            }
            default: {
                logging.info(this, "popuptype " + n + " not implemented");
            }
        }
    }

    protected void addItem(final int n) {
        int n2 = this.listPopups.indexOf(n);
        this.menuItems[n2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupMenuTrait.this.action(n);
            }
        });
        this.add(this.menuItems[n2]);
    }

    public void addPopupListenersTo(JComponent[] jComponentArray) {
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].addMouseListener(new PopupMouseListener(this));
        }
    }

    public void action(int n) {
        logging.debug(this, "action called for type " + n);
    }
}

