/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.hwinfopage;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.hwinfopage.PanelHWByAuditDriver;
import de.uib.configed.tree.IconNode;
import de.uib.configed.tree.IconNodeRenderer;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentToPdf;
import de.uib.utilities.swing.PopupMenuTrait;
import de.uib.utilities.table.gui.ColorTableCellRenderer;
import de.uib.utilities.tree.XTree;
import java.awt.Dimension;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PanelHWInfo
extends JPanel
implements TreeSelectionListener {
    public static final String class_COMPUTER_SYSTEM = "COMPUTER_SYSTEM";
    public static final String class_BASE_BOARD = "BASE_BOARD";
    public static final ArrayList<String> hwClassesForByAudit = new ArrayList();
    public static final String key_VENDOR = "vendor";
    public static final String key_MODEL = "model";
    public static final String key_PRODUCT = "product";
    protected Map hwInfo;
    protected String treeRootTitle;
    protected List hwConfig;
    protected String title = "HW Information";
    private Map<String, String> hwOpsiToUI;
    protected DocumentToPdf tableToPDF;
    protected JSplitPane contentPane;
    protected JScrollPane jScrollPaneTree;
    protected JScrollPane jScrollPaneInfo;
    protected XTree tree;
    protected IconNode root;
    protected TreePath rootPath;
    protected DefaultTreeModel treeModel;
    protected JTable table;
    protected HWInfoTableModel tableModel;
    protected HashMap hwClassMapping;
    protected static final String SCANPROPERTYNAME = "SCANPROPERTIES";
    protected static final String SCANTIME = "scantime";
    protected String vendorStringCOMPUTER_SYSTEM;
    protected String vendorStringBASE_BOARD;
    protected String modelString;
    protected String productString;
    private PanelHWByAuditDriver panelByAuditInfo;
    protected PopupMenuTrait popupMenu;
    protected int hGap = 5;
    protected int vGap = 5;
    protected int hLabel = 24;
    protected IconNode selectedNode;
    protected boolean withPopup;
    private final ArrayList EMPTY = new ArrayList();
    ConfigedMain main;

    public PanelHWInfo(ConfigedMain configedMain) {
        this(true, configedMain);
    }

    public PanelHWInfo(boolean bl, ConfigedMain configedMain) {
        this.withPopup = bl;
        this.main = configedMain;
        this.buildPanel();
    }

    private String encodeString(String string) {
        return string;
    }

    protected void buildPanel() {
        this.panelByAuditInfo = new PanelHWByAuditDriver(this.title, this.main);
        this.tree = new XTree(null);
        this.jScrollPaneTree = new JScrollPane(this.tree);
        this.jScrollPaneTree.setVerticalScrollBarPolicy(22);
        this.jScrollPaneTree.setMinimumSize(new Dimension(200, 200));
        this.jScrollPaneTree.setPreferredSize(new Dimension(400, 200));
        this.tableModel = new HWInfoTableModel();
        this.table = new JTable(this.tableModel, null);
        this.table.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.table.setTableHeader(null);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.setDragEnabled(true);
        this.table.setBackground(Globals.nimbusBackground);
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addComponent(this.table, -2, -2, Short.MAX_VALUE).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(this.table, -2, -2, Short.MAX_VALUE).addGap(this.vGap, this.vGap, this.vGap));
        this.jScrollPaneInfo = new JScrollPane(jPanel);
        this.jScrollPaneInfo.setVerticalScrollBarPolicy(22);
        this.contentPane = new JSplitPane(1, this.jScrollPaneTree, this.jScrollPaneInfo);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addGroup(groupLayout2.createParallelGroup().addGroup(groupLayout2.createSequentialGroup().addGap(this.hGap - 2, this.hGap - 2, this.hGap - 2).addComponent(this.panelByAuditInfo, 30, -2, Short.MAX_VALUE).addGap(this.hGap - 2, this.hGap - 2, this.hGap - 2)).addComponent(this.contentPane, 100, -2, Short.MAX_VALUE)).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(this.panelByAuditInfo, -2, -2, -2).addGap(this.vGap / 2, this.vGap / 2, this.vGap / 2).addComponent(this.contentPane, -2, -2, Short.MAX_VALUE));
        if (this.withPopup) {
            this.popupMenu = new PopupMenuTrait(new Integer[]{4, 10, 6}){

                @Override
                public void action(int n) {
                    switch (n) {
                        case 4: {
                            PanelHWInfo.this.reload();
                            break;
                        }
                        case 6: {
                            PanelHWInfo.this.floatExternal();
                            break;
                        }
                        case 10: {
                            logging.info(this, "------------- create report");
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("header", configed.getResourceValue("PanelHWInfo.createPDF.title"));
                            PanelHWInfo.this.title = "";
                            if (PanelHWInfo.this.main.getHostsStatusInfo().getInvolvedDepots().length() != 0) {
                                PanelHWInfo.this.title = PanelHWInfo.this.title + "Depot: " + PanelHWInfo.this.main.getHostsStatusInfo().getInvolvedDepots();
                            }
                            if (PanelHWInfo.this.main.getHostsStatusInfo().getSelectedClientNames().length() != 0) {
                                PanelHWInfo.this.title = PanelHWInfo.this.title + "; Client: " + PanelHWInfo.this.main.getHostsStatusInfo().getSelectedClientNames();
                            }
                            hashMap.put("title", PanelHWInfo.this.title);
                            hashMap.put("keywords", "hardware infos");
                            PanelHWInfo.this.tableToPDF = new DocumentToPdf(null, hashMap);
                            PanelHWInfo.this.tableToPDF.createContentElement("table", PanelHWInfo.this.CreateHWInfoTableModelComplete());
                            PanelHWInfo.this.tableToPDF.setPageSizeA4_Landscape();
                            PanelHWInfo.this.tableToPDF.toPDF();
                        }
                    }
                }
            };
            this.popupMenu.addPopupListenersTo(new JComponent[]{this.tree, this.table});
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.panelByAuditInfo.setTitle(string);
    }

    protected void reload() {
        logging.debug(this, "reload action");
    }

    protected void floatExternal() {
        PanelHWInfo panelHWInfo = new PanelHWInfo(false, this.main);
        panelHWInfo.setHardwareConfig(this.hwConfig);
        panelHWInfo.setHardwareInfo(this.hwInfo, this.treeRootTitle);
        panelHWInfo.expandRows(this.tree.getToggledRows(this.rootPath));
        panelHWInfo.setSelectedRow(this.tree.getMinSelectionRow());
        GeneralFrame generalFrame = new GeneralFrame(null, this.title, false);
        generalFrame.addPanel(panelHWInfo);
        generalFrame.setup();
        generalFrame.setSize(this.getSize());
        generalFrame.centerOn(Globals.mainFrame);
        generalFrame.setVisible(true);
    }

    private ImageIcon createImageIcon(String string) {
        return Globals.createImageIcon(string, "");
    }

    protected void createRoot(String string) {
        this.root = new IconNode(string);
        ImageIcon imageIcon = this.createImageIcon("hwinfo_images/DEVICE.png");
        this.root.setClosedIcon(imageIcon);
        this.root.setLeafIcon(imageIcon);
        this.root.setOpenIcon(imageIcon);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree.setModel(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new IconNodeRenderer());
        this.rootPath = this.tree.getPathForRow(0);
    }

    protected String addUnit(String string, String string2) {
        if (string.equals("")) {
            return string;
        }
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (Exception exception) {
            return string + " " + string2;
        }
        int n = 1000;
        if (string2.toLowerCase().equals("byte")) {
            n = 1024;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(n * n * n)) >= 0) {
            return (float)Math.round(bigInteger.floatValue() * 1000.0f / (float)(n * n * n)) / 1000.0f + " G" + string2;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(n * n)) >= 0) {
            return (float)Math.round(bigInteger.floatValue() * 1000.0f / (float)(n * n)) / 1000.0f + " M" + string2;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(n)) >= 0) {
            return (float)Math.round(bigInteger.floatValue() * 1000.0f / (float)n) / 1000.0f + " k" + string2;
        }
        return string + " " + string2;
    }

    private void expandRows(Vector<Integer> vector) {
        this.tree.expandRows(vector);
    }

    private void setSelectedRow(int n) {
        this.tree.setSelectionInterval(n, n);
    }

    private ArrayList getDataForNode(IconNode iconNode) {
        return this.getDataForNode(iconNode, false);
    }

    private ArrayList getDataForNode(IconNode iconNode, boolean bl) {
        if (iconNode == null || !iconNode.isLeaf()) {
            return this.EMPTY;
        }
        TreeNode[] treeNodeArray = iconNode.getPath();
        if (treeNodeArray.length < 3) {
            return this.EMPTY;
        }
        String string = treeNodeArray[1].toString();
        String string2 = treeNodeArray[2].toString();
        String string3 = (String)this.hwClassMapping.get(string);
        if (string3 != null && bl && !hwClassesForByAudit.contains(string3)) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.hwInfo.get(string3);
        Map map = iconNode.getDeviceInfo();
        if (arrayList == null || map == null) {
            return this.EMPTY;
        }
        List list = null;
        for (int i = 0; i < this.hwConfig.size(); ++i) {
            try {
                Map map2 = (Map)this.hwConfig.get(i);
                if (!((String)((Map)map2.get("Class")).get("Opsi")).equals(string3)) continue;
                list = (List)map2.get("Values");
                break;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        if (list != null) {
            block3: for (int i = 0; i < list.size(); ++i) {
                Map map3 = (Map)list.get(i);
                String string4 = (String)map3.get("Opsi");
                logging.debug(this, "opsi " + string4);
                String string5 = this.encodeString((String)map3.get("UI"));
                String string6 = null;
                if (map3.containsKey("Unit")) {
                    string6 = (String)map3.get("Unit");
                    logging.debug(this, "unit  " + string6);
                }
                for (String string7 : map.keySet()) {
                    if (!string7.equalsIgnoreCase(string4)) continue;
                    String string8 = "";
                    string8 = map.get(string7) instanceof String ? (String)map.get(string7) : "" + map.get(string7);
                    if (bl && string3 != null) {
                        logging.debug(this, "key " + string4);
                        if (string3.equals(class_COMPUTER_SYSTEM)) {
                            if (string4.equalsIgnoreCase(key_VENDOR)) {
                                this.vendorStringCOMPUTER_SYSTEM = string8;
                            } else if (string4.equalsIgnoreCase(key_MODEL)) {
                                this.modelString = string8;
                            }
                        } else if (string3.equals(class_BASE_BOARD)) {
                            if (string4.equalsIgnoreCase(key_VENDOR)) {
                                this.vendorStringBASE_BOARD = string8;
                            } else if (string4.equalsIgnoreCase(key_PRODUCT)) {
                                this.productString = string8;
                            }
                        }
                    }
                    if (string6 != null) {
                        string8 = this.addUnit(string8, string6);
                    }
                    Object[] objectArray = new String[]{string5, string8};
                    arrayList2.add(objectArray);
                    logging.debug(this, "hwClass row  version 1 " + string3 + ": " + Arrays.toString(objectArray));
                    continue block3;
                }
            }
        } else {
            for (String string9 : map.keySet()) {
                Object[] objectArray = new String[]{string9, (String)map.get(string9)};
                arrayList2.add(objectArray);
                logging.debug(this, "hwClass row  " + string3 + ": " + Arrays.toString(objectArray));
            }
        }
        return arrayList2;
    }

    private void setNode(IconNode iconNode) {
        this.selectedNode = iconNode;
        this.tableModel.setData(this.getDataForNode(iconNode));
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IconNode iconNode = (IconNode)this.tree.getLastSelectedPathComponent();
        if (iconNode == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        logging.debug(this, "selectedPath " + treePath);
        int n = this.tree.getRowForPath(treePath);
        if (!iconNode.isLeaf()) {
            this.tree.expandPath(treePath);
        }
        this.setNode(iconNode);
    }

    public void setHardwareConfig(List list) {
        this.hwConfig = list;
    }

    private void scanNodes(IconNode iconNode) {
        if (iconNode != null && iconNode.isLeaf()) {
            TreeNode[] treeNodeArray = iconNode.getPath();
            if (treeNodeArray.length < 3) {
                this.tableModel.setData(new ArrayList());
                return;
            }
            String string = treeNodeArray[1].toString();
            String string2 = treeNodeArray[2].toString();
            String string3 = (String)this.hwClassMapping.get(string);
            if (string3 != null && (string3.equals(class_COMPUTER_SYSTEM) || string3.equals(class_BASE_BOARD))) {
                logging.debug(this, "scanNode found  class_COMPUTER_SYSTEM or class_BASE_BOARD");
                this.getDataForNode(iconNode, true);
                this.panelByAuditInfo.setByAuditFields(this.vendorStringCOMPUTER_SYSTEM, this.vendorStringBASE_BOARD, this.modelString, this.productString);
            }
        }
    }

    protected void initByAuditStrings() {
        this.vendorStringCOMPUTER_SYSTEM = "";
        this.vendorStringBASE_BOARD = "";
        this.modelString = "";
        this.productString = "";
    }

    public void setHardwareInfo(Map map, String string) {
        Object object;
        int n;
        this.initByAuditStrings();
        this.panelByAuditInfo.emptyByAuditStrings();
        this.hwInfo = map;
        this.treeRootTitle = string;
        if (map == null) {
            this.createRoot(string);
            this.tableModel.setData(this.EMPTY);
            return;
        }
        List list = (List)map.get(SCANPROPERTYNAME);
        String string2 = "";
        if (list != null && list.size() > 0 && list.get(0) != null && ((Map)list.get(0)).get(SCANTIME) != null) {
            string2 = "Scan " + (String)((Map)list.get(0)).get(SCANTIME);
        }
        this.title = string2;
        this.createRoot(string2);
        this.tableModel.setData(new ArrayList());
        if (this.hwConfig == null) {
            logging.info("hwConfig null");
            return;
        }
        if (map == null) {
            logging.info("hwInfo null");
            return;
        }
        this.hwClassMapping = new HashMap();
        Object[] objectArray = new String[this.hwConfig.size()];
        for (n = 0; n < this.hwConfig.size(); ++n) {
            object = (Map)this.hwConfig.get(n);
            objectArray[n] = (String)((Map)object.get("Class")).get("UI");
            this.hwClassMapping.put(objectArray[n], (String)((Map)object.get("Class")).get("Opsi"));
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            Object[] objectArray2;
            int n2;
            object = objectArray[n];
            String string3 = (String)this.hwClassMapping.get(object);
            ArrayList arrayList = (ArrayList)map.get(string3);
            if (arrayList == null) {
                logging.debug(this, "No devices of hwclass " + string3 + " found");
                continue;
            }
            IconNode iconNode = new IconNode(this.encodeString((String)object));
            ImageIcon imageIcon = this.createImageIcon("hwinfo_images/" + string3 + ".png");
            if (imageIcon == null) {
                imageIcon = this.createImageIcon("hwinfo_images/DEVICE.png");
            }
            iconNode.setClosedIcon(imageIcon);
            iconNode.setLeafIcon(imageIcon);
            iconNode.setOpenIcon(imageIcon);
            this.root.add(iconNode);
            HashMap hashMap = new HashMap();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                objectArray2 = (Object[])arrayList.get(n2);
                Object object2 = (String)objectArray2.get("name");
                if (object2 == null || ((String)object2).equals("")) {
                    object2 = string3 + "_" + n2;
                }
                if (!hashMap.containsKey(object2)) {
                    hashMap.put(object2, new ArrayList());
                }
                ((ArrayList)hashMap.get(object2)).add(arrayList.get(n2));
            }
            n2 = 0;
            objectArray2 = new String[arrayList.size()];
            for (String string4 : hashMap.keySet()) {
                ArrayList arrayList2 = (ArrayList)hashMap.get(string4);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    HashMap hashMap2 = (HashMap)arrayList2.get(i);
                    String string5 = string4;
                    if (arrayList2.size() > 1) {
                        string5 = string5 + " (" + i + ")";
                    }
                    hashMap2.put("displayName", string5);
                    objectArray2[n2] = string5;
                    ++n2;
                }
            }
            Arrays.sort(objectArray2);
            block5: for (int i = 0; i < objectArray2.length; ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (!((String)objectArray2[i]).equals((String)((HashMap)arrayList.get(j)).get("displayName"))) continue;
                    IconNode iconNode2 = new IconNode(this.encodeString((String)((HashMap)arrayList.get(j)).get("displayName")));
                    iconNode2.setClosedIcon(imageIcon);
                    iconNode2.setLeafIcon(imageIcon);
                    iconNode2.setOpenIcon(imageIcon);
                    iconNode2.setDeviceInfo((HashMap)arrayList.get(j));
                    iconNode.add(iconNode2);
                    this.scanNodes(iconNode2);
                    continue block5;
                }
            }
        }
        this.treeModel.nodeChanged(this.root);
        this.tree.expandRow(0);
        this.tree.expandRow(1);
    }

    private void getLocalizedHashMap() {
        Object object;
        Map map;
        String string = "";
        this.hwOpsiToUI = new HashMap<String, String>();
        for (Object e : this.hwConfig) {
            map = (Map)e;
            object = (List)map.get("Values");
            for (int i = 0; i < object.size(); ++i) {
                Map map2 = (Map)object.get(i);
                String string2 = (String)map2.get("Opsi");
                String string3 = (String)map2.get("UI");
                if (this.hwOpsiToUI.containsKey(string2)) continue;
                this.hwOpsiToUI.put(string2, string3);
            }
        }
        for (Object e : this.hwConfig) {
            map = (Map)e;
            object = (String)((Map)map.get("Class")).get("UI");
            String string4 = (String)((Map)map.get("Class")).get("Opsi");
            if (this.hwOpsiToUI.containsKey(string4)) continue;
            this.hwOpsiToUI.put(string4, (String)object);
        }
    }

    private JTable CreateHWInfoTableModelComplete() {
        this.getLocalizedHashMap();
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        JTable jTable = new JTable(defaultTableModel);
        defaultTableModel.addColumn(configed.getResourceValue("PanelHWInfo.createPDF.column_hardware"));
        defaultTableModel.addColumn(configed.getResourceValue("PanelHWInfo.createPDF.column_device"));
        defaultTableModel.addColumn(configed.getResourceValue("PanelHWInfo.createPDF.column_name"));
        defaultTableModel.addColumn(configed.getResourceValue("PanelHWInfo.createPDF.column_value"));
        for (int i = 0; i < this.treeModel.getChildCount(this.treeModel.getRoot()); ++i) {
            Object object = this.treeModel.getChild(this.treeModel.getRoot(), i);
            ArrayList arrayList = (ArrayList)this.hwInfo.get(this.hwClassMapping.get(object.toString()));
            Iterator iterator = arrayList.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                String string;
                boolean bl2;
                Iterator iterator2;
                Vector<String> vector;
                HashMap hashMap = (HashMap)iterator.next();
                if (bl) {
                    vector = new Vector<String>();
                    vector.add(object.toString());
                    vector.add(hashMap.get("displayName").toString());
                    iterator2 = hashMap.keySet().iterator();
                    bl2 = true;
                    while (iterator2.hasNext()) {
                        string = (String)iterator2.next();
                        if (string.equals("displayName") || string.equals("type")) continue;
                        if (bl2) {
                            vector.add(this.hwOpsiToUI.get(string));
                            vector.add((String)hashMap.get(string));
                            bl2 = false;
                        } else {
                            vector = new Vector();
                            vector.add("");
                            vector.add("");
                            vector.add(this.hwOpsiToUI.get(string));
                            vector.add((String)hashMap.get(string));
                        }
                        defaultTableModel.addRow(vector);
                    }
                    bl = false;
                    continue;
                }
                vector = new Vector();
                vector.add("");
                vector.add(hashMap.get("displayName").toString());
                iterator2 = hashMap.keySet().iterator();
                bl2 = true;
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    if (string.equals("displayName") || string.equals("type")) continue;
                    if (bl2) {
                        bl2 = false;
                        vector.add(this.hwOpsiToUI.get(string));
                        vector.add((String)hashMap.get(string));
                    } else {
                        vector = new Vector();
                        vector.add("");
                        vector.add("");
                        vector.add(this.hwOpsiToUI.get(string));
                        vector.add((String)hashMap.get(string));
                    }
                    defaultTableModel.addRow(vector);
                }
            }
        }
        return jTable;
    }

    static {
        hwClassesForByAudit.add(class_COMPUTER_SYSTEM);
        hwClassesForByAudit.add(class_BASE_BOARD);
    }

    private class HWInfoTableModel
    extends AbstractTableModel {
        private ArrayList data;
        private final String[] header = new String[]{"Name", "Wert"};

        public HWInfoTableModel() {
            this.data = new ArrayList();
        }

        public void setData(ArrayList arrayList) {
            this.data = arrayList;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return this.header[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ((String[])this.data.get(n))[n2];
        }
    }
}

