/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.hwinfopage;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.productaction.PanelMountShare;
import de.uib.connectx.SmbConnect;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.FileX;
import de.uib.utilities.NameProducer;
import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.JTextShowField;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;

public class PanelDriverUpload
extends JPanel
implements NameProducer {
    int firstLabelWidth = Globals.firstLabelWidth;
    int hFirstGap = Globals.hFirstGap;
    protected int hGap = 5;
    protected int vGap = 5;
    protected int hLabel = 24;
    protected String byAuditPath = "";
    protected JTextShowField fieldByAuditPath;
    protected JTextShowField fieldClientname;
    JComboBox comboChooseDepot;
    JComboBox comboChooseWinProduct;
    PanelMountShare panelMountShare;
    String depotProductDirectory = "";
    boolean smbMounted = false;
    String driverDirectory = "";
    RadioButtonIntegrationType buttonStandard;
    RadioButtonIntegrationType buttonPreferred;
    RadioButtonIntegrationType buttonNotPreferred;
    RadioButtonIntegrationType buttonAdditional;
    RadioButtonIntegrationType buttonByAudit;
    Vector<RadioButtonIntegrationType> radioButtons;
    JButton buttonCallSelectDriverFiles;
    protected JTextShowField fieldDriverPath;
    JFileChooser chooserDriverPath;
    JTextShowField fieldServerPath;
    JButton buttonCallChooserServerpath;
    JFileChooser chooserServerpath;
    File driverPath;
    File targetPath;
    JButton buttonUploadDrivers;
    String selectedDepot = null;
    String winProduct = "";
    JLabel label_topic;
    int wLeftText;
    PersistenceController persist;
    ConfigedMain main;
    String server;
    JFrame rootFrame;

    public PanelDriverUpload(ConfigedMain configedMain, PersistenceController persistenceController, JFrame jFrame) {
        this.main = configedMain;
        this.persist = persistenceController;
        this.rootFrame = jFrame;
        this.server = configedMain.getConfigserver();
        this.defineChoosers();
        this.selectedDepot = "" + this.comboChooseDepot.getSelectedItem();
        this.depotProductDirectory = SmbConnect.getInstance().buildSambaTarget(this.selectedDepot, "opsi_depot_rw");
        logging.info(this, "depotProductDirectory " + this.depotProductDirectory);
        this.label_topic = new JLabel(configed.getResourceValue("PanelDriverUpload.topic"));
        this.wLeftText = this.label_topic.getPreferredSize().width;
        this.panelMountShare = new PanelMountShare(this, configedMain, jFrame, this.wLeftText + this.hFirstGap){

            @Override
            protected boolean checkConnectionToShare() {
                boolean bl = super.checkConnectionToShare();
                if (PanelDriverUpload.this.comboChooseWinProduct != null && bl) {
                    PanelDriverUpload.this.evaluateWinProducts();
                }
                return bl;
            }
        };
        this.initComponents();
        logging.info(this, "depotProductDirectory " + this.depotProductDirectory);
        this.smbMounted = new File(this.depotProductDirectory).exists();
        this.panelMountShare.mount(this.smbMounted);
        this.evaluateWinProducts();
        this.buildPanel();
    }

    private void defineChoosers() {
        this.comboChooseDepot = new JComboBox();
        this.comboChooseDepot.setSize(Globals.textfieldDimension);
        this.comboChooseDepot.setModel(new DefaultComboBoxModel<String>(this.main.getLinkedDepots()));
        this.comboChooseDepot.setEnabled(false);
        this.comboChooseDepot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelDriverUpload.this.selectedDepot = "" + PanelDriverUpload.this.comboChooseDepot.getSelectedItem();
                logging.info(this, "actionPerformed  depot selected " + PanelDriverUpload.this.selectedDepot);
            }
        });
        this.comboChooseWinProduct = new JComboBox();
        this.comboChooseWinProduct.setSize(Globals.textfieldDimension);
        this.comboChooseWinProduct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelDriverUpload.this.winProduct = "" + PanelDriverUpload.this.comboChooseWinProduct.getSelectedItem();
                logging.info(this, "winProduct  " + PanelDriverUpload.this.winProduct);
                PanelDriverUpload.this.produceTarget();
            }
        });
        this.chooserDriverPath = new JFileChooser();
        this.chooserDriverPath.setFileSelectionMode(2);
        this.chooserDriverPath.setApproveButtonText(configed.getResourceValue("FileChooser.approve"));
        UIManager.put("FileChooser.cancelButtonText", configed.getResourceValue("FileChooser.cancel"));
        SwingUtilities.updateComponentTreeUI(this.chooserDriverPath);
        this.chooserDriverPath.setDialogType(0);
        this.chooserDriverPath.setDialogTitle("opsi config editor " + configed.getResourceValue("PanelDriverUpload.labelDriverToIntegrate"));
        this.chooserServerpath = new JFileChooser();
        this.chooserServerpath.setFileSelectionMode(1);
        this.chooserServerpath.setApproveButtonText(configed.getResourceValue("FileChooser.approve"));
        UIManager.put("FileChooser.cancelButtonText", configed.getResourceValue("FileChooser.cancel"));
        SwingUtilities.updateComponentTreeUI(this.chooserServerpath);
        this.chooserServerpath.setDialogType(0);
        this.chooserServerpath.setDialogTitle("opsi config editor " + configed.getResourceValue("InstallOpsiPackage.chooserServerPath"));
    }

    private void initComponents() {
        this.defineChoosers();
    }

    private void evaluateWinProducts() {
        this.retrieveWinProducts();
        this.winProduct = "" + this.comboChooseWinProduct.getSelectedItem();
        this.produceTarget();
    }

    private void retrieveWinProducts() {
        logging.info(this, "retrieveWinProducts in " + this.depotProductDirectory);
        if (this.depotProductDirectory == null) {
            return;
        }
        this.smbMounted = new File(this.depotProductDirectory).exists();
        logging.info(this, "retrieveWinProducts smbMounted " + this.smbMounted);
        Vector<String> vector = this.persist.getWinProducts(this.server, this.depotProductDirectory);
        this.comboChooseWinProduct.setModel(new DefaultComboBoxModel<String>(vector));
    }

    protected void buildPanel() {
        this.fieldByAuditPath = new JTextShowField();
        this.fieldClientname = new JTextShowField();
        JLabel jLabel = new JLabel(configed.getResourceValue("PanelDriverUpload.DepotServer"));
        JLabel jLabel2 = new JLabel(configed.getResourceValue("PanelDriverUpload.labelWinProduct"));
        JLabel jLabel3 = new JLabel(configed.getResourceValue("PanelDriverUpload.labelDriverToIntegrate"));
        this.buttonCallSelectDriverFiles = new JButton("", Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectDriverFiles.setSelectedIcon(Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectDriverFiles.setPreferredSize(Globals.graphicButtonDimension);
        this.buttonCallSelectDriverFiles.setToolTipText(configed.getResourceValue("PanelDriverUpload.hintDriverToIntegrate"));
        this.fieldServerPath = new JTextShowField(true);
        this.fieldServerPath.getDocument().addDocumentListener(new FileNameDocumentListener());
        this.fieldServerPath.setForeground(Globals.greyed);
        this.buttonCallChooserServerpath = new JButton("", Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallChooserServerpath.setSelectedIcon(Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallChooserServerpath.setPreferredSize(Globals.graphicButtonDimension);
        this.buttonCallChooserServerpath.setToolTipText(configed.getResourceValue("PanelDriverUpload.determineServerPath"));
        this.buttonCallChooserServerpath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelDriverUpload.this.chooseServerpath();
            }
        });
        JLabel jLabel4 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelTargetPath"));
        this.fieldServerPath = new JTextShowField(true);
        this.fieldServerPath.getDocument().addDocumentListener(new FileNameDocumentListener());
        this.fieldDriverPath = new JTextShowField(true);
        this.fieldDriverPath.getDocument().addDocumentListener(new FileNameDocumentListener());
        final PanelDriverUpload panelDriverUpload = this;
        this.buttonCallSelectDriverFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PanelDriverUpload.this.chooserDriverPath.showOpenDialog(panelDriverUpload);
                if (n == 0) {
                    String string = PanelDriverUpload.this.chooserDriverPath.getSelectedFile().getPath();
                    PanelDriverUpload.this.fieldDriverPath.setText(string);
                    PanelDriverUpload.this.fieldDriverPath.setCaretPosition(string.length());
                } else {
                    PanelDriverUpload.this.fieldDriverPath.setText("");
                }
            }
        });
        JLabel jLabel5 = new JLabel(configed.getResourceValue("PanelDriverUpload.byAuditDriverLocationPath"));
        JLabel jLabel6 = new JLabel(configed.getResourceValue("PanelDriverUpload.type"));
        this.radioButtons = new Vector();
        this.buttonStandard = new RadioButtonIntegrationType(configed.getResourceValue("PanelDriverUpload.type.standard"), FileX.getLocalsystemPath(SmbConnect.DIRECTORY_DRIVERS));
        this.buttonPreferred = new RadioButtonIntegrationType(configed.getResourceValue("PanelDriverUpload.type.preferred"), FileX.getLocalsystemPath(SmbConnect.DIRECTORY_DRIVERS_PREFERRED));
        this.buttonNotPreferred = new RadioButtonIntegrationType(configed.getResourceValue("PanelDriverUpload.type.excluded"), FileX.getLocalsystemPath(SmbConnect.DIRECTORY_DRIVERS_EXCLUDED));
        this.buttonAdditional = new RadioButtonIntegrationType(configed.getResourceValue("PanelDriverUpload.type.additional"), FileX.getLocalsystemPath(SmbConnect.DIRECTORY_DRIVERS_ADDITIONAL));
        this.buttonByAudit = new RadioButtonIntegrationType(configed.getResourceValue("PanelDriverUpload.type.byAudit"), FileX.getLocalsystemPath(SmbConnect.DIRECTORY_DRIVERS_BY_AUDIT));
        this.radioButtons.add(this.buttonStandard);
        this.radioButtons.add(this.buttonPreferred);
        this.radioButtons.add(this.buttonNotPreferred);
        this.radioButtons.add(this.buttonAdditional);
        this.radioButtons.add(this.buttonByAudit);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final RadioButtonIntegrationType object2 : this.radioButtons) {
            buttonGroup.add(object2);
            object2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        logging.debug(this, " " + itemEvent);
                        PanelDriverUpload.this.driverDirectory = object2.getSubdir();
                        PanelDriverUpload.this.produceTarget();
                    }
                }
            });
        }
        this.buttonByAudit.setSelected(true);
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        jPanel.setBorder(new LineBorder(Globals.blueGrey, 1, true));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(jLabel6, 28, 28, 28).addGap(this.vGap, this.vGap, this.vGap).addComponent(this.buttonStandard, 28, 28, 28).addComponent(this.buttonPreferred, 28, 28, 28).addComponent(this.buttonNotPreferred, 28, 28, 28).addComponent(this.buttonAdditional, 28, 28, 28).addComponent(this.buttonByAudit, 28, 28, 28).addGroup(groupLayout.createParallelGroup().addComponent(jLabel5, 28, 28, 28).addComponent(this.fieldByAuditPath, 28, 28, 28)).addGap(this.vGap, this.vGap, this.vGap));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addGroup(groupLayout.createParallelGroup().addComponent(jLabel6, -2, -2, -2).addComponent(this.buttonStandard, -2, -2, -2).addComponent(this.buttonPreferred, -2, -2, -2).addComponent(this.buttonNotPreferred, -2, -2, -2).addComponent(this.buttonAdditional, -2, -2, -2).addComponent(this.buttonByAudit, -2, -2, -2).addGroup(groupLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(jLabel5, 10, -2, -2).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.fieldByAuditPath, 140, 280, Short.MAX_VALUE).addGap(this.hGap, this.hGap, this.hGap))).addGap(this.hGap, this.hGap, this.hGap));
        this.buttonUploadDrivers = new JButton("", Globals.createImageIcon("images/upload2product.png", ""));
        this.buttonUploadDrivers.setSelectedIcon(Globals.createImageIcon("images/upload2product.png", ""));
        this.buttonUploadDrivers.setToolTipText(configed.getResourceValue("PanelDriverUpload.execute"));
        this.buttonUploadDrivers.setEnabled(false);
        this.buttonUploadDrivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.info(this, "actionPerformed on buttonUploadDrivers from " + PanelDriverUpload.this.fieldDriverPath.getText() + " to " + PanelDriverUpload.this.fieldServerPath.getText());
                Color color = PanelDriverUpload.this.buttonUploadDrivers.getBackground();
                PanelDriverUpload.this.buttonUploadDrivers.setBackground(Globals.failedBackColor);
                PanelDriverUpload.this.execute();
                PanelDriverUpload.this.buttonUploadDrivers.setBackground(color);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        int n = 24;
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGap(this.vGap, this.vGap * 2, this.vGap * 2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.label_topic, n, n, n).addComponent(this.fieldClientname, n, n, n)).addGap(2 * this.vGap, 3 * this.vGap, 3 * this.vGap).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 28, 28, 28).addComponent(this.comboChooseDepot, 28, 28, 28).addComponent(jLabel2, 28, 28, 28).addComponent(this.comboChooseWinProduct, 28, 28, 28)).addGap(2 * this.vGap, 3 * this.vGap, 3 * this.vGap).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3, 28, 28, 28).addComponent(this.buttonCallSelectDriverFiles, 28, 28, 28).addComponent(this.fieldDriverPath, 28, 28, 28)).addGap(2 * this.vGap, 3 * this.vGap, 3 * this.vGap).addComponent(jPanel, -2, -2, -2).addGap(2 * this.vGap, 3 * this.vGap, 3 * this.vGap).addComponent(this.panelMountShare, 28, 28, 28).addGap(5, 5, 5).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4, 28, 28, 28).addComponent(this.buttonCallChooserServerpath, 28, 28, 28).addComponent(this.fieldServerPath, 28, 28, 28)).addGap(2 * this.vGap, 3 * this.vGap, 3 * this.vGap).addComponent(this.buttonUploadDrivers, 28, 28, 28).addGap(this.vGap, this.vGap * 2, this.vGap * 2));
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup().addGroup(groupLayout2.createSequentialGroup().addGap(this.hFirstGap, this.hFirstGap, this.hFirstGap).addGroup(groupLayout2.createParallelGroup().addGroup(groupLayout2.createSequentialGroup().addComponent(this.label_topic, 5, this.wLeftText, this.wLeftText).addGap(this.hFirstGap, this.hFirstGap, this.hFirstGap).addComponent(this.fieldClientname, 140, 140, 280)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.panelMountShare, -2, -2, -2)).addGroup(groupLayout2.createSequentialGroup().addComponent(jLabel).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.comboChooseDepot, 140, 140, 280).addGap(this.hGap, this.hGap, this.hGap).addComponent(jLabel2, -2, -2, -2).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.comboChooseWinProduct, 140, 280, 420)).addGroup(groupLayout2.createSequentialGroup().addComponent(jLabel3, -2, -2, -2).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.buttonCallSelectDriverFiles, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.fieldDriverPath, 140, 280, Short.MAX_VALUE)).addComponent(jPanel, -2, -2, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.panelMountShare, -2, -2, -2)).addGroup(groupLayout2.createSequentialGroup().addComponent(jLabel4, 5, this.wLeftText, this.wLeftText).addGap(this.hFirstGap, this.hFirstGap, this.hFirstGap).addComponent(this.buttonCallChooserServerpath, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(this.hFirstGap, this.hFirstGap, this.hFirstGap).addComponent(this.fieldServerPath, 280, 280, Short.MAX_VALUE))).addGap(this.hFirstGap, this.hFirstGap, this.hFirstGap)).addGroup(groupLayout2.createSequentialGroup().addGap(5, 5, Short.MAX_VALUE).addComponent(this.buttonUploadDrivers, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(this.hFirstGap / 2, this.hFirstGap / 2, this.hFirstGap / 2)));
        this.setBackground(de.uib.utilities.Globals.backgroundLightGrey);
    }

    public void makePath(File file, boolean bl) {
        logging.info(this, "makePath for " + file);
        if (file != null && !file.exists()) {
            int n = 1;
            n = JOptionPane.showOptionDialog(this.rootFrame, configed.getResourceValue("PanelDriverUpload.makeFilePath.text"), configed.getResourceValue("PanelDriverUpload.makeFilePath.title"), 0, 3, null, null, null);
            if (n == 0) {
                file.mkdirs();
            }
        }
        logging.info(this, "makePath result " + file);
    }

    protected void execute() {
        WaitCursor waitCursor = null;
        try {
            waitCursor = new WaitCursor(this.rootFrame);
            logging.info(this, "copy  " + this.driverPath + " to " + this.targetPath);
            Thread.currentThread();
            Thread.sleep(100L);
            this.makePath(this.targetPath, true);
            if (this.targetPath.exists()) {
                if (this.driverPath.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory(this.driverPath, this.targetPath);
                } else {
                    FileUtils.copyFileToDirectory(this.driverPath, this.targetPath);
                }
            } else {
                logging.info(this, "execute: targetPath does not exist");
            }
            if (this.targetPath.exists()) {
                String string = "/" + SmbConnect.unixPath(SmbConnect.directoryProducts) + "/" + this.winProduct + "/" + SmbConnect.unixPath(SmbConnect.DIRECTORY_DRIVERS);
                logging.info(this, "set rights for " + string);
                this.persist.setRights(string);
            }
            waitCursor.stop();
            JOptionPane.showMessageDialog(this.rootFrame, "Ready", configed.getResourceValue("CompleteWinProduct.reportTitle"), 1);
        }
        catch (Exception exception) {
            waitCursor.stop();
            logging.error("copy error:\n" + exception, exception);
        }
    }

    public void setByAuditPath(String string) {
        this.byAuditPath = string;
        this.fieldByAuditPath.setText(string);
        this.produceTarget();
    }

    public void setClientName(String string) {
        this.fieldClientname.setText(string);
    }

    public void setDepot(String string) {
        this.comboChooseDepot.setModel(new DefaultComboBoxModel<String>(new String[]{string}));
    }

    private boolean checkFiles() {
        boolean bl = false;
        if (this.fieldServerPath != null && this.fieldDriverPath != null) {
            try {
                this.targetPath = new File(this.fieldServerPath.getText());
                this.driverPath = new File(this.fieldDriverPath.getText());
                if (this.targetPath.isDirectory() && this.driverPath.exists()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                logging.info(this, "checkFiles " + exception);
            }
        }
        logging.info(this, "checkFiles " + bl);
        if (this.buttonUploadDrivers != null) {
            this.buttonUploadDrivers.setEnabled(bl);
        }
        return bl;
    }

    private void produceTarget() {
        if (this.fieldServerPath == null) {
            return;
        }
        String string = this.depotProductDirectory + File.separator + this.winProduct + File.separator + this.driverDirectory;
        if (this.buttonByAudit.isSelected()) {
            string = string + File.separator + this.byAuditPath;
        }
        this.fieldServerPath.setText(string);
    }

    private void chooseServerpath() {
        String string = this.fieldServerPath.getText();
        File file = new File(string);
        this.makePath(file, true);
        this.chooserServerpath.setCurrentDirectory(file);
        int n = this.chooserServerpath.showOpenDialog(this);
        if (n == 0) {
            String string2 = this.chooserServerpath.getSelectedFile().getPath();
            this.fieldServerPath.setText(string2);
            this.fieldServerPath.setCaretPosition(string2.length());
        }
    }

    @Override
    public String produceName() {
        if (this.fieldServerPath != null) {
            logging.info(this, "produceName ? fieldServerPath , depotProductDirectory " + this.fieldServerPath.getText() + " , " + this.depotProductDirectory);
        }
        if (this.fieldServerPath == null || this.fieldServerPath.getText().equals("") || this.fieldServerPath.getText().startsWith(this.depotProductDirectory)) {
            return this.depotProductDirectory;
        }
        return this.fieldServerPath.getText();
    }

    @Override
    public String getDefaultName() {
        return this.byAuditPath;
    }

    class FileNameDocumentListener
    implements DocumentListener {
        FileNameDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            PanelDriverUpload.this.checkFiles();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            PanelDriverUpload.this.checkFiles();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            PanelDriverUpload.this.checkFiles();
        }
    }

    class RadioButtonIntegrationType
    extends JRadioButton {
        private String subdir;

        public RadioButtonIntegrationType(String string, String string2) {
            super(string);
            this.subdir = string2;
        }

        public String getSubdir() {
            return this.subdir;
        }
    }
}

