/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.type.DatedRowList;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentElementToPdf;
import de.uib.utilities.pdf.DocumentToPdf;
import de.uib.utilities.swing.PopupMenuTrait;
import de.uib.utilities.table.GenTableModel;
import de.uib.utilities.table.TableModelFilter;
import de.uib.utilities.table.TableModelFilterCondition;
import de.uib.utilities.table.gui.ColorHeaderCellRenderer;
import de.uib.utilities.table.gui.PanelGenEditTable;
import de.uib.utilities.table.gui.StandardTableCellRenderer;
import de.uib.utilities.table.provider.DefaultTableProvider;
import de.uib.utilities.table.provider.MapRetriever;
import de.uib.utilities.table.provider.RetrieverMapSource;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;

public class PanelSWInfo
extends JPanel {
    protected PanelGenEditTable panelTable;
    protected JPanel subPanelTitle;
    protected JScrollPane jScrollPane;
    protected JTable jTable;
    protected SWInfoTableModel tableModel;
    protected GenTableModel modelSWInfo;
    protected JLabel jLabelTitle;
    protected JLabel labelTitle;
    protected String title = "";
    protected DatedRowList swRows;
    protected String hostId = "";
    protected boolean withPopup;
    protected PopupMenuTrait popupMenu;
    protected DocumentToPdf tableToPDF;
    protected int hGap = 5;
    protected int vGap = 5;
    protected int hLabel = 24;
    protected ConfigedMain mainController;
    JCheckBox checkWithMsUpdates;
    protected boolean withMsUpdates = false;
    static final String FILTER_MS_UPDATES = "withMsUpdates";
    int indexOfColWindowsSoftwareID;
    TableModelFilterCondition filterConditionWithMsUpdates = new TableModelFilterCondition(){

        @Override
        public void setFilter(TreeSet<Object> treeSet) {
        }

        @Override
        public boolean test(Vector<Object> vector) {
            boolean bl = ((String)vector.get(PanelSWInfo.this.indexOfColWindowsSoftwareID)).startsWith("kb");
            return !bl;
        }
    };

    public PanelSWInfo(ConfigedMain configedMain) {
        this(true, configedMain);
    }

    public PanelSWInfo(boolean bl, ConfigedMain configedMain) {
        this.withPopup = bl;
        this.mainController = configedMain;
        this.initTable();
        this.buildPanel();
    }

    protected void initTable() {
        this.labelTitle = new JLabel();
        this.labelTitle.setFont(de.uib.utilities.Globals.defaultFontBold);
        this.panelTable = new PanelGenEditTable("title", 0, false, 0, true, new int[0], true){};
        this.panelTable.setTitle("");
        this.panelTable.setColumnSelectionAllowed(false);
        this.panelTable.setSearchSelectMode(true);
        this.panelTable.setSearchMode(0);
        Vector<String> vector = new Vector<String>(SWAuditClientEntry.KEYS);
        vector.remove(0);
        Vector<String> vector2 = new Vector<String>();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add("java.lang.String");
            nArray[i] = i;
        }
        this.modelSWInfo = new GenTableModel(null, new DefaultTableProvider(new RetrieverMapSource(vector, vector2, new MapRetriever(){

            @Override
            public Map<String, Map> retrieveMap() {
                logging.info(this, "retrieving data for " + PanelSWInfo.this.hostId);
                Map<String, Map> map = PanelSWInfo.this.mainController.getPersistenceController().retrieveSoftwareAuditData(PanelSWInfo.this.hostId);
                logging.info(this, "retrieved size  " + map.keySet().size());
                if (map == null || map.keySet().size() == 0) {
                    PanelSWInfo.this.setTitle(configed.getResourceValue("PanelSWInfo.noScanResult"));
                } else {
                    PanelSWInfo.this.setTitle("Scan " + PanelSWInfo.this.mainController.getPersistenceController().getLastSoftwareAuditModification(PanelSWInfo.this.hostId));
                }
                return map;
            }
        })), -1, nArray, null, null);
        this.indexOfColWindowsSoftwareID = vector.indexOf("windowsSoftwareID");
        this.modelSWInfo.chainFilter(FILTER_MS_UPDATES, new TableModelFilter(this.filterConditionWithMsUpdates));
        this.modelSWInfo.reset();
        this.modelSWInfo.setUsingFilter(FILTER_MS_UPDATES, this.withMsUpdates);
        this.modelSWInfo.toggleFilter(FILTER_MS_UPDATES);
        this.panelTable.setDataChanged(false);
        this.checkWithMsUpdates = new JCheckBox("", this.withMsUpdates);
        this.checkWithMsUpdates.setForeground(Globals.blue);
        this.checkWithMsUpdates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (PanelSWInfo.this.modelSWInfo == null) {
                    return;
                }
                boolean bl = PanelSWInfo.this.panelTable.isDataChanged();
                PanelSWInfo.this.withMsUpdates = PanelSWInfo.this.checkWithMsUpdates.isSelected();
                PanelSWInfo.this.modelSWInfo.toggleFilter(PanelSWInfo.FILTER_MS_UPDATES);
                PanelSWInfo.this.panelTable.setDataChanged(bl);
            }
        });
        this.subPanelTitle = new JPanel();
        JLabel jLabel = new JLabel(configed.getResourceValue("PanelSWInfo.withMsUpdates"));
        this.subPanelTitle.setBackground(Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(this.subPanelTitle);
        this.subPanelTitle.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addGroup(groupLayout.createParallelGroup().addComponent(this.labelTitle, -2, -2, -2).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel, -2, -2, -2).addGap(this.hGap, this.hGap, this.hGap).addGap(this.hGap, this.hGap, this.hGap).addComponent(this.checkWithMsUpdates, -2, -2, -2))).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(this.labelTitle, -2, -2, -2).addGap(this.vGap, this.vGap, this.vGap).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, -2, -2, -2).addComponent(this.checkWithMsUpdates, -2, -2, -2)).addGap(this.vGap, this.vGap, this.vGap).addGap(this.vGap, this.vGap, this.vGap));
        this.panelTable.setTableModel(this.modelSWInfo);
        this.panelTable.setSearchColumnsAll();
        this.panelTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.panelTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.panelTable.getColumnModel().getColumn(2).setPreferredWidth(100);
    }

    protected void buildPanel() {
        this.jLabelTitle = new JLabel("");
        this.jLabelTitle.setOpaque(true);
        this.jLabelTitle.setBackground(de.uib.utilities.Globals.backgroundLightGrey);
        this.tableModel = new SWInfoTableModel();
        this.jTable = new JTable(this.tableModel, null);
        this.jTable.setAutoCreateRowSorter(true);
        TableRowSorter tableRowSorter = (TableRowSorter)this.jTable.getRowSorter();
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
        arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        tableRowSorter.setSortKeys(arrayList);
        tableRowSorter.sort();
        this.jTable.setDefaultRenderer(Object.class, new StandardTableCellRenderer());
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.jTable.getTableHeader().setDefaultRenderer(new ColorHeaderCellRenderer(this.jTable.getTableHeader().getDefaultRenderer()));
        this.jTable.setColumnSelectionAllowed(true);
        this.jTable.setRowSelectionAllowed(true);
        this.jTable.setDragEnabled(true);
        this.jScrollPane = new JScrollPane(this.jTable);
        this.jScrollPane.getViewport().setBackground(de.uib.utilities.Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addGroup(groupLayout.createParallelGroup().addComponent(this.subPanelTitle, -2, -2, Short.MAX_VALUE).addComponent(this.panelTable, -2, -2, Short.MAX_VALUE)).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(this.subPanelTitle, -2, -2, -2).addComponent(this.panelTable, -2, -2, Short.MAX_VALUE).addGap(this.vGap, this.vGap, this.vGap));
        if (this.withPopup) {
            this.popupMenu = new PopupMenuTrait(new Integer[]{4, 10, 6}){

                @Override
                public void action(int n) {
                    switch (n) {
                        case 4: {
                            PanelSWInfo.this.reload();
                            break;
                        }
                        case 6: {
                            PanelSWInfo.this.floatExternalX();
                            break;
                        }
                        case 10: {
                            logging.info(this, "------------- create report");
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("PanelSWInfo.jLabel_title"));
                            hashMap.put("header", " " + messageFormat.format(new String[]{PanelSWInfo.this.hostId, PanelSWInfo.this.swRows.getDate()}));
                            PanelSWInfo.this.title = "";
                            if (PanelSWInfo.this.mainController.getHostsStatusInfo().getInvolvedDepots().length() != 0) {
                                PanelSWInfo.this.title = PanelSWInfo.this.title + "Depot : " + PanelSWInfo.this.mainController.getHostsStatusInfo().getInvolvedDepots();
                            }
                            if (PanelSWInfo.this.mainController.getHostsStatusInfo().getSelectedClientNames().length() != 0) {
                                PanelSWInfo.this.title = PanelSWInfo.this.title + "; Client: " + PanelSWInfo.this.mainController.getHostsStatusInfo().getSelectedClientNames();
                            }
                            hashMap.put("title", PanelSWInfo.this.title);
                            hashMap.put("subject", "report of table");
                            hashMap.put("keywords", "software inventory");
                            PanelSWInfo.this.tableToPDF = new DocumentToPdf(null, hashMap);
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            arrayList.add(0);
                            DocumentElementToPdf.setAlignmentLeft(arrayList);
                            PanelSWInfo.this.tableToPDF.createContentElement("table", PanelSWInfo.this.jTable);
                            PanelSWInfo.this.tableToPDF.setPageSizeA4_Landscape();
                            PanelSWInfo.this.tableToPDF.toPDF();
                        }
                    }
                }
            };
            this.popupMenu.addPopupListenersTo(new JComponent[]{this, this.panelTable.getTheTable(), this.jTable, this.jScrollPane, this.jScrollPane.getViewport()});
        }
    }

    public void setTitle(String string) {
        this.title = "  " + string + " " + this.title;
        this.labelTitle.setText(string);
    }

    protected void reload() {
        logging.debug(this, "reload action");
    }

    protected void floatExternalX() {
        PanelSWInfo panelSWInfo = new PanelSWInfo(false, this.mainController);
        panelSWInfo.setSoftwareInfo(this.hostId, this.swRows);
        GeneralFrame generalFrame = new GeneralFrame(null, this.title, false);
        generalFrame.addPanel(panelSWInfo);
        generalFrame.setup();
        generalFrame.setSize(this.getSize());
        generalFrame.centerOn(Globals.mainFrame);
        generalFrame.setVisible(true);
    }

    public void setSoftwareInfo(String string, DatedRowList datedRowList) {
        logging.info(this, "setSoftwareInfo for " + string + " -- ");
        this.hostId = "" + string;
        String string2 = "" + de.uib.utilities.Globals.getToday();
        String[] stringArray = string2.split(":");
        if (stringArray.length > 2) {
            string2 = stringArray[0] + ":" + stringArray[1];
        }
        this.panelTable.reload();
        this.title = string;
        this.swRows = datedRowList;
        this.jLabelTitle.setText(" (no software audit data, checked at time:  " + string2 + ")");
        if (datedRowList == null) {
            this.tableModel.setData(new DatedRowList());
            return;
        }
        if (datedRowList.getDate() != null) {
            MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("PanelSWInfo.jLabel_title"));
            this.jLabelTitle.setText(" " + messageFormat.format(new String[]{string, datedRowList.getDate()}));
            this.title = this.title + "   " + configed.getResourceValue("PanelSWInfo.title");
        }
        this.tableModel.setData(datedRowList);
    }

    public class SWInfoTableModel
    extends AbstractTableModel {
        private List<String[]> data;
        private final String[] header = new String[]{configed.getResourceValue("PanelSWInfo.tableheader_displayName"), configed.getResourceValue("PanelSWInfo.tableheader_softwareId"), configed.getResourceValue("PanelSWInfo.tableheader_displayVersion")};

        public SWInfoTableModel() {
            this.data = new ArrayList<String[]>();
        }

        public void setData(DatedRowList datedRowList) {
            this.data = datedRowList.getRows();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return SWAuditClientEntry.getDisplayKeys().size();
        }

        @Override
        public String getColumnName(int n) {
            return SWAuditClientEntry.getDisplayKey(n + 1);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n)[n2 + 1];
        }
    }
}

