/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection;

import de.uib.configed.clientselection.SelectData;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.SelectGroupOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.configed.clientselection.SelectionManager;
import de.uib.configed.clientselection.elements.GroupElement;
import de.uib.configed.clientselection.operations.AndOperation;
import de.uib.configed.clientselection.operations.HardwareOperation;
import de.uib.configed.clientselection.operations.HostOperation;
import de.uib.configed.clientselection.operations.NotOperation;
import de.uib.configed.clientselection.operations.OrOperation;
import de.uib.configed.clientselection.operations.SoftwareOperation;
import de.uib.configed.clientselection.operations.SwAuditOperation;
import de.uib.configed.clientselection.serializers.WrongVersionException;
import de.uib.opsidatamodel.SavedSearches;
import de.uib.utilities.logging.logging;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Serializer {
    protected SelectionManager manager;

    public Serializer(SelectionManager selectionManager) {
        this.manager = selectionManager;
    }

    public void save(SelectOperation selectOperation, String string, String string2) {
        Map<String, Object> map = this.produceData(selectOperation);
        this.saveData(string, string2, map);
    }

    public abstract List<String> getSaved();

    public abstract SavedSearches getSavedSearches();

    public SelectOperation deserialize(Map<String, Object> map) {
        logging.info("deserialize data " + map);
        if (map.get("elementPath") != null) {
            logging.info("deserialize, elementPath " + Arrays.toString((String[])map.get("elementPath")));
        }
        try {
            if (map == null) {
                return null;
            }
            SelectOperation selectOperation = this.getOperation(map, null);
            if (this.getSearchDataVersion() == 1) {
                selectOperation = this.checkForHostGroup(selectOperation);
            }
            return selectOperation;
        }
        catch (Exception exception) {
            logging.error("deserialize error for data " + map + " message " + exception.getMessage(), exception);
            return null;
        }
    }

    public SelectOperation deserialize(String string) {
        logging.info(this, "deserialize serialized " + string);
        SelectOperation selectOperation = null;
        try {
            Map<String, Object> map = this.decipher(string);
            selectOperation = this.deserialize(map);
        }
        catch (Exception exception) {
            logging.error("deserialize error " + exception.getMessage(), exception);
        }
        return selectOperation;
    }

    public SelectOperation load(String string) {
        logging.info(this, "load " + string);
        try {
            Map<String, Object> map = this.getData(string);
            return this.deserialize(map);
        }
        catch (Exception exception) {
            logging.error(exception.getMessage(), exception);
            return null;
        }
    }

    public abstract void remove(String var1);

    protected abstract Map<String, Object> getData(String var1) throws WrongVersionException;

    protected abstract Map<String, Object> decipher(String var1) throws WrongVersionException;

    protected abstract void saveData(String var1, String var2, Map<String, Object> var3);

    protected abstract int getSearchDataVersion();

    private SelectOperation getOperation(Map<String, Object> map, Map<String, List<SelectElement>> map2) throws Exception {
        Class<?> clazz;
        Object object;
        List<SelectElement> list;
        String[] stringArray;
        Object object3;
        logging.info(this, "getOperation for map " + map + "; hardware " + map2);
        String string = null;
        if (map.get("elementPath") != null) {
            string = Arrays.toString((String[])map.get("elementPath"));
            logging.info("getOperation, elementPath in data " + string);
        }
        Object object4 = null;
        if (map.get("element") != null && !((String)map.get("element")).isEmpty()) {
            object3 = (String)map.get("element");
            logging.info(this, "Element name: " + (String)object3);
            stringArray = (String[])map.get("elementPath");
            if (((String)object3).equals("SoftwareNameElement")) {
                object4 = this.manager.getNewSoftwareNameElement();
            } else if (((String)object3).equals("GroupElement")) {
                object4 = new GroupElement(this.manager.getBackend().getGroups().toArray(new String[0]));
            } else if (((String)object3).startsWith("Generic")) {
                if (map2 == null) {
                    map2 = this.manager.getBackend().getHardwareList();
                }
                logging.info(this, "getOperation elementPath[0] " + stringArray[0]);
                list = map2.get(stringArray[0]);
                for (SelectElement object22 : list) {
                    logging.info(this, "getOperation possibleElement.getClassName() " + object22 + " compare with elementName " + (String)object3 + " or perhaps with elementPathS " + string);
                    if (!object22.getClassName().equals(object3) || !Arrays.toString(object22.getPathArray()).equals(string)) continue;
                    object4 = object22;
                    break;
                }
            } else {
                object4 = (SelectElement)Class.forName("de.uib.configed.clientselection.elements." + (String)object3).newInstance();
            }
        }
        if (object4 != null) {
            object3 = "" + object4 + " class " + object4.getClass() + " path " + ((SelectElement)object4).getPath();
            logging.info(this, "getOperation element " + (String)object3);
        }
        object3 = (List)map.get("children");
        stringArray = new LinkedList();
        if (object3 != null) {
            list = object3.iterator();
            while (list.hasNext()) {
                object = (Map)list.next();
                stringArray.add(this.getOperation((Map<String, Object>)object, map2));
            }
        }
        list = (String)map.get("operation");
        logging.info(this, "getOperation Operation name: " + (String)((Object)list));
        if (this.getSearchDataVersion() == 1) {
            object = this.parseOperationVersion1((String)((Object)list), (SelectElement)object4, (List<SelectOperation>)stringArray);
        } else {
            Class<?> clazz2 = Class.forName("de.uib.configed.clientselection.operations." + (String)((Object)list));
            logging.info(this, "getOperation operationClass  " + clazz2.toString());
            if (object4 != null) {
                logging.info(this, "getOperation element != null, element  " + object4);
                object = (SelectOperation)clazz2.getConstructors()[0].newInstance(object4);
            } else {
                clazz = Class.forName("java.util.List");
                logging.info(this, "getOperation List name: " + clazz.toString());
                object = (SelectOperation)clazz2.getConstructor(clazz).newInstance(new Object[]{stringArray});
            }
        }
        logging.info(this, "getOperation  " + object);
        SelectData.DataType dataType = (SelectData.DataType)((Object)map.get("dataType"));
        clazz = map.get("data");
        SelectData selectData = dataType == null || map == null ? null : new SelectData(clazz, dataType);
        ((SelectOperation)object).setSelectData(selectData);
        return object;
    }

    private Map<String, Object> produceData(SelectOperation selectOperation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SelectElement selectElement = selectOperation.getElement();
        if (selectElement == null) {
            hashMap.put("element", null);
            hashMap.put("elementPath", null);
        } else {
            hashMap.put("element", selectElement.getClassName());
            hashMap.put("elementPath", selectElement.getPathArray());
        }
        hashMap.put("operation", selectOperation.getClassName());
        if (selectOperation.getSelectData() == null) {
            hashMap.put("dataType", null);
            hashMap.put("data", null);
        } else {
            hashMap.put("dataType", (Object)selectOperation.getSelectData().getType());
            hashMap.put("data", selectOperation.getSelectData().getData());
        }
        if (selectOperation instanceof SelectGroupOperation) {
            LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
            for (SelectOperation selectOperation2 : ((SelectGroupOperation)selectOperation).getChildOperations()) {
                linkedList.add(this.produceData(selectOperation2));
            }
            hashMap.put("children", linkedList);
        } else {
            hashMap.put("children", null);
        }
        logging.info(this, "produced " + hashMap);
        return hashMap;
    }

    private SelectOperation parseOperationVersion1(String string, SelectElement selectElement, List<SelectOperation> list) {
        logging.info(this, "parseOperationVersion1");
        if (selectElement != null) {
            for (SelectOperation selectOperation : selectElement.supportedOperations()) {
                if (!selectOperation.getOperationString().equals(string)) continue;
                return selectOperation;
            }
            throw new IllegalArgumentException("While parsing ver 1 saved search: " + string);
        }
        if (string.equals("Hardware")) {
            return new HardwareOperation(list);
        }
        if (string.equals("Software")) {
            return new SoftwareOperation(list);
        }
        if (string.equals("SwAudit")) {
            return new SwAuditOperation(list);
        }
        if (string.equals("and")) {
            return new AndOperation(list);
        }
        if (string.equals("or")) {
            return new OrOperation(list);
        }
        if (string.equals("not")) {
            return new NotOperation(list);
        }
        throw new IllegalArgumentException("While parsing ver 1 saved search: " + string);
    }

    private SelectOperation checkForHostGroup(SelectOperation selectOperation) {
        if (!(selectOperation instanceof SelectGroupOperation)) {
            logging.debug("No group: " + selectOperation.getClassName() + ", element path size: " + selectOperation.getElement().getPathArray().length);
            if (selectOperation.getElement().getPathArray().length == 1) {
                return new HostOperation(selectOperation);
            }
            return selectOperation;
        }
        if (selectOperation instanceof HardwareOperation || selectOperation instanceof SoftwareOperation || selectOperation instanceof SwAuditOperation) {
            return selectOperation;
        }
        if (!(selectOperation instanceof AndOperation)) {
            return new HostOperation(selectOperation);
        }
        AndOperation andOperation = (AndOperation)selectOperation;
        SelectOperation selectOperation2 = selectOperation;
        while (selectOperation2 instanceof SelectGroupOperation) {
            selectOperation2 = ((SelectGroupOperation)selectOperation2).getChildOperations().get(0);
        }
        SelectOperation selectOperation3 = andOperation.getChildOperations().get(1);
        while (selectOperation3 instanceof SelectGroupOperation) {
            selectOperation3 = ((SelectGroupOperation)selectOperation3).getChildOperations().get(0);
        }
        if (selectOperation2.getElement().getPathArray().length != 1) {
            return selectOperation;
        }
        if (selectOperation2.getElement().getPathArray().length == 1 && selectOperation3.getElement().getPathArray().length == 1) {
            return new HostOperation(andOperation);
        }
        List<SelectOperation> list = andOperation.getChildOperations();
        HostOperation hostOperation = new HostOperation(list.get(0));
        list.remove(0);
        list.add(0, hostOperation);
        return new AndOperation(list);
    }
}

