/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.type.licences;

import de.uib.utilities.ExtendedInteger;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LicenceEntry
extends TreeMap<String, Object> {
    public static final String idSERVICEKEY = "id";
    public static final String licenceContractIdSERVICEKEY = "licenseContractId";
    public static final String boundToHostSERVICEKEY = "boundToHost";
    public static final String maxInstallationsSERVICEKEY = "maxInstallations";
    public static final String expirationDateSERVICEKEY = "expirationDate";
    public static final String typeSERVICEKEY = "type";
    public static final String idKEY = "softwareLicenseId";
    public static final String licenceContractIdKEY = "licenseContractId";
    public static final String boundToHostKEY = "boundToHost";
    public static final String maxInstallationsKEY = "maxInstallations";
    public static final String expirationDateKEY = "expirationDate";
    public static final String typeKEY = "licenseType";
    private static List<String> KEYS = new ArrayList<String>();
    public static final String VOLUME = "VOLUME";
    public static final String OEM = "OEM";
    public static final String RETAIL = "RETAIL";
    public static final String CONCURRENT = "CONCURRENT";
    public static final String VOLUMEservice = "VolumeSoftwareLicense";
    public static final String OEMservice = "OEMSoftwareLicense";
    public static final String RETAILservice = "RetailSoftwareLicense";
    public static final String CONCURRENTservice = "ConcurrentSoftwareLicense";
    public static final String[] LICENCE_TYPES;
    private static final List<String> TYPE_LIST;

    public static List<String> getKeys() {
        return KEYS;
    }

    private String translateTypeFromService(String string) {
        switch (string) {
            case "VolumeSoftwareLicense": {
                return VOLUME;
            }
            case "OEMSoftwareLicense": {
                return OEM;
            }
            case "RetailSoftwareLicense": {
                return RETAIL;
            }
            case "ConcurrentSoftwareLicense": {
                return CONCURRENT;
            }
        }
        logging.warning(this, "illlegal servicetype " + string);
        return "";
    }

    public LicenceEntry(Map<String, Object> map) {
        super(map);
        if (map.get(idSERVICEKEY) != null) {
            this.put(idKEY, map.get(idSERVICEKEY));
        }
        if (this.get(idKEY) == null) {
            logging.warning(this, "missing primary key in " + map);
        }
        if (map.get("maxInstallations") == null) {
            map.put("maxInstallations", ExtendedInteger.ZERO);
        } else if (!(map.get("maxInstallations") instanceof Integer)) {
            logging.warning(this, " " + map.get(idKEY) + " has not an integer for " + map.get("maxInstallations"));
        } else {
            int n = (Integer)map.get("maxInstallations");
            if (n == 0) {
                this.put("maxInstallations", ExtendedInteger.INFINITE);
            } else {
                this.put("maxInstallations", new ExtendedInteger(n));
            }
        }
        if (map.get(typeSERVICEKEY) != null) {
            this.put(typeKEY, this.translateTypeFromService((String)map.get(typeSERVICEKEY)));
        }
    }

    public String getId() {
        return (String)this.get(idKEY);
    }

    public ExtendedInteger getMaxInstallations() {
        return (ExtendedInteger)this.get("maxInstallations");
    }

    public static String produceNormalizedCount(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("0")) {
            return "0";
        }
        ExtendedInteger extendedInteger = new ExtendedInteger(string);
        if (extendedInteger.equals(ExtendedInteger.INFINITE)) {
            return "0";
        }
        return string;
    }

    static {
        KEYS.add(idKEY);
        KEYS.add("licenseContractId");
        KEYS.add("boundToHost");
        KEYS.add("maxInstallations");
        KEYS.add("expirationDate");
        KEYS.add(typeKEY);
        LICENCE_TYPES = new String[]{VOLUME, OEM, RETAIL, CONCURRENT};
        TYPE_LIST = Arrays.asList(LICENCE_TYPES);
    }
}

