/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.tree.ClientTreeTransferHandler;
import de.uib.configed.tree.GroupNode;
import de.uib.configed.tree.IconNode;
import de.uib.configed.tree.IconNodeRendererClientTree;
import de.uib.configed.tree.TreePopupMouseListener;
import de.uib.utilities.WaitCursor;
import de.uib.utilities.datastructure.StringValuedRelationElement;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEditList;
import de.uib.utilities.swing.FEditRecord;
import de.uib.utilities.tree.SimpleTreePath;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ClientTree
extends JTree
implements TreeSelectionListener,
MouseListener,
MouseMotionListener,
TreeModelListener {
    ConfigedMain main;
    protected DefaultTreeModel model;
    protected TreeSelectionModel selectionmodel;
    public GroupNode ALL;
    protected GroupNode GROUPS;
    protected GroupNode DIRECTORY;
    protected GroupNode DIRECTORY_NOT_ASSIGNED;
    public static String ALL_NAME = configed.getResourceValue("ClientTree.ALLname");
    public static String GROUPS_NAME = configed.getResourceValue("ClientTree.GROUPSname");
    public static String DIRECTORY_NAME = configed.getResourceValue("ClientTree.DIRECTORYname");
    public static String DIRECTORY_PERSISTENT_NAME = "clientdirectory";
    public static String DIRECTORY_NOT_ASSIGNED_NAME = configed.getResourceValue("ClientTree.NOTASSIGNEDname");
    public static Map<String, String> translationsToPersistentNames = new HashMap<String, String>();
    public static Map<String, String> translationsFromPersistentNames = new HashMap<String, String>();
    public static Set<String> topGroupNames;
    protected TreePath pathToROOT;
    protected TreePath pathToALL;
    protected TreePath pathToGROUPS;
    protected TreePath pathToDIRECTORY;
    protected TreePath pathToDIRECTORY_NOT_ASSIGNED;
    protected final Map<String, String> groupALL = new HashMap<String, String>();
    protected final Map<String, String> groupGROUPS = new HashMap<String, String>();
    protected final Map<String, String> groupDIRECTORY = new HashMap<String, String>();
    protected final Map<String, String> groupDIRECTORY_NOT_ASSIGNED = new HashMap<String, String>();
    public final GroupNode ROOT = new GroupNode("top");
    protected IconNodeRendererClientTree nodeRenderer;
    protected Map<String, Set<GroupNode>> locationsInDIRECTORY;
    protected Leafname2AllItsPaths leafname2AllItsPaths;
    protected Map<String, Map<String, String>> groups;
    protected Map<String, GroupNode> groupNodes;
    protected Map<String, DefaultMutableTreeNode> clientNodesInDIRECTORY;
    protected HashSet<String> activeParents = new HashSet();
    JPopupMenu popupMenu;
    TreePopupMouseListener treePopupMouseListener;
    boolean mouse_ready = true;

    public static String translateToPersistentName(String string) {
        if (translationsToPersistentNames.get(string) != null) {
            return translationsToPersistentNames.get(string);
        }
        return string;
    }

    public static String translateFromPersistentName(String string) {
        if (translationsFromPersistentNames.get(string) != null) {
            return translationsFromPersistentNames.get(string);
        }
        return string;
    }

    public ClientTree(ConfigedMain configedMain) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.main = configedMain;
        if (!this.main.treeViewAllowed()) {
            this.setEnabled(false);
            this.setToolTipText(de.uib.utilities.Globals.wrapToHTML(configed.getResourceValue("ConfigedMain.TreeViewNotActive")));
        }
        logging.debug(this, "UI " + this.getUI());
        ClientTreeTransferHandler clientTreeTransferHandler = new ClientTreeTransferHandler(this);
        this.setTransferHandler(clientTreeTransferHandler);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.createTopNodes();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.nodeRenderer = new IconNodeRendererClientTree(this.main);
        this.setCellRenderer(this.nodeRenderer);
        this.model = new DefaultTreeModel(this.ROOT);
        this.setModel(this.model);
        this.model.setAsksAllowsChildren(true);
        this.model.addTreeModelListener(this);
        this.selectionmodel = new DefaultTreeSelectionModel();
        this.selectionmodel.setSelectionMode(2);
        this.setSelectionModel(this.selectionmodel);
        this.popupMenu = new JPopupMenu();
        this.treePopupMouseListener = new TreePopupMouseListener(this.popupMenu, this, null);
        this.addMouseListener(this.treePopupMouseListener);
        JMenuItem jMenuItem = new JMenuItem(configed.getResourceValue("ClientTree.addNode"));
        TreePopupMouseListener.createSubnodePosition = 0;
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconNode iconNode = ClientTree.this.makeSubgroupAt(ClientTree.this.treePopupMouseListener.getPopupSourcePath());
                if (iconNode != null) {
                    ClientTree.this.makeVisible(ClientTree.this.pathByAddingChild(ClientTree.this.treePopupMouseListener.getPopupSourcePath(), iconNode));
                    ClientTree.this.repaint();
                }
            }
        });
        this.popupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(configed.getResourceValue("ClientTree.editNode"));
        TreePopupMouseListener.editNodePosition = 1;
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClientTree.this.editGroupNode(ClientTree.this.treePopupMouseListener.getPopupSourcePath());
            }
        });
        this.popupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(configed.getResourceValue("ClientTree.deleteNode"));
        TreePopupMouseListener.deleteNodePosition = 2;
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClientTree.this.deleteNode(ClientTree.this.treePopupMouseListener.getPopupSourcePath());
            }
        });
        this.popupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("alle elemente ausw\u00e4hlen");
        TreePopupMouseListener.activateElementsPosition = 3;
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = ClientTree.this.treePopupMouseListener.getPopupSourcePath();
                if (treePath != null && treePath.getPathComponent(treePath.getPathCount() - 1) instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)treePath.getPathComponent(treePath.getPathCount() - 1);
                    ClientTree.this.main.setGroup(groupNode.toString());
                    logging.debug(this, "menuItemActivateElements " + ClientTree.this.treePopupMouseListener.getPopupSourcePath() + " node " + treePath.getPathComponent(treePath.getPathCount() - 1));
                }
            }
        });
        this.popupMenu.add(jMenuItem4);
        this.addMouseListener(this);
        this.locationsInDIRECTORY = new HashMap<String, Set<GroupNode>>();
        this.clientNodesInDIRECTORY = new HashMap<String, DefaultMutableTreeNode>();
        this.leafname2AllItsPaths = new Leafname2AllItsPaths();
    }

    @Override
    public TreePath[] getPathBetweenRows(int n, int n2) {
        return super.getPathBetweenRows(n, n2);
    }

    public TreePath pathByAddingChild(TreePath treePath, Object object) {
        if (object == null) {
            logging.debug(this, "pathByAddingChild: child null cannot be added");
            return null;
        }
        TreePath treePath2 = treePath.pathByAddingChild(object);
        logging.debug(this, " pathByAddingChild result " + treePath2);
        return treePath2;
    }

    public TreePath getPathToNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        TreePath treePath = this.pathToROOT;
        for (int i = 1; i < treeNodeArray.length; ++i) {
            logging.debug(this, "getPathToNode " + treePath + " adding " + treeNodeArray[i]);
            treePath = treePath.pathByAddingChild(treeNodeArray[i]);
        }
        return treePath;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        try {
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        n = this.getRowForLocation(mouseEvent.getX() + 30, mouseEvent.getY());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.mouse_ready) {
            logging.info(this, "mousePressed, but mouse not ready setSelectedClientsArray");
            return;
        }
        logging.info(this, "mousePressed, mouse ready ");
        this.mouse_ready = false;
        Cursor cursor = this.getCursor();
        ClientTree clientTree = this;
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        logging.info(this, " mouse pressed,  (x,y) " + mouseEvent.getX() + ", " + mouseEvent.getY() + "  row " + n);
        clientTree.setCursor(new Cursor(3));
        this.mouse_ready = this.main.treeClients_mouseAction(true, mouseEvent);
        clientTree.setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private IconNode produceClientNode(Object object) {
        IconNode iconNode = new IconNode(object, false);
        iconNode.setEnabled(false);
        iconNode.setIcon(Globals.createImageIcon("images/client_small.png", "client"));
        iconNode.setNonSelectedLeafIcon(Globals.createImageIcon("images/client_small_unselected.png", "client"));
        iconNode.setDisabledLeafIcon();
        return iconNode;
    }

    private GroupNode produceGroupNode(Object object, String string) {
        GroupNode groupNode = new GroupNode(object, string);
        groupNode.setToolTipText(string);
        groupNode.setEnabled(true);
        groupNode.setIcon(Globals.createImageIcon("images/group_small.png", "group"));
        groupNode.setClosedIcon(Globals.createImageIcon("images/group_small_unselected.png", "group unselected"));
        groupNode.setEmphasizedIcon(Globals.createImageIcon("images/group_small_1selected.png", "group 1selected"));
        groupNode.setDisabledLeafIcon();
        return groupNode;
    }

    private GroupNode produceGroupNode(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("groupId", string);
        hashMap.put("description", string);
        return this.produceGroupNode(hashMap);
    }

    private GroupNode produceGroupNode(Map<String, String> map) {
        String string = map.get("description");
        if (string == null || string.trim().equals("")) {
            string = map.get("groupId");
        }
        return this.produceGroupNode(map.get("groupId"), string);
    }

    private void createDIRECTORY_NOT_ASSIGNED() {
        this.DIRECTORY_NOT_ASSIGNED = this.produceGroupNode(DIRECTORY_NOT_ASSIGNED_NAME, configed.getResourceValue("ClientTree.NOTASSIGNEDdescription"));
        this.DIRECTORY_NOT_ASSIGNED.setAllowsSubGroups(false);
        this.DIRECTORY_NOT_ASSIGNED.setFixed(true);
        this.DIRECTORY_NOT_ASSIGNED.setChildsArePersistent(false);
        this.DIRECTORY.add(this.DIRECTORY_NOT_ASSIGNED);
        this.pathToDIRECTORY_NOT_ASSIGNED = new TreePath(new Object[]{this.ROOT, this.DIRECTORY, this.DIRECTORY_NOT_ASSIGNED});
    }

    private void createGROUPS() {
    }

    private void createTopNodes() {
        this.ROOT.setImmutable(true);
        this.ROOT.setFixed(true);
        this.pathToROOT = new TreePath(new Object[]{this.ROOT});
        this.GROUPS = this.produceGroupNode(GROUPS_NAME, configed.getResourceValue("ClientTree.GROUPSdescription"));
        this.GROUPS.setAllowsOnlyGroupChilds(true);
        this.GROUPS.setFixed(true);
        this.ROOT.add(this.GROUPS);
        this.pathToGROUPS = new TreePath(new Object[]{this.ROOT, this.GROUPS});
        this.DIRECTORY = this.produceGroupNode(DIRECTORY_NAME, configed.getResourceValue("ClientTree.DIRECTORYdescription"));
        this.DIRECTORY.setAllowsOnlyGroupChilds(true);
        this.DIRECTORY.setFixed(true);
        this.ROOT.add(this.DIRECTORY);
        this.pathToDIRECTORY = new TreePath(new Object[]{this.ROOT, this.DIRECTORY});
        this.ALL = this.produceGroupNode(ALL_NAME, configed.getResourceValue("ClientTree.ALLdescription"));
        this.ROOT.add(this.ALL);
        this.ALL.setImmutable(true);
        this.ALL.setFixed(true);
        this.pathToALL = new TreePath(new Object[]{this.ROOT, this.ALL});
        logging.info(this, "created topnodes e.g. pathToALL  " + this.pathToALL);
    }

    private void removeDIRECTORYchildren() {
        this.DIRECTORY.removeAllChildren();
    }

    public void clear() {
        this.ALL.removeAllChildren();
        this.DIRECTORY.removeAllChildren();
        this.GROUPS.removeAllChildren();
        logging.debug(this, "count groups children " + this.model.getChildCount(this.GROUPS));
        this.model.nodeStructureChanged(this.GROUPS);
        this.clientNodesInDIRECTORY.clear();
        this.locationsInDIRECTORY.clear();
        this.leafname2AllItsPaths.clear();
    }

    private void deleteGroupWithSubgroups(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode2.getAllowsChildren()) continue;
            this.deleteGroup(defaultMutableTreeNode2.toString());
        }
    }

    protected boolean deleteNode(TreePath treePath) {
        logging.debug(this, "deleteNode " + treePath);
        if (treePath == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string = (String)defaultMutableTreeNode.getUserObject();
        GroupNode groupNode = (GroupNode)defaultMutableTreeNode.getParent();
        if (this.groupNodes.get(string) != null && this.groupNodes.get(string).getParent() != groupNode) {
            logging.warning(this, "groupNodes.get(nodeID).getParent() != parent");
            groupNode = (GroupNode)this.groupNodes.get(string).getParent();
        }
        String string2 = (String)groupNode.getUserObject();
        if (this.groupNodes.get(string) != null) {
            int n = JOptionPane.showOptionDialog(Globals.mainContainer, configed.getResourceValue("ClientTree.deleteGroupWarning"), "opsi config editor " + configed.getResourceValue("ClientTree.deleteGroupWarningTitle"), 2, 2, null, null, null);
            if (n == 0) {
                this.groupNodes.remove(string);
                this.groups.remove(string);
                this.deleteGroupWithSubgroups(defaultMutableTreeNode);
                groupNode.remove(defaultMutableTreeNode);
                this.getActivePaths().remove(treePath);
                this.getActivePaths().add(treePath.getParentPath());
                this.getModel().nodeStructureChanged(groupNode);
            }
        } else {
            this.removeClientInternally(string, groupNode);
            this.removeObject2Group(string, string2);
        }
        return true;
    }

    private void produceDIRECTORYinfo(TreePath treePath, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.isInDIRECTORY(treePath)) {
            String string = (String)defaultMutableTreeNode.getUserObject();
            if (this.locationsInDIRECTORY.get(string) == null) {
                this.locationsInDIRECTORY.put(string, new TreeSet<DefaultMutableTreeNode>(new NodeComparator()));
            }
            Set<GroupNode> set = this.locationsInDIRECTORY.get(string);
            set.add((GroupNode)defaultMutableTreeNode.getParent());
        }
    }

    protected TreePath addClientNodeInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        String string = (String)defaultMutableTreeNode.getUserObject();
        this.leafname2AllItsPaths.add(string, treePath);
        return treePath;
    }

    public void produceClients(Object[] objectArray, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.produceClients(objectArray, defaultMutableTreeNode, false);
    }

    public void produceClients(Object[] objectArray, DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            IconNode iconNode = this.produceClientNode(string);
            if (bl) {
                this.clientNodesInDIRECTORY.put(string, iconNode);
            }
            if (defaultMutableTreeNode != null) {
                defaultMutableTreeNode.add(iconNode);
            } else {
                logging.info(this, "not added Node for " + string + " under " + defaultMutableTreeNode);
            }
            TreePath treePath = this.addClientNodeInfo(iconNode);
            this.produceDIRECTORYinfo(treePath, iconNode);
        }
        this.model.nodeStructureChanged(defaultMutableTreeNode);
    }

    protected void produceClients(Object[] objectArray) {
        this.produceClients(objectArray, this.ALL);
    }

    public void produceTreeForALL(Object[] objectArray) {
        this.clientNodesInDIRECTORY.clear();
        this.produceClients(objectArray);
    }

    protected void initTopGroups() {
        logging.debug(this, "initTopGroups  we have already groups " + this.groups);
        this.groupALL.put("groupId", ALL_NAME);
        this.groupALL.put("description", "root of complete client listing");
        this.groupNodes.put(ALL_NAME, this.ALL);
        this.groups.put(ALL_NAME, this.groupALL);
        this.groupGROUPS.put("groupId", GROUPS_NAME);
        this.groupGROUPS.put("description", "root of groups");
        this.groupNodes.put(GROUPS_NAME, this.GROUPS);
        this.groups.put(GROUPS_NAME, this.groupGROUPS);
        this.groupDIRECTORY.put("groupId", DIRECTORY_NAME);
        this.groupDIRECTORY.put("description", "root of directory");
        this.groupNodes.put(DIRECTORY_NAME, this.DIRECTORY);
        this.groups.put(DIRECTORY_NAME, this.groupDIRECTORY);
        this.groupDIRECTORY_NOT_ASSIGNED.put("groupId", DIRECTORY_NOT_ASSIGNED_NAME);
        this.groupDIRECTORY_NOT_ASSIGNED.put("description", "root of DIRECTORY_NOT_ASSIGNED");
        this.groupNodes.put(DIRECTORY_NOT_ASSIGNED_NAME, this.DIRECTORY_NOT_ASSIGNED);
        this.groups.put(DIRECTORY_NOT_ASSIGNED_NAME, this.groupDIRECTORY_NOT_ASSIGNED);
        logging.debug(this, "initTopGroups  we have groups " + this.groups);
    }

    private void listChildren(String string) {
        Enumeration<TreeNode> enumeration = this.DIRECTORY.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            logging.debug(this, "listChildren " + string + " node " + defaultMutableTreeNode);
        }
    }

    private boolean hasChildWithName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        boolean bl = false;
        for (int i = 0; i < this.model.getChildCount(defaultMutableTreeNode); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.model.getChild(defaultMutableTreeNode, i);
            String string2 = defaultMutableTreeNode2.getUserObject().toString();
            logging.info(this, "foundChild " + defaultMutableTreeNode2);
            if (!string2.equals(string)) continue;
            bl = true;
        }
        logging.info(this, "compareTo " + string + ": " + bl);
        return bl;
    }

    public boolean groupNodesExists() {
        return this.groupNodes != null;
    }

    public void produceAndLinkGroups(Map<String, Map<String, String>> map) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.groups = new TreeMap<String, Map<String, String>>(map);
        this.createDIRECTORY_NOT_ASSIGNED();
        this.groupNodes = new HashMap<String, GroupNode>();
        this.initTopGroups();
        logging.debug(this, "produceAndLinkGroups " + this.groups);
        for (String string : this.groups.keySet()) {
            if (topGroupNames.contains(string)) continue;
            defaultMutableTreeNode = this.produceGroupNode(this.groups.get(string));
            this.groupNodes.put(string, (GroupNode)defaultMutableTreeNode);
        }
        logging.info(this, "count groups children " + this.model.getChildCount(this.GROUPS));
        logging.info(this, "produceAndLinkGroups ");
        for (String string : this.groups.keySet()) {
            if (topGroupNames.contains(string)) continue;
            defaultMutableTreeNode = this.groupNodes.get(string);
            logging.debug(this, "node " + defaultMutableTreeNode);
            String string2 = this.groups.get(string).get("parentGroupId");
            logging.debug(this, "produceAndLinkGroups, groupId, found parentId " + string + ", " + string2);
            if (string2 == null || string2.equalsIgnoreCase("null")) {
                string2 = GROUPS_NAME;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            logging.debug(this, "produceAndLinkGroups, groupNodes.get(parentId)  " + this.groupNodes.get(string2));
            defaultMutableTreeNode2 = this.groupNodes.get(string2) == null ? (DefaultMutableTreeNode)this.groupNodes.get(GROUPS_NAME) : (DefaultMutableTreeNode)this.groupNodes.get(string2);
            logging.debug(this, "produceAndLinkGroups, parent node  " + this.groupNodes.get(string2));
            logging.debug(this, "produceAndLinkGroups, getPathToNode   parent  " + this.getPathToNode(defaultMutableTreeNode2));
            try {
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                this.model.nodesWereInserted(defaultMutableTreeNode2, new int[]{this.model.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode)});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logging.error(this, "Cannot add node to parent " + defaultMutableTreeNode + ", " + defaultMutableTreeNode2 + ": " + illegalArgumentException, illegalArgumentException);
                JOptionPane.showMessageDialog(Globals.mainContainer, configed.getResourceValue("ClientTree.cannot_add_node.text") + " " + defaultMutableTreeNode + " in  " + defaultMutableTreeNode2 + "(" + illegalArgumentException + ")", configed.getResourceValue("ClientTree.cannot_add_node.title"), 0);
            }
        }
        logging.debug(this, "produceAndLinkGroups groups " + this.groups);
        logging.debug(this, "count groups children " + this.model.getChildCount(this.GROUPS));
    }

    @Override
    public DefaultTreeModel getModel() {
        return this.model;
    }

    public void associateClientsToGroups(String[] stringArray, Map<String, Set<String>> map) {
        int n;
        Cloneable cloneable;
        Object object;
        this.locationsInDIRECTORY.clear();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (map.get(string) == null) continue;
            Object object2 = map.get(string);
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                cloneable = (ArrayList<Object>)hashMap.get(string2);
                if (cloneable == null) {
                    cloneable = new ArrayList<Object>();
                }
                cloneable.add(string);
                hashMap.put(string2, cloneable);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        hashMap.put(DIRECTORY_NOT_ASSIGNED_NAME, arrayList);
        for (Object object2 : hashMap.keySet()) {
            object = this.groupNodes.get(object2);
            if (object == null) {
                logging.warning("group for groupId " + (String)object2 + " not found");
                continue;
            }
            boolean bl = this.isInDIRECTORY((DefaultMutableTreeNode)object);
            this.produceClients(((List)hashMap.get(object2)).toArray(), (DefaultMutableTreeNode)object, bl);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            this.checkDIRECTORY((String)object, null);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            Set<GroupNode> set = this.locationsInDIRECTORY.get(object);
            if (set.size() != 0) continue;
            arrayList.add(object);
            cloneable = this.produceClientNode(object);
            this.DIRECTORY_NOT_ASSIGNED.add((MutableTreeNode)((Object)cloneable));
            this.clientNodesInDIRECTORY.put((String)object, (DefaultMutableTreeNode)cloneable);
            this.addClientNodeInfo((DefaultMutableTreeNode)cloneable);
            set.add(this.DIRECTORY_NOT_ASSIGNED);
        }
        logging.debug(this, "associateClientsToGroups groups " + this.groups);
        this.model.nodeStructureChanged(this.DIRECTORY);
    }

    public void editGroupNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return;
        }
    }

    protected void editGroupNode(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (treePath == null) {
            return;
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return;
        }
        String string = defaultMutableTreeNode.toString();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("groupname", string);
        linkedHashMap.put("description", this.groups.get(string).get("description"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("groupname", configed.getResourceValue("ClientTree.editNode.label.groupname"));
        hashMap.put("description", configed.getResourceValue("ClientTree.editNode.label.description"));
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("groupname", false);
        hashMap2.put("description", true);
        FEditRecord fEditRecord = new FEditRecord(configed.getResourceValue("ClientTree.editGroup"));
        fEditRecord.setRecord(linkedHashMap, hashMap, null, hashMap2);
        fEditRecord.setTitle(configed.getResourceValue("ClientTree.editNode.title") + " (" + "opsi config editor" + ")");
        fEditRecord.init();
        fEditRecord.setSize(450, 250);
        fEditRecord.centerOn(Globals.mainContainer);
        fEditRecord.setModal(true);
        fEditRecord.setVisible(true);
        linkedHashMap = fEditRecord.getData();
        if (!fEditRecord.isCancelled()) {
            this.groups.get(string).put("description", linkedHashMap.get("description"));
            this.groupNodes.get(string).setToolTipText(linkedHashMap.get("description"));
            this.updateGroup(string, this.groups.get(string));
        }
    }

    public IconNode makeSubgroupAt(TreePath treePath) {
        return this.makeSubgroupAt(treePath, "");
    }

    public IconNode makeSubgroupAt(TreePath treePath, String string) {
        logging.debug(this, "makeSubgroupAt  " + treePath);
        GroupNode groupNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode = treePath == null ? this.GROUPS : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getAllowsChildren()) {
            if (!defaultMutableTreeNode.toString().equals(GROUPS_NAME) && this.main.getOpsiVersion().compareTo("3.4.9") < 0) {
                JOptionPane.showMessageDialog(Globals.mainContainer, "group in group not supported for opsiVersion < 3.4.9, \nopsiVersion is " + this.main.getOpsiVersion(), "opsi info ", 2);
                return groupNode;
            }
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("groupname", "");
            linkedHashMap.put("description", "");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("groupname", configed.getResourceValue("ClientTree.editNode.label.groupname"));
            hashMap.put("description", configed.getResourceValue("ClientTree.editNode.label.description"));
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            hashMap2.put("groupname", true);
            hashMap2.put("description", true);
            String string2 = "";
            boolean bl = string2 != null && !string2.equals("") && !this.groups.keySet().contains(string2);
            String string3 = "";
            FEditRecord fEditRecord = new FEditRecord(string3);
            fEditRecord.setRecord(linkedHashMap, hashMap, null, hashMap2);
            fEditRecord.setTitle(configed.getResourceValue("ClientTree.addNode.title") + " (" + "opsi config editor" + ")");
            fEditRecord.init();
            fEditRecord.setSize(450, 250);
            fEditRecord.centerOn(Globals.mainContainer);
            fEditRecord.setModal(true);
            while (!bl) {
                if (string2.equals("")) {
                    string3 = configed.getResourceValue("ClientTree.requestGroup");
                } else if (this.groups.keySet().contains(string2)) {
                    string3 = "'" + string2 + "' " + configed.getResourceValue("ClientTree.requestNotExistingGroupName");
                } else {
                    bl = true;
                }
                fEditRecord.setHint(string3);
                if (bl) continue;
                fEditRecord.setVisible(true);
                string2 = fEditRecord.getData().get("groupname").toLowerCase();
                if (!fEditRecord.isCancelled()) continue;
                return null;
            }
            if (bl) {
                StringValuedRelationElement stringValuedRelationElement = new StringValuedRelationElement();
                stringValuedRelationElement.put("groupId", string2);
                stringValuedRelationElement.put("parentGroupId", defaultMutableTreeNode.toString());
                stringValuedRelationElement.put("description", linkedHashMap.get("description"));
                if (this.addGroup(stringValuedRelationElement)) {
                    this.groups.put(string2, stringValuedRelationElement);
                    logging.debug(this, "makeSubGroupAt newGroupKey, newGroup " + string2 + ", " + stringValuedRelationElement);
                    GroupNode groupNode2 = this.insertGroup(string2, linkedHashMap.get("description"), defaultMutableTreeNode);
                    this.groupNodes.put(string2, groupNode2);
                    groupNode = groupNode2;
                }
            }
        }
        return groupNode;
    }

    private boolean addObject2InternalGroup(String string, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath) {
        if (this.getChildWithUserObjectString(string, defaultMutableTreeNode) == null) {
            this.produceClients(new String[]{string}, defaultMutableTreeNode);
            this.makeVisible(this.pathByAddingChild(treePath, string));
            return true;
        }
        return false;
    }

    public void moveGroupTo(String string, GroupNode groupNode, GroupNode groupNode2, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath, String string2) {
        this.insertNodeInOrder(groupNode, defaultMutableTreeNode);
        this.getModel().nodeStructureChanged(groupNode2);
        this.makeVisible(this.pathByAddingChild(treePath, groupNode));
        Map<String, String> map = this.getGroups().get(string);
        map.put("parentGroupId", string2);
        this.updateGroup(string, map);
        this.leafname2AllItsPaths.rebuildFromTree(this.ROOT);
    }

    public void removeClientInternally(String string, GroupNode groupNode) {
        int n;
        logging.debug("removeClientInternally clientId, parentNode " + string + ", " + groupNode);
        DefaultMutableTreeNode defaultMutableTreeNode = this.getChildWithUserObjectString(string, groupNode);
        for (n = 0; defaultMutableTreeNode != null && n <= this.clientNodesInDIRECTORY.size(); ++n) {
            groupNode.remove(defaultMutableTreeNode);
            defaultMutableTreeNode = this.getChildWithUserObjectString(string, groupNode);
        }
        if (n > this.clientNodesInDIRECTORY.size()) {
            logging.warning("removing client not successful but stopped because of reaching the repetition limit");
        }
        this.clientNodesInDIRECTORY.remove(string);
        SimpleTreePath simpleTreePath = new SimpleTreePath(groupNode.getPath());
        simpleTreePath.add(string);
        this.leafname2AllItsPaths.remove(string, simpleTreePath);
        this.activeParents.removeAll(simpleTreePath.collectNodeNames());
        logging.debug(this, "removeClientInternally activeParents " + this.activeParents);
        this.getModel().nodeStructureChanged(groupNode);
        logging.debug("removeClientInternally ready");
        this.repaint();
    }

    private void moveClientTo(String string, TreePath treePath, String string2, GroupNode groupNode, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath2, String string3) {
        logging.debug(this, "moveClientTo " + string + " to " + defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getChildWithUserObjectString(string, defaultMutableTreeNode);
        if (defaultMutableTreeNode2 == null) {
            if (treePath != null) {
                logging.debug(this, "moveClientTo checked importID sourcePath.getLastPathComponent(); " + treePath.getLastPathComponent() + " class " + treePath.getLastPathComponent().getClass());
            } else {
                logging.debug(this, "moveClientTo sourcePath null, sourceParentNode " + groupNode);
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.getChildWithUserObjectString(string, groupNode);
            this.insertNodeInOrder(defaultMutableTreeNode3, defaultMutableTreeNode);
            this.getModel().nodeStructureChanged(groupNode);
            if (this.getGroupNode(string3).getChildsArePersistent()) {
                this.addObject2PersistentGroup(string, string3);
            }
            if (this.isInDIRECTORY(treePath2)) {
                this.locationsInDIRECTORY.get(string).add(this.getGroupNode(string3));
                this.locationsInDIRECTORY.get(string).remove(groupNode);
            }
            TreePath treePath3 = this.pathByAddingChild(treePath2, defaultMutableTreeNode3);
            SimpleTreePath simpleTreePath = new SimpleTreePath(treePath2.getPath());
            this.leafname2AllItsPaths.add(string, treePath3);
            this.activeParents.addAll(simpleTreePath.collectNodeNames());
            logging.debug(this, "moveClientTo -- remove " + string + " from " + string2 + " clientNode, sourceParentNode, sourcePath " + defaultMutableTreeNode3 + ", " + groupNode + ", " + treePath);
            this.removeObject2Group(string, string2);
            this.removeClientInternally(string, groupNode);
            this.makeVisible(treePath3);
            this.repaint();
            this.checkDIRECTORY(string, (GroupNode)defaultMutableTreeNode);
        }
    }

    public void clientCopyOrMoveTo(String string, TreePath treePath, String string2, GroupNode groupNode, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath2, String string3, Boolean bl) {
        logging.debug(this, "clientCopyOrMoveTo moving " + bl);
        if (bl != null && bl.booleanValue()) {
            this.moveClientTo(string, treePath, string2, groupNode, defaultMutableTreeNode, treePath2, string3);
        } else {
            this.copyClientTo(string, treePath, string3, defaultMutableTreeNode, treePath2);
        }
    }

    public void copyClientTo(String string, TreePath treePath, String string2, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath2) {
        logging.debug(this, " copying " + string + ", sourcePath " + treePath + " into group " + string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = treePath == null ? this.getClientNode(string) : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        logging.debug(this, " -- copyClientTo childs are persistent, newParentNode " + defaultMutableTreeNode + " " + ((GroupNode)defaultMutableTreeNode).getChildsArePersistent());
        boolean bl = this.addObject2InternalGroup(string, defaultMutableTreeNode, treePath2);
        if (bl && ((GroupNode)defaultMutableTreeNode).getChildsArePersistent()) {
            this.addObject2PersistentGroup(string, string2);
        }
        TreePath treePath3 = this.pathByAddingChild(treePath2, defaultMutableTreeNode2);
        SimpleTreePath simpleTreePath = new SimpleTreePath(treePath3.getPath());
        this.leafname2AllItsPaths.add(string, treePath3);
        this.activeParents.addAll(simpleTreePath.collectNodeNames());
        Set<GroupNode> set = this.locationsInDIRECTORY.get(string);
        if (set.contains(this.DIRECTORY_NOT_ASSIGNED) && set.size() > 1) {
            this.locationsInDIRECTORY.get(string).remove(this.DIRECTORY_NOT_ASSIGNED);
            this.removeClientInternally(string, this.DIRECTORY_NOT_ASSIGNED);
            set = this.locationsInDIRECTORY.get(string);
        }
        this.repaint();
        this.checkDIRECTORY(string, (GroupNode)defaultMutableTreeNode);
    }

    private void checkDIRECTORY(String string, GroupNode groupNode) {
        Set<GroupNode> set = this.locationsInDIRECTORY.get(string);
        if (set == null) {
            set = new TreeSet<DefaultMutableTreeNode>(new NodeComparator());
            this.locationsInDIRECTORY.put(string, set);
        }
        if (set.size() <= 1) {
            return;
        }
        List<GroupNode> list = this.selectOneNode(set, string, groupNode);
        if (list != null) {
            set.removeAll(list);
            for (GroupNode groupNode2 : set) {
                this.removeClientInternally(string, groupNode2);
                this.removeObject2Group(string, groupNode2.getUserObject().toString());
            }
            this.locationsInDIRECTORY.put(string, new HashSet<GroupNode>(list));
        }
    }

    private List<GroupNode> selectOneNode(Set<GroupNode> set, String string, GroupNode groupNode) {
        List<GroupNode> list = null;
        if (set.size() > 1) {
            logging.debug(this, "selectOneNode groupSet, clientID " + set + ", " + string);
            FEditList fEditList = new FEditList(null);
            fEditList.setListModel(new DefaultComboBoxModel<GroupNode>(new Vector<GroupNode>(set)));
            fEditList.setTitle("opsi config editor:  " + configed.getResourceValue("ClientTree.DIRECTORYname") + " " + configed.getResourceValue("ClientTree.checkDIRECTORYAssignments"));
            fEditList.setExtraLabel(configed.getResourceValue("ClientTree.severalLocationsAssigned") + " >> " + string + " <<, " + configed.getResourceValue("ClientTree.selectCorrectLocation"));
            fEditList.init(new Dimension(640, 60));
            fEditList.centerOn(Globals.mainContainer);
            fEditList.setModal(true);
            if (groupNode != null) {
                fEditList.setSelectedValue(groupNode);
                fEditList.setDataChanged(true);
            }
            fEditList.setVisible(true);
            logging.debug(this, "fList getSelectedValue " + fEditList.getSelectedList());
            if (fEditList.getSelectedList().size() == 0) {
                int n = JOptionPane.showOptionDialog(Globals.mainContainer, configed.getResourceValue("ClientTree.abandonUniqueLocation"), "opsi config editor " + configed.getResourceValue("ClientTree.requestInformation"), -1, 2, null, new String[]{configed.getResourceValue("yesOption"), configed.getResourceValue("noOption")}, configed.getResourceValue("noOption"));
                if (n == 1 || n == -1) {
                    list = this.selectOneNode(set, string, groupNode);
                }
            } else {
                list = fEditList.getSelectedList();
            }
        }
        return list;
    }

    public boolean isChildOfALL(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode.getParent() == this.ALL;
    }

    public boolean isInGROUPS(String string) {
        GroupNode groupNode = this.groupNodes.get(string);
        if (groupNode == null) {
            return false;
        }
        return this.isInGROUPS(groupNode);
    }

    public boolean isInDIRECTORY(String string) {
        GroupNode groupNode = this.groupNodes.get(string);
        if (groupNode == null) {
            return false;
        }
        return this.isInDIRECTORY(groupNode);
    }

    public boolean isInGROUPS(TreePath treePath) {
        boolean bl = treePath.getPathCount() >= 2 && treePath.getPathComponent(1) == this.GROUPS;
        return bl;
    }

    public boolean isInDIRECTORY(TreePath treePath) {
        boolean bl = treePath.getPathCount() >= 2 && treePath.getPathComponent(1) == this.DIRECTORY;
        return bl;
    }

    public boolean isInDIRECTORY(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        boolean bl = treeNodeArray.length >= 2 && treeNodeArray[1] == this.DIRECTORY;
        return bl;
    }

    public boolean isInGROUPS(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        boolean bl = treeNodeArray.length >= 2 && treeNodeArray[1] == this.GROUPS;
        return bl;
    }

    public void insertNodeInOrder(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (defaultMutableTreeNode == null || defaultMutableTreeNode2 == null) {
            return;
        }
        String string = defaultMutableTreeNode.getUserObject().toString();
        boolean bl = false;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode3.getAllowsChildren() && !defaultMutableTreeNode.getAllowsChildren()) continue;
            if (!defaultMutableTreeNode3.getAllowsChildren() && defaultMutableTreeNode.getAllowsChildren()) {
                bl = true;
                continue;
            }
            if (defaultMutableTreeNode3.toString().compareToIgnoreCase(string) <= 0) continue;
            bl = true;
        }
        if (defaultMutableTreeNode3 == null || !bl) {
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        } else {
            int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode3);
            defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
        }
        this.model.nodesWereInserted(defaultMutableTreeNode2, new int[]{this.model.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode)});
    }

    protected GroupNode insertGroup(Object object, DefaultMutableTreeNode defaultMutableTreeNode) {
        return this.insertGroup(object, object.toString(), defaultMutableTreeNode);
    }

    protected GroupNode insertGroup(Object object, String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string2 = string;
        if (string == null || string.trim().equals("")) {
            string2 = object.toString();
        }
        GroupNode groupNode = this.produceGroupNode(object, string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode2 = this.GROUPS;
        }
        this.insertNodeInOrder(groupNode, defaultMutableTreeNode2);
        return groupNode;
    }

    public TreePath getPathToALL() {
        return this.pathToALL;
    }

    public TreePath getPathToGROUPS() {
        return this.pathToGROUPS;
    }

    public TreePath getPathToDIRECTORY() {
        return this.pathToDIRECTORY;
    }

    public ArrayList<TreePath> getActivePaths() {
        return this.main.getActivePaths();
    }

    public TreePath getActiveTreePath(String string) {
        return this.main.getActiveTreeNodes().get(string);
    }

    public void collectParentIDsFrom(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.activeParents.addAll(this.collectParentIDs(defaultMutableTreeNode));
    }

    public void initActiveParents() {
        this.activeParents.clear();
    }

    public void produceActiveParents(String[] stringArray) {
        this.initActiveParents();
        for (int i = 0; i < stringArray.length; ++i) {
            this.activeParents.addAll(this.collectParentIDs(stringArray[i]));
        }
        logging.debug(this, "produceActiveParents activeParents " + this.activeParents);
        this.repaint();
    }

    private ArrayList<String> enumerateLeafNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getAllowsChildren()) continue;
            String string = (String)defaultMutableTreeNode2.getUserObject();
            arrayList.add(string);
        }
        return arrayList;
    }

    private ArrayList<String> enumerateLeafs(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getAllowsChildren()) continue;
            String string = (String)defaultMutableTreeNode2.getUserObject();
            arrayList.add(string);
        }
        return arrayList;
    }

    public TreeSet<String> collectLeafs(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeSet<String> treeSet = new TreeSet<String>(this.enumerateLeafs(defaultMutableTreeNode));
        return treeSet;
    }

    private HashSet<String> collectParentIDs(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = (String)defaultMutableTreeNode.getUserObject();
        return this.collectParentIDs(string);
    }

    private HashSet<String> collectParentIDs(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SimpleTreePath> arrayList = this.leafname2AllItsPaths.getSimpleTreePaths(string);
        if (arrayList == null) {
            logging.info(this, "collectParentIDs nodeID, treePaths " + string + ", " + arrayList);
        } else {
            for (SimpleTreePath simpleTreePath : arrayList) {
                hashSet.addAll(simpleTreePath.collectNodeNames());
            }
        }
        return hashSet;
    }

    public HashSet<String> getActiveParents() {
        if (this.activeParents == null) {
            this.initActiveParents();
        }
        return this.activeParents;
    }

    public TreePath getGroupPathActivatedByTree() {
        return this.main.getGroupPathActivatedByTree();
    }

    public boolean addObject2PersistentGroup(String string, String string2) {
        return this.main.addObject2Group(string, string2);
    }

    public boolean removeObject2Group(String string, String string2) {
        return this.main.removeObject2Group(string, string2);
    }

    public boolean addGroup(StringValuedRelationElement stringValuedRelationElement) {
        return this.main.addGroup(stringValuedRelationElement);
    }

    public boolean updateGroup(String string, Map<String, String> map) {
        return this.main.updateGroup(string, map);
    }

    public boolean deleteGroup(String string) {
        return this.main.deleteGroup(string);
    }

    public GroupNode getGroupNode(String string) {
        return this.groupNodes.get(string);
    }

    public Map<String, Map<String, String>> getGroups() {
        return this.groups;
    }

    public DefaultMutableTreeNode getClientNode(String string) {
        return this.clientNodesInDIRECTORY.get(string);
    }

    public Set getLocationsInDIRECTORY(String string) {
        return this.locationsInDIRECTORY.get(string);
    }

    public DefaultMutableTreeNode getChildWithUserObjectString(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode3.getUserObject().toString().equals(string)) continue;
            bl = true;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        logging.debug(this, "getChildWithUserObjectString  object in groupNode   " + string + " in " + defaultMutableTreeNode + ": " + defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    public ArrayList<String> getSelectedClientsInTable() {
        return this.main.getSelectedClientsInTable();
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
        }
        catch (ClassCastException classCastException) {
            logging.warning(this, "the ugly well known exception " + classCastException);
            WaitCursor.stopAll();
        }
    }

    static {
        translationsToPersistentNames.put(DIRECTORY_NAME, DIRECTORY_PERSISTENT_NAME);
        translationsFromPersistentNames.put(DIRECTORY_PERSISTENT_NAME, DIRECTORY_NAME);
        topGroupNames = new HashSet<String>();
        topGroupNames.add(ALL_NAME);
        topGroupNames.add(GROUPS_NAME);
        topGroupNames.add(DIRECTORY_NAME);
        topGroupNames.add(DIRECTORY_NOT_ASSIGNED_NAME);
    }

    class Leafname2AllItsPaths {
        Map<String, ArrayList<SimpleTreePath>> invertedSimpleClientPaths = new HashMap<String, ArrayList<SimpleTreePath>>();

        Leafname2AllItsPaths() {
        }

        public void clear() {
            this.invertedSimpleClientPaths.clear();
        }

        public void rebuildFromTree(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.clear();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode2.getAllowsChildren()) continue;
                String string = (String)defaultMutableTreeNode2.getUserObject();
                this.add(string, new SimpleTreePath(defaultMutableTreeNode2.getPath()));
            }
        }

        public ArrayList<SimpleTreePath> getSimpleTreePaths(String string) {
            return this.invertedSimpleClientPaths.get(string);
        }

        public void add(String string, SimpleTreePath simpleTreePath) {
            if (this.invertedSimpleClientPaths.get(string) == null) {
                this.invertedSimpleClientPaths.put(string, new ArrayList());
            }
            this.invertedSimpleClientPaths.get(string).add(simpleTreePath);
        }

        public void add(String string, TreePath treePath) {
            this.add(string, new SimpleTreePath(treePath.getPath()));
        }

        public void remove(String string, SimpleTreePath simpleTreePath) {
            if (this.invertedSimpleClientPaths.get(string) != null) {
                this.invertedSimpleClientPaths.get(string).remove(simpleTreePath);
            }
        }

        public void remove(String string, TreePath treePath) {
            logging.debug(this, "remove leafname, clientPath " + string + ", " + treePath);
            if (this.invertedSimpleClientPaths.get(string) != null) {
                SimpleTreePath simpleTreePath = new SimpleTreePath(treePath.getPath());
                this.invertedSimpleClientPaths.get(string).remove(new SimpleTreePath(treePath.getPath()));
            }
        }
    }

    class TreeException
    extends Exception {
        TreeException(String string) {
            super(string);
        }
    }

    class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        final Collator myCollator = Collator.getInstance();

        NodeComparator() {
            this.myCollator.setStrength(3);
        }

        @Override
        public int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            return this.myCollator.compare("" + defaultMutableTreeNode.getUserObject(), "" + defaultMutableTreeNode2.getUserObject());
        }
    }
}

