/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities;

import de.uib.configed.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.ActivityPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.util.concurrent.atomic.AtomicInteger;

public class WaitCursor {
    private static AtomicInteger objectCounting = new AtomicInteger();
    private static boolean allStopped = false;
    int objectNo = objectCounting.addAndGet(1);
    boolean ready = false;
    Cursor saveCursor;
    Component c;
    String callLocation;

    public WaitCursor() {
        this(null, new Cursor(0));
    }

    public WaitCursor(Component component) {
        this(component, new Cursor(0));
    }

    public WaitCursor(Component component, String string) {
        this(component, new Cursor(0), string);
    }

    public WaitCursor(Component component, Cursor cursor) {
        this(component, cursor, "(not specified)");
    }

    public WaitCursor(Component component, Cursor cursor, String string) {
        allStopped = false;
        this.saveCursor = cursor;
        this.callLocation = string;
        if (component == null) {
            try {
                this.c = Globals.mainContainer;
            }
            catch (Exception exception) {
                logging.info(this, "retrieveBasePane " + exception);
                this.c = null;
            }
        } else {
            this.c = component;
        }
        logging.info(this, "adding instance " + this.objectNo + "-- call location at (" + string + ") on component " + this.c);
        new Thread(){

            @Override
            public void run() {
                ActivityPanel.setActing(true);
                while (!WaitCursor.this.ready && !allStopped) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    public void stop() {
        logging.info(this, " stop wait cursor " + this.objectNo + ", was located at (" + this.callLocation + ")");
        this.ready = true;
        if (this.c != null) {
            this.c.setCursor(this.saveCursor);
        }
        objectCounting.decrementAndGet();
        logging.debug(this, "removing instance " + this.objectNo);
        if (objectCounting.get() == 0) {
            logging.debug(this, "seemed to be last living instance");
            ActivityPanel.setActing(false);
        } else {
            logging.info(this, " stopped wait cursor  instance " + this.objectNo + ", " + " still active  " + objectCounting);
        }
    }

    public boolean isStopped() {
        return this.ready;
    }

    public static void stopAll() {
        allStopped = true;
    }

    private int getObjectNo() {
        return this.objectNo;
    }
}

