/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.gui;

import de.uib.configed.configed;
import de.uib.utilities.Globals;
import de.uib.utilities.Mapping;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.JComboBoxToolTip;
import de.uib.utilities.swing.JMenuItemFormatted;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;

public class SearchPane
extends JPanel
implements DocumentListener,
KeyListener {
    JTextField fieldSearch;
    private boolean searchActive = false;
    int blinkrate;
    JComboBox comboSearchFields;
    JComboBox comboSearchFieldsMode;
    JPopupMenu searchMenu;
    public static final int FULL_TEXT_SEARCH = 0;
    public static final int START_TEXT_SEARCH = 1;
    public static final int REGEX_SEARCH = 2;
    protected boolean withRegEx = true;
    protected boolean selectMode = true;
    private int foundrow = -1;
    JTable table;
    final Comparator comparator = Globals.getCollator();
    Map<String, Mapping<Integer, String>> mappedValues = new HashMap<String, Mapping<Integer, String>>();

    public SearchPane(JTable jTable, boolean bl) {
        this.withRegEx = bl;
        this.initComponents();
        this.table = jTable;
    }

    public SearchPane(JTable jTable) {
        this(jTable, false);
    }

    public void setMapping(String string, Mapping<Integer, String> mapping) {
        this.mappedValues.put(string, mapping);
    }

    public void setSelectMode(boolean bl) {
        this.selectMode = bl;
    }

    protected void initComponents() {
        this.setBackground(Globals.backgroundWhite);
        JLabel jLabel = new JLabel(configed.getResourceValue("SearchPane.search"));
        jLabel.setFont(Globals.defaultFont);
        this.fieldSearch = new JTextField("");
        this.fieldSearch.setPreferredSize(Globals.buttonDimension);
        this.fieldSearch.setFont(Globals.defaultFontBig);
        this.fieldSearch.setBackground(Globals.backLightYellow);
        this.fieldSearch.getCaret().setBlinkRate(0);
        this.fieldSearch.getDocument().addDocumentListener(this);
        this.fieldSearch.addKeyListener(this);
        this.searchMenu = new JPopupMenu();
        JMenuItemFormatted jMenuItemFormatted = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted2 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted3 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted4 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted5 = new JMenuItemFormatted();
        this.searchMenu.add(jMenuItemFormatted);
        this.searchMenu.add(jMenuItemFormatted2);
        this.searchMenu.add(jMenuItemFormatted3);
        this.searchMenu.add(jMenuItemFormatted4);
        this.searchMenu.add(jMenuItemFormatted5);
        jMenuItemFormatted.setText("Suchen");
        jMenuItemFormatted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.searchTheRow(SearchPane.this.selectMode);
            }
        });
        jMenuItemFormatted2.setText(configed.getResourceValue("SearchPane.popup.searchnext"));
        jMenuItemFormatted2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.searchNextRow(SearchPane.this.selectMode);
            }
        });
        jMenuItemFormatted3.setText(configed.getResourceValue("SearchPane.popup.searchnew"));
        jMenuItemFormatted3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.searchTheRow(0, SearchPane.this.selectMode);
            }
        });
        jMenuItemFormatted4.setText(configed.getResourceValue("SearchPane.popup.markall"));
        jMenuItemFormatted4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.markAll();
            }
        });
        jMenuItemFormatted5.setText(configed.getResourceValue("SearchPane.popup.empty"));
        jMenuItemFormatted5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.fieldSearch.setText("");
            }
        });
        this.fieldSearch.setComponentPopupMenu(this.searchMenu);
        this.fieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPane.this.searchNextRow(SearchPane.this.selectMode);
            }
        });
        JLabel jLabel2 = new JLabel(configed.getResourceValue("SearchPane.searchmode.searchmode"));
        jLabel2.setFont(Globals.defaultFont);
        this.comboSearchFieldsMode = new JComboBoxToolTip();
        this.comboSearchFieldsMode.setFont(Globals.defaultFont);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(configed.getResourceValue("SearchPane.searchmode.fulltext"), configed.getResourceValue("SearchPane.mode.fulltext.tooltip"));
        linkedHashMap.put(configed.getResourceValue("SearchPane.mode.starttext"), configed.getResourceValue("SearchPane.mode.starttext.tooltip"));
        if (this.withRegEx) {
            linkedHashMap.put(configed.getResourceValue("SearchPane.mode.regex"), configed.getResourceValue("SearchPane.mode.regex.tooltip"));
        }
        ((JComboBoxToolTip)this.comboSearchFieldsMode).setValues(linkedHashMap, false);
        this.comboSearchFieldsMode.setSelectedIndex(1);
        this.comboSearchFieldsMode.setPreferredSize(Globals.lowerButtonDimension);
        this.comboSearchFields = new JComboBox<String>(new String[]{configed.getResourceValue("SearchPane.search.allfields")});
        this.comboSearchFields.setPreferredSize(Globals.lowerButtonDimension);
        this.comboSearchFields.setFont(Globals.defaultFont);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.fieldSearch, -2, -2, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(jLabel, -2, -2, -2).addGap(10, 10, 10).addComponent(this.comboSearchFields, -2, -2, -2).addGap(10, 10, 10).addComponent(jLabel2, -2, -2, -2).addGap(10, 10, 10).addComponent(this.comboSearchFieldsMode, -2, -2, -2).addGap(10, 10, 10)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 10, -2, -2).addComponent(this.fieldSearch, 10, -2, -2).addComponent(jLabel2, -2, -2, -2).addComponent(this.comboSearchFieldsMode, -2, -2, -2).addComponent(this.comboSearchFields, 10, -2, -2)));
    }

    public void setSearchFields(Integer[] integerArray) {
        for (int i = 0; i < integerArray.length; ++i) {
            this.comboSearchFields.addItem(this.table.getModel().getColumnName(integerArray[i]));
        }
    }

    public void setSearchFieldsAll() {
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            String string = this.table.getModel().getColumnName(i);
            this.comboSearchFields.addItem(string);
            logging.info(this, "setSearchFieldsAll, adding colname " + string);
        }
    }

    public void setSearchFields(List<String> list) {
        for (String string : list) {
            if (((DefaultComboBoxModel)this.comboSearchFields.getModel()).getIndexOf(string) != -1) continue;
            this.comboSearchFields.addItem(string);
        }
    }

    public void setSelectedSearchField(String string) {
        this.comboSearchFields.setSelectedItem(string);
    }

    public void setSearchMode(int n) {
        if (n <= 1) {
            this.comboSearchFieldsMode.setSelectedIndex(n);
        } else if (this.withRegEx) {
            this.comboSearchFieldsMode.setSelectedIndex(2);
        }
    }

    @Override
    public void requestFocus() {
        this.fieldSearch.requestFocus();
    }

    private Finding stringContainsParts(String string, String string2, String[] stringArray) {
        String string3 = string2;
        if (this.mappedValues.get(string) != null) {
            string3 = this.mappedValues.get(string).getMapOfStrings().get(string2);
        }
        return this.stringContainsParts(string3, stringArray);
    }

    private Finding stringContainsParts(String string, String[] stringArray) {
        Finding finding = new Finding();
        String string2 = string;
        if (string == null) {
            return finding;
        }
        if (stringArray == null) {
            return finding;
        }
        int n = stringArray.length;
        if (n == 0) {
            finding.success = true;
            return finding;
        }
        int n2 = 0;
        boolean bl = true;
        Finding finding2 = new Finding();
        while (bl) {
            finding2 = this.stringContains(string2, stringArray[n2]);
            if (finding2.success) {
                if (++n2 >= n) {
                    finding.success = true;
                    finding.endChar = finding2.endChar;
                    bl = false;
                    continue;
                }
                if (string2.length() > 0) {
                    string2 = string2.substring(finding2.endChar);
                    continue;
                }
                finding.success = false;
                continue;
            }
            finding.success = false;
            bl = false;
        }
        return finding;
    }

    private Finding stringContains(String string, String string2) {
        return this.stringContains(null, string, string2);
    }

    private Finding stringContains(String string, String string2, String string3) {
        Finding finding = new Finding();
        if (string2 == null) {
            return finding;
        }
        if (string3 == null) {
            return finding;
        }
        String string4 = string2;
        if (string != null && this.mappedValues.get(string) != null) {
            string4 = this.mappedValues.get(string).getMapOfStrings().get(string2);
        }
        if (string4 == null || string3.length() > string4.length()) {
            return finding;
        }
        if (string3.length() == 0) {
            finding.success = true;
            finding.endChar = 0;
            return finding;
        }
        finding.success = false;
        finding.startChar = 0;
        int n = string4.length() - string3.length() + 1;
        for (int i = 0; !finding.success && i < n; ++i) {
            finding.startChar = i;
            finding.success = this.comparator.compare(string4.substring(i, i + string3.length()), string3) == 0;
            finding.endChar = i + string3.length() - 1;
        }
        return finding;
    }

    private boolean stringStartsWith(String string, String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        if (string3 == null) {
            return false;
        }
        String string4 = string2;
        if (this.mappedValues.get(string) != null) {
            string4 = this.mappedValues.get(string).getMapOfStrings().get(string2);
        }
        if (string3.length() > string4.length()) {
            return false;
        }
        if (string3.length() == 0) {
            return true;
        }
        return this.comparator.compare(string4.substring(0, string3.length()), string3) == 0;
    }

    protected int findViewRowFromValue(int n, Object object, Set set, boolean bl, boolean bl2, boolean bl3) {
        logging.debug(this, "findViewRowFromValue(int startviewrow, Object value, Set colIndices, boolean fulltext, boolean regex): " + n + ", " + object + ", " + set + ", " + bl + ", " + bl2 + ", " + bl3);
        if (object == null) {
            return -1;
        }
        String string = object.toString();
        if (string.length() < 2) {
            return -1;
        }
        String[] stringArray = string.split(" ");
        String string2 = string.toLowerCase();
        boolean bl4 = false;
        int n2 = 0;
        if (n > 0) {
            n2 = n;
        }
        Pattern pattern = null;
        if (bl2) {
            try {
                if (bl) {
                    string = ".*" + string + ".*";
                }
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logging.info(this, "pattern problem " + patternSyntaxException);
                return -1;
            }
        }
        while (!bl4 && n2 < this.table.getModel().getRowCount()) {
            Object object2;
            if (bl3) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
                    if (set != null && !set.contains(i)) continue;
                    int n3 = this.table.convertColumnIndexToModel(i);
                    object2 = this.table.getModel().getValueAt(this.table.convertRowIndexToModel(n2), n3);
                    if (object2 == null) continue;
                    String string3 = "" + object2;
                    String string4 = this.table.getModel().getColumnName(n3);
                    if (this.mappedValues.get(string4) != null) {
                        string3 = this.mappedValues.get(string4).getMapOfStrings().get(string3);
                    }
                    stringBuffer.append(string3);
                }
                String string5 = stringBuffer.toString();
                if (string5.equals("")) {
                    if (string.equals("")) {
                        bl4 = true;
                    }
                } else {
                    bl4 = this.stringContainsParts((String)string5, (String[])stringArray).success;
                }
            } else {
                for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
                    if (set != null && !set.contains(i)) continue;
                    int n4 = this.table.convertColumnIndexToModel(i);
                    Object object3 = this.table.getModel().getValueAt(this.table.convertRowIndexToModel(n2), n4);
                    if (object3 == null) {
                        if (string.equals("")) {
                            bl4 = true;
                        }
                    } else {
                        object2 = "" + object3;
                        if (bl2) {
                            if (pattern.matcher((CharSequence)object2).matches()) {
                                bl4 = true;
                            }
                        } else {
                            bl4 = bl ? this.stringContainsParts((String)this.table.getModel().getColumnName((int)n4), (String)object2, (String[])stringArray).success : this.stringStartsWith(this.table.getModel().getColumnName(n4), (String)object2, string);
                        }
                    }
                    if (bl4) break;
                }
            }
            if (bl4) continue;
            ++n2;
        }
        if (bl4) {
            return n2;
        }
        return -1;
    }

    private void getSelectedAndSearch(boolean bl) {
        this.getSelectedAndSearch(false, bl);
    }

    public boolean isSearchActive() {
        return this.searchActive;
    }

    public void markAll() {
        this.table.clearSelection();
        this.searchTheRow(0, true);
        int n = this.foundrow++;
        while (this.foundrow > n) {
            this.getSelectedAndSearch(true, true);
        }
    }

    private void searchNextRow(boolean bl) {
        ++this.foundrow;
        this.searchTheRow(this.foundrow, false, bl);
    }

    private void getSelectedAndSearch(boolean bl, boolean bl2) {
        int n = 0;
        if (this.table.getSelectedRow() >= 0) {
            n = this.table.getSelectedRows()[this.table.getSelectedRows().length - 1] + 1;
        }
        if (n >= this.table.getRowCount()) {
            n = 0;
        }
        this.searchTheRow(n, bl, bl2);
        if (this.foundrow == -1) {
            this.searchTheRow(0, bl, bl2);
        }
    }

    private void searchTheRow(boolean bl) {
        this.searchTheRow(this.table.getSelectedRow(), bl);
    }

    private void searchTheRow(int n, boolean bl) {
        this.searchTheRow(n, false, bl);
    }

    private void setRow(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                this.addSelectedRow(n);
            } else {
                this.setSelectedRow(n);
            }
        } else {
            this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
        }
    }

    private void searchTheRow(int n, boolean bl, boolean bl2) {
        String string = this.fieldSearch.getText();
        HashSet<Integer> hashSet = null;
        if (this.comboSearchFields.getSelectedIndex() > 0) {
            hashSet = new HashSet<Integer>();
            hashSet.add(((AbstractTableModel)this.table.getModel()).findColumn((String)this.comboSearchFields.getSelectedItem()));
        }
        HashSet<Integer> hashSet2 = hashSet;
        boolean bl3 = this.comboSearchFieldsMode.getSelectedIndex() == 0;
        boolean bl4 = this.comboSearchFieldsMode.getSelectedIndex() == 2;
        boolean bl5 = bl3;
        this.foundrow = this.findViewRowFromValue(n, string, hashSet2, bl3, bl4, bl5);
        if (this.foundrow > -1) {
            this.setRow(this.foundrow, bl, bl2);
        } else if (n > 0) {
            this.searchTheRow(0, bl, bl2);
        } else {
            this.setRow(0, false, bl2);
        }
    }

    public void scrollRowToVisible(int n) {
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
    }

    public void addSelectedRow(int n) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        this.table.addRowSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
    }

    public void setSelectedRow(int n) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        if (n == -1) {
            this.table.clearSelection();
            return;
        }
        this.table.setRowSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.searchTheRow(this.selectMode);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.searchTheRow(this.selectMode);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.setRow(0, false, this.selectMode);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 116) {
            if (!this.fieldSearch.getText().equals("")) {
                this.markAll();
            }
        } else if (keyEvent.getKeyCode() == 114 && !this.fieldSearch.getText().equals("")) {
            this.searchNextRow(this.selectMode);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
    }

    private class Finding {
        boolean success = false;
        int startChar = -1;
        int endChar = -1;

        private Finding() {
        }
    }
}

