/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.configed;
import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.DataLoadingObserver;
import de.uib.utilities.swing.MyPainter;
import de.uib.utilities.swing.SetWaitCursor;
import de.uib.utilities.swing.Waiting;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIDefaults;

public class FWaitProgress
extends JFrame
implements WindowListener,
DataLoadingObserver {
    JProgressBar jProgressBar1;
    JLabel jLabel1;
    protected String info;
    protected Component home;
    protected int waitUntilShow;
    protected int maxShowing;
    SetWaitCursor sWaitCursor;
    Waiting pureProgress;
    boolean sendingToFront = false;
    protected Object observingMesg = configed.getResourceValue("LoadingObserver.start");
    static final String waitString = " ";
    String[] waitStrings;
    int max = 200;
    private boolean showing = true;
    ThreadProgressBar threadProgress;

    public FWaitProgress(String string, String string2, Component component, int n, int n2) {
        this.setTitle(string);
        this.info = string2;
        this.home = component;
        this.waitUntilShow = n;
        this.maxShowing = n2;
        this.addWindowListener(this);
        this.createGUI();
    }

    public FWaitProgress(String string, String string2, Component component, int n) {
        this(string, string2, null, n, 0);
    }

    public FWaitProgress(String string, String string2, int n) {
        this(string, string2, null, n);
    }

    @Override
    public void gotNotification(Object object) {
        this.observingMesg = object;
    }

    private void createGUI() {
        this.setIconImage(Globals.mainIcon);
        this.waitStrings = new String[]{"        ", "  .     ", "  ..    ", "  ....  ", "  ..... "};
        this.jProgressBar1 = new JProgressBar();
        this.jProgressBar1.setEnabled(true);
        this.jProgressBar1.setMaximum(this.max);
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ProgressBar[Enabled].foregroundPainter", new MyPainter(Globals.opsiLogoBlue));
        uIDefaults.put("ProgressBar[Enabled].backgroundPainter", new MyPainter(Globals.opsiLogoLightBlue));
        this.jProgressBar1.putClientProperty("Nimbus.Overrides", uIDefaults);
        this.jLabel1 = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        ImageIcon imageIcon = de.uib.configed.Globals.createImageIcon("images/configed_icon.png", "");
        JLabel jLabel = new JLabel(imageIcon);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 150, 150, 150).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(this.jLabel1, 100, 300, Short.MAX_VALUE).addGap(10, 10, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 30).addComponent(this.jProgressBar1, 100, 350, Short.MAX_VALUE).addGap(10, 10, 30)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jLabel, 150, 150, 150).addComponent(this.jProgressBar1, 10, 10, 10).addComponent(this.jLabel1, 30, 30, 30));
        this.getContentPane().add(jPanel);
        this.setSize(new Dimension(400, 250));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 65);
    }

    public void start() {
        this.showing = true;
        try {
            if (this.waitUntilShow == 0) {
                this.setVisible(true);
            }
            if (this.home != null) {
                this.sWaitCursor = new SetWaitCursor(this.home);
                this.sWaitCursor.start();
            }
            if (this.info == null) {
                this.setInfo(this.waitStrings[0]);
            } else {
                this.setInfo(this.info);
            }
            this.threadProgress = new ThreadProgressBar(this);
            this.threadProgress.start();
        }
        catch (Exception exception) {
            logging.info(this, "ex " + exception);
        }
    }

    public void stop() {
        this.showing = false;
        this.setVisible(false);
    }

    public void setWaitUntilShow(int n) {
        this.waitUntilShow = n;
    }

    public void setInfo(String string) {
        this.jLabel1.setText(string);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.showing = false;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.sendingToFront = true;
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.sendingToFront = false;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    class ThreadProgressBar
    extends Thread {
        ThreadProgressBar(FWaitProgress fWaitProgress2) {
        }

        @Override
        public void run() {
            int n = 0;
            int n2 = 0;
            try {
                while (FWaitProgress.this.showing) {
                    if (n % 4 == 0) {
                        logging.info(this, "progressIndex " + n);
                    }
                    FWaitProgress.this.jProgressBar1.setValue(n);
                    if (++n > FWaitProgress.this.waitUntilShow) {
                        if (++n2 > 4) {
                            n2 = 0;
                        }
                        FWaitProgress.this.setInfo("" + FWaitProgress.this.observingMesg + FWaitProgress.waitString + FWaitProgress.this.waitStrings[n2]);
                        if (FWaitProgress.this.sendingToFront) {
                            FWaitProgress.this.setVisible(true);
                        }
                    }
                    if (FWaitProgress.this.showing) {
                        ThreadProgressBar.sleep(400L);
                    }
                    if (FWaitProgress.this.maxShowing > 0 && n > FWaitProgress.this.maxShowing) {
                        FWaitProgress.this.showing = false;
                    }
                    if (FWaitProgress.this.jProgressBar1.getValue() < FWaitProgress.this.jProgressBar1.getMaximum()) continue;
                    FWaitProgress.this.showing = false;
                }
                ThreadProgressBar.sleep(10L);
                FWaitProgress.this.jProgressBar1.setValue(0);
                FWaitProgress.this.jProgressBar1.setEnabled(false);
                FWaitProgress.this.setVisible(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (FWaitProgress.this.sWaitCursor != null) {
                FWaitProgress.this.sWaitCursor.showing = false;
            }
            if (FWaitProgress.this.pureProgress != null) {
                FWaitProgress.this.pureProgress.showing = false;
            }
            FWaitProgress.this.dispose();
        }
    }
}

