/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CheckedDocument
extends PlainDocument {
    char[] allowedChars;
    int size;
    boolean checkMask = false;

    public CheckedDocument() {
    }

    public CheckedDocument(char[] cArray, int n) {
        this.allowedChars = cArray;
        this.size = n;
    }

    public boolean appendCharIfAllowed(StringBuffer stringBuffer, char c) {
        char c2 = c;
        if (this.allowedChars == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (Character.toLowerCase(this.allowedChars[i]) != Character.toLowerCase(c)) continue;
            if (Character.isLowerCase(this.allowedChars[i])) {
                c2 = Character.toLowerCase(c);
            } else if (Character.isUpperCase(this.allowedChars[i])) {
                c2 = Character.toUpperCase(c);
            }
            stringBuffer.append(c2);
            bl = true;
            break;
        }
        return bl;
    }

    public String giveAllowedCharacters(String string, int n) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            this.appendCharIfAllowed(stringBuffer, cArray[i]);
        }
        return stringBuffer.toString();
    }

    protected void applyMask(AttributeSet attributeSet, int n) throws BadLocationException {
    }

    protected void insertStringPlain(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n, string, attributeSet);
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (this.size > -1 && n >= this.size) {
            return;
        }
        String string2 = this.giveAllowedCharacters(string, n);
        if (this.size > -1 && n + string2.length() > this.size) {
            string2 = string2.substring(0, this.size - n);
        }
        this.insertStringPlain(n, string2, attributeSet);
        if (this.checkMask) {
            this.applyMask(attributeSet, n);
        }
    }
}

