/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TargetConfiguration {
    public static final String KEY = "targetConfiguration";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int UNDEFINED = 0;
    public static final int INSTALLED = 1;
    public static final int ALWAYS = 2;
    public static final int FORBIDDEN = 4;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Vector<Integer> states;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(0);
        states.add(1);
        states.add(2);
        states.add(4);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("undefined");
        labels.add("installed");
        labels.add("always");
        labels.add("forbidden");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(0, "undefined");
        state2label.put(1, "installed");
        state2label.put(2, "always");
        state2label.put(4, "forbidden");
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("undefined", 0);
        label2state.put("installed", 1);
        label2state.put("always", 2);
        label2state.put("forbidden", 4);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("undefined", "undefined");
        label2displayLabel.put("installed", "installed");
        label2displayLabel.put("always", "always");
        label2displayLabel.put("forbidden", "forbidden");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("undefined", "undefined");
        displayLabel2label.put("installed", "installed");
        displayLabel2label.put("always", "always");
        displayLabel2label.put("forbidden", "forbidden");
        choiceLabels = new String[]{label2displayLabel.get("undefined"), label2displayLabel.get("installed"), label2displayLabel.get("always"), label2displayLabel.get("forbidden")};
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        TargetConfiguration.checkCollections();
        return label2displayLabel;
    }

    public static boolean existsState(int n) {
        TargetConfiguration.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        TargetConfiguration.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        TargetConfiguration.checkCollections();
        if (!TargetConfiguration.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        TargetConfiguration.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        TargetConfiguration.checkCollections();
        if (string == null || string.equals("")) {
            return 0;
        }
        if (!TargetConfiguration.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        TargetConfiguration.checkCollections();
        return label2displayLabel.get(TargetConfiguration.getLabel(n));
    }

    public static final String[] getDisplayLabelsForChoice() {
        TargetConfiguration.checkCollections();
        return choiceLabels;
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return TargetConfiguration.getLabel(this.state);
    }

    public String toString() {
        return TargetConfiguration.getLabel(this.state);
    }

    public static TargetConfiguration produceFromDisplayLabel(String string) {
        return TargetConfiguration.produceFromLabel(displayLabel2label.get(string));
    }

    public static TargetConfiguration produceFromLabel(String string) {
        TargetConfiguration.checkCollections();
        if (string == null) {
            return new TargetConfiguration(-2);
        }
        if (!labels.contains(string)) {
            return new TargetConfiguration(-2);
        }
        return new TargetConfiguration(TargetConfiguration.getVal(string));
    }

    public TargetConfiguration() {
    }

    public TargetConfiguration(int n) {
        this.state = TargetConfiguration.existsState(n) ? n : -2;
    }

    public static void main(String[] stringArray) {
        TargetConfiguration.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

