/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.tree.ClientTree;
import de.uib.configed.type.ConfigName2ConfigValue;
import de.uib.configed.type.ConfigOption;
import de.uib.configed.type.DatedRowList;
import de.uib.configed.type.HostInfo;
import de.uib.configed.type.Object2GroupEntry;
import de.uib.configed.type.OpsiPackage;
import de.uib.configed.type.OpsiProductInfo;
import de.uib.configed.type.RemoteControl;
import de.uib.configed.type.RetrievedMap;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.configed.type.SWAuditEntry;
import de.uib.configed.type.SavedSearch;
import de.uib.configed.type.licences.AuditSoftwareXLicencePool;
import de.uib.configed.type.licences.LicenceContractEntry;
import de.uib.configed.type.licences.LicenceEntry;
import de.uib.configed.type.licences.LicenceStatisticsRow;
import de.uib.configed.type.licences.LicenceUsableForEntry;
import de.uib.configed.type.licences.LicenceUsageEntry;
import de.uib.configed.type.licences.LicencepoolEntry;
import de.uib.opsicommand.ConnectionState;
import de.uib.opsicommand.Executioner;
import de.uib.opsicommand.JSONReMapper;
import de.uib.opsicommand.JSONthroughHTTPS;
import de.uib.opsicommand.OpsiMethodCall;
import de.uib.opsidatamodel.DataStub;
import de.uib.opsidatamodel.DataStubNOM;
import de.uib.opsidatamodel.HostInfoCollections;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.Product2VersionList;
import de.uib.opsidatamodel.RemoteControls;
import de.uib.opsidatamodel.SavedSearches;
import de.uib.opsidatamodel.productstate.ActionRequest;
import de.uib.opsidatamodel.productstate.InstallationStatus;
import de.uib.opsidatamodel.productstate.ProductState;
import de.uib.utilities.ExtendedInteger;
import de.uib.utilities.Globals;
import de.uib.utilities.datapanel.MapTableModel;
import de.uib.utilities.datastructure.StringValuedRelationElement;
import de.uib.utilities.logging.TimeCheck;
import de.uib.utilities.logging.logging;
import de.uib.utilities.table.ListCellOptions;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpsiserviceNOMPersistenceController
extends PersistenceController {
    private static final String EMPTYFIELD = "-";
    private static final ArrayList NONE_LIST = new ArrayList(){

        @Override
        public int size() {
            return -1;
        }
    };
    private boolean readOnly = false;
    public static final String nameRequirementTypeBefore = "before";
    public static final String nameRequirementTypeAfter = "after";
    public static final String nameRequirementTypeNeutral = "";
    public static final String nameRequirementTypeOnDeinstall = "on_deinstall";
    public static final String[] LICENSE_TYPES = new String[]{"VOLUME", "OEM", "RETAIL", "CONCURRENT"};
    private static PersistenceController staticPersistControl;
    protected String connectionServer;
    private String user;
    private String password;
    protected Map<String, List> mapOfMethodSignatures;
    protected List<OpsiProductInfo> productInfos;
    protected Map<String, Map<String, Object>> productGlobalInfos;
    protected List productDependenciesCompleteList;
    protected Map productDependenciesMapForProducts;
    protected Map<String, Map<String, ConfigName2ConfigValue>> productproperties;
    private Map<String, Map<String, ConfigName2ConfigValue>> depot2product2properties;
    protected Set<String> productsHavingSpecificProperties;
    protected Map<String, Boolean> productHavingClientSpecificProperties;
    protected Map<String, Map<String, ListCellOptions>> productPropertyDefinitions;
    protected HostInfoCollections hostInfoCollections;
    private String theDepot = "";
    private List<Map<String, Object>> depotLocalbootProducts;
    private List<Map<String, Object>> depotNetbootProducts;
    private List<String> localbootProductNames;
    private List<String> netbootProductNames;
    private Map<String, List<String>> possibleActions;
    private String saveDepotId;
    private HashMap actionsToBeChanged;
    protected String[] logtypes;
    protected List<Map<String, Object>> softwareAuditOnClients;
    protected List<Map<String, Object>> relations_auditHardwareOnHost;
    protected AuditSoftwareXLicencePool relations_auditSoftwareToLicencePools;
    protected Map<String, Map> rowmapAuditSoftware;
    protected Map<String, String> fSoftware2LicencePool;
    protected Map<String, List<String>> fLicencePool2SoftwareList;
    protected Map<String, LicenceUsageEntry> rowsLicencesUsage;
    protected Map<String, List<LicenceUsageEntry>> fClient2LicencesUsageList;
    protected Map<String, Map<String, Object>> rowsLicencesReconciliation;
    protected TreeMap<String, LicenceStatisticsRow> rowsLicenceStatistics;
    protected Map<String, Set<String>> swId2clients;
    protected Map<String, List<Object>> hwAuditConf;
    protected HostGroups hostGroups;
    protected Map<String, Set<String>> fObject2Groups;
    protected Map<String, Set<String>> fGroup2Members;
    protected Map<String, Set<String>> fProductGroup2Members;
    protected Map<String, String> logfiles;
    private ArrayList updateProductOnClient_items;
    private ArrayList<LicenceUsageEntry> itemsDeletionLicenceUsage;
    protected Map opsiInformation;
    protected Date expiresDate;
    protected Map<String, Object> opsiModules;
    protected String opsiVersion;
    public boolean withLicenceManagement = false;
    protected boolean withLocalImaging = false;
    protected boolean withMySQL = false;
    protected boolean withUEFI = false;
    protected boolean withWAN = false;
    protected boolean withLinuxAgent = false;
    protected Map<String, ConfigOption> configOptions;
    protected Map<String, ListCellOptions> configListCellOptions;
    protected Map<String, List> configDefaultValues;
    protected Map<String, Map<String, Object>> hostConfigs;
    protected RemoteControls remoteControls;
    protected SavedSearches savedSearches;
    protected LinkedHashMap<String, Boolean> productOnClients_displayFieldsNetbootProducts;
    protected LinkedHashMap<String, Boolean> productOnClients_displayFieldsLocalbootProducts;
    protected LinkedHashMap<String, Boolean> host_displayFields;
    protected List configStateCollection;
    protected List deleteConfigStateItems;
    protected List configCollection;
    protected List productPropertyStateUpdateCollection;
    protected List productPropertyStateDeleteCollection;
    protected Map<String, Map<String, Object>> hostUpdates;
    protected TreeSet<String> productIds;
    protected Map<String, Map<String, String>> productDefaultStates;
    protected List<Object> licenceOnClientDeleteItems;
    DataStub dataStub;

    @Override
    protected boolean sourceAccepted() {
        return this.dataStub.test();
    }

    @Override
    public HostInfoCollections getHostInfoCollections() {
        return this.hostInfoCollections;
    }

    OpsiserviceNOMPersistenceController(String string, String string2, String string3) {
        logging.info(this, "start construction, \nconnect to " + string + " as " + string2);
        this.connectionServer = string;
        this.user = string2;
        this.password = string3;
        logging.debug(this, "create");
        this.hostInfoCollections = new DefaultHostInfoCollections(this);
        this.exec = new JSONthroughHTTPS(string, string2, string3);
        this.execs.put(string, this.exec);
        this.hwAuditConf = new HashMap<String, List<Object>>();
        this.initMembers();
    }

    protected void initMembers() {
        this.dataStub = new DataStubNOM(this);
    }

    @Override
    protected boolean checkConfiguration() {
        this.initMembers();
        boolean bl = this.sourceAccepted();
        if (bl) {
            this.checkReadOnly();
            if (!this.readOnly) {
                bl = this.checkStandardConfigs();
            }
        }
        return bl;
    }

    @Override
    public Executioner retrieveWorkingExec(String string) {
        logging.info(this, "retrieveWorkingExec for server " + string);
        if (string.equals(this.connectionServer)) {
            logging.info(this, "retrieveWorkingExec for config server");
            return this.exec;
        }
        String string2 = (String)this.getHostInfoCollections().getDepots().get(string).get("opsiHostKey");
        JSONthroughHTTPS jSONthroughHTTPS = new JSONthroughHTTPS(string, string, string2);
        if (this.makeConnection(jSONthroughHTTPS)) {
            logging.info(this, "retrieveWorkingExec new for server " + string);
            return jSONthroughHTTPS;
        }
        logging.info(this, "no connection to server " + string);
        return Executioner.NONE;
    }

    @Override
    protected boolean makeConnection() {
        return this.makeConnection(this.exec);
    }

    protected boolean makeConnection(Executioner executioner) {
        logging.info(this, "trying to make connection");
        boolean bl = false;
        try {
            bl = executioner.doCall(new OpsiMethodCall("authenticated", new String[0]));
            if (!bl) {
                logging.info(this, "connection does not work");
            }
        }
        catch (ClassCastException classCastException) {
            logging.info(this, "JSONthroughHTTPS failed to make connection");
        }
        bl = bl && this.getConnectionState().equals(3);
        logging.info(this, "tried to make connection result " + bl);
        return bl;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.exec.getConnectionState();
    }

    @Override
    public void setConnectionState(ConnectionState connectionState) {
        this.exec.setConnectionState(connectionState);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void checkReadOnly() {
        this.readOnly = false;
        logging.info(this, "checkReadOnly");
        if (this.exec.getBooleanResult(new OpsiMethodCall("accessControl_userIsReadOnlyUser", new String[0]))) {
            this.readOnly = true;
            logging.info(this, "checkReadOnly " + this.readOnly);
        }
    }

    public boolean checkPermission() {
        if (this.readOnly) {
            JOptionPane.showMessageDialog(de.uib.configed.Globals.mainContainer, configed.getResourceValue("Permission.readonly.info"), configed.getResourceValue("Permission.readonly.info.title"), 0);
        }
        return !this.readOnly;
    }

    @Override
    public boolean installPackage(String string) {
        return this.installPackage(string, true, new Object[0], nameRequirementTypeNeutral);
    }

    public boolean installPackage(String string, boolean bl, Object object, String string2) {
        String string3 = "depot_installPackage";
        logging.check(this, string3);
        boolean bl2 = this.exec.doCall(new OpsiMethodCall(string3, new Object[]{string, bl}));
        logging.info(this, "installPackage result " + bl2);
        return bl2;
    }

    @Override
    public boolean setRights(String string) {
        String string2 = "setRights";
        logging.info(this, "setRights for path " + string);
        Object[] objectArray = new String[]{string};
        if (string == null) {
            objectArray = new String[]{};
        }
        boolean bl = this.exec.getBooleanResult(new OpsiMethodCall(string2, objectArray));
        return bl;
    }

    @Override
    public List<Map<String, Object>> HOST_read() {
        String[] stringArray = new String[]{};
        HashMap hashMap = new HashMap();
        TimeCheck timeCheck = new TimeCheck(this, "retrieveOpsiHosts").start();
        logging.check(this, "host_getObjects");
        List<Map<String, Object>> list = this.exec.getListOfMaps(new OpsiMethodCall("host_getObjects", new Object[]{stringArray, hashMap}));
        timeCheck.stop();
        for (Map<String, Object> map : list) {
        }
        return list;
    }

    @Override
    public List<String> getClientsWithOtherProductVersion(String string, String string2, String string3) {
        String[] stringArray = new String[]{};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("productId", string);
        hashMap.put("productType", "LocalbootProduct");
        List<Map<String, Object>> list = this.retrieveListOfMapsNOM(stringArray, hashMap, "productOnClient_getObjects");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map<String, Object> map : list) {
            String string4 = (String)map.get("clientId");
            String string5 = (String)map.get("productVersion");
            String string6 = (String)map.get("packageVersion");
            Object object = map.get("installationStatus");
            if (!InstallationStatus.getLabel(1).equals(object) || (JSONReMapper.equalsNull(string5) || string2.equals(string5)) && (JSONReMapper.equalsNull(string6) || string3.equals(string6))) continue;
            logging.debug("getClientsWithOtherProductVersion hit " + map);
            arrayList.add(string4);
        }
        logging.info(this, "getClientsWithOtherProductVersion globally " + arrayList);
        this.hostInfoCollections.intersectWithMapOfPCs(arrayList);
        logging.info(this, "getClientsWithOtherProductVersion " + arrayList);
        return arrayList;
    }

    @Override
    public boolean areDepotsSynchronous(Set set) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("areDepotsSynchronous", new Object[]{set.toArray()});
        boolean bl = this.exec.getBooleanResult(opsiMethodCall);
        return bl;
    }

    private List<Object> addWANConfigStates(String string, boolean bl, List<Object> list) {
        HashMap hashMap = new HashMap();
        HashMap<String, List<Object>> hashMap2 = new HashMap<String, List<Object>>();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(CONFIG_CLIENTD_EVENT_GUISTARTUP_WAN_VALUE == false);
        hashMap2.put("opsiclientd.event_gui_startup.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_GUISTARTUP_WAN_VALUE);
        hashMap.put("opsiclientd.event_gui_startup.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_GUISTARTUP_USERLOGGEDIN_WAN_VALUE == false);
        hashMap2.put("opsiclientd.event_gui_startup{user_logged_in}.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_GUISTARTUP_USERLOGGEDIN_WAN_VALUE);
        hashMap.put("opsiclientd.event_gui_startup{user_logged_in}.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_NET_CONNECTION_WAN_VALUE == false);
        hashMap2.put("opsiclientd.event_net_connection.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_NET_CONNECTION_WAN_VALUE);
        hashMap.put("opsiclientd.event_net_connection.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_TIMER_WAN_VALUE == false);
        hashMap2.put("opsiclientd.event_timer.active", arrayList);
        arrayList = new ArrayList();
        arrayList.add(CONFIG_CLIENTD_EVENT_TIMER_WAN_VALUE);
        hashMap.put("opsiclientd.event_timer.active", arrayList);
        this.setConfig(hashMap2);
        this.setConfig();
        HashMap<Object, Object> hashMap3 = bl ? hashMap : hashMap2;
        if (list == null) {
            list = new ArrayList<Object>();
        }
        for (String string2 : hashMap3.keySet()) {
            Map<String, Object> map = this.createNOMitem("ConfigState");
            map.put("configId", string2);
            map.put("values", this.exec.jsonArray((List)hashMap3.get(string2)));
            map.put("objectId", string);
            list.add(this.exec.jsonMap(map));
        }
        return list;
    }

    @Override
    public boolean setWANConfigs(String string, boolean bl) {
        boolean bl2 = false;
        List<Object> list = this.addWANConfigStates(string, bl, null);
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("configState_updateObjects", new Object[]{this.exec.jsonArray(list)});
        bl2 = this.exec.doCall(opsiMethodCall);
        return bl2;
    }

    private Object createUefiEntry(String string) {
        Map<String, Object> map = this.createNOMitem("ConfigState");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("linux/pxelinux.cfg/elilo.efi");
        map.put("objectId", string);
        map.put("values", this.exec.jsonArray(arrayList));
        map.put("configId", "clientconfig.dhcpd.filename");
        return this.exec.jsonMap(map);
    }

    @Override
    public boolean configureUefiBoot(String string, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.createUefiEntry(string));
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("configState_updateObjects", new Object[]{this.exec.jsonArray(arrayList)});
            bl2 = this.exec.doCall(opsiMethodCall);
        } else {
            Map<String, Object> map = this.createNOMitem("ConfigState");
            map.put("configId", "clientconfig.dhcpd.filename");
            map.put("objectId", string);
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            arrayList.add(this.exec.jsonMap(map));
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("configState_deleteObjects", new Object[]{this.exec.jsonArray(arrayList)});
            bl2 = this.exec.doCall(opsiMethodCall);
        }
        return bl2;
    }

    @Override
    public boolean createClient(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, String string9, String string10, String string11) {
        Map<String, Object> map;
        List<Object> list;
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl3 = false;
        if (string5 == null) {
            string5 = nameRequirementTypeNeutral;
        }
        if (string4 == null) {
            string4 = nameRequirementTypeNeutral;
        }
        if (string6 == null) {
            string6 = nameRequirementTypeNeutral;
        }
        if (string7.equals(nameRequirementTypeNeutral)) {
            string7 = null;
        }
        if (string9 == null) {
            string9 = nameRequirementTypeNeutral;
        }
        String string12 = string + "." + string2;
        Map<String, Object> map2 = this.createNOMitem("OpsiClient");
        map2.put("id", string12);
        map2.put("description", string4);
        map2.put("notes", string6);
        map2.put("hardwareAddress", string8);
        map2.put("ipAddress", string7);
        map2.put("inventoryNumber", string5);
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("host_createObjects", new Object[]{this.exec.jsonMap(map2)});
        bl3 = this.exec.doCall(opsiMethodCall);
        HostInfo hostInfo = new HostInfo(map2);
        if (bl3) {
            list = new ArrayList<Object>();
            map = this.createNOMitem("ConfigState");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string3);
            map.put("objectId", string12);
            map.put("values", this.exec.jsonArray(arrayList));
            map.put("configId", "clientconfig.depot.id");
            list.add(this.exec.jsonMap(map));
            if (bl) {
                list.add(this.createUefiEntry(string12));
            }
            if (bl2) {
                list = this.addWANConfigStates(string12, true, list);
            }
            opsiMethodCall = new OpsiMethodCall("configState_updateObjects", new Object[]{this.exec.jsonArray(list)});
            bl3 = this.exec.doCall(opsiMethodCall);
        }
        if (bl3 && string9 != null && !string9.isEmpty()) {
            logging.info(this, "createClient group " + string9);
            list = new ArrayList();
            map = this.createNOMitem("ObjectToGroup");
            map.put("groupType", "HostGroup");
            map.put("groupId", string9);
            map.put("objectId", string12);
            list.add(this.exec.jsonMap(map));
            opsiMethodCall = new OpsiMethodCall("objectToGroup_createObjects", new Object[]{this.exec.jsonArray(list)});
            bl3 = this.exec.doCall(opsiMethodCall);
        }
        if (bl3 && string10 != null && !string10.isEmpty()) {
            logging.info(this, "createClient productNetboot " + string10);
            list = new ArrayList();
            map = this.createNOMitem("ProductOnClient");
            map.put("productId", string10);
            map.put("productType", "NetbootProduct");
            map.put("clientId", string12);
            map.put(ProductState.key2servicekey.get("actionRequest"), "setup");
            list.add(this.exec.jsonMap(map));
            opsiMethodCall = new OpsiMethodCall("productOnClient_createObjects", new Object[]{this.exec.jsonArray(list)});
            bl3 = this.exec.doCall(opsiMethodCall);
        }
        if (bl3 && string11 != null && !string11.isEmpty()) {
            logging.info(this, "createClient productLocalboot " + string11);
            list = new ArrayList();
            map = this.createNOMitem("ProductOnClient");
            map.put("productId", string11);
            map.put("productType", "LocalbootProduct");
            map.put("clientId", string12);
            map.put(ProductState.key2servicekey.get("actionRequest"), "setup");
            list.add(this.exec.jsonMap(map));
            opsiMethodCall = new OpsiMethodCall("productOnClient_createObjects", new Object[]{this.exec.jsonArray(list)});
            bl3 = this.exec.doCall(opsiMethodCall);
        }
        if (bl3) {
            if (string3 == null || string3.equals(nameRequirementTypeNeutral)) {
                string3 = this.getHostInfoCollections().getConfigServer();
            }
            hostInfo.setInDepot(string3);
            hostInfo.setUefiBoot(bl);
            hostInfo.setWanConfig(bl2);
            this.hostInfoCollections.setLocalHostInfo(string12, string3, hostInfo);
            logging.info(this, " createClient hostInfo " + hostInfo);
        }
        return bl3;
    }

    @Override
    public boolean renameClient(String string, String string2) {
        if (!this.checkPermission()) {
            return false;
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("host_renameOpsiClient", new String[]{string, string2});
        this.hostInfoCollections.opsiHostsRequestRefresh();
        return this.exec.doCall(opsiMethodCall);
    }

    @Override
    public void deleteClient(String string) {
        if (!this.checkPermission()) {
            return;
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("host_delete", new String[]{string});
        this.exec.doCall(opsiMethodCall);
        this.hostInfoCollections.opsiHostsRequestRefresh();
    }

    private List<String> collectErrorsFromResponsesByHost(Map map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object k : map.keySet()) {
            JSONObject jSONObject = (JSONObject)map.get(k);
            String string2 = JSONReMapper.getErrorFromResponse(jSONObject);
            if (string2 == null) continue;
            string2 = k + ":\t" + string2;
            logging.info(string + ",  " + string2);
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public List<String> deletePackageCaches(String[] stringArray) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControlSafe_opsiclientdRpc", new Object[]{"cacheService_deleteCache", new Object[0], stringArray});
        Map map = this.exec.getMapResult(opsiMethodCall);
        return this.collectErrorsFromResponsesByHost(map, "deleteCache");
    }

    @Override
    public Map<String, List<String>> getHostSeparationByDepots(String[] stringArray) {
        HashMap hashMap = new HashMap();
        for (String string : stringArray) {
            String string2 = this.getHostInfoCollections().getMapPcBelongsToDepot().get(string);
            if (hashMap.get(string2) == null) {
                hashMap.put(string2, new HashSet());
            }
            ((Set)hashMap.get(string2)).add(string);
        }
        HashMap hashMap2 = new HashMap();
        for (String string : hashMap.keySet()) {
            hashMap2.put(string, new ArrayList((Collection)hashMap.get(string)));
        }
        return hashMap2;
    }

    @Override
    public List<String> wakeOnLan(String[] stringArray) {
        return this.wakeOnLan(stringArray, this.getHostSeparationByDepots(stringArray));
    }

    protected List<String> wakeOnLan(String[] stringArray, Map<String, List<String>> map) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (String string : map.keySet()) {
            logging.info(this, "from depot " + string + " we have hosts " + map.get(string));
            String string2 = (String)this.getHostInfoCollections().getDepots().get(string).get("opsiHostKey");
            Executioner executioner = (Executioner)hashMap2.get(string);
            logging.info(this, "working exec for depot " + string + " " + (executioner != null));
            if (executioner == null) {
                executioner = this.retrieveWorkingExec(string);
            }
            if (executioner == null || executioner == Executioner.NONE) continue;
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_start", new Object[]{map.get(string).toArray(new String[0])});
            Map map2 = executioner.getMapResult(opsiMethodCall);
            hashMap.putAll(map2);
        }
        return this.collectErrorsFromResponsesByHost(hashMap, "wakeOnLan");
    }

    @Override
    public List<String> wakeOnLan(List<String> list, Map<String, List<String>> map, Map<String, Executioner> map2) {
        HashMap hashMap = new HashMap();
        for (String string : map.keySet()) {
            logging.info(this, "from depot " + string + " we have hosts " + map.get(string));
            if (map2.get(string) == null || map2.get(string) == Executioner.NONE) continue;
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_start", new Object[]{map.get(string).toArray(new String[0])});
            Map map3 = map2.get(string).getMapResult(opsiMethodCall);
            hashMap.putAll(map3);
        }
        return this.collectErrorsFromResponsesByHost(hashMap, "wakeOnLan");
    }

    @Override
    public List<String> fireOpsiclientdEventOnClients(String string, String[] stringArray) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_fireEvent", new Object[]{string, stringArray});
        Map map = this.exec.getMapResult(opsiMethodCall);
        return this.collectErrorsFromResponsesByHost(map, "fireOpsiclientdEventOnClients");
    }

    @Override
    public List<String> showPopupOnClients(String string, String[] stringArray) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_showPopup", new Object[]{string, stringArray});
        Map map = this.exec.getMapResult(opsiMethodCall);
        return this.collectErrorsFromResponsesByHost(map, "showPopupOnClients");
    }

    @Override
    public List<String> shutdownClients(String[] stringArray) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_shutdown", new Object[]{stringArray});
        Map map = this.exec.getMapResult(opsiMethodCall);
        return this.collectErrorsFromResponsesByHost(map, "shutdownClients");
    }

    @Override
    public List<String> rebootClients(String[] stringArray) {
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("hostControl_reboot", new Object[]{stringArray});
        Map map = this.exec.getMapResult(opsiMethodCall);
        return this.collectErrorsFromResponsesByHost(map, "rebootClients");
    }

    @Override
    public Map<String, Object> reachableInfo(String[] stringArray) {
        Object[] objectArray = new Object[]{};
        if (stringArray != null) {
            objectArray = new Object[]{stringArray};
        }
        Map map = this.exec.getMapResult(new OpsiMethodCall("hostControl_reachable", objectArray, true));
        return map;
    }

    @Override
    public Map<String, String> sessionInfo(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray = new Object[]{};
        if (stringArray != null && stringArray.length > 0) {
            objectArray = new Object[]{stringArray};
        }
        String string = "hostControl_getActiveSessions";
        Map<String, Object> map = JSONReMapper.getResponses(this.exec.retrieveJSONObject(new OpsiMethodCall(string, objectArray)));
        for (String string2 : map.keySet()) {
            String string3;
            block7: {
                Object object;
                block5: {
                    block8: {
                        block6: {
                            string3 = nameRequirementTypeNeutral;
                            if (!(map.get(string2) instanceof String)) break block5;
                            object = (String)map.get(string2);
                            string3 = "no response";
                            if (((String)object).indexOf("Opsi timeout") <= -1) break block6;
                            int n = ((String)object).indexOf("(");
                            string3 = n > -1 ? string3 + "   " + ((String)object).substring(n + 1, ((String)object).length() - 1) : string3 + " (opsi timeout)";
                            break block7;
                        }
                        if (((String)object).indexOf(string) <= -1) break block8;
                        string3 = string3 + "  (" + string + " not valid)";
                        break block7;
                    }
                    if (((String)object).indexOf("Name or service not known") <= -1) break block7;
                    string3 = string3 + " (name or service not known)";
                    break block7;
                }
                if (map.get(string2) instanceof List) {
                    object = (List)map.get(string2);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Map<String, Object> map2 = JSONReMapper.getMap_Object((JSONObject)e);
                        String string4 = nameRequirementTypeNeutral + map2.get("UserName");
                        String string5 = nameRequirementTypeNeutral + map2.get("LogonDomain");
                        if (!string3.equals(nameRequirementTypeNeutral)) {
                            string3 = string3 + "; ";
                        }
                        string3 = string3 + string4 + " (" + string5 + "\\" + string4 + ")";
                    }
                }
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    @Override
    public void updateHosts() {
        if (!this.checkPermission()) {
            return;
        }
        if (this.hostUpdates == null) {
            return;
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (String string : this.hostUpdates.keySet()) {
            arrayList.add(this.exec.jsonMap(this.hostUpdates.get(string)));
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("host_updateObjects", new Object[]{arrayList.toArray()});
        if (this.exec.doCall(opsiMethodCall)) {
            this.hostUpdates.clear();
        }
    }

    protected void updateHost(String string, String string2, String string3) {
        Map<String, Object> map;
        if (this.hostUpdates == null) {
            this.hostUpdates = new HashMap<String, Map<String, Object>>();
        }
        if ((map = this.hostUpdates.get(string)) == null) {
            map = new HashMap<String, Object>();
        }
        String string4 = nameRequirementTypeNeutral;
        if (string3 != null) {
            string4 = string3;
        }
        map.put("ident", string);
        map.put("type", "OpsiClient");
        map.put(string2, string3);
        this.hostUpdates.put(string, map);
    }

    @Override
    public void setHostDescription(String string, String string2) {
        this.updateHost(string, "description", string2);
    }

    @Override
    public void setClientInventoryNumber(String string, String string2) {
        this.updateHost(string, "inventoryNumber", string2);
    }

    @Override
    public void setClientOneTimePassword(String string, String string2) {
        this.updateHost(string, "oneTimePassword", string2);
    }

    @Override
    public void setHostNotes(String string, String string2) {
        this.updateHost(string, "notes", string2);
    }

    @Override
    public void setMacAddress(String string, String string2) {
        this.updateHost(string, "hardwareAddress", string2);
    }

    @Override
    public String getMacAddress(String string) {
        return nameRequirementTypeNeutral;
    }

    @Override
    public Map<String, Map<String, String>> getProductGroups() {
        String[] stringArray = new String[]{};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "ProductGroup");
        Map<String, Map<String, String>> map = this.exec.getStringMappedObjectsByKey(new OpsiMethodCall("group_getObjects", new Object[]{stringArray, hashMap}), "ident", new String[]{"id", "parentGroupId", "description"}, new String[]{"groupId", "parentGroupId", "description"});
        return map;
    }

    @Override
    public Map<String, Map<String, String>> getHostGroups() {
        if (this.hostGroups != null) {
            return this.hostGroups;
        }
        String[] stringArray = new String[]{};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "HostGroup");
        this.hostGroups = new HostGroups(this.exec.getStringMappedObjectsByKey(new OpsiMethodCall("group_getObjects", new Object[]{stringArray, hashMap}), "ident", new String[]{"id", "parentGroupId", "description"}, new String[]{"groupId", "parentGroupId", "description"}));
        logging.debug(this, "getHostGroups " + this.hostGroups);
        this.hostGroups = this.hostGroups.addSpecialGroups();
        logging.debug(this, "getHostGroups " + this.hostGroups);
        this.hostGroups.alterToWorkingVersion();
        logging.debug(this, "getHostGroups rebuilt" + this.hostGroups);
        return this.hostGroups;
    }

    @Override
    public void hostGroupsRequestRefresh() {
        this.hostGroups = null;
    }

    @Override
    public void fGroup2MembersRequestRefresh() {
        this.fGroup2Members = null;
    }

    @Override
    public void fProductGroup2MembersRequestRefresh() {
        this.fProductGroup2Members = null;
    }

    private Map<String, Set<String>> projectToFunction(Map<String, Map<String, String>> map, String string, String string2) {
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        for (String string3 : map.keySet()) {
            Map<String, String> map2 = map.get(string3);
            String string4 = map2.get(string);
            String string5 = map2.get(string2);
            if (string5 == null) continue;
            TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(string4);
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
            }
            treeSet.add(string5);
            treeMap.put(string4, treeSet);
        }
        return treeMap;
    }

    @Override
    public Map<String, Set<String>> getFGroup2Members() {
        if (this.fGroup2Members == null) {
            this.fGroup2Members = this.retrieveFGroup2Members("HostGroup", "clientId");
        }
        return this.fGroup2Members;
    }

    @Override
    public Map<String, Set<String>> getFProductGroup2Members() {
        if (this.fProductGroup2Members == null) {
            this.fProductGroup2Members = this.retrieveFGroup2Members("ProductGroup", "productId");
        }
        return this.fProductGroup2Members;
    }

    private Map<String, Set<String>> retrieveFGroup2Members(String string, String string2) {
        String[] stringArray = new String[]{};
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("groupType", string);
        Map<String, Map<String, String>> map = this.exec.getStringMappedObjectsByKey(new OpsiMethodCall("objectToGroup_getObjects", new Object[]{stringArray, hashMap}), "ident", new String[]{"objectId", "groupId"}, new String[]{string2, "groupId"});
        return this.projectToFunction(map, "groupId", string2);
    }

    public void fObject2ProductGroupsRequestRefresh() {
        this.fObject2Groups = null;
    }

    @Override
    public void fObject2GroupsRequestRefresh() {
        this.fObject2Groups = null;
    }

    @Override
    public Map<String, Set<String>> getFObject2Groups() {
        if (this.fObject2Groups == null) {
            Map<String, Map<String, String>> map = this.exec.getStringMappedObjectsByKey(new OpsiMethodCall("objectToGroup_getObjects", new String[0]), "ident", new String[]{"objectId", "groupId"}, new String[]{"clientId", "groupId"}, ClientTree.translationsFromPersistentNames);
            this.fObject2Groups = this.projectToFunction(map, "clientId", "groupId");
        }
        return this.fObject2Groups;
    }

    @Override
    public boolean addObject2Group(String string, String string2) {
        if (!this.checkPermission()) {
            return false;
        }
        String string3 = ClientTree.translateToPersistentName(string2);
        logging.debug(this, "addObject2Group persistentGroupId " + string3);
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("objectToGroup_create", new String[]{"HostGroup", string3, string});
        return this.exec.doCall(opsiMethodCall);
    }

    @Override
    public boolean removeHostGroupElements(List<Object2GroupEntry> list) {
        if (!this.checkPermission()) {
            return false;
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (Object2GroupEntry object : list) {
            Map<String, Object> map = this.createNOMitem("ObjectToGroup");
            map.put("groupType", "HostGroup");
            map.put("groupId", object.getGroupId());
            map.put("objectId", object.getMember());
            arrayList.add(this.exec.jsonMap(map));
        }
        boolean bl = true;
        if (arrayList.size() > 0) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("objectToGroup_deleteObjects", new Object[]{arrayList.toArray()});
            if (this.exec.doCall(opsiMethodCall)) {
                arrayList.clear();
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean removeObject2Group(String string, String string2) {
        if (!this.checkPermission()) {
            return false;
        }
        String string3 = ClientTree.translateToPersistentName(string2);
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("objectToGroup_delete", new String[]{"HostGroup", string3, string});
        return this.exec.doCall(opsiMethodCall);
    }

    @Override
    public boolean addGroup(StringValuedRelationElement stringValuedRelationElement) {
        return this.addGroup(stringValuedRelationElement, true);
    }

    private boolean addGroup(StringValuedRelationElement stringValuedRelationElement, boolean bl) {
        String string;
        if (!this.checkPermission()) {
            return false;
        }
        logging.debug(this, "addGroup : " + stringValuedRelationElement + " requestRefresh " + bl);
        String string2 = (String)stringValuedRelationElement.get("groupId");
        String string3 = (String)stringValuedRelationElement.get("parentGroupId");
        if (string3 == null || string3.equals(ClientTree.GROUPS_NAME)) {
            string3 = null;
        }
        if (string2.equalsIgnoreCase(string3 = ClientTree.translateToPersistentName(string3))) {
            logging.error(this, "Cannot add group as child to itself, group ID " + string2);
            return false;
        }
        String string4 = (String)stringValuedRelationElement.get("description");
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("group_createHostGroup", new Object[]{string2, string4, string = nameRequirementTypeNeutral, string3});
        boolean bl2 = this.exec.doCall(opsiMethodCall);
        if (bl2) {
            this.hostGroupsRequestRefresh();
        }
        return bl2;
    }

    @Override
    public boolean deleteGroup(String string) {
        if (!this.checkPermission()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("group_delete", new String[]{string});
        boolean bl = this.exec.doCall(opsiMethodCall);
        if (bl) {
            this.hostGroupsRequestRefresh();
        }
        return bl;
    }

    @Override
    public boolean updateGroup(String string, Map<String, String> map) {
        if (!this.checkPermission()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("ident", string);
        map.put("type", "HostGroup");
        if (map.get("parentGroupId").equals(ClientTree.GROUPS_NAME)) {
            map.put("parentGroupId", "null");
        }
        String string2 = map.get("parentGroupId");
        string2 = ClientTree.translateToPersistentName(string2);
        map.put("parentGroupId", string2);
        logging.debug(this, "updateGroup " + string2);
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("group_updateObject", new Object[]{this.exec.jsonMap(map)});
        return this.exec.doCall(opsiMethodCall);
    }

    @Override
    public boolean setProductGroup(String string, String string2, Set<String> set) {
        Object object;
        HashMap<String, String> hashMap;
        Object object2;
        if (!this.checkPermission()) {
            return false;
        }
        logging.debug(this, "setProductGroup: groupId " + string);
        if (string == null) {
            return false;
        }
        boolean bl = true;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("id", string);
        hashMap2.put("type", "ProductGroup");
        if (string2 != null) {
            hashMap2.put("description", string2);
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("group_createObjects", new Object[]{new Object[]{this.exec.jsonMap(hashMap2)}});
        bl = this.exec.doCall(opsiMethodCall);
        HashSet<String> hashSet = new HashSet<String>(set);
        HashSet hashSet2 = new HashSet();
        if (string != null && this.getFProductGroup2Members().get(string) != null) {
            object2 = this.getFProductGroup2Members().get(string);
            logging.debug(this, "setProductGroup: oriSet " + object2);
            hashSet2 = new HashSet(object2);
            hashSet2.removeAll(set);
            hashSet.removeAll((Collection<?>)object2);
        }
        logging.debug(this, "setProductGroup: inOriSetnotInNewSet, inNewSetnotInOriSet. " + hashSet2 + ", " + hashSet);
        object2 = new HashMap();
        object2.put("groupType", "ProductGroup");
        object2.put("type", "ObjectToGroup");
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (String string3 : hashSet2) {
            hashMap = new HashMap<String, String>((Map<String, String>)object2);
            hashMap.put("groupId", string);
            hashMap.put("objectId", string3);
            arrayList.add(this.exec.jsonMap(hashMap));
        }
        logging.debug(this, "delete objects " + arrayList);
        if (arrayList.size() > 0) {
            object = this.exec.jsonArray(arrayList);
            bl = bl && this.exec.doCall(new OpsiMethodCall("objectToGroup_deleteObjects", new Object[]{object}));
        }
        arrayList.clear();
        for (String string3 : hashSet) {
            hashMap = new HashMap(object2);
            hashMap.put("groupId", string);
            hashMap.put("objectId", string3);
            arrayList.add(this.exec.jsonMap(hashMap));
        }
        logging.debug(this, "create new objects " + arrayList);
        if (arrayList.size() > 0) {
            object = this.exec.jsonArray(arrayList);
            boolean bl2 = bl = bl && this.exec.doCall(new OpsiMethodCall("objectToGroup_createObjects", new Object[]{object}));
        }
        if (bl) {
            this.getFProductGroup2Members().put(string, set);
        }
        return bl;
    }

    @Override
    public List<String> getHostGroupIds() {
        Set<String> set = this.getHostGroups().keySet();
        set.remove(ClientTree.DIRECTORY_NAME);
        return new ArrayList<String>(new TreeSet<String>(set));
    }

    @Override
    public boolean existsEntry(String string) {
        if (this.hostInfoCollections.getMapOfPCs() == null) {
            return false;
        }
        return this.hostInfoCollections.getMapOfPCs().containsKey(string);
    }

    @Override
    public void hwAuditConfRequestRefresh() {
        this.hwAuditConf.clear();
    }

    @Override
    public List<Object> getOpsiHWAuditConf(String string) {
        if (!this.hwAuditConf.containsKey(string)) {
            this.hwAuditConf.put(string, this.exec.getListOfMapsOfListsOfMaps(new OpsiMethodCall("getOpsiHWAuditConf", new String[]{string})));
        }
        return this.hwAuditConf.get(string);
    }

    @Override
    public Map getSoftwareInfo(String string) {
        return null;
    }

    @Override
    public void softwareAuditOnClientsRequestRefresh() {
        logging.info(this, "softwareAuditOnClientsRequestRefresh");
        this.dataStub.softwareAuditOnClientsRequestRefresh();
    }

    @Override
    public void fillClient2Software(List<String> list) {
        this.dataStub.fillClient2Software(list);
    }

    @Override
    public Map<String, List<SWAuditClientEntry>> getClient2Software() {
        return this.dataStub.getClient2Software();
    }

    @Override
    public DatedRowList getSoftwareAudit(String string) {
        this.dataStub.fillClient2Software(string);
        List<SWAuditClientEntry> list = this.dataStub.getClient2Software().get(string);
        if (list == null) {
            return null;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string2 = null;
        if (list.size() > 0) {
            string2 = list.get(0).getLastModification();
        }
        for (SWAuditClientEntry sWAuditClientEntry : list) {
            if (sWAuditClientEntry.getSWid() == null) continue;
            arrayList.add(sWAuditClientEntry.getExpandedData(this.getInstalledSoftwareInformation(), this.getSWident(sWAuditClientEntry.getSWid())));
        }
        logging.info(this, "getSoftwareAudit for client " + string);
        return new DatedRowList(arrayList, string2);
    }

    @Override
    public String getLastSoftwareAuditModification(String string) {
        String string2 = nameRequirementTypeNeutral;
        if (string != null && !string.equals(nameRequirementTypeNeutral) && this.dataStub.getClient2Software() != null && this.dataStub.getClient2Software().get(string) != null && this.dataStub.getClient2Software().get(string).size() > 0) {
            string2 = this.dataStub.getClient2Software().get(string).get(0).getLastModification();
        }
        return string2;
    }

    @Override
    public Map<String, Map> retrieveSoftwareAuditData(String string) {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        if (string == null || string.equals(nameRequirementTypeNeutral)) {
            return treeMap;
        }
        this.dataStub.fillClient2Software(string);
        List<SWAuditClientEntry> list = this.dataStub.getClient2Software().get(string);
        if (list == null) {
            return treeMap;
        }
        for (SWAuditClientEntry sWAuditClientEntry : list) {
            if (sWAuditClientEntry.getSWid() == null) continue;
            treeMap.put(nameRequirementTypeNeutral + sWAuditClientEntry.getSWid(), sWAuditClientEntry.getExpandedMap(this.getInstalledSoftwareInformation(), this.getSWident(sWAuditClientEntry.getSWid())));
        }
        return treeMap;
    }

    @Override
    public Object getHardwareInfo(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Map map = this.exec.getMapOfListsOfMaps(new OpsiMethodCall("getHardwareInformation_hash", new String[]{string}));
        if (map.size() > 1) {
            return map;
        }
        return null;
    }

    @Override
    public void auditHardwareOnHostRequestRefresh() {
        this.relations_auditHardwareOnHost = null;
    }

    @Override
    public List<Map<String, Object>> getHardwareOnClient() {
        if (this.relations_auditHardwareOnHost == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("state", "1");
            this.relations_auditHardwareOnHost = this.exec.getListOfMaps(new OpsiMethodCall("auditHardwareOnHost_getHashes", new Object[]{new String[0], hashMap}));
        }
        return this.relations_auditHardwareOnHost;
    }

    @Override
    public String[] getLogtypes() {
        if (this.logtypes == null) {
            this.logtypes = de.uib.configed.Globals.logtypes;
        }
        return this.logtypes;
    }

    @Override
    public Map<String, String> getEmptyLogfiles() {
        this.logfiles = new HashMap<String, String>();
        String[] stringArray = this.getLogtypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.logfiles.put(stringArray[i], nameRequirementTypeNeutral);
        }
        return this.logfiles;
    }

    @Override
    public Map<String, String> getLogfiles(String string, String string2) {
        int n;
        String[] stringArray = this.getLogtypes();
        if (this.logfiles == null) {
            this.getEmptyLogfiles();
        }
        if ((n = Arrays.asList(de.uib.configed.Globals.logtypes).indexOf(string2)) < 0) {
            logging.error("illegal logtype: " + string2);
            return this.logfiles;
        }
        logging.debug(this, "------------- getLogfile logtye " + string2);
        String string3 = nameRequirementTypeNeutral;
        try {
            logging.debug(this, "OpsiMethodCall readLog " + stringArray[n] + " max size " + de.uib.configed.Globals.maxLogSizes[n]);
            try {
                string3 = de.uib.configed.Globals.maxLogSizes[n] == 0 ? this.exec.getStringResult(new OpsiMethodCall("readLog", new String[]{string2, string})) : this.exec.getStringResult(new OpsiMethodCall("readLog", new String[]{string2, string, String.valueOf(de.uib.configed.Globals.maxLogSizes[n])}));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                string3 = "--- file too big for showing, enlarge java memory  ---";
                System.gc();
            }
            logging.injectLogLevel(null);
        }
        catch (Exception exception) {
            string3 = "not found, " + exception;
        }
        this.logfiles.put(string2, string3);
        return this.logfiles;
    }

    @Override
    public Map<String, String> getLogfiles(String string) {
        this.logfiles = new HashMap<String, String>();
        String[] stringArray = this.getLogtypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.getLogfiles(string, stringArray[i]);
        }
        return this.logfiles;
    }

    @Override
    public void depotChange() {
        logging.info(this, "depotChange");
        this.productGlobalInfos = null;
        this.possibleActions = null;
        this.saveDepotId = null;
        this.productIds = null;
        this.netbootProductNames = null;
        this.localbootProductNames = null;
        this.retrieveProducts();
        this.retrieveProductPropertyDefinitions();
        this.getProductGlobalInfos(this.theDepot);
    }

    @Override
    public void productDataRequestRefresh() {
        this.dataStub.productDataRequestRefresh();
        this.productpropertiesRequestRefresh();
        this.depot2product2properties = null;
        this.depotChange();
    }

    @Override
    public List<String> getAllLocalbootProductNames(String string) {
        logging.debug(this, "getAllLocalbootProductNames for depot " + string);
        logging.info(this, "getAllLocalbootProductNames, producing " + (this.localbootProductNames == null));
        if (this.localbootProductNames == null) {
            ArrayList arrayList;
            Map map = this.exec.getMapOfLists(new OpsiMethodCall("getProductOrdering", new String[]{string}));
            ArrayList<String> arrayList2 = (ArrayList<String>)map.get("sorted");
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<String>();
            }
            if ((arrayList = (ArrayList)map.get("not_sorted")) == null) {
                arrayList = new ArrayList();
            }
            logging.info(this, "not ordered " + (arrayList.size() - arrayList2.size()) + nameRequirementTypeNeutral);
            arrayList.removeAll(arrayList2);
            logging.info(this, "missing: " + arrayList);
            this.localbootProductNames = arrayList2;
            this.localbootProductNames.addAll(arrayList);
        }
        logging.info(this, "localbootProductNames sorted: " + this.localbootProductNames);
        return this.localbootProductNames;
    }

    @Override
    public List<String> getAllLocalbootProductNames() {
        return this.getAllLocalbootProductNames(this.theDepot);
    }

    @Override
    public void retrieveProducts() {
        this.retrieveDepotProducts(this.theDepot);
    }

    protected void retrieveDepotProducts(String string) {
        logging.debug(this, "retrieveDepotProducts for " + string);
        this.netbootProductNames = this.dataStub.getDepot2NetbootProducts().get(string) != null ? new ArrayList(((Product2VersionList)this.dataStub.getDepot2NetbootProducts().get(string)).keySet()) : new ArrayList<String>();
        this.localbootProductNames = this.getAllLocalbootProductNames(string);
    }

    @Override
    public List<String> getAllDepotsWithIdenticalProductStock(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<OpsiPackage> treeSet = this.dataStub.getDepot2Packages().get(string);
        logging.info(this, "getAllDepotsWithIdenticalProductStock " + treeSet);
        for (String string2 : this.getHostInfoCollections().getAllDepots().keySet()) {
            if (!string.equals(string2) && (treeSet != null || this.dataStub.getDepot2Packages().get(string2) != null) && (treeSet == null || !treeSet.equals(this.dataStub.getDepot2Packages().get(string2)))) continue;
            arrayList.add(string2);
        }
        logging.info(this, "getAllDepotsWithIdenticalProductStock  result " + arrayList);
        return arrayList;
    }

    @Override
    public List<String> getAllNetbootProductNames(String string) {
        if (this.netbootProductNames == null) {
            this.retrieveDepotProducts(string);
        }
        return this.netbootProductNames;
    }

    @Override
    public List<String> getAllNetbootProductNames() {
        return this.getAllNetbootProductNames(this.theDepot);
    }

    @Override
    public Vector<String> getWinProducts(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        if (string2 == null) {
            return vector;
        }
        boolean bl = new File(string2).exists();
        for (String string3 : new TreeSet<String>(this.getAllNetbootProductNames(string))) {
            if (bl && !new File(string2 + File.separator + string3 + File.separator + "winpe").exists() && !new File(string2 + File.separator + string3 + File.separator + "i386").exists()) continue;
            vector.add(string3);
        }
        return vector;
    }

    @Override
    public Map<String, Map<String, OpsiProductInfo>> getProduct2versionInfo2infos() {
        return this.dataStub.getProduct2versionInfo2infos();
    }

    private void retrieveProductGlobalInfos(String string) {
        logging.info(this, "retrieveProductGlobalInfos , depot " + string);
        this.productGlobalInfos = new HashMap<String, Map<String, Object>>();
        this.possibleActions = new HashMap<String, List<String>>();
        for (String string2 : this.dataStub.getProduct2versionInfo2infos().keySet()) {
            if (this.dataStub.getProduct2versionInfo2infos().get(string2) == null) continue;
            String string3 = null;
            Map<String, OpsiProductInfo> map = this.dataStub.getProduct2versionInfo2infos().get(string2);
            Product2VersionList product2VersionList = (Product2VersionList)this.dataStub.getDepot2LocalbootProducts().get(string);
            if (product2VersionList != null && product2VersionList.get(string2) != null && ((List)product2VersionList.get(string2)).size() > 0) {
                string3 = (String)((List)product2VersionList.get(string2)).get(0);
            }
            if (string3 == null && (product2VersionList = (Product2VersionList)this.dataStub.getDepot2NetbootProducts().get(string)) != null && product2VersionList.get(string2) != null && ((List)product2VersionList.get(string2)).size() > 0) {
                string3 = (String)((List)product2VersionList.get(string2)).get(0);
            }
            if (string3 == null || map.get(string3) == null) continue;
            OpsiProductInfo opsiProductInfo = map.get(string3);
            this.possibleActions.put(string2, opsiProductInfo.getPossibleActions());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("actions", opsiProductInfo.getPossibleActions());
            hashMap.put("productId", opsiProductInfo.getProductId());
            hashMap.put("versionInfo", Globals.ProductPackageVersionSeparator.formatKeyForDisplay(opsiProductInfo.getVersionInfo()));
            hashMap.put("priority", opsiProductInfo.getPriority());
            hashMap.put("productName", opsiProductInfo.getProductName());
            hashMap.put("description", opsiProductInfo.getDescription());
            hashMap.put("advice", opsiProductInfo.getAdvice());
            hashMap.put("productVersion", opsiProductInfo.getProductVersion());
            hashMap.put("packageVersion", opsiProductInfo.getPackageVersion());
            this.productGlobalInfos.put(string2, hashMap);
        }
    }

    private void checkProductGlobalInfos(String string) {
        logging.debug(this, "checkProductGlobalInfos depotId " + string + " productGlobaInfos  = null " + (this.productGlobalInfos == null) + " possibleActions = null " + (this.possibleActions == null));
        if (this.possibleActions == null || this.productGlobalInfos == null || this.theDepot == null || !this.theDepot.equals(string)) {
            this.retrieveProductGlobalInfos(string);
        }
    }

    @Override
    public Map<String, List<String>> getPossibleActions(String string) {
        this.checkProductGlobalInfos(string);
        return this.possibleActions;
    }

    @Override
    public Map getMapOfProductStatesAndActions(String[] stringArray) {
        logging.debug(this, "getMapOfProductStatesAndActions for : " + logging.getStrings(stringArray));
        HashMap hashMap = new HashMap();
        if (stringArray == null || stringArray.length == 0) {
            return hashMap;
        }
        Map<String, List<Map<String, String>>> map = this.getProductStatesNOM(stringArray);
        if (map != null) {
            return map;
        }
        return hashMap;
    }

    private Map<String, List<Map<String, String>>> getLocalBootProductStates(String[] stringArray, Map<String, List<Map<String, String>>> map) {
        Map<String, List<Map<String, String>>> map2 = this.getLocalBootProductStatesNOM(stringArray);
        return map2;
    }

    protected Map<String, List<Map<String, String>>> getProductStatesNOM(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", "ProductOnClient");
        hashMap.put("clientId", this.exec.jsonArray(Arrays.asList(stringArray)));
        List<Map<String, Object>> list = this.exec.getListOfMaps(new OpsiMethodCall("productOnClient_getHashes", new Object[]{stringArray2, hashMap}));
        HashMap<String, List<Map<String, String>>> hashMap2 = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, Object> map : list) {
            String string = (String)map.get("clientId");
            ArrayList<ProductState> arrayList = (ArrayList<ProductState>)hashMap2.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ProductState>();
                hashMap2.put(string, arrayList);
            }
            arrayList.add(new ProductState(JSONReMapper.giveEmptyForNull(map), true));
        }
        return hashMap2;
    }

    protected Map<String, List<Map<String, String>>> getLocalBootProductStatesNOM(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", "ProductOnClient");
        hashMap.put("clientId", this.exec.jsonArray(Arrays.asList(stringArray)));
        hashMap.put("productType", "LocalbootProduct");
        List<Map<String, Object>> list = this.exec.getListOfMaps(new OpsiMethodCall("productOnClient_getHashes", new Object[]{stringArray2, hashMap}));
        HashMap<String, List<Map<String, String>>> hashMap2 = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, Object> map : list) {
            String string = (String)map.get("clientId");
            ArrayList<ProductState> arrayList = (ArrayList<ProductState>)hashMap2.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ProductState>();
                hashMap2.put(string, arrayList);
            }
            ProductState productState = new ProductState(JSONReMapper.giveEmptyForNull(map), true);
            arrayList.add(productState);
        }
        return hashMap2;
    }

    @Override
    public Map getMapOfLocalbootProductStatesAndActions(String[] stringArray) {
        return this.getMapOfLocalbootProductStatesAndActions(stringArray, null);
    }

    @Override
    public Map getMapOfLocalbootProductStatesAndActions(String[] stringArray, Map map) {
        logging.debug(this, "getMapOfLocalbootProductStatesAndActions for : " + logging.getStrings(stringArray));
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashMap hashMap = new HashMap();
        Map<String, List<Map<String, String>>> map2 = null;
        map2 = this.getLocalBootProductStates(stringArray, map);
        if (map2 != null) {
            return map2;
        }
        return hashMap;
    }

    protected Map<String, List<Map<String, String>>> getNetBootProductStatesNOM(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", "ProductOnClient");
        hashMap.put("clientId", this.exec.jsonArray(Arrays.asList(stringArray)));
        hashMap.put("productType", "NetbootProduct");
        List<Map<String, Object>> list = this.exec.getListOfMaps(new OpsiMethodCall("productOnClient_getHashes", new Object[]{stringArray2, hashMap}));
        HashMap<String, List<Map<String, String>>> hashMap2 = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, Object> map : list) {
            String string = (String)map.get("clientId");
            ArrayList<ProductState> arrayList = (ArrayList<ProductState>)hashMap2.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ProductState>();
                hashMap2.put(string, arrayList);
            }
            arrayList.add(new ProductState(JSONReMapper.giveEmptyForNull(map), true));
        }
        return hashMap2;
    }

    @Override
    public Map getMapOfNetbootProductStatesAndActions(String[] stringArray) {
        logging.debug(this, "getMapOfNetbootProductStatesAndActions for : " + logging.getStrings(stringArray));
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashMap hashMap = new HashMap();
        Map<String, List<Map<String, String>>> map = this.getNetBootProductStatesNOM(stringArray);
        if (map != null) {
            return map;
        }
        return hashMap;
    }

    protected boolean updateProductOnClient(String string, String string2, int n, Map map, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("productType", OpsiPackage.giveProductType(n));
        hashMap.put("type", "ProductOnClient");
        hashMap.put("clientId", string);
        hashMap.put("productId", string2);
        hashMap.putAll(map);
        logging.debug(this, "updateProductOnClient, values " + hashMap);
        list.add(this.exec.jsonMap(hashMap));
        return true;
    }

    @Override
    public boolean updateProductOnClient(String string, String string2, int n, Map map) {
        if (this.updateProductOnClient_items == null) {
            this.updateProductOnClient_items = new ArrayList();
        }
        return this.updateProductOnClient(string, string2, n, map, this.updateProductOnClient_items);
    }

    public boolean updateProductOnClients(List list) {
        OpsiMethodCall opsiMethodCall;
        if (!this.checkPermission()) {
            return false;
        }
        logging.debug(this, "updateProductOnClients");
        boolean bl = false;
        if (list != null && list.size() > 0 && (bl = this.exec.doCall(opsiMethodCall = new OpsiMethodCall("productOnClient_updateObjects", new Object[]{this.exec.jsonArray(list)})))) {
            list.clear();
        }
        return bl;
    }

    @Override
    public boolean updateProductOnClients() {
        return this.updateProductOnClients(this.updateProductOnClient_items);
    }

    @Override
    public boolean updateProductOnClients(Set<String> set, String string, int n, Map<String, String> map) {
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        for (String string2 : set) {
            bl = bl && this.updateProductOnClient(string2, string, n, map, arrayList);
        }
        return bl && this.updateProductOnClients(arrayList);
    }

    public boolean freeAllPossibleLicences(String[] stringArray) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            Map<String, Object> map = this.createNOMitem("LicenseOnClient");
        }
        return bl;
    }

    @Override
    public boolean resetLocalbootProducts(String[] stringArray) {
        Object object;
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = true;
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> arrayList2 = new ArrayList<JSONObject>();
        for (String string : this.localbootProductNames) {
            for (int i = 0; i < stringArray.length; ++i) {
                Map<String, Object> map = this.createNOMitem("ProductOnClient");
                map.put("productType", "LocalbootProduct");
                map.put("clientId", stringArray[i]);
                map.put("productId", string);
                arrayList.add(this.exec.jsonMap(map));
                Map<String, Object> map2 = this.createNOMitem("ProductPropertyState");
                if (this.getProductproperties(stringArray[i], string) == null) continue;
                for (String string2 : this.getProductproperties(stringArray[i], string).keySet()) {
                    map2.put("objectId", stringArray[i]);
                    map2.put("productId", string);
                    map2.put("propertyId", string2);
                    arrayList2.add(this.exec.jsonMap(map2));
                }
            }
        }
        logging.debug(this, "resetLocalbootProducts deleteProductItems.size " + arrayList.size());
        if (arrayList.size() > 0) {
            logging.injectLogLevel(6);
            object = new OpsiMethodCall("productOnClient_deleteObjects", new Object[]{arrayList.toArray()});
            bl = this.exec.doCall((OpsiMethodCall)object);
            logging.injectLogLevel(null);
        }
        logging.debug(this, "resetLocalbootProducts result " + bl);
        logging.debug(this, "resetLocalbootProducts deletePropertyItems.size " + arrayList2.size());
        if (bl && arrayList2.size() > 0) {
            logging.injectLogLevel(6);
            object = new OpsiMethodCall("productPropertyState_deleteObjects", new Object[]{arrayList2.toArray()});
            bl = this.exec.doCall((OpsiMethodCall)object);
            logging.injectLogLevel(null);
        }
        logging.debug(this, "resetLocalbootProducts result " + bl);
        return bl;
    }

    @Override
    public void retrieveProductDependencies() {
        this.dataStub.getDepot2product2dependencyInfos();
    }

    @Override
    public Map<String, Map<String, Object>> getProductGlobalInfos(String string) {
        this.checkProductGlobalInfos(string);
        return this.productGlobalInfos;
    }

    public Map<String, Object> getProductInfos(String string) {
        this.checkProductGlobalInfos(this.theDepot);
        return this.productGlobalInfos.get(string);
    }

    @Override
    public Map<String, Map<String, String>> getProductDefaultStates() {
        if (this.productIds == null) {
            this.getProductIds();
        }
        logging.debug(this, "getProductDefaultStates, count " + this.productDefaultStates.size());
        return this.productDefaultStates;
    }

    @Override
    public Vector<Vector<Object>> getProductRows() {
        return this.dataStub.getProductRows();
    }

    @Override
    public Map<String, Map<String, List<String>>> getProduct2VersionInfo2Depots() {
        return this.dataStub.getProduct2VersionInfo2Depots();
    }

    @Override
    public TreeSet<String> getProductIds() {
        this.dataStub.getProduct2versionInfo2infos();
        if (this.productIds == null) {
            this.productIds = new TreeSet();
            this.productDefaultStates = new TreeMap<String, Map<String, String>>();
            for (String string : this.dataStub.getProduct2versionInfo2infos().keySet()) {
                this.productIds.add(string);
                ProductState productState = new ProductState(null);
                productState.put("productId", string);
                this.productDefaultStates.put(string, productState);
            }
            logging.debug(this, "getProductIds " + this.productIds);
        }
        return this.productIds;
    }

    private List<Map<String, String>> getProductDependencies(String string, String string2) {
        ArrayList<Map<String, String>> arrayList = null;
        if (this.dataStub.getDepot2product2dependencyInfos().get(string) != null) {
            arrayList = this.dataStub.getDepot2product2dependencyInfos().get(string).get(string2);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        logging.debug(this, "getProductDependencies for depot, product " + string + ", " + string2 + " , result " + arrayList);
        return arrayList;
    }

    private boolean generateIfNull3(Map<String, Map<String, Map<String, Object>>> map) {
        if (map == null) {
            map = new HashMap<String, Map<String, Map<String, Object>>>();
            return true;
        }
        return false;
    }

    private boolean generateIfNull2(Map<String, Map<String, Object>> map) {
        if (map == null) {
            map = new HashMap<String, Map<String, Object>>();
            return true;
        }
        return false;
    }

    private boolean generateIfNull1(Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
            return true;
        }
        return false;
    }

    protected Set<String> getProductsHavingSpecificProperties() {
        return this.productsHavingSpecificProperties;
    }

    @Override
    public Boolean hasClientSpecificProperties(String string) {
        return this.productHavingClientSpecificProperties.get(string);
    }

    @Override
    public Map<String, Boolean> getProductHavingClientSpecificProperties() {
        return this.productHavingClientSpecificProperties;
    }

    List<Map<String, Object>> retrieveListOfMapsNOM(String string) {
        String[] stringArray = new String[]{};
        HashMap hashMap = new HashMap();
        return this.retrieveListOfMapsNOM(stringArray, hashMap, string);
    }

    List<Map<String, Object>> retrieveListOfMapsNOM(String[] stringArray, HashMap hashMap, String string) {
        List<Map<String, Object>> list = this.exec.getListOfMaps(new OpsiMethodCall(string, new Object[]{stringArray, hashMap}));
        logging.injectLogLevel(6);
        logging.debug(this, "retrieveListOfMapsNOM " + list);
        logging.injectLogLevel(null);
        return list;
    }

    @Override
    public List<String> getCommonProductPropertyValues(List<String> list, String string, String string2) {
        logging.info(this, "getCommonProductPropertyValues for product, property, clients " + string + ", " + string2 + "  -- " + list);
        String[] stringArray = new String[]{};
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("objectId", this.exec.jsonArray(list));
        hashMap.put("productId", string);
        hashMap.put("propertyId", string2);
        List<Map<String, Object>> list2 = this.retrieveListOfMapsNOM(stringArray, hashMap, "productPropertyState_getObjects");
        HashSet hashSet = new HashSet();
        boolean bl = true;
        for (Map<String, Object> map : list2) {
            Object object = map.get("objectId");
            ArrayList arrayList = ((JSONArray)map.get("values")).toList();
            List list3 = arrayList;
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < list3.size(); ++i) {
                hashSet2.add((String)list3.get(i));
            }
            if (bl) {
                hashSet = hashSet2;
                bl = false;
                continue;
            }
            hashSet.retainAll(hashSet2);
        }
        logging.info(this, "getCommonProductPropertyValues " + hashSet);
        return new ArrayList<String>(hashSet);
    }

    @Override
    public void retrieveProductproperties(List<String> list) {
        this.retrieveProductproperties(new HashSet<String>(list));
    }

    @Override
    public Map<String, Map<String, ConfigName2ConfigValue>> getDepot2product2properties() {
        this.retrieveDepotProductProperties();
        return this.depot2product2properties;
    }

    @Override
    public Map<String, ConfigName2ConfigValue> getDefaultProductProperties(String string) {
        logging.debug(this, "getDefaultProductProperties for depot " + string);
        this.retrieveDepotProductProperties();
        if (this.depot2product2properties == null) {
            logging.error("no product properties ");
            return null;
        }
        if (this.depot2product2properties.get(string) == null) {
            return new HashMap<String, ConfigName2ConfigValue>();
        }
        if (this.depot2product2properties.get(string).size() > 0) {
            logging.info(this, "getDefaultProductProperties for depotId " + string + " starts with " + new ArrayList<String>(this.depot2product2properties.get(string).keySet()).get(0));
        }
        return this.depot2product2properties.get(string);
    }

    @Override
    public void retrieveDepotProductProperties() {
        if (this.depot2product2properties != null) {
            return;
        }
        logging.info(this, "retrieveDepotProductProperties, build depot2product2properties");
        this.depot2product2properties = new HashMap<String, Map<String, ConfigName2ConfigValue>>();
        List<Map<String, Object>> list = this.dataStub.getProductPropertyDepotStates(this.hostInfoCollections.getDepots().keySet());
        for (Map<String, Object> map : list) {
            ConfigName2ConfigValue configName2ConfigValue;
            String string = (String)map.get("objectId");
            if (!this.hostInfoCollections.getDepots().keySet().contains(string)) {
                logging.warning(this, "should be a productPropertyState for a depot, but host " + string);
                continue;
            }
            Map<String, ConfigName2ConfigValue> map2 = this.depot2product2properties.get(string);
            if (map2 == null) {
                map2 = new HashMap<String, ConfigName2ConfigValue>();
                this.depot2product2properties.put(string, map2);
            }
            if ((configName2ConfigValue = map2.get(map.get("productId"))) == null) {
                configName2ConfigValue = new ConfigName2ConfigValue((Map<String, Object>)new HashMap<String, Object>());
                map2.put((String)map.get("productId"), configName2ConfigValue);
            }
            configName2ConfigValue.put((String)map.get("propertyId"), ((JSONArray)map.get("values")).toList());
            configName2ConfigValue.getRetrieved().put((String)map.get("propertyId"), ((JSONArray)map.get("values")).toList());
            logging.debug(this, "retrieveDepotProductProperties product properties " + map.get("productId"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void retrieveProductproperties(Set<String> set) {
        ConfigName2ConfigValue configName2ConfigValue;
        Object object;
        Object object22;
        Iterator iterator;
        ConfigName2ConfigValue configName2ConfigValue22;
        boolean bl = true;
        if (this.productproperties == null) {
            bl = false;
        } else {
            for (String object32 : set) {
                if (this.productproperties.get(object32) != null) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return;
        }
        this.productproperties = new HashMap<String, Map<String, ConfigName2ConfigValue>>();
        HashMap hashMap = new HashMap();
        this.dataStub.fillProductPropertyStates(set);
        List<Map<String, Object>> list = this.dataStub.getProductPropertyStates();
        HashSet<String> hashSet = new HashSet<String>();
        for (ConfigName2ConfigValue configName2ConfigValue22 : list) {
            void var10_11;
            Map map;
            iterator = (String)configName2ConfigValue22.get("objectId");
            hashSet.add((String)configName2ConfigValue22.get("productId"));
            object22 = (HashMap)hashMap.get(iterator);
            if (object22 == null) {
                object22 = new HashMap();
                hashMap.put(iterator, object22);
            }
            if ((map = (Map)object22.get(configName2ConfigValue22.get("productId"))) == null) {
                HashMap hashMap2 = new HashMap();
                object22.put((String)configName2ConfigValue22.get("productId"), hashMap2);
            }
            var10_11.put((String)configName2ConfigValue22.get("propertyId"), ((JSONArray)configName2ConfigValue22.get("values")).toList());
        }
        logging.info(this, " retrieveProductproperties  productsWithProductPropertyStates " + hashSet);
        Map<String, ConfigName2ConfigValue> map = this.getDefaultProductProperties(this.theDepot);
        configName2ConfigValue22 = new HashMap<String, Object>();
        if (map != null) {
            for (Object object22 : map.keySet()) {
                configName2ConfigValue22.put(object22, map.get(object22));
            }
        }
        iterator = configName2ConfigValue22.keySet();
        this.productsHavingSpecificProperties = new TreeSet(iterator);
        for (String string : set) {
            object = new HashMap();
            this.productproperties.put(string, (Map<String, ConfigName2ConfigValue>)object);
            configName2ConfigValue = (ConfigName2ConfigValue)hashMap.get(string);
            if (configName2ConfigValue == null) {
                configName2ConfigValue = configName2ConfigValue22;
                this.productsHavingSpecificProperties.clear();
            }
            Iterator<Object> iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Map map2 = (Map)configName2ConfigValue.get(string2);
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>((Map)configName2ConfigValue22.get(string2));
                if (map2 == null) {
                    this.productsHavingSpecificProperties.remove(string2);
                } else {
                    for (String string3 : map2.keySet()) {
                        hashMap3.put(string3, map2.get(string3));
                    }
                }
                ConfigName2ConfigValue configName2ConfigValue3 = new ConfigName2ConfigValue(hashMap3, null);
                ((HashMap)object).put(string2, configName2ConfigValue3);
            }
        }
        logging.info(this, " retrieveProductproperties productsHavingSpecificProperties " + this.productsHavingSpecificProperties);
        object22 = this.getDefaultProductProperties(this.theDepot);
        Iterator iterator3 = iterator.iterator();
        while (iterator3.hasNext()) {
            object = (String)iterator3.next();
            if (this.productPropertyDefinitions == null || this.productPropertyDefinitions.get(object) == null) continue;
            configName2ConfigValue = (ConfigName2ConfigValue)object22.get(object);
            for (String string2 : this.productPropertyDefinitions.get(object).keySet()) {
                if (configName2ConfigValue == null || configName2ConfigValue.get(string2) == null) {
                    this.productPropertyDefinitions.get(object).get(string2).setDefaultValues(new ArrayList());
                    continue;
                }
                this.productPropertyDefinitions.get(object).get(string2).setDefaultValues((List)configName2ConfigValue.get(string2));
            }
        }
        this.productHavingClientSpecificProperties = new HashMap<String, Boolean>();
        Iterator iterator4 = iterator.iterator();
        while (iterator4.hasNext()) {
            object = (String)iterator4.next();
            this.productHavingClientSpecificProperties.put((String)object, this.productsHavingSpecificProperties.contains(object));
        }
    }

    @Override
    public Map<String, Object> getProductproperties(String string, String string2) {
        logging.debug(this, "getProductProperties for product, host " + string2 + ", " + string);
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(string);
        this.retrieveProductproperties(treeSet);
        if (this.productproperties.get(string) == null || this.productproperties.get(string).get(string2) == null) {
            return new HashMap<String, Object>();
        }
        logging.info(this, "getProductProperties ");
        return this.productproperties.get(string).get(string2);
    }

    public void setProductproperties(String string, String string2, Map map, List list, List list2) {
        if (!(map instanceof ConfigName2ConfigValue)) {
            logging.warning(this, "! properties instanceof de.uib.configed.type.ConfigName2ConfigValue ");
            return;
        }
        Iterator iterator = map.keySet().iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            hashMap.put("type", "ProductPropertyState");
            hashMap.put("objectId", string);
            hashMap.put("productId", string2);
            hashMap.put("propertyId", string3);
            List list3 = (List)map.get(string3);
            Map<String, Object> map2 = ((RetrievedMap)map).getRetrieved();
            Object object = null;
            if (map2 != null) {
                object = map2.get(string3);
            }
            if (list3 == object) continue;
            if (list3 == MapTableModel.nullLIST) {
                logging.debug(this, "setProductProperties,  requested deletion " + (List)map.get(string3));
                list2.add(this.exec.jsonMap(hashMap));
                if (map2 == null) continue;
                map2.remove(string3);
                continue;
            }
            hashMap.put("values", this.exec.jsonArray(list3));
            logging.debug(this, "setProductProperties,  requested update " + (List)map.get(string3) + " for oldValue " + object);
            logging.debug(this, "setProductProperties,  we have new state " + hashMap);
            list.add(this.exec.jsonMap(hashMap));
            if (map2 == null) continue;
            map2.put(string3, (List)map.get(string3));
        }
    }

    @Override
    public void setProductproperties(String string, String string2, Map map) {
        if (this.productPropertyStateUpdateCollection == null) {
            this.productPropertyStateUpdateCollection = new ArrayList();
        }
        if (this.productPropertyStateDeleteCollection == null) {
            this.productPropertyStateDeleteCollection = new ArrayList();
        }
        this.setProductproperties(string, string2, map, this.productPropertyStateUpdateCollection, this.productPropertyStateDeleteCollection);
    }

    @Override
    public void setProductproperties() {
        this.setProductproperties(this.productPropertyStateUpdateCollection, this.productPropertyStateDeleteCollection);
    }

    public void setProductproperties(List list, List list2) {
        logging.debug(this, "setProductproperties() ");
        if (!this.checkPermission()) {
            return;
        }
        if (list != null && list.size() > 0 && this.exec.doCall(new OpsiMethodCall("productPropertyState_updateObjects", new Object[]{this.exec.jsonArray(list)}))) {
            list.clear();
        }
        if (list2 != null && list2.size() > 0 && this.exec.doCall(new OpsiMethodCall("productPropertyState_deleteObjects", new Object[]{this.exec.jsonArray(list2)}))) {
            list2.clear();
        }
    }

    @Override
    public void setCommonProductPropertyValue(Set<String> set, String string, String string2, List<String> list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (String string3 : set) {
            ConfigName2ConfigValue configName2ConfigValue = new ConfigName2ConfigValue(null);
            configName2ConfigValue.put(string2, list);
            this.setProductproperties(string3, string, configName2ConfigValue, arrayList, arrayList2);
        }
        this.setProductproperties(arrayList, arrayList2);
    }

    @Override
    public Map<String, ListCellOptions> getProductPropertyOptionsMap(String string, String string2) {
        Map<Object, Object> map = null;
        if (this.dataStub.getDepot2Product2PropertyDefinitions().get(string) == null) {
            map = new HashMap();
            logging.info("getProductPropertyOptionsMap: no productproperty definitions for depot " + string);
        } else {
            map = this.dataStub.getDepot2Product2PropertyDefinitions().get(string).get(string2);
        }
        if (map == null) {
            logging.info("getProductPropertyOptionsMap: no productproperty definitions  for depot, product " + string + ", " + string2);
            map = new HashMap();
        }
        return map;
    }

    @Override
    public Map<String, ListCellOptions> getProductPropertyOptionsMap(String string) {
        Map<String, ListCellOptions> map;
        this.retrieveProductPropertyDefinitions();
        if (this.productPropertyDefinitions == null) {
            map = new HashMap<String, ListCellOptions>();
        } else {
            map = this.productPropertyDefinitions.get(string);
            if (map == null) {
                map = new HashMap();
            }
        }
        return map;
    }

    @Override
    public void productPropertyDefinitionsRequestRefresh() {
        this.dataStub.productPropertyDefinitionsRequestRefresh();
        this.productPropertyDefinitions = null;
    }

    @Override
    public void retrieveProductPropertyDefinitions() {
        this.productPropertyDefinitions = this.dataStub.getDepot2Product2PropertyDefinitions().get(this.theDepot);
    }

    @Override
    public String getProductTitle(String string) {
        logging.info(this, "getProductTitle for product " + string);
        Object object = this.productGlobalInfos.get(string).get("productName");
        logging.debug(this, "getProductTitle for product " + object);
        String string2 = null;
        string2 = object == null ? EMPTYFIELD : nameRequirementTypeNeutral + object;
        return string2;
    }

    @Override
    public String getProductInfo(String string) {
        String string2 = nameRequirementTypeNeutral + this.productGlobalInfos.get(string).get("description");
        logging.debug(this, " getProductInfo for product " + string + ": " + string2);
        return string2;
    }

    @Override
    public String getProductHint(String string) {
        return (String)this.productGlobalInfos.get(string).get("advice");
    }

    @Override
    public String getProductVersion(String string) {
        this.productGlobalInfos.get(string).get("productVersion");
        String string2 = this.exec.getStringValueFromItem(this.getProductInfos(string).get("productVersion"));
        if (string2 == null) {
            string2 = EMPTYFIELD;
        }
        logging.debug(this, "getProductVersion which? " + this.productGlobalInfos.get(string).get("productVersion") + " //or//   " + string2);
        return string2;
    }

    @Override
    public String getProductPackageVersion(String string) {
        return (String)this.productGlobalInfos.get(string).get("packageVersion");
    }

    @Override
    public String getProductTimestamp(String string) {
        String string2 = null;
        if (string2 == null) {
            string2 = EMPTYFIELD;
        }
        return string2;
    }

    private Map<String, String> getProductRequirements(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string4 = null;
        string4 = string == null ? this.theDepot : string;
        logging.debug(this, "getProductRequirements productname, requirementType  " + string2 + ", " + string3);
        List<Map<String, String>> list = this.getProductDependencies(string4, string2);
        if (list == null) {
            return hashMap;
        }
        for (Map<String, String> map : list) {
            logging.debug(this, " dependency map : " + map);
            if (string3.equals(nameRequirementTypeOnDeinstall) && map.get("action").equals(ActionRequest.getLabel(5))) {
                hashMap.put(map.get("requiredProductId"), map.get("requiredInstallationStatus") + ":" + map.get("requiredAction"));
                continue;
            }
            logging.debug(this, " dependency map : ");
            if (!string3.equals(nameRequirementTypeNeutral) && !string3.equals(nameRequirementTypeBefore) && !string3.equals(nameRequirementTypeAfter) || !map.get("action").equals(ActionRequest.getLabel(1)) && !map.get("action").equals(ActionRequest.getLabel(8)) && !map.get("action").equals(ActionRequest.getLabel(7)) && !map.get("action").equals(ActionRequest.getLabel(11)) || !map.get("requirementType").equals(string3)) continue;
            hashMap.put(map.get("requiredProductId"), map.get("requiredInstallationStatus") + ":" + map.get("requiredAction"));
        }
        logging.debug(this, "getProductRequirements " + hashMap);
        return hashMap;
    }

    @Override
    public Map<String, String> getProductPreRequirements(String string, String string2) {
        return this.getProductRequirements(string, string2, nameRequirementTypeBefore);
    }

    @Override
    public Map<String, String> getProductRequirements(String string, String string2) {
        return this.getProductRequirements(string, string2, nameRequirementTypeNeutral);
    }

    @Override
    public Map<String, String> getProductPostRequirements(String string, String string2) {
        return this.getProductRequirements(string, string2, nameRequirementTypeAfter);
    }

    @Override
    public Map<String, String> getProductDeinstallRequirements(String string, String string2) {
        return this.getProductRequirements(string, string2, nameRequirementTypeOnDeinstall);
    }

    @Override
    public void productpropertiesRequestRefresh() {
        this.dataStub.productPropertyStatesRequestRefresh();
        this.productproperties = null;
    }

    @Override
    public List getMethodSignature(String string) {
        List list;
        if (this.mapOfMethodSignatures == null && (list = this.exec.getListResult(new OpsiMethodCall("getPossibleMethods_listOfHashes", new Object[0]))) != null) {
            this.mapOfMethodSignatures = new HashMap<String, List>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map map = this.exec.getMapFromItem(iterator.next());
                String string2 = (String)map.get("name");
                List list2 = this.exec.getListFromItem(map.get("params").toString());
                for (int i = 0; i < list2.size(); ++i) {
                    if (((String)list2.get(i)).charAt(0) != '*') continue;
                    list2.set(i, ((String)list2.get(i)).substring(1));
                }
                this.mapOfMethodSignatures.put(string2, list2);
            }
        }
        if (this.mapOfMethodSignatures.get(string) == null) {
            return NONE_LIST;
        }
        return this.mapOfMethodSignatures.get(string);
    }

    @Override
    public String getBackendInfos() {
        Object object;
        String string = "#dedeff";
        String string2 = "#ffffff";
        String string3 = nameRequirementTypeNeutral;
        String string4 = "14px";
        String string5 = "10px";
        String string6 = "8px";
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("getBackendInfos_listOfHashes", new String[0]);
        List list = this.exec.getListResult(opsiMethodCall);
        StringBuffer stringBuffer = new StringBuffer(nameRequirementTypeNeutral);
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            Object object2 = this.exec.getMapFromItem(list.get(i));
            object = "UNKNOWN";
            if (object2.containsKey("name")) {
                object = (String)object2.get("name");
            }
            if (!hashMap.containsKey(object)) {
                hashMap.put((String)object, new ArrayList());
            }
            ((ArrayList)hashMap.get(object)).add(object2);
        }
        stringBuffer.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
        for (Object object2 : hashMap.keySet()) {
            stringBuffer.append("<tr><td bgcolor='#fbeca5' color='#000000'  width='100%'  colspan='3'  align='left'>");
            stringBuffer.append("<font size='" + string4 + "'><b>" + (String)object2 + "</b></font></td></tr>");
            object = (ArrayList)hashMap.get(object2);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Map map = (Map)((ArrayList)object).get(i);
                Iterator iterator = map.keySet().iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    if (string7.equals("name")) continue;
                    bl = !bl;
                    string3 = bl ? string : string2;
                    Object v = map.get(string7);
                    stringBuffer.append("<tr height='8px'>");
                    stringBuffer.append("<td width='200px'  bgcolor='" + string3 + "' align='left' valign='top'><font size='" + string5 + "'>" + string7 + "</font></td>");
                    if (string7.equals("config")) {
                        stringBuffer.append("<td colspan='2'  bgcolor='" + string3 + "' align='left' valign='top'><font size='" + string5 + "'>&nbsp;</font></td>");
                        stringBuffer.append("</tr>");
                        Map map2 = this.exec.getMapFromItem(v);
                        if (map2 == null) {
                            logging.debug(this, "------------------ key " + string7 + "  config  null");
                            continue;
                        }
                        for (String string8 : map2.keySet()) {
                            Object v2 = map2.get(string8);
                            String string9 = nameRequirementTypeNeutral;
                            try {
                                string9 = v2.toString();
                            }
                            catch (Exception exception) {
                                logging.debug(this, exception.toString());
                            }
                            stringBuffer.append("<td bgcolor='" + string3 + "'>&nbsp;</td>");
                            stringBuffer.append("<td width='200px'  bgcolor='" + string3 + "' align='left' valign='top'><font size='" + string6 + "'>" + string8 + "</font></td>");
                            stringBuffer.append("<td width='200px'  bgcolor='" + string3 + "' align='left' valign='top'><font size='" + string6 + "'>" + string9 + "</font></td>");
                            stringBuffer.append("</tr>");
                        }
                        continue;
                    }
                    stringBuffer.append("<td width='300px'  bgcolor='" + string3 + "' align='left' valign='top'><font size='" + string5 + "'>" + v + "</font></td>");
                    stringBuffer.append("</tr>");
                }
                stringBuffer.append("<tr height='10px'><td bgcolor='" + string3 + "' colspan='3'></td></tr>");
            }
            stringBuffer.append("<tr><td bgcolor='#ffffff' color='#000000' width='100%' height='30px' colspan='3'>&nbsp;</td></tr>");
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    @Override
    public Map<String, ListCellOptions> getConfigOptions() {
        int n = 0;
        if (this.configListCellOptions == null || this.configOptions == null || this.configDefaultValues == null) {
            block2: while (n <= 1) {
                ++n;
                this.configOptions = new HashMap<String, ConfigOption>();
                this.configListCellOptions = new HashMap<String, ListCellOptions>();
                this.configDefaultValues = new HashMap<String, List>();
                this.remoteControls = new RemoteControls();
                this.savedSearches = new SavedSearches();
                List<Map<String, Object>> list = this.retrieveListOfMapsNOM("config_getObjects");
                logging.info(this, "configOptions retrieved ");
                for (Map<String, Object> map : list) {
                    for (String string : map.keySet()) {
                        if (!(map.get(string) instanceof JSONArray)) continue;
                        map.put(string, ((JSONArray)map.get(string)).toList());
                    }
                    String string = (String)map.get("ident");
                    ConfigOption object2 = new ConfigOption(map);
                    this.configOptions.put(string, object2);
                    this.configListCellOptions.put(string, object2);
                    if (object2.getDefaultValues() == null) {
                        logging.warning(this, "default values missing for config  " + (String)string);
                        if (n <= 1) {
                            logging.warning(this, "repeat loading the values , we repeated  " + n + " times");
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block2;
                        }
                    }
                    this.configDefaultValues.put(string, object2.getDefaultValues());
                    if (object2.getDefaultValues() == null || object2.getDefaultValues().size() <= 0) continue;
                    this.remoteControls.checkIn(string, nameRequirementTypeNeutral + object2.getDefaultValues().get(0));
                    this.savedSearches.checkIn(string, nameRequirementTypeNeutral + object2.getDefaultValues().get(0));
                }
            }
        }
        logging.debug(this, "getConfigOptions() ready ");
        return this.configListCellOptions;
    }

    private Object getLocalbootDisplayFieldsConfig() {
        return null;
    }

    @Override
    public Map<String, RemoteControl> getRemoteControls() {
        this.getConfigOptions();
        return this.remoteControls;
    }

    @Override
    public SavedSearches getSavedSearches() {
        this.getConfigOptions();
        return this.savedSearches;
    }

    @Override
    public Map<String, List> getConfigDefaultValues() {
        this.getConfigOptions();
        return this.configDefaultValues;
    }

    @Override
    public void configOptionsRequestRefresh() {
        this.configOptions = null;
    }

    @Override
    public void hostConfigsRequestRefresh() {
        this.dataStub.hostConfigsRequestRefresh();
    }

    @Override
    public Map<String, Map<String, Object>> getConfigs() {
        return this.dataStub.getConfigs();
    }

    @Override
    public Map<String, Object> getConfig(String string) {
        this.getConfigOptions();
        Map<String, Object> map = this.dataStub.getConfigs().get(string);
        return new ConfigName2ConfigValue(map, this.configOptions);
    }

    private Map<String, Object> createNOMitem(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", string);
        return hashMap;
    }

    @Override
    public void setHostValues(Map map) {
        if (!this.checkPermission()) {
            return;
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        HashMap hashMap = new HashMap();
        for (Object k : map.keySet()) {
            if (map.get(k) instanceof String && ((String)map.get(k)).trim().equals("null")) {
                hashMap.put(k, JSONObject.NULL);
                continue;
            }
            hashMap.put(k, map.get(k));
        }
        arrayList.add(this.exec.jsonMap(hashMap));
        this.exec.doCall(new OpsiMethodCall("host_createObjects", new Object[]{this.exec.jsonArray(arrayList)}));
    }

    @Override
    public void setAdditionalConfiguration(String string, Map map) {
        Object object;
        Map<String, Object> map2;
        Object object2;
        if (this.configStateCollection == null) {
            this.configStateCollection = new ArrayList();
        }
        if (!(map instanceof ConfigName2ConfigValue)) {
            logging.warning(this, "! settings instanceof de.uib.configed.type.ConfigName2ConfigValue ");
            return;
        }
        Set set = map.keySet();
        logging.debug(this, "setAdditionalConfigurations keySet: " + set);
        if (((RetrievedMap)map).getRetrieved() != null) {
            Set<String> set2 = ((RetrievedMap)map).getRetrieved().keySet();
            logging.debug(this, "setAdditionalConfigurations retrieved " + set2);
            Object object3 = new HashSet(set2);
            object3.removeAll(set);
            logging.debug(this, "setAdditionalConfigurations removed " + object3);
            if (object3.size() > 0) {
                if (this.deleteConfigStateItems == null) {
                    this.deleteConfigStateItems = new ArrayList();
                }
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    map2 = object2.next();
                    object = nameRequirementTypeNeutral + map2 + ";" + string;
                    Map<String, Object> map3 = this.createNOMitem("ConfigState");
                    map3.put("ident", object);
                    this.deleteConfigStateItems.add(this.exec.jsonMap(map3));
                }
            }
        }
        for (Object object3 : map.keySet()) {
            object2 = new HashMap<String, Object>();
            object2.put("type", "ConfigState");
            object2.put("objectId", string);
            object2.put("configId", object3);
            object2.put("values", (List)map.get(object3));
            map2 = ((RetrievedMap)map).getRetrieved();
            object = null;
            if (map2 != null) {
                object = map2.get(object3);
            }
            if ((List)map.get(object3) == object) continue;
            this.configStateCollection.add(object2);
            if (map2 == null) continue;
            map2.put((String)object3, (List)map.get(object3));
        }
    }

    @Override
    public void setAdditionalConfiguration(boolean bl) {
        if (!this.checkPermission()) {
            return;
        }
        logging.info(this, "setAdditionalConfiguration(),  configStateCollection: " + this.configStateCollection);
        if (this.configStateCollection != null && this.configStateCollection.size() > 0) {
            ArrayList<JSONObject> arrayList;
            Object object;
            ArrayList<JSONObject> arrayList2;
            Object object2;
            boolean bl2 = false;
            if (this.deleteConfigStateItems == null) {
                this.deleteConfigStateItems = new ArrayList();
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            Object object3 = this.configStateCollection.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                arrayList2 = (String)((Map)object2).get("configId");
                hashSet.add((String)((Object)arrayList2));
                object = (List)((Map)object2).get("values");
                if (object.size() > 0 && object.get(0) instanceof Boolean) {
                    hashMap.put((String)((Object)arrayList2), "BoolConfig");
                } else {
                    hashMap.put((String)((Object)arrayList2), "UnicodeConfig");
                }
                if (object != MapTableModel.nullLIST) continue;
                arrayList = this.createNOMitem("ConfigState");
                arrayList.put((String)"objectId", ((Map)object2).get("objectId"));
                arrayList.put((String)"configId", ((Map)object2).get("configId"));
                this.deleteConfigStateItems.add(this.exec.jsonMap((Map)((Object)arrayList)));
                arrayList3.add(object2);
            }
            logging.debug(this, "setAdditionalConfiguration(), usedConfigIds: " + hashSet);
            logging.debug(this, "setAdditionalConfiguration(), deleteConfigStateItems  " + this.deleteConfigStateItems);
            if (this.deleteConfigStateItems.size() > 0 && this.exec.doCall((OpsiMethodCall)(object3 = new OpsiMethodCall("configState_deleteObjects", new Object[]{this.deleteConfigStateItems.toArray()})))) {
                this.deleteConfigStateItems.clear();
                this.configStateCollection.removeAll(arrayList3);
            }
            object3 = this.exec.getListResult(new OpsiMethodCall("config_getIdents", new Object[0]));
            logging.debug(this, "setAdditionalConfiguration(), existingConfigIds: " + object3);
            object2 = new HashSet(hashSet);
            arrayList2 = object3.iterator();
            while (arrayList2.hasNext()) {
                object = arrayList2.next();
                object2.remove(object);
            }
            logging.debug(this, "setAdditionalConfiguration(), missingConfigIds: " + object2);
            arrayList2 = new ArrayList<JSONObject>();
            object = object2.iterator();
            while (object.hasNext()) {
                arrayList = (String)object.next();
                Map<String, Object> map = this.createNOMitem((String)hashMap.get(arrayList));
                map.put("ident", arrayList);
                arrayList2.add(this.exec.jsonMap(map));
            }
            if (arrayList2.size() > 0) {
                object = new OpsiMethodCall("config_createObjects", new Object[]{arrayList2.toArray()});
                this.exec.doCall((OpsiMethodCall)object);
                bl2 = true;
            }
            if (bl2) {
                this.configOptionsRequestRefresh();
                this.getConfigOptions();
            }
            object = new ArrayList();
            arrayList = new ArrayList<JSONObject>();
            for (Object e : this.configStateCollection) {
                Map map = (Map)e;
                if (bl) {
                    ConfigOption configOption = this.configOptions.get(map.get("configId"));
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    hashMap2.put("ident", map.get("configId"));
                    hashMap2.put("type", configOption.getRetrieved().get("type"));
                    hashMap2.put("defaultValues", this.exec.jsonArray((List)map.get("values")));
                    List list = (List)configOption.get("possibleValues");
                    for (Object e2 : (List)map.get("values")) {
                        if (list.indexOf(e2) != -1) continue;
                        list.add(e2);
                    }
                    hashMap2.put("possibleValues", this.exec.jsonArray(list));
                    logging.debug(this, "setAdditionalConfiguation " + hashMap2);
                    arrayList.add(this.exec.jsonMap(hashMap2));
                }
                map.put("values", this.exec.jsonArray((List)map.get("values")));
                object.add(this.exec.jsonMap(map));
            }
            logging.debug(this, "callsConfigCollection " + arrayList);
            if (arrayList.size() > 0) {
                this.exec.doCall(new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonArray(arrayList)}));
            }
            boolean bl3 = this.exec.doCall(new OpsiMethodCall("configState_updateObjects", new Object[]{this.exec.jsonArray((List)object)}));
            this.configStateCollection.clear();
        }
    }

    @Override
    public void setConfig(Map<String, List<Object>> map) {
        logging.debug(this, "setConfig settings " + map);
        if (this.configCollection == null) {
            this.configCollection = new ArrayList();
        }
        for (String string : map.keySet()) {
            List<Object> list;
            Object object;
            logging.info(this, "setConfig,  key, settings.get(key): " + string + ", " + map.get(string));
            if (map.get(string) == null) continue;
            logging.info(this, "setConfig,  settings.get(key), settings.get(key).getClass().getName(): " + map.get(string) + " , " + map.get(string).getClass().getName());
            if (map.get(string) instanceof Map) {
                object = null;
                object = (HashMap)((Object)map.get(string));
                if (this.configOptions.get(string) != null) continue;
                list = new HashMap<String, String>();
                list.put("ident", string);
                list.put("type", object.get("type"));
                list.put("defaultValues", object.get("defaultValues"));
                list.put("possibleValues", object.get("possibleValues"));
                list.put("description", object.get("description"));
                this.configCollection.add(list);
                continue;
            }
            if (!(map.get(string) instanceof List)) continue;
            object = null;
            if (this.configOptions.get(string) != null) {
                object = this.configOptions.get(string).getDefaultValues();
            }
            logging.info(this, "setConfig, key, oldValue: " + string + ", " + object);
            list = map.get(string);
            if (list == null || list.equals(object)) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ident", string);
            String string2 = "UnicodeConfig";
            logging.debug(this, "setConfig, key,  configOptions.get(key):  " + string + ", " + this.configOptions.get(string));
            if (this.configOptions.get(string) != null) {
                string2 = (String)this.configOptions.get(string).get("type");
            } else if (list.size() > 0 && list.get(0) instanceof Boolean) {
                string2 = "BoolConfig";
            }
            hashMap.put("type", string2);
            hashMap.put("defaultValues", list);
            List<Boolean> list2 = null;
            if (this.configOptions.get(string) == null) {
                list2 = new ArrayList();
                if (string2.equals("BoolConfig")) {
                    list2.add(true);
                    list2.add(false);
                }
            } else {
                list2 = this.configOptions.get(string).getPossibleValues();
            }
            for (Object e : list) {
                if (list2.indexOf(e) != -1) continue;
                list2.add((Boolean)e);
            }
            hashMap.put("possibleValues", list2);
            this.configCollection.add(hashMap);
        }
    }

    @Override
    public void setConfig() {
        logging.info(this, "setConfig(),  configCollection: " + this.configCollection);
        if (!this.checkPermission()) {
            return;
        }
        if (this.configCollection != null && this.configCollection.size() > 0) {
            Object object;
            Object object2;
            ArrayList<JSONObject> arrayList;
            Object object32;
            boolean bl = false;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Object object32 : this.configCollection) {
                arrayList = (String)((Map)object32).get("ident");
                arrayList2.add((String)((Object)arrayList));
                hashMap.put((String)((Object)arrayList), (String)((Map)object32).get("type"));
            }
            logging.debug(this, "setConfig(), usedConfigIds: " + arrayList2);
            List list = this.exec.getListResult(new OpsiMethodCall("config_getIdents", new Object[0]));
            logging.info(this, "setConfig(), existingConfigIds: " + list);
            object32 = new ArrayList(arrayList2);
            arrayList = list.iterator();
            while (arrayList.hasNext()) {
                object2 = arrayList.next();
                object32.remove(object2);
            }
            logging.info(this, "setConfig(), missingConfigIds: " + object32);
            arrayList = new ArrayList<JSONObject>();
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Map<String, Object> map = this.createNOMitem((String)hashMap.get(object));
                map.put("ident", object);
                arrayList.add(this.exec.jsonMap(map));
            }
            if (arrayList.size() > 0) {
                object2 = new OpsiMethodCall("config_createObjects", new Object[]{arrayList.toArray()});
                this.exec.doCall((OpsiMethodCall)object2);
            }
            object2 = new ArrayList();
            object = new ArrayList();
            for (Object e : this.configCollection) {
                Map map = (Map)e;
                if (((Map)e).get("defaultValues") == MapTableModel.nullLIST) {
                    object.add(this.exec.jsonMap((Map)e));
                    continue;
                }
                map.put("defaultValues", this.exec.jsonArray((List)((Map)e).get("defaultValues")));
                map.put("possibleValues", this.exec.jsonArray((List)((Map)e).get("possibleValues")));
                object2.add(this.exec.jsonMap((Map)e));
            }
            if (object.size() > 0) {
                this.exec.doCall(new OpsiMethodCall("config_deleteObjects", new Object[]{this.exec.jsonArray((List)object)}));
                this.configOptionsRequestRefresh();
                this.hostConfigsRequestRefresh();
            }
            if (object2.size() > 0) {
                this.exec.doCall(new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonArray((List)object2)}));
                this.configOptionsRequestRefresh();
            }
            this.getConfigOptions();
            this.configCollection.clear();
            logging.info(this, "setConfig(),  configCollection result: " + this.configCollection);
        }
    }

    @Override
    public String getDomain(String string) {
        Object[] objectArray = string.equals(nameRequirementTypeNeutral) ? new Object[]{} : new Object[]{string};
        String string2 = this.exec.getStringResult(new OpsiMethodCall("getDomain", objectArray));
        return string2;
    }

    @Override
    public void setDepot(String string) {
        logging.info(this, "setDepot " + string);
        this.theDepot = string;
    }

    private String getDepot() {
        return this.theDepot;
    }

    @Override
    public Map<String, SWAuditEntry> getInstalledSoftwareInformation() {
        return this.dataStub.getInstalledSoftwareInformation();
    }

    @Override
    public void installedSoftwareInformationRequestRefresh() {
        this.dataStub.installedSoftwareInformationRequestRefresh();
    }

    @Override
    public String getSWident(Integer n) {
        return this.dataStub.getSWident(n);
    }

    @Override
    public LinkedList<String> getSoftwareList() {
        return this.dataStub.getSoftwareList();
    }

    @Override
    public Map<String, LicenceContractEntry> getLicenceContracts() {
        this.dataStub.licenceContractsRequestRefresh();
        return this.dataStub.getLicenceContracts();
    }

    @Override
    public String editLicenceContract(String string, String string2, String string3, String string4, String string5, String string6) {
        if (!this.checkPermission()) {
            return nameRequirementTypeNeutral;
        }
        String string7 = nameRequirementTypeNeutral;
        logging.debug(this, "editLicenceContract " + string);
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("createLicenseContract", new String[]{string, string2, string3, string4, string5, string6});
            this.exec.getStringResult(opsiMethodCall);
            string7 = string;
        }
        logging.debug(this, "editLicenceContract result " + string7);
        return string7;
    }

    @Override
    public boolean deleteLicenceContract(String string) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("deleteLicenseContract", new String[]{string});
            bl = this.exec.doCall(opsiMethodCall);
        }
        return bl;
    }

    @Override
    public String editLicencePool(String string, String string2) {
        if (!this.checkPermission()) {
            return nameRequirementTypeNeutral;
        }
        String string3 = nameRequirementTypeNeutral;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("createLicensePool", new String[]{string, string2});
            string3 = this.exec.getStringResult(opsiMethodCall);
        }
        return string3;
    }

    @Override
    public boolean deleteLicencePool(String string) {
        logging.info(this, "deleteLicencePool " + string);
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("deleteLicensePool", new Object[]{string, false});
            bl = this.exec.doCall(opsiMethodCall);
        }
        return bl;
    }

    @Override
    public Map<String, LicenceEntry> getSoftwareLicences() {
        Map<String, LicenceEntry> map = new HashMap<String, LicenceEntry>();
        if (this.withLicenceManagement) {
            this.dataStub.licencesRequestRefresh();
            map = this.dataStub.getLicences();
        }
        return map;
    }

    @Override
    public String editSoftwareLicence(String string, String string2, String string3, String string4, String string5, String string6) {
        if (!this.checkPermission()) {
            return nameRequirementTypeNeutral;
        }
        String string7 = nameRequirementTypeNeutral;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("createSoftwareLicense", new String[]{string, string2, string3, string4, string5, string6});
            string7 = this.exec.getStringResult(opsiMethodCall);
        }
        return string7;
    }

    @Override
    public boolean deleteSoftwareLicence(String string) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("deleteSoftwareLicense", new Object[]{string, false});
            bl = this.exec.doCall(opsiMethodCall);
        }
        return bl;
    }

    @Override
    public Map<String, Map> getRelationsSoftwareL2LPool() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        if (this.withLicenceManagement) {
            List list = this.exec.getListResult(new OpsiMethodCall("getSoftwareLicenses_listOfHashes", new String[0]));
            for (Object e : list) {
                Map map = this.exec.getMapFromItem(e);
                String string = (String)map.get("softwareLicenseId");
                List list2 = this.exec.getListFromItem(nameRequirementTypeNeutral + map.get("licensePoolIds"));
                Map map2 = this.exec.getMapFromItem(nameRequirementTypeNeutral + map.get("licenseKeys"));
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    String string2 = (String)iterator.next();
                    hashMap2.put("licensePoolId", string2);
                    String string3 = null;
                    if (map2 != null) {
                        string3 = (String)map2.get(string2);
                    }
                    if (string3 == null) {
                        string3 = nameRequirementTypeNeutral;
                    }
                    hashMap2.put("licenseKey", string3);
                    hashMap2.put("softwareLicenseId", string);
                    hashMap.put(de.uib.configed.Globals.pseudokey(new String[]{string, string2}), hashMap2);
                }
            }
        }
        return hashMap;
    }

    @Override
    public String editRelationSoftwareL2LPool(String string, String string2, String string3) {
        Object object;
        if (!this.checkPermission()) {
            return nameRequirementTypeNeutral;
        }
        String string4 = nameRequirementTypeNeutral;
        if (this.withLicenceManagement) {
            object = new OpsiMethodCall("addSoftwareLicenseToLicensePool", new String[]{string, string2, string3});
            string4 = this.exec.getStringResult((OpsiMethodCall)object);
        }
        object = de.uib.configed.Globals.pseudokey(new String[]{string, string2});
        return object;
    }

    @Override
    public boolean deleteRelationSoftwareL2LPool(String string, String string2) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("removeSoftwareLicenseFromLicensePool", new String[]{string, string2});
            bl = this.exec.doCall(opsiMethodCall);
        }
        return bl;
    }

    @Override
    public Map<String, Map<String, String>> getRelationsProductId2LPool() {
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        if (this.withLicenceManagement) {
            this.dataStub.licencePoolXOpsiProductRequestRefresh();
            this.dataStub.getLicencePoolXOpsiProduct();
            logging.info(this, "licencePoolXOpsiProduct size " + this.dataStub.getLicencePoolXOpsiProduct().size());
            for (StringValuedRelationElement stringValuedRelationElement : this.dataStub.getLicencePoolXOpsiProduct()) {
                hashMap.put(Globals.pseudokey(new String[]{(String)stringValuedRelationElement.get("licensePoolId"), (String)stringValuedRelationElement.get("productId")}), stringValuedRelationElement);
            }
        }
        logging.info(this, "rowsLicencePoolXOpsiProduct size " + hashMap.size());
        return hashMap;
    }

    @Override
    public String editRelationProductId2LPool(String string, String string2) {
        if (!this.checkPermission()) {
            return nameRequirementTypeNeutral;
        }
        String string3 = nameRequirementTypeNeutral;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("addProductIdsToLicensePool", new String[]{string, string2});
            this.exec.doCall(opsiMethodCall);
            string3 = string2;
        }
        return string3;
    }

    @Override
    public boolean deleteRelationProductId2LPool(String string, String string2) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("removeProductIdsFromLicensePool", new String[]{string, string2});
            bl = this.exec.doCall(opsiMethodCall);
        }
        return bl;
    }

    private void retrieveRelationsAuditSoftwareToLicencePools() {
        logging.info(this, "retrieveRelationsAuditSoftwareToLicencePools start " + (this.relations_auditSoftwareToLicencePools != null));
        if (this.relations_auditSoftwareToLicencePools != null) {
            return;
        }
        this.dataStub.auditSoftwareXLicencePoolRequestRefresh();
        if (!this.withLicenceManagement) {
            return;
        }
        this.relations_auditSoftwareToLicencePools = this.dataStub.getAuditSoftwareXLicencePool();
        this.rowmapAuditSoftware = new TreeMap<String, Map>();
        this.fSoftware2LicencePool = new HashMap<String, String>();
        this.fLicencePool2SoftwareList = new HashMap<String, List<String>>();
        for (StringValuedRelationElement stringValuedRelationElement : this.relations_auditSoftwareToLicencePools) {
            SWAuditEntry sWAuditEntry = new SWAuditEntry(stringValuedRelationElement, this.relations_auditSoftwareToLicencePools);
            String string = (String)stringValuedRelationElement.get("licensePoolId");
            String string2 = sWAuditEntry.getIdent();
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Object object = SWAuditEntry.getDisplayKeys().iterator();
            while (object.hasNext()) {
                String string3 = object.next();
                linkedHashMap.put(string3, sWAuditEntry.get(string3));
            }
            this.rowmapAuditSoftware.put(string2, linkedHashMap);
            if (this.fSoftware2LicencePool.get(string2) != null && !this.fSoftware2LicencePool.get(string2).equals(string)) {
                logging.error("software with ident \"" + string2 + "\" has assigned license pool " + this.fSoftware2LicencePool.get(string2) + " as well as " + string);
            }
            this.fSoftware2LicencePool.put(string2, string);
            if (this.fLicencePool2SoftwareList.get(string) == null) {
                this.fLicencePool2SoftwareList.put(string, new ArrayList());
            }
            if ((object = this.fLicencePool2SoftwareList.get(string)).indexOf(string2) != -1) continue;
            object.add(string2);
        }
    }

    @Override
    public void relations_auditSoftwareToLicencePools_requestRefresh() {
        this.relations_auditSoftwareToLicencePools = null;
    }

    @Override
    public List getSoftwareListByLicencePool(String string) {
        return this.fLicencePool2SoftwareList.get(string);
    }

    @Override
    public String getLicencePoolBySoftwareId(String string) {
        return this.fSoftware2LicencePool.get(string);
    }

    @Override
    public void relations_windowsSoftwareId2LPool_requestRefresh() {
    }

    public TreeMap<String, Map> getRelationsWindowsSoftwareId2LPool() {
        return null;
    }

    @Override
    public boolean setWindowsSoftwareIds2LPool(String string, List list) {
        logging.debug(this, "setWindowsSoftwareIds2LPool  licensePoolId,  softwareToAssign:" + string + " , " + list);
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            Object object;
            Cloneable cloneable;
            ArrayList<JSONObject> arrayList;
            this.getInstalledSoftwareInformation();
            List<String> list2 = this.fLicencePool2SoftwareList.get(string);
            HashSet<String> hashSet = new HashSet<String>();
            if (list2 != null) {
                arrayList = new ArrayList<JSONObject>();
                for (String object2 : list2) {
                    if (this.getInstalledSoftwareInformation().get(object2) == null) continue;
                    hashSet.add(object2);
                    cloneable = new HashMap();
                    cloneable.put("ident", object2 + ";" + string);
                    cloneable.put("type", "AuditSoftwareToLicensePool");
                    arrayList.add(this.exec.jsonMap((Map)((Object)cloneable)));
                }
                object = new OpsiMethodCall("auditSoftwareToLicensePool_deleteObjects", new Object[]{arrayList.toArray()});
                bl = this.exec.doCall((OpsiMethodCall)object);
                if (!bl) {
                    return false;
                }
            } else {
                this.fLicencePool2SoftwareList.put(string, new ArrayList());
            }
            arrayList = new ArrayList();
            for (String string2 : list) {
                cloneable = new HashMap<String, String>();
                cloneable.put("ident", string2 + ";" + string);
                cloneable.put("type", "AuditSoftwareToLicensePool");
                arrayList.add(this.exec.jsonMap((Map)((Object)cloneable)));
            }
            logging.debug(this, "setWindowsSoftwareIds2LPool, createItems " + arrayList);
            object = new OpsiMethodCall("auditSoftwareToLicensePool_createObjects", new Object[]{arrayList.toArray()});
            bl = this.exec.doCall((OpsiMethodCall)object);
            if (bl) {
                HashSet hashSet2 = new HashSet(this.fLicencePool2SoftwareList.get(string));
                hashSet2.removeAll(hashSet);
                hashSet2.addAll(list);
                cloneable = new ArrayList(hashSet2);
                this.fLicencePool2SoftwareList.put(string, (List<String>)((Object)cloneable));
            }
        }
        return bl;
    }

    @Override
    public List<String> getServerConfigStrings(String string) {
        this.getConfigOptions();
        ArrayList arrayList = this.configDefaultValues.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object e : arrayList) {
            arrayList2.add((String)e);
        }
        return arrayList2;
    }

    @Override
    public Map<String, LicencepoolEntry> getLicencepools() {
        this.dataStub.licencepoolsRequestRefresh();
        return this.dataStub.getLicencepools();
    }

    private Integer getIntValue(String string) {
        if (string == null) {
            return -1;
        }
        Integer n = -1;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            logging.info(this, "getIntValue exception " + exception);
        }
        return n;
    }

    private String testOutRow(String string, Map<String, String> map) {
        boolean bl;
        String string2 = String.format("%50s", map.get("licensePoolId")) + ": " + " licence_options " + String.format("%5s", map.get("licence_options")) + " used_by_opsi " + String.format("%5s", map.get("used_by_opsi")) + " remaining_opsi " + String.format("%5s", map.get("remaining_opsi")) + " SWinventory_used " + String.format("%5s", map.get("SWinventory_used")) + " SWinventory_remaining " + String.format("%5s", map.get("SWinventory_remaining"));
        assert (map.get("licence_options") != null) : " rowmap.get(licence_options) is null";
        assert (this.rowsLicenceStatistics.get(string) != null) : " rowsLicenceStatistics.get(licencePoolId)  is null";
        assert (this.rowsLicenceStatistics.get(string).get("licence_options") != null) : "rowsLicenceStatistics.get(licencePoolId).get.get(licence_options) is null";
        assert (map.get("used_by_opsi") != null) : " rowmap.get(used_by_opsi) is null";
        assert (this.rowsLicenceStatistics.get(string).get("used_by_opsi") != null) : "rowsLicenceStatistics.get(licencePoolId).get(used_by_opsi)  is null";
        assert (map.get("SWinventory_used") != null) : "rowsLicenceStatistics.get(licencePoolId).get(SWinventory_used ) is null";
        boolean bl2 = bl = map.get("licence_options").equals(this.rowsLicenceStatistics.get(string).get("licence_options")) && map.get("used_by_opsi").equals(this.rowsLicenceStatistics.get(string).get("used_by_opsi")) && map.get("remaining_opsi").equals(this.rowsLicenceStatistics.get(string).get("remaining_opsi")) && map.get("SWinventory_used").equals(this.rowsLicenceStatistics.get(string).get("SWinventory_used"));
        if (!bl) {
            String string3 = String.format("%50s", map.get("licensePoolId")) + ": " + " licence_options " + String.format("%5s", this.rowsLicenceStatistics.get(string).get("licence_options")) + " used_by_opsi " + String.format("%5s", this.rowsLicenceStatistics.get(string).get("used_by_opsi")) + " remaining_opsi " + String.format("%5s", this.rowsLicenceStatistics.get(string).get("remaining_opsi")) + " SWinventory_used " + String.format("%5s", this.rowsLicenceStatistics.get(string).get("SWinventory_used")) + " SWinventory_remaining " + String.format("%5s", this.rowsLicenceStatistics.get(string).get("SWinventory_remaining"));
            logging.warning(this, "statistic results differ new result " + string2);
            logging.warning(this, "statistic results differ old  result " + string3);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, LicenceStatisticsRow> produceLicenceStatistics() {
        Object object;
        Set set;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Object object4;
        Object object8;
        Map<String, LicencepoolEntry> map;
        logging.info(this, "produceLicenceStatistics === ");
        HashMap hashMap = new HashMap();
        HashMap<Object, Cloneable> hashMap2 = new HashMap<Object, Cloneable>();
        HashMap<Object, Integer> hashMap3 = new HashMap<Object, Integer>();
        this.fillClient2Software(this.getHostInfoCollections().getOpsiHostNames());
        AuditSoftwareXLicencePool auditSoftwareXLicencePool = this.dataStub.getAuditSoftwareXLicencePool();
        Map<String, Set<String>> map2 = this.dataStub.getSoftwareIdent2clients();
        if (this.withLicenceManagement) {
            map = this.dataStub.getLicencepools();
            if (this.rowsLicencesReconciliation == null) {
                this.rowsLicencesReconciliation = new HashMap<String, Map<String, Object>>();
                object8 = this.getServerConfigStrings("configed.license_inventory_extradisplayfields");
                Map<String, HostInfo> object72 = this.hostInfoCollections.getMapOfAllPCInfoMaps();
                for (String string : object72.keySet()) {
                    for (String string2 : map.keySet()) {
                        HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
                        hashMap4.put("hostId", string);
                        object4 = object8.iterator();
                        while (object4.hasNext()) {
                            String string3 = (String)object4.next();
                            hashMap4.put(string3, object72.get(string).getMap().get(string3));
                        }
                        hashMap4.put("licensePoolId", string2);
                        hashMap4.put("used_by_opsi", false);
                        hashMap4.put("SWinventory_used", false);
                        object4 = de.uib.configed.Globals.pseudokey(new String[]{string, string2});
                        this.rowsLicencesReconciliation.put((String)object4, hashMap4);
                    }
                }
            }
            this.getInstalledSoftwareInformation();
            this.retrieveRelationsAuditSoftwareToLicencePools();
            for (String string : this.getInstalledSoftwareInformation().keySet()) {
                object3 = this.fSoftware2LicencePool.get(string);
                if (object3 == null) continue;
                List list = (List)hashMap.get(object3);
                cloneable = (Set)hashMap2.get(object3);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    hashMap.put(object3, arrayList);
                }
                if (cloneable == null) {
                    cloneable = new HashSet();
                    hashMap2.put(object3, cloneable);
                }
                logging.debug(this, "software " + string + " installed on " + map2.get(string));
                if (map2.get(string) == null) continue;
                try {
                    for (String string4 : map2.get(string)) {
                        void var10_17;
                        var10_17.add(string4);
                        cloneable.add(string4);
                    }
                }
                catch (Exception exception) {
                    logging.warning(" swId2clients.get(softwareIdent) -" + exception);
                }
                hashMap3.put(object3, cloneable.size());
                for (String string5 : map2.get(string)) {
                    object4 = de.uib.configed.Globals.pseudokey(new String[]{string5, object3});
                    if (this.rowsLicencesReconciliation.get(object4) == null) {
                        logging.warning("client " + string5 + " or license pool ID " + (String)object3 + " do not exist");
                        continue;
                    }
                    this.rowsLicencesReconciliation.get(object4).put("SWinventory_used", true);
                }
            }
        }
        map = this.dataStub.getLicencepools();
        logging.info(this, " licences ");
        logging.info(this, " licence usabilities ");
        object8 = this.dataStub.getLicenceUsabilities();
        logging.info(this, " licence usages ");
        List<LicenceUsageEntry> list = this.dataStub.getLicenceUsages();
        object3 = new TreeMap();
        Iterator iterator = object8.iterator();
        while (iterator.hasNext()) {
            cloneable = (LicenceUsableForEntry)iterator.next();
            String string = ((LicenceUsableForEntry)cloneable).getLicencePoolId();
            String string6 = ((LicenceUsableForEntry)cloneable).getLicenceId();
            object4 = (ExtendedInteger)((TreeMap)object3).get(string);
            if (object4 == null) {
                object4 = this.dataStub.getLicences().get(string6).getMaxInstallations();
                ((TreeMap)object3).put(string, object4);
            } else {
                ExtendedInteger extendedInteger = ((ExtendedInteger)object4).add(this.dataStub.getLicences().get(string6).getMaxInstallations());
                ((TreeMap)object3).put(string, extendedInteger);
            }
            if (!string.equals("bacula")) continue;
            logging.info(this, "count for bacula " + object4);
        }
        logging.info(this, " pool2allowedUsagesCount " + object3);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        cloneable = new TreeMap();
        for (LicenceUsageEntry licenceUsageEntry : list) {
            object4 = licenceUsageEntry.getLic4pool();
            String string = licenceUsageEntry.getLicencepool();
            object2 = (Integer)treeMap.get(string);
            set = (TreeSet<String>)cloneable.get(string);
            if (set == null) {
                set = new TreeSet<String>();
                cloneable.put(string, set);
            }
            if (object2 == null) {
                object2 = new Integer(0);
                treeMap.put(string, object2);
            }
            if ((object = licenceUsageEntry.getClientId()) == null) continue;
            object2 = (Integer)object2 + 1;
            treeMap.put(string, object2);
            set.add(object);
        }
        logging.info(this, "  retrieveStatistics  collect pool2installationsCount");
        TreeMap treeMap2 = new TreeMap();
        TreeMap<String, Integer> treeMap3 = new TreeMap<String, Integer>();
        for (StringValuedRelationElement stringValuedRelationElement : auditSoftwareXLicencePool) {
            logging.debug(this, " retrieveStatistics1 relationElement  " + stringValuedRelationElement);
            object2 = (String)stringValuedRelationElement.get("licensePoolId");
            set = (TreeSet<String>)treeMap2.get(object2);
            if (set == null) {
                set = new TreeSet<String>();
                treeMap2.put(object2, set);
            }
            object = (String)stringValuedRelationElement.get("swId");
            logging.debug(this, " retrieveStatistics1 swIdent " + (String)object);
            if (map2.get(object) == null) continue;
            logging.debug(this, "pool " + (String)object2 + " serves clients " + map2.get(object));
            ((TreeSet)set).addAll(map2.get(object));
        }
        for (String string : treeMap2.keySet()) {
            treeMap3.put(string, ((TreeSet)treeMap2.get(string)).size());
        }
        this.rowsLicenceStatistics = new TreeMap();
        if (this.withLicenceManagement) {
            for (String string : map.keySet()) {
                object2 = new LicenceStatisticsRow(string);
                this.rowsLicenceStatistics.put(string, (LicenceStatisticsRow)object2);
                ((LicenceStatisticsRow)object2).setAllowedUsagesCount((ExtendedInteger)((TreeMap)object3).get(string));
                ((LicenceStatisticsRow)object2).setOpsiUsagesCount((Integer)treeMap.get(string));
                ((LicenceStatisticsRow)object2).setSWauditUsagesCount((Integer)treeMap3.get(string));
                set = (Set)cloneable.get(string);
                logging.info(this, "pool  " + string + " used_by_opsi on clients : " + set);
                if (set == null) continue;
                for (String string7 : set) {
                    String string8 = de.uib.configed.Globals.pseudokey(new String[]{string7, string});
                    if (this.rowsLicencesReconciliation.get(string8) == null) {
                        logging.warning("client " + string7 + " or license pool ID " + string + " do not exist");
                        continue;
                    }
                    this.rowsLicencesReconciliation.get(string8).put("used_by_opsi", true);
                }
            }
        }
        logging.debug(this, "rowsLicenceStatistics " + this.rowsLicenceStatistics);
        return this.rowsLicenceStatistics;
    }

    @Override
    public Map<String, LicenceStatisticsRow> getLicenceStatistics() {
        return this.produceLicenceStatistics();
    }

    @Override
    public void licencesUsageRequestRefresh() {
        this.rowsLicencesUsage = null;
        this.fClient2LicencesUsageList = null;
    }

    @Override
    public Map<String, LicenceUsageEntry> getLicencesUsage() {
        this.retrieveLicencesUsage();
        return this.rowsLicencesUsage;
    }

    @Override
    public Map<String, List<LicenceUsageEntry>> getFClient2LicencesUsageList() {
        this.retrieveLicencesUsage();
        return this.fClient2LicencesUsageList;
    }

    protected void retrieveLicencesUsage() {
        logging.info(this, "retrieveLicencesUsage with refresh " + (this.rowsLicencesUsage == null));
        if (this.rowsLicencesUsage != null) {
            return;
        }
        this.dataStub.licenceUsagesRequestRefresh();
        if (!this.withLicenceManagement) {
            return;
        }
        this.rowsLicencesUsage = new HashMap<String, LicenceUsageEntry>();
        this.fClient2LicencesUsageList = new HashMap<String, List<LicenceUsageEntry>>();
        for (LicenceUsageEntry licenceUsageEntry : this.dataStub.getLicenceUsages()) {
            this.rowsLicencesUsage.put(licenceUsageEntry.getPseudoKey(), licenceUsageEntry);
            List<LicenceUsageEntry> list = this.fClient2LicencesUsageList.get(licenceUsageEntry.getClientId());
            if (list == null) {
                list = new ArrayList<LicenceUsageEntry>();
                this.fClient2LicencesUsageList.put(licenceUsageEntry.getClientId(), list);
            }
            list.add(licenceUsageEntry);
        }
    }

    @Override
    public String getLicenceUsage(String string, String string2) {
        String string3 = null;
        Map map = null;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("getOrCreateSoftwareLicenseUsage_hash", new String[]{string, string2});
            map = this.exec.getMapResult(opsiMethodCall);
        }
        if (map != null && !map.isEmpty()) {
            string3 = de.uib.configed.Globals.pseudokey(new String[]{nameRequirementTypeNeutral + map.get("hostId"), nameRequirementTypeNeutral + map.get("softwareLicenseId"), nameRequirementTypeNeutral + map.get("licensePoolId")});
        }
        return string3;
    }

    @Override
    public String editLicenceUsage(String string, String string2, String string3, String string4, String string5) {
        if (!this.checkPermission()) {
            return null;
        }
        String string6 = null;
        Map map = null;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("setSoftwareLicenseUsage", new String[]{string, string3, string2, string4, string5});
            map = this.exec.getMapResult(opsiMethodCall);
        }
        if (!map.isEmpty()) {
            string6 = de.uib.configed.Globals.pseudokey(new String[]{nameRequirementTypeNeutral + map.get("hostId"), nameRequirementTypeNeutral + map.get("softwareLicenseId"), nameRequirementTypeNeutral + map.get("licensePoolId")});
        }
        return string6;
    }

    @Override
    public void addDeletionLicenceUsage(String string, String string2, String string3) {
        if (this.itemsDeletionLicenceUsage == null) {
            this.itemsDeletionLicenceUsage = new ArrayList();
        }
        this.addDeletionLicenceUsage(string, string2, string3, this.itemsDeletionLicenceUsage);
    }

    protected void addDeletionLicenceUsage(String string, String string2, String string3, List<LicenceUsageEntry> list) {
        if (list == null) {
            return;
        }
        if (!this.checkPermission()) {
            return;
        }
        if (!this.withLicenceManagement) {
            return;
        }
        LicenceUsageEntry licenceUsageEntry = new LicenceUsageEntry(string, string2, string3, nameRequirementTypeNeutral, nameRequirementTypeNeutral);
        list.add(licenceUsageEntry);
    }

    @Override
    public boolean executeCollectedDeletionsLicenceUsage() {
        logging.info(this, "executeCollectedDeletionsLicenceUsage itemsDeletionLicenceUsage == null " + (this.itemsDeletionLicenceUsage == null));
        if (this.itemsDeletionLicenceUsage == null) {
            return true;
        }
        if (!this.checkPermission()) {
            return false;
        }
        if (!this.withLicenceManagement) {
            return false;
        }
        boolean bl = false;
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (LicenceUsageEntry object : this.itemsDeletionLicenceUsage) {
            arrayList.add(this.exec.jsonMap(object.getNOMobject()));
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("licenseOnClient_deleteObjects", new Object[]{this.exec.jsonArray(arrayList)});
        bl = this.exec.doCall(opsiMethodCall);
        if (bl) {
            for (LicenceUsageEntry licenceUsageEntry : this.itemsDeletionLicenceUsage) {
                String string = licenceUsageEntry.getPseudoKey();
                String string2 = licenceUsageEntry.getClientId();
                LicenceUsageEntry licenceUsageEntry2 = this.rowsLicencesUsage.get(string);
                this.rowsLicencesUsage.remove(string);
                this.fClient2LicencesUsageList.get(string2).remove(licenceUsageEntry2);
                logging.debug(this, "deleteLicenceUsage check fClient2LicencesUsageList " + this.fClient2LicencesUsageList.get(string2));
            }
        }
        this.itemsDeletionLicenceUsage.clear();
        return bl;
    }

    @Override
    public boolean deleteLicenceUsage(String string, String string2, String string3) {
        if (!this.checkPermission()) {
            return false;
        }
        boolean bl = false;
        if (this.withLicenceManagement) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("deleteSoftwareLicenseUsage", new String[]{string, string2, string3});
            bl = this.exec.doCall(opsiMethodCall);
            if (bl) {
                String string4 = LicenceUsageEntry.produceKey(string, string3, string2);
                LicenceUsageEntry licenceUsageEntry = this.rowsLicencesUsage.get(string4);
                this.rowsLicencesUsage.remove(string4);
                this.fClient2LicencesUsageList.get(string).remove(licenceUsageEntry);
            }
            logging.info(this, "deleteLicenceUsage check fClient2LicencesUsageList " + this.fClient2LicencesUsageList.get(string));
        }
        return bl;
    }

    @Override
    public void reconciliationInfoRequestRefresh() {
        logging.info(this, "reconciliationInfoRequestRefresh");
        this.rowsLicencesReconciliation = null;
        this.dataStub.installedSoftwareInformationRequestRefresh();
        this.relations_auditSoftwareToLicencePools = null;
        this.dataStub.softwareAuditOnClientsRequestRefresh();
        this.dataStub.licencepoolsRequestRefresh();
        this.dataStub.licencesRequestRefresh();
        this.dataStub.licenceUsabilitiesRequestRefresh();
        this.dataStub.licenceUsagesRequestRefresh();
        this.hostInfoCollections.opsiHostsRequestRefresh();
    }

    @Override
    public Map<String, Map<String, Object>> getLicencesReconciliation() {
        this.getLicenceStatistics();
        return this.rowsLicencesReconciliation;
    }

    @Override
    public String editLicencesReconciliation(String string, String string2) {
        return nameRequirementTypeNeutral;
    }

    @Override
    public boolean deleteLicencesReconciliation(String string, String string2) {
        return false;
    }

    private List<String> getPossibleValuesProductOnClientDisplayfields_localboot() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("productId");
        arrayList.add("productName");
        arrayList.add("installationStatus");
        arrayList.add("installationInfo");
        arrayList.add("actionRequest");
        arrayList.add("priority");
        arrayList.add("position");
        arrayList.add("stateChange");
        arrayList.add("targetConfiguration");
        arrayList.add("versionInfo");
        return arrayList;
    }

    private List<String> getDefaultValuesProductOnClientDisplayfields_localboot() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("productId");
        arrayList.add("installationStatus");
        arrayList.add("installationInfo");
        arrayList.add("actionRequest");
        arrayList.add("versionInfo");
        return arrayList;
    }

    private List<String> produceProductOnClientDisplayfields_localboot() {
        if (!this.checkPermission()) {
            return null;
        }
        List<String> list = this.getDefaultValuesProductOnClientDisplayfields_localboot();
        List<String> list2 = this.getPossibleValuesProductOnClientDisplayfields_localboot();
        Map<String, Object> map = this.createNOMitem("UnicodeConfig");
        map.put("ident", "configed.productonclient_displayfields_localboot");
        map.put("description", nameRequirementTypeNeutral);
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(list2));
        map.put("editable", false);
        map.put("multiValue", true);
        logging.info(this, "produceProductOnClientDisplayfields_localboot");
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonMap(map)});
        this.exec.doCall(opsiMethodCall);
        return list;
    }

    @Override
    public LinkedHashMap<String, Boolean> getProductOnClients_displayFieldsLocalbootProducts() {
        if (this.productOnClients_displayFieldsLocalbootProducts == null) {
            Map<String, List> map = this.getConfigDefaultValues();
            List<String> list = map.get("configed.productonclient_displayfields_localboot");
            logging.debug(this, "getProductOnClients_displayFieldsLocalbootProducts()  configOptions.get(KEY_PRODUCTONCLIENT_DISPLAYFIELDS_LOCALBOOT " + this.configOptions.get("configed.productonclient_displayfields_localboot"));
            List list2 = new ArrayList();
            if (this.configOptions.get("configed.productonclient_displayfields_localboot") != null) {
                list2 = (List)this.configOptions.get("configed.productonclient_displayfields_localboot").get("possibleValues");
            }
            logging.debug(this, "getProductOnClients_displayFieldsLocalbootProducts() possibleValuesAccordingToService " + list2);
            if (list == null || !new HashSet<String>(this.getPossibleValuesProductOnClientDisplayfields_localboot()).equals(new HashSet(list2))) {
                list = this.produceProductOnClientDisplayfields_localboot();
            }
            this.productOnClients_displayFieldsLocalbootProducts = new LinkedHashMap();
            this.productOnClients_displayFieldsLocalbootProducts.put("productId", true);
            this.productOnClients_displayFieldsLocalbootProducts.put("productName", list.indexOf("productName") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("targetConfiguration", list.indexOf("targetConfiguration") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("installationStatus", true);
            this.productOnClients_displayFieldsLocalbootProducts.put("installationInfo", list.indexOf("installationInfo") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("actionRequest", true);
            this.productOnClients_displayFieldsLocalbootProducts.put("priority", list.indexOf("priority") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("position", list.indexOf("position") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("stateChange", list.indexOf("stateChange") > -1);
            this.productOnClients_displayFieldsLocalbootProducts.put("versionInfo", true);
        }
        return this.productOnClients_displayFieldsLocalbootProducts;
    }

    @Override
    public void deleteSavedSearch(String string) {
        logging.debug(this, "deleteSavedSearch " + string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Map<String, Object> map = this.createNOMitem("UnicodeConfig");
        map.put("id", "configed.saved_search." + string);
        arrayList.add(this.exec.jsonMap(map));
        map = this.createNOMitem("UnicodeConfig");
        map.put("id", "configed.saved_search." + string + "." + "description");
        arrayList.add(this.exec.jsonMap(map));
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_deleteObjects", new Object[]{this.exec.jsonArray(arrayList)});
        this.exec.doCall(opsiMethodCall);
        this.savedSearches.remove(string);
    }

    @Override
    public void saveSearch(SavedSearch savedSearch) {
        logging.debug(this, "saveSearch " + savedSearch);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.produceConfigEntry("UnicodeConfig", "configed.saved_search." + savedSearch.getName(), savedSearch.getSerialization(), savedSearch.getDescription(), false));
        arrayList.add(this.produceConfigEntry("UnicodeConfig", "configed.saved_search." + savedSearch.getName() + "." + "description", savedSearch.getDescription(), nameRequirementTypeNeutral, true));
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonArray(arrayList)});
        this.exec.doCall(opsiMethodCall);
    }

    private List<String> getPossibleValuesProductOnClientDisplayfields_netboot() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("productId");
        arrayList.add("productName");
        arrayList.add("installationStatus");
        arrayList.add("installationInfo");
        arrayList.add("actionRequest");
        arrayList.add("priority");
        arrayList.add("position");
        arrayList.add("stateChange");
        arrayList.add("targetConfiguration");
        arrayList.add("versionInfo");
        return arrayList;
    }

    private List<String> getDefaultValuesProductOnClientDisplayfields_netboot() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("productId");
        arrayList.add("installationStatus");
        arrayList.add("installationInfo");
        arrayList.add("actionRequest");
        arrayList.add("versionInfo");
        return arrayList;
    }

    private List<String> produceProductOnClientDisplayfields_netboot() {
        List<String> list = this.getDefaultValuesProductOnClientDisplayfields_netboot();
        List<String> list2 = this.getPossibleValuesProductOnClientDisplayfields_netboot();
        Map<String, Object> map = this.createNOMitem("UnicodeConfig");
        map.put("ident", "configed.productonclient_displayfields_netboot");
        map.put("description", nameRequirementTypeNeutral);
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(list2));
        map.put("editable", false);
        map.put("multiValue", true);
        logging.info(this, "produceProductOnClientDisplayfields_netboot");
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonMap(map)});
        this.exec.doCall(opsiMethodCall);
        return list;
    }

    @Override
    public LinkedHashMap<String, Boolean> getProductOnClients_displayFieldsNetbootProducts() {
        if (this.productOnClients_displayFieldsNetbootProducts == null) {
            Map<String, List> map = this.getConfigDefaultValues();
            List<String> list = map.get("configed.productonclient_displayfields_netboot");
            List list2 = new ArrayList();
            if (this.configOptions.get("configed.productonclient_displayfields_netboot") != null) {
                list2 = (List)this.configOptions.get("configed.productonclient_displayfields_netboot").get("possibleValues");
            }
            if (list == null || !new HashSet<String>(this.getPossibleValuesProductOnClientDisplayfields_netboot()).equals(new HashSet(list2))) {
                list = this.produceProductOnClientDisplayfields_netboot();
            }
            this.productOnClients_displayFieldsNetbootProducts = new LinkedHashMap();
            this.productOnClients_displayFieldsNetbootProducts.put("productId", true);
            this.productOnClients_displayFieldsNetbootProducts.put("productName", list.indexOf("productName") > -1);
            this.productOnClients_displayFieldsNetbootProducts.put("targetConfiguration", false);
            this.productOnClients_displayFieldsNetbootProducts.put("installationStatus", true);
            this.productOnClients_displayFieldsNetbootProducts.put("installationInfo", list.indexOf("installationInfo") > -1);
            this.productOnClients_displayFieldsNetbootProducts.put("actionRequest", true);
            this.productOnClients_displayFieldsNetbootProducts.put("stateChange", list.indexOf("stateChange") > -1);
            this.productOnClients_displayFieldsNetbootProducts.put("versionInfo", true);
        }
        return this.productOnClients_displayFieldsNetbootProducts;
    }

    private List<String> produceHost_displayFields(List<String> list) {
        boolean bl = true;
        ArrayList<String> arrayList = null;
        logging.info(this, "produceHost_displayFields configOptions.get(key) " + this.configOptions.get("configed.host_displayfields"));
        List list2 = null;
        List list3 = null;
        if (this.configOptions.get("configed.host_displayfields") != null) {
            list2 = this.configOptions.get("configed.host_displayfields").getPossibleValues();
            list3 = this.configOptions.get("configed.host_displayfields").getDefaultValues();
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("clientName");
        arrayList2.add("clientDescription");
        arrayList2.add("clientSessionInfo");
        arrayList2.add("clientConnected");
        arrayList2.add("clientLastSeen");
        arrayList2.add("clientIPAddress");
        arrayList2.add("clientHardwareAddress");
        arrayList2.add("clientInventoryNumber");
        arrayList2.add("clientCreated");
        if (list2 == null || !list2.equals(arrayList2)) {
            bl = true;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("clientName");
        arrayList3.add("clientDescription");
        arrayList3.add("clientConnected");
        arrayList3.add("clientLastSeen");
        arrayList3.add("clientIPAddress");
        if (list == null || list.size() == 0) {
            arrayList = arrayList3;
            bl = true;
        } else {
            arrayList = list;
        }
        if (bl) {
            Map<String, Object> map = this.createNOMitem("UnicodeConfig");
            map.put("ident", "configed.host_displayfields");
            map.put("description", nameRequirementTypeNeutral);
            map.put("defaultValues", this.exec.jsonArray(arrayList));
            map.put("possibleValues", this.exec.jsonArray(arrayList2));
            map.put("editable", false);
            map.put("multiValue", true);
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonMap(map)});
            this.exec.doCall(opsiMethodCall);
        }
        return arrayList;
    }

    @Override
    public LinkedHashMap<String, Boolean> getHost_displayFields() {
        if (this.host_displayFields == null) {
            Map<String, List> map = this.getConfigDefaultValues();
            List<String> list = map.get("configed.host_displayfields");
            list = this.produceHost_displayFields(list);
            this.host_displayFields = new LinkedHashMap();
            this.host_displayFields.put("clientName", true);
            this.host_displayFields.put("clientDescription", list.indexOf("clientDescription") > -1);
            this.host_displayFields.put("clientConnected", list.indexOf("clientConnected") > -1);
            this.host_displayFields.put("clientLastSeen", list.indexOf("clientLastSeen") > -1);
            this.host_displayFields.put("clientIPAddress", list.indexOf("clientIPAddress") > -1);
            this.host_displayFields.put("clientHardwareAddress", list.indexOf("clientHardwareAddress") > -1);
            this.host_displayFields.put("clientInventoryNumber", list.indexOf("clientInventoryNumber") > -1);
            this.host_displayFields.put("clientCreated", list.indexOf("clientCreated") > -1);
            this.host_displayFields.put("clientSessionInfo", list.indexOf("clientSessionInfo") > -1);
        }
        return this.host_displayFields;
    }

    @Override
    public List<String> getDisabledClientMenuEntries() {
        this.getConfigOptions();
        return this.configDefaultValues.get("configed.host_actions_disabled");
    }

    @Override
    public List<String> getOpsiclientdExtraEvents() {
        logging.debug(this, "getOpsiclientdExtraEvents");
        this.getConfigOptions();
        ArrayList arrayList = this.configDefaultValues.get("configed.opsiclientd_events");
        logging.debug(this, "getOpsiclientdExtraEvents() " + arrayList);
        if (arrayList == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.opsiclientd_events");
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private Object produceConfigEntry(String string, String string2, Object object, String string3) {
        return this.produceConfigEntry(string, string2, object, string3, true);
    }

    private Object produceConfigEntry(String string, String string2, Object object, String string3, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(object);
        Map<String, Object> map = this.createNOMitem(string);
        map.put("ident", string2);
        map.put("description", string3);
        map.put("defaultValues", this.exec.jsonArray(arrayList2));
        map.put("possibleValues", this.exec.jsonArray(arrayList));
        map.put("editable", bl);
        map.put("multiValue", false);
        return this.exec.jsonMap(map);
    }

    private boolean checkStandardConfigs() {
        boolean bl;
        logging.info(this, "checkStandardConfigs");
        boolean bl2 = bl = this.getConfigOptions() != null;
        if (!bl) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("algorithm1");
        arrayList.add("algorithm2");
        List<String> list = new ArrayList();
        list = this.configDefaultValues.get("product_sort_algorithm");
        logging.info(this, "checkStandardConfigs:  from server product_sort_algorithm " + list);
        Map<String, Object> map = this.createNOMitem("UnicodeConfig");
        map.put("ident", "product_sort_algorithm");
        map.put("description", nameRequirementTypeNeutral);
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(arrayList));
        map.put("editable", false);
        map.put("multiValue", false);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(this.exec.jsonMap(map));
        arrayList = new ArrayList();
        arrayList.add("description");
        arrayList.add("inventoryNumber");
        arrayList.add("notes");
        arrayList.add("ipAddress");
        arrayList.add("lastSeen");
        list = this.configDefaultValues.get("configed.license_inventory_extradisplayfields");
        if (list == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.license_inventory_extradisplayfields");
            list = new ArrayList();
        }
        map = this.createNOMitem("UnicodeConfig");
        map.put("ident", "configed.license_inventory_extradisplayfields");
        map.put("description", configed.getResourceValue("ConfigedMain.Licences.TabLicenceReconciliation.ExtraHostFields"));
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(arrayList));
        map.put("editable", false);
        map.put("multiValue", true);
        arrayList2.add(this.exec.jsonMap(map));
        String string = "ping_linux";
        String string2 = "xterm +hold -e ping %host%";
        String string3 = "ping, started in a Linux environment";
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string, string2, string3));
        arrayList2.add(this.produceConfigEntry("BoolConfig", "configed.remote_control." + string + "." + "editable", true, "(command may be edited)"));
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string + "." + "description", string3, nameRequirementTypeNeutral));
        string = "ping_windows";
        string2 = "cmd.exe /c start ping %host%";
        string3 = "ping, started in a Windows terminal";
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string, string2, string3));
        arrayList2.add(this.produceConfigEntry("BoolConfig", "configed.remote_control." + string + "." + "editable", true, "(command may be edited)"));
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string + "." + "description", string3, nameRequirementTypeNeutral));
        string = "configed.host_actions_disabled";
        list = this.configDefaultValues.get(string);
        if (list == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.host_actions_disabled");
            list = new ArrayList();
            this.configDefaultValues.put(string, list);
        }
        arrayList = new ArrayList();
        arrayList.add("add client");
        arrayList.add("remove client");
        arrayList.add("free licences for client");
        map = this.createNOMitem("UnicodeConfig");
        map.put("id", string);
        map.put("description", nameRequirementTypeNeutral);
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(arrayList));
        map.put("editable", false);
        map.put("multiValue", true);
        arrayList2.add(this.exec.jsonMap(map));
        string = "product_failed";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ \"version\" : \"2\", ");
        stringBuffer.append("\"data\" : {");
        stringBuffer.append(" \"element\" : null, ");
        stringBuffer.append(" \"elementPath\" : null,");
        stringBuffer.append(" \"operation\" : \"SoftwareOperation\", \"dataType\" : null, \"data\" : null, ");
        stringBuffer.append(" \"children\" : [ { \"element\" : \"SoftwareActionResultElement\", \"elementPath\" : [ \"Product\", \"Action Result\" ], \"operation\" : \"StringEqualsOperation\", \"dataType\" : TextType, \"data\" : \"failed\", \"children\" : null } ] ");
        stringBuffer.append("} }");
        String string4 = stringBuffer.toString();
        string3 = "any product failed";
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.saved_search." + string, string4, string3));
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.saved_search." + string + "." + "description", string3, nameRequirementTypeNeutral));
        string = "ping_windows";
        string2 = "cmd.exe /c start ping %host%";
        string3 = "ping, started in a Windows terminal";
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string, string2, string3));
        arrayList2.add(this.produceConfigEntry("BoolConfig", "configed.remote_control." + string + "." + "editable", true, "(command may be edited)"));
        arrayList2.add(this.produceConfigEntry("UnicodeConfig", "configed.remote_control." + string + "." + "description", string3, nameRequirementTypeNeutral));
        string = "configed.host_actions_disabled";
        list = this.configDefaultValues.get(string);
        if (list == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.host_actions_disabled");
            list = new ArrayList();
            this.configDefaultValues.put(string, list);
        }
        arrayList = new ArrayList();
        arrayList.add("add client");
        arrayList.add("remove client");
        map = this.createNOMitem("UnicodeConfig");
        map.put("id", string);
        map.put("description", nameRequirementTypeNeutral);
        map.put("defaultValues", this.exec.jsonArray(list));
        map.put("possibleValues", this.exec.jsonArray(arrayList));
        map.put("editable", false);
        map.put("multiValue", true);
        arrayList2.add(this.exec.jsonMap(map));
        string = "configed.ssh_menu_active";
        list = this.configDefaultValues.get(string);
        if (list == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.ssh_menu_active");
            arrayList2.add(this.produceConfigEntry("BoolConfig", string, false, "de-activate ssh connection to server"));
        }
        if ((list = this.configDefaultValues.get(string = "configed.ssh_shell_active")) == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.ssh_shell_active");
            arrayList2.add(this.produceConfigEntry("BoolConfig", string, false, "de-activate ssh connection (shell) to server"));
        }
        if ((list = this.configDefaultValues.get(string = "configed.ssh_config_active")) == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.ssh_config_active");
            arrayList2.add(this.produceConfigEntry("BoolConfig", string, false, "de-activate ssh connection (config) to server"));
        }
        if ((list = this.configDefaultValues.get(string = "configed.opsiclientd_events")) == null) {
            logging.warning(this, "checkStandardConfigs:  since no values found setting values for  configed.opsiclientd_events");
            list = new ArrayList();
            list.add("on_demand");
            this.configDefaultValues.put(string, list);
            arrayList = new ArrayList();
            arrayList.add("on_demand");
            arrayList.add("silent_install");
            map = this.createNOMitem("UnicodeConfig");
            map = this.createNOMitem("UnicodeConfig");
            map.put("id", string);
            map.put("description", nameRequirementTypeNeutral);
            map.put("defaultValues", this.exec.jsonArray(list));
            map.put("possibleValues", this.exec.jsonArray(arrayList));
            map.put("editable", true);
            map.put("multiValue", true);
            arrayList2.add(this.exec.jsonMap(map));
        }
        OpsiMethodCall opsiMethodCall = new OpsiMethodCall("config_updateObjects", new Object[]{this.exec.jsonArray(arrayList2)});
        this.exec.doCall(opsiMethodCall);
        return true;
    }

    @Override
    public void opsiInformationRequestRefresh() {
        this.opsiInformation = null;
    }

    @Override
    public Date getOpsiExpiresDate() {
        this.retrieveOpsiModules();
        return this.expiresDate;
    }

    @Override
    public Map<String, Object> retrieveOpsiModules() {
        logging.info(this, "retrieveOpsiModules ");
        if (this.opsiInformation == null) {
            OpsiMethodCall opsiMethodCall = new OpsiMethodCall("getOpsiInformation_hash", new String[0]);
            this.opsiInformation = new HashMap();
            this.opsiVersion = nameRequirementTypeNeutral;
            this.opsiModules = new HashMap<String, Object>();
            Map map = new HashMap();
            String string = "expires";
            try {
                logging.info(this, "getOpsiInformation_hash, method signature: " + this.getMethodSignature("getOpsiInformation_hash"));
                if (this.getMethodSignature("getOpsiInformation_hash") != NONE_LIST) {
                    this.opsiInformation = this.exec.getMapResult(opsiMethodCall);
                }
                this.opsiVersion = (String)this.opsiInformation.get("opsiVersion");
                logging.info(this, "opsi version information " + this.opsiVersion);
                final ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    this.opsiModules = this.exec.getMapFromItem(this.opsiInformation.get("modules"));
                    this.opsiModules.remove("signature");
                    logging.info(this, "opsi module information " + this.opsiModules);
                    map = this.exec.getMapFromItem(this.opsiInformation.get("realmodules"));
                    this.getHostInfoCollections().retrieveOpsiHosts();
                    for (Object e : map.keySet()) {
                        try {
                            int n = Integer.valueOf(nameRequirementTypeNeutral + map.get(e));
                            logging.info(this, "retrieveOpsiModules " + e + " , maxClients " + n + " count " + this.hostInfoCollections.getCountClients());
                            if (n <= 0 || n > this.hostInfoCollections.getCountClients()) continue;
                            arrayList.add("Module " + e + ", maximum clients: " + n);
                            int n2 = (int)((double)n * 1.05);
                            if (this.hostInfoCollections.getCountClients() <= n2) continue;
                            this.opsiModules.put((String)e, false);
                        }
                        catch (Exception exception) {
                            logging.info("retrieveOpsiModules " + exception);
                        }
                    }
                    if (arrayList.size() > 0) {
                        SwingUtilities.invokeLater(new Thread(){

                            @Override
                            public void run() {
                                StringBuffer stringBuffer = new StringBuffer(configed.getResourceValue("Permission.modules.clientcount.1"));
                                stringBuffer.append(" (" + OpsiserviceNOMPersistenceController.this.hostInfoCollections.getCountClients() + ") ");
                                stringBuffer.append(configed.getResourceValue("Permission.modules.clientcount.2"));
                                stringBuffer.append(":\n");
                                for (String string : arrayList) {
                                    stringBuffer.append(string);
                                    stringBuffer.append("\n");
                                }
                                logging.info(this, "missingModules " + stringBuffer);
                                JOptionPane.showMessageDialog(de.uib.configed.Globals.mainContainer, stringBuffer.toString(), configed.getResourceValue("Permission.modules.title"), 0);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    logging.logTrace(exception);
                    logging.debugOut(2, "opsi module information does not exist, " + exception);
                }
                if (this.opsiModules.get(string) == null) {
                    this.expiresDate = null;
                } else if (((String)this.opsiModules.get(string)).equals("never")) {
                    this.expiresDate = null;
                } else {
                    Object object = (String)this.opsiModules.get(string);
                    try {
                        if (((String)object).indexOf(32) == -1) {
                            object = (String)object + " 00:00:00";
                        }
                        this.expiresDate = Timestamp.valueOf((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logging.debugOut(1, " not valid date in opsiModules : " + (String)object);
                        this.expiresDate = null;
                    }
                }
                logging.info(this, " missingModulesPermission " + arrayList);
                logging.info(this, " opsiModules " + this.opsiModules);
                this.withLinuxAgent = this.opsiModules.get("linux_agent") != null && (Boolean)this.opsiModules.get("linux_agent") != false;
                this.withLicenceManagement = this.opsiModules.get("license_management") != null && (Boolean)this.opsiModules.get("license_management") != false;
                this.withLocalImaging = this.opsiModules.get("local_imaging") != null && (Boolean)this.opsiModules.get("local_imaging") != false;
                this.withMySQL = this.opsiModules.get("mysql_backend") != null && (Boolean)this.opsiModules.get("mysql_backend") != false;
                this.withUEFI = this.opsiModules.get("uefi") != null && (Boolean)this.opsiModules.get("uefi") != false;
                this.withWAN = this.opsiModules.get("vpn") != null && (Boolean)this.opsiModules.get("vpn") != false;
            }
            catch (Exception exception) {
                logging.debug(this, "Exception " + exception);
            }
        }
        logging.info(this, " withMySQL " + this.withMySQL);
        return this.opsiModules;
    }

    @Override
    public boolean isWithLocalImaging() {
        this.retrieveOpsiModules();
        return this.withLocalImaging;
    }

    @Override
    public boolean isWithMySQL() {
        return this.withMySQL;
    }

    @Override
    public boolean isWithUEFI() {
        return this.withUEFI;
    }

    @Override
    public boolean isWithWAN() {
        return this.withWAN;
    }

    @Override
    public boolean isWithLinuxAgent() {
        return this.withLinuxAgent;
    }

    @Override
    public boolean isWithLicenceManagement() {
        return this.withLicenceManagement;
    }

    @Override
    public String getOpsiVersion() {
        this.retrieveOpsiModules();
        if (this.opsiVersion == null || this.opsiVersion.equals(nameRequirementTypeNeutral)) {
            this.opsiVersion = "< 3.4";
        }
        return this.opsiVersion;
    }

    protected class DefaultHostInfoCollections
    extends HostInfoCollections {
        protected String configServer;
        protected List<String> opsiHostNames;
        protected int countClients = 0;
        protected Map<String, Map<String, Object>> masterDepots;
        protected Map<String, Map<String, Object>> allDepots;
        protected Map<String, Map<String, HostInfo>> depot2_host2hostInfo;
        protected LinkedList<String> depotNamesList;
        protected HashMap<String, Boolean> mapOfPCs;
        protected HashMap<String, HostInfo> mapPC_Infomap;
        protected HashMap<String, HostInfo> host2hostInfo;
        protected HashMap<String, String> mapPcBelongsToDepot;

        DefaultHostInfoCollections(PersistenceController persistenceController) {
        }

        @Override
        public String getConfigServer() {
            return this.configServer;
        }

        protected void checkMapPcBelongsToDepot() {
            if (this.mapPcBelongsToDepot == null) {
                this.mapPcBelongsToDepot = new HashMap();
            }
        }

        @Override
        public Map<String, String> getMapPcBelongsToDepot() {
            this.checkMapPcBelongsToDepot();
            return this.mapPcBelongsToDepot;
        }

        @Override
        protected Map<String, Boolean> getMapOfPCs() {
            return this.mapOfPCs;
        }

        @Override
        public List<String> getOpsiHostNames() {
            this.retrieveOpsiHosts();
            return this.opsiHostNames;
        }

        @Override
        public int getCountClients() {
            return this.countClients;
        }

        @Override
        public Map<String, Map<String, Object>> getDepots() {
            this.retrieveOpsiHosts();
            logging.debug(this, "getDepots masterDepots " + this.masterDepots);
            return this.masterDepots;
        }

        @Override
        public LinkedList<String> getDepotNamesList() {
            this.retrieveOpsiHosts();
            return this.depotNamesList;
        }

        @Override
        public Map<String, Map<String, Object>> getAllDepots() {
            this.retrieveOpsiHosts();
            return this.allDepots;
        }

        @Override
        public Map<String, HostInfo> getMapOfPCInfoMaps() {
            logging.info(this, "getMapOfPCInfoMaps() size " + this.mapPC_Infomap.size());
            return this.mapPC_Infomap;
        }

        @Override
        public Map<String, HostInfo> getMapOfAllPCInfoMaps() {
            logging.info(this, "getMapOfAllPCInfoMaps() size " + this.host2hostInfo.size());
            return this.host2hostInfo;
        }

        @Override
        public void opsiHostsRequestRefresh() {
            this.opsiHostNames = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveOpsiHosts() {
            if (this.opsiHostNames == null) {
                Object object;
                Serializable serializable;
                String string;
                List<Map<String, Object>> list = OpsiserviceNOMPersistenceController.this.HOST_read();
                this.opsiHostNames = new ArrayList<String>();
                this.allDepots = new TreeMap<String, Map<String, Object>>();
                this.masterDepots = new CheckingEntryMapOfMaps();
                this.depotNamesList = new LinkedList();
                this.countClients = list.size();
                this.host2hostInfo = new HashMap();
                for (Map<String, Object> object22 : list) {
                    string = (String)object22.get("id");
                    this.opsiHostNames.add(string);
                    serializable = new HashMap<String, String>();
                    for (String string2 : object22.keySet()) {
                        if (JSONReMapper.isNull(object22.get(string2))) {
                            object22.put(string2, "null");
                        }
                        serializable.put(string2, OpsiserviceNOMPersistenceController.nameRequirementTypeNeutral + object22.get(string2));
                    }
                    if (!object22.get("type").equals("OpsiConfigserver")) continue;
                    logging.info(this, "retrieveOpsiHosts  type opsiconfigserver host " + object22);
                    this.configServer = string;
                    this.depotNamesList.add(string);
                    this.allDepots.put(string, object22);
                    --this.countClients;
                    object = true;
                    try {
                        if (object22.get("isMasterDepot") instanceof Boolean) {
                            object = (Boolean)object22.get("isMasterDepot");
                        } else if (object22.get("isMasterDepot") instanceof Integer) {
                            object = (Integer)object22.get("isMasterDepot") == 1;
                        } else if (object22.get("isMasterDepot") instanceof String) {
                            object = object22.get("isMasterDepot").equals("1");
                        }
                    }
                    catch (Exception exception) {
                        logging.info(this, "retrieveOpsiHosts, exception " + exception);
                    }
                    logging.info(this, "configserver map " + serializable);
                    if (object == null || !((Boolean)object).booleanValue()) continue;
                    this.masterDepots.put(string, (Map<String, Object>)((Object)serializable));
                }
                logging.info(this, "retrieveOpsiHost masterDepots " + this.masterDepots.size());
                this.depot2_host2hostInfo = new TreeMap<String, Map<String, HostInfo>>();
                this.depot2_host2hostInfo.put(this.configServer, new TreeMap());
                for (Map<String, Object> map : list) {
                    string = (String)map.get("id");
                    if (string == null) {
                        logging.info(this, "retrieveOpsiHosts, host  " + map);
                    }
                    if (!map.get("type").equals("OpsiDepotserver")) continue;
                    this.allDepots.put(string, map);
                    --this.countClients;
                    serializable = null;
                    try {
                        if (map.get("isMasterDepot") instanceof Boolean) {
                            serializable = (Boolean)map.get("isMasterDepot");
                        } else if (map.get("isMasterDepot") instanceof Integer) {
                            serializable = Boolean.valueOf((Integer)map.get("isMasterDepot") == 1);
                        }
                    }
                    catch (Exception exception) {
                        logging.info(this, "retrieveOpsiHosts, exception " + exception);
                    }
                    if (serializable == null || !((Boolean)serializable).booleanValue()) continue;
                    object = new HashMap<String, Object>(map);
                    this.masterDepots.put(string, (Map<String, Object>)object);
                    this.depot2_host2hostInfo.put(string, new TreeMap());
                }
                for (Map<String, Object> map : list) {
                    void var7_30;
                    String string3;
                    string = (String)map.get("id");
                    if (!((String)map.get("type")).equals("OpsiClient")) continue;
                    boolean bl = false;
                    object = null;
                    if (OpsiserviceNOMPersistenceController.this.getConfigs().get(string) == null || OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.depot.id") == null || ((List)OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.depot.id")).size() == 0) {
                        logging.debug(this, "retrieveOpsiHosts client  " + string + " has no config for " + "clientconfig.depot.id");
                    } else {
                        object = (String)((List)OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.depot.id")).get(0);
                    }
                    if (object != null && this.masterDepots.keySet().contains(object)) {
                        bl = true;
                    } else if (object != null) {
                        logging.warning("Host " + string + " is in " + (String)object + " which is not a master depot");
                    }
                    logging.debug(this, "getConfigs for " + string);
                    if (OpsiserviceNOMPersistenceController.this.getConfigs().get(string) != null && OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.dhcpd.filename") != null && ((List)OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.dhcpd.filename")).size() > 0 && (string3 = (String)((List)OpsiserviceNOMPersistenceController.this.getConfigs().get(string).get("clientconfig.dhcpd.filename")).get(0)).indexOf("elilo") >= 0) {
                        map.put("uefiBoot", true);
                    }
                    if (OpsiserviceNOMPersistenceController.this.getConfig(string) != null) {
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        boolean bl5;
                        boolean bl6 = true;
                        if (bl6) {
                            bl5 = this.valueFromConfigStateAsExpected(OpsiserviceNOMPersistenceController.this.getConfig(string), "opsiclientd.event_gui_startup.active", PersistenceController.CONFIG_CLIENTD_EVENT_GUISTARTUP_WAN_VALUE);
                        }
                        if (bl5) {
                            bl4 = this.valueFromConfigStateAsExpected(OpsiserviceNOMPersistenceController.this.getConfig(string), "opsiclientd.event_gui_startup{user_logged_in}.active", PersistenceController.CONFIG_CLIENTD_EVENT_GUISTARTUP_USERLOGGEDIN_WAN_VALUE);
                        }
                        if (bl4) {
                            bl3 = this.valueFromConfigStateAsExpected(OpsiserviceNOMPersistenceController.this.getConfig(string), "opsiclientd.event_net_connection.active", PersistenceController.CONFIG_CLIENTD_EVENT_NET_CONNECTION_WAN_VALUE);
                        }
                        if (bl3) {
                            bl2 = this.valueFromConfigStateAsExpected(OpsiserviceNOMPersistenceController.this.getConfig(string), "opsiclientd.event_timer.active", PersistenceController.CONFIG_CLIENTD_EVENT_TIMER_WAN_VALUE);
                        }
                        map.put("wanConfig", bl2);
                    }
                    Object var7_27 = null;
                    if (bl) {
                        map.put("depotId", object);
                        HostInfo hostInfo = new HostInfo(map);
                        this.depot2_host2hostInfo.get(object).put(string, hostInfo);
                    } else {
                        map.put("depotId", this.configServer);
                        HostInfo hostInfo = new HostInfo(map);
                        this.depot2_host2hostInfo.get(this.configServer).put(string, hostInfo);
                    }
                    this.host2hostInfo.put(string, (HostInfo)var7_30);
                }
                for (String string4 : this.masterDepots.keySet()) {
                    logging.info(this, "retrieveOpsiHosts clients in " + string4 + ": " + this.depot2_host2hostInfo.get(string4).size());
                }
                TreeSet<String> treeSet = new TreeSet<String>(this.masterDepots.keySet());
                treeSet.remove(this.configServer);
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.depotNamesList.add(string);
                }
            }
        }

        private Boolean valueFromConfigStateAsExpected(Map<String, Object> map, String string, boolean bl) {
            Object e;
            boolean bl2 = false;
            if (map != null && map.get(string) != null && ((List)map.get(string)).size() > 0 && (e = ((List)map.get(string)).get(0)) instanceof Boolean && (Boolean)e == Boolean.valueOf(bl)) {
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Map<String, Boolean> getPcListForDepots(String[] stringArray) {
            this.retrieveOpsiHosts();
            logging.debug(this, " ------ building pcList");
            this.mapPcBelongsToDepot = new HashMap();
            this.mapOfPCs = new HashMap();
            this.mapPC_Infomap = new HashMap();
            for (String string : stringArray) {
                if (this.depot2_host2hostInfo.get(string) == null) {
                    logging.info(this, "getPcListForDepots depot " + string + " is null");
                    continue;
                }
                for (String string2 : this.depot2_host2hostInfo.get(string).keySet()) {
                    HostInfo hostInfo = this.depot2_host2hostInfo.get(string).get(string2);
                    this.mapOfPCs.put(string2, false);
                    this.mapPC_Infomap.put(string2, hostInfo);
                    this.mapPcBelongsToDepot.put(string2, string);
                }
            }
            return this.mapOfPCs;
        }

        protected void setDepot(String string, String string2) {
            if (OpsiserviceNOMPersistenceController.this.getConfigs().get(string) == null) {
                OpsiserviceNOMPersistenceController.this.getConfigs().put(string, new HashMap());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            OpsiserviceNOMPersistenceController.this.getConfigs().get(string).put("clientconfig.depot.id", arrayList);
            HostInfo hostInfo = this.mapPC_Infomap.get(string);
            logging.info(this, "setDepot, hostinfo for client " + string + " : " + this.mapPC_Infomap.get(string));
            hostInfo.put("depotId", string2);
            String string3 = this.mapPcBelongsToDepot.get(string);
            logging.info(this, "setDepot clientName, oldDepot " + string + ", " + string3);
            this.mapPcBelongsToDepot.put(string, string2);
            this.depot2_host2hostInfo.get(string3).remove(string);
            this.depot2_host2hostInfo.get(string2).put(string, hostInfo);
        }

        @Override
        public void setDepotForClients(String[] stringArray, String string) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            ConfigName2ConfigValue configName2ConfigValue = new ConfigName2ConfigValue(null);
            arrayList.add(string);
            configName2ConfigValue.put("clientconfig.depot.id", arrayList);
            for (n = 0; n < stringArray.length; ++n) {
                OpsiserviceNOMPersistenceController.this.setAdditionalConfiguration(stringArray[n], configName2ConfigValue);
            }
            OpsiserviceNOMPersistenceController.this.setAdditionalConfiguration(false);
            for (n = 0; n < stringArray.length; ++n) {
                this.setDepot(stringArray[n], string);
            }
        }

        @Override
        public void addOpsiHostName(String string) {
            this.opsiHostNames.add(string);
        }

        @Override
        public void updateLocalHostInfo(String string, String string2, Object object) {
            if (this.mapPC_Infomap != null && this.mapPC_Infomap.get(string) != null) {
                this.mapPC_Infomap.get(string).put(string2, object);
                logging.debug(this, "updateLocalHostInfo " + string + " - " + string2 + " : " + object);
            }
        }

        @Override
        public void setLocalHostInfo(String string, String string2, HostInfo hostInfo) {
            logging.debug(this, "setLocalHostInfo  " + string + ", " + string2 + ", " + hostInfo);
            this.mapPC_Infomap.put(string, hostInfo);
            this.depot2_host2hostInfo.get(string2).put(string, hostInfo);
        }

        @Override
        public void intersectWithMapOfPCs(List<String> list) {
            if (list != null) {
                for (String string : list) {
                    if (!this.mapOfPCs.containsKey(string)) continue;
                    this.mapOfPCs.put(string, true);
                }
            }
        }
    }

    protected class CheckingEntryMapOfMaps
    extends LinkedHashMap<String, Map<String, Object>> {
        protected CheckingEntryMapOfMaps() {
        }
    }

    class HostGroups
    extends HashMap<String, Map<String, String>> {
        public HostGroups(Map map) {
            super(map);
        }

        HostGroups addSpecialGroups() {
            logging.debug(this, "addSpecialGroups check");
            Vector<StringValuedRelationElement> vector = new Vector<StringValuedRelationElement>();
            if (this.get(ClientTree.DIRECTORY_PERSISTENT_NAME) == null) {
                logging.debug(this, "addSpecialGroups");
                StringValuedRelationElement stringValuedRelationElement = new StringValuedRelationElement();
                stringValuedRelationElement.put("groupId", ClientTree.DIRECTORY_PERSISTENT_NAME);
                stringValuedRelationElement.put("parentGroupId", null);
                stringValuedRelationElement.put("description", "root of directory");
                OpsiserviceNOMPersistenceController.this.addGroup(stringValuedRelationElement, false);
                vector.add(stringValuedRelationElement);
                this.put(ClientTree.DIRECTORY_PERSISTENT_NAME, stringValuedRelationElement);
                logging.debug(this, "addSpecialGroups we have " + this);
            }
            return this;
        }

        void alterToWorkingVersion() {
            logging.debug(this, "alterToWorkingVersion we have " + this);
            for (String string : this.keySet()) {
                Map map = (Map)this.get(string);
                if (!ClientTree.DIRECTORY_PERSISTENT_NAME.equals(map.get("parentGroupId"))) continue;
                map.put("parentGroupId", ClientTree.DIRECTORY_NAME);
            }
            Map map = (Map)this.get(ClientTree.DIRECTORY_PERSISTENT_NAME);
            if (map != null) {
                map.put("groupId", ClientTree.DIRECTORY_NAME);
            }
            this.put(ClientTree.DIRECTORY_NAME, map);
            this.remove(ClientTree.DIRECTORY_PERSISTENT_NAME);
        }
    }
}

