/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.gui;

import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.IconButton;
import de.uib.utilities.Globals;
import de.uib.utilities.IntComparatorForStrings;
import de.uib.utilities.Mapping;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentToPdf;
import de.uib.utilities.swing.JMenuItemFormatted;
import de.uib.utilities.table.GenTableModel;
import de.uib.utilities.table.JTableWithToolTips;
import de.uib.utilities.table.TableCellRendererByBoolean;
import de.uib.utilities.table.TableCellRendererCurrency;
import de.uib.utilities.table.TableCellRendererDate;
import de.uib.utilities.table.gui.ColorHeaderCellRenderer;
import de.uib.utilities.table.gui.ColorTableCellRenderer;
import de.uib.utilities.table.gui.SearchPane;
import de.uib.utilities.table.gui.StandardTableCellRenderer;
import de.uib.utilities.table.gui.TableCellRendererConfigured;
import de.uib.utilities.table.updates.UpdateController;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultRowSorter;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import utils.PopupMouseListener;

public class PanelGenEditTable
extends JPanel
implements ActionListener,
TableModelListener,
ListSelectionListener,
KeyListener,
MouseListener,
ComponentListener {
    protected Comparator[] comparators;
    protected JScrollPane scrollpane;
    protected JTable theTable;
    protected GenTableModel tableModel;
    protected IconButton buttonCommit;
    protected IconButton buttonCancel;
    protected JLabel label;
    protected JLabel labelRowCount;
    protected JLabel labelMarkedCount;
    protected String textMarkedCount = "selected";
    private JTextField celleditorfield;
    protected Color backgroundColorEditFieldsSelected = Globals.defaultTableCellSelectedBgColor;
    protected Color backgroundColorSelected = Globals.defaultTableCellSelectedBgColorNotEditable;
    protected JPopupMenu popupMenu;
    protected boolean dataChanged = false;
    protected UpdateController myController;
    protected int maxTableWidth = Short.MAX_VALUE;
    protected boolean editing = true;
    protected boolean switchLineColors = true;
    protected boolean awareOfSelectionListener = false;
    protected boolean followSelectionListener = true;
    protected boolean withSearchPane = false;
    protected SearchPane searchPane;
    protected String title = "";
    protected int generalPopupPosition = 0;
    protected int popupIndex = 0;
    private int oldrowcount = -1;
    protected LinkedHashMap<Integer, SortOrder> sortDescriptor;
    protected LinkedHashMap<Integer, SortOrder> specialSortDescriptor;
    protected DocumentToPdf tableToPDF;
    public static final int POPUP_DELETE_ROW = 1;
    public static final int POPUP_SAVE = 2;
    public static final int POPUP_CANCEL = 3;
    public static final int POPUP_RELOAD = 4;
    public static final int POPUP_SORT_AGAIN = 5;
    public static final int POPUP_PRINT = 6;
    public static final int POPUP_EXPORT_EXCEL = 7;
    public static final int POPUP_EXPORT_SELECTED_EXCEL = 8;
    public static final int POPUP_EXPORT_CSV = 9;
    public static final int POPUP_EXPORT_SELECTED_CSV = 10;
    public static final int POPUP_NEW_ROW = 11;
    public static final int POPUP_COPY_ROW = 12;
    public static final int POPUP_FLOATINGCOPY = 13;
    public static final int POPUP_PDF = 14;
    public static final int[] POPUPS_EDITABLE_TABLE = new int[]{11, 12, 1, 2, 3, 8, 7, 4, 5};
    public static final int[] POPUPS_EDITABLE_TABLE_PRINTABLE = new int[]{11, 12, 1, 2, 3, 6, 14, 8, 7, 4, 5};
    public static final int[] POPUPS_NOT_EDITABLE_TABLE = new int[]{8, 7, 4, 5};
    public static final int[] POPUPS_NOT_EDITABLE_TABLE_PRINTABLE = new int[]{6, 14, 8, 7, 4, 5};
    public static final int[] POPUPS_MINIMAL = new int[]{4, 5};
    protected List<Integer> popups;
    JMenuItemFormatted menuItemDeleteRelation;
    JMenuItemFormatted menuItemSave;
    JMenuItemFormatted menuItemCancel;
    JMenuItemFormatted menuItemReload;
    JMenuItemFormatted menuItemSortAgain;
    JMenuItemFormatted menuItemPrint;
    JMenuItemFormatted menuItemExportExcel;
    JMenuItemFormatted menuItemExportSelectedExcel;
    JMenuItemFormatted menuItemExportCSV;
    JMenuItemFormatted menuItemExportSelectedCSV;
    JMenuItemFormatted menuItemNewRow;
    JMenuItemFormatted menuItemCopyRelation;
    JMenuItemFormatted menuItemFloatingCopy;
    JMenuItemFormatted menuItemPDF;
    protected Vector<JMenuItem> menuItemsRequesting1SelectedLine;
    protected Vector<JMenuItem> menuItemsRequestingMultiSelectedLines;
    private boolean separatorAdded = false;

    public PanelGenEditTable(String string, int n, boolean bl, int n2, boolean bl2, int[] nArray, boolean bl3) {
        this.withSearchPane = bl3;
        this.menuItemsRequesting1SelectedLine = new Vector();
        this.menuItemsRequestingMultiSelectedLines = new Vector();
        this.generalPopupPosition = n2;
        if (nArray != null) {
            this.popups = new ArrayList<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                this.popups.add(nArray[i]);
            }
        } else {
            this.popups = new ArrayList<Integer>();
            this.popups.add(4);
            this.popups.add(14);
        }
        if (n > 0) {
            this.maxTableWidth = n;
        }
        if (string != null) {
            this.title = string;
        }
        this.editing = bl;
        if (de.uib.configed.Globals.isReadOnly()) {
            this.editing = false;
        }
        this.switchLineColors = bl2;
        this.initComponents();
        if (n2 == 0) {
            this.addPopupStandard();
        }
    }

    public PanelGenEditTable(String string, int n, boolean bl, int n2, boolean bl2, int[] nArray) {
        this(string, n, bl, n2, bl2, nArray, false);
    }

    public PanelGenEditTable(String string, int n, boolean bl, int n2, boolean bl2) {
        this(string, n, bl, n2, bl2, null);
    }

    public PanelGenEditTable(String string, int n, boolean bl, int n2) {
        this(string, n, bl, n2, false);
    }

    public PanelGenEditTable(String string, int n, boolean bl) {
        this(string, n, bl, 0);
    }

    public PanelGenEditTable(String string, int n) {
        this(string, n, true);
    }

    public PanelGenEditTable(int n) {
        this("", n);
    }

    public PanelGenEditTable() {
        this(0);
    }

    protected Object modifyHeaderValue(Object object) {
        return object;
    }

    @Override
    public void requestFocus() {
        if (this.theTable != null) {
            this.theTable.requestFocus();
        }
        if (this.withSearchPane) {
            this.searchPane.requestFocus();
        }
    }

    public void setAutoResizeMode(int n) {
        this.theTable.setAutoResizeMode(n);
    }

    public void setUpdateController(UpdateController updateController) {
        this.myController = updateController;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getListSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getListSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    protected void initComponents() {
        this.setBackground(Globals.backgroundWhite);
        this.addComponentListener(this);
        this.buttonCommit = new IconButton(configed.getResourceValue("PanelGenEditTable.SaveButtonTooltip"), "images/apply.png", "images/apply_over.png", "images/apply_disabled.png");
        this.buttonCommit.setPreferredSize(Globals.smallButtonDimension);
        if (!this.editing) {
            this.buttonCommit.setVisible(false);
        }
        this.buttonCancel = new IconButton(configed.getResourceValue("PanelGenEditTable.CancelButtonTooltip"), "images/cancel.png", "images/cancel_over.png", "images/cancel_disabled.png");
        this.buttonCancel.setPreferredSize(Globals.smallButtonDimension);
        if (!this.editing) {
            this.buttonCancel.setVisible(false);
        }
        this.buttonCommit.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.setDataChanged(false);
        this.label = new JLabel(this.title);
        this.label.setFont(Globals.defaultFontStandardBold);
        if (this.title == null || this.title.equals("")) {
            this.label.setVisible(false);
        }
        this.labelRowCount = new JLabel(this.title);
        this.labelRowCount.setFont(Globals.defaultFontStandardBold);
        this.labelMarkedCount = new JLabel("");
        this.labelMarkedCount.setFont(Globals.defaultFontStandard);
        this.theTable = new JTableWithToolTips();
        this.searchPane = new SearchPane(this.theTable, true);
        this.searchPane.setVisible(this.withSearchPane);
        this.theTable.getTableHeader().addMouseListener(this);
        this.scrollpane = new JScrollPane();
        if (this.switchLineColors) {
            this.theTable.setDefaultRenderer(Object.class, new StandardTableCellRenderer());
        } else {
            this.theTable.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        }
        this.theTable.addMouseListener(this);
        this.theTable.setShowHorizontalLines(true);
        this.theTable.setGridColor(Color.WHITE);
        this.theTable.getTableHeader().setDefaultRenderer(new ColorHeaderCellRenderer(this.theTable.getTableHeader().getDefaultRenderer()){

            @Override
            protected Object modifyValue(Object object) {
                return PanelGenEditTable.this.modifyHeaderValue(object);
            }
        });
        this.theTable.setSelectionMode(0);
        this.theTable.getTableHeader().setReorderingAllowed(false);
        this.theTable.addKeyListener(this);
        this.getListSelectionModel().addListSelectionListener(this);
        this.theTable.setDragEnabled(true);
        this.theTable.setDropMode(DropMode.ON);
        this.theTable.setAutoCreateRowSorter(false);
        this.scrollpane = new JScrollPane();
        this.scrollpane.setViewportView(this.theTable);
        this.scrollpane.getViewport().setBackground(Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.label, -2, -2, -2)).addComponent(this.searchPane, -2, -2, Short.MAX_VALUE).addComponent(this.scrollpane, -1, 100, this.maxTableWidth).addGroup(groupLayout.createSequentialGroup().addComponent(this.buttonCommit, -2, -2, -2).addGap(10, 10, 10).addComponent(this.buttonCancel, -2, -2, -2))).addGap(5, 5, 5)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.label).addGap(5, 5, 5).addComponent(this.searchPane).addGap(5, 5, 5).addComponent(this.scrollpane, 20, 100, Short.MAX_VALUE).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCommit, -2, -2, -2).addGap(10, 10, 10).addComponent(this.buttonCancel, -2, -2, -2)).addGap(5, 5, 5)));
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.theTable.setColumnSelectionAllowed(bl);
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.theTable.setRowSelectionAllowed(bl);
    }

    public void sortAgainAsConfigured() {
        logging.debug(this, "sortAgainAsConfigured " + this.specialSortDescriptor);
        if (this.specialSortDescriptor != null && this.specialSortDescriptor.size() > 0) {
            this.sortDescriptor = this.specialSortDescriptor;
        }
        if (this.sortDescriptor != null && this.sortDescriptor.size() > 0) {
            int n = this.getSelectedRow();
            Object object = null;
            if (n > -1 && this.tableModel.getKeyCol() > -1) {
                object = this.tableModel.getValueAt(this.theTable.convertRowIndexToModel(n), this.tableModel.getKeyCol());
            }
            this.setSortOrder(this.sortDescriptor);
            ((DefaultRowSorter)this.getRowSorter()).sort();
            this.setSorter();
            if (object != null) {
                int n2 = this.findViewRowFromValue(object, this.tableModel.getKeyCol());
                this.moveToRow(n2);
                this.setSelectedRow(n2);
            }
        }
    }

    public void requestReload() {
        this.tableModel.requestReload();
    }

    public void reset() {
        this.tableModel.reset();
    }

    public void reload() {
        logging.info(this, "reload()");
        WaitCursor waitCursor = new WaitCursor(this);
        this.tableModel.requestReload();
        this.tableModel.reset();
        this.setDataChanged(false);
        waitCursor.stop();
    }

    public void setTitle(String string) {
        logging.info(this, "setTitle " + string);
        this.title = string;
        this.label.setText(string);
    }

    protected void addPopupStandard() {
        if (this.generalPopupPosition > 0) {
            this.popupMenu.addSeparator();
        }
        for (int n : this.popups) {
            switch (n) {
                case 2: {
                    this.menuItemSave = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.saveData"));
                    this.menuItemSave.setEnabled(false);
                    this.menuItemSave.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelGenEditTable.this.commit();
                        }
                    });
                    this.addPopupItem(this.menuItemSave);
                    break;
                }
                case 3: {
                    this.menuItemCancel = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.abandonNewData"));
                    this.menuItemCancel.setEnabled(false);
                    this.menuItemCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelGenEditTable.this.cancel();
                        }
                    });
                    this.addPopupItem(this.menuItemCancel);
                    break;
                }
                case 4: {
                    this.menuItemReload = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.reload"), de.uib.configed.Globals.createImageIcon("images/reload16.png", ""));
                    this.menuItemReload.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelGenEditTable.this.reload();
                        }
                    });
                    if (this.popupIndex > 1) {
                        this.popupMenu.addSeparator();
                    }
                    this.addPopupItem(this.menuItemReload);
                    break;
                }
                case 5: {
                    this.menuItemSortAgain = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.sortAsConfigured"));
                    this.menuItemSortAgain.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelGenEditTable.this.sortAgainAsConfigured();
                        }
                    });
                    this.addPopupItem(this.menuItemSortAgain);
                    break;
                }
                case 1: {
                    this.menuItemDeleteRelation = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.deleteRow"));
                    this.menuItemDeleteRelation.setEnabled(false);
                    this.menuItemDeleteRelation.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (PanelGenEditTable.this.getSelectedRowCount() == 0) {
                                JOptionPane.showMessageDialog(de.uib.configed.Globals.mainContainer, configed.getResourceValue("PanelGenEditTable.noRowSelected"), configed.getResourceValue("ConfigedMain.Licences.hint.title"), 0);
                                return;
                            }
                            PanelGenEditTable.this.tableModel.deleteRow(PanelGenEditTable.this.getSelectedRowInModelTerms());
                        }
                    });
                    this.addPopupItem(this.menuItemDeleteRelation);
                    break;
                }
                case 6: {
                    this.menuItemPrint = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.print"));
                    this.menuItemPrint.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                PanelGenEditTable.this.theTable.print();
                            }
                            catch (Exception exception) {
                                logging.debugOut(1, "printing error " + exception);
                            }
                        }
                    });
                    this.addPopupItem(this.menuItemPrint);
                    break;
                }
                case 13: {
                    this.menuItemFloatingCopy = new JMenuItemFormatted(configed.getResourceValue("PanelGenEditTable.floatingCopy"));
                    this.menuItemFloatingCopy.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelGenEditTable.this.floatExternal();
                        }
                    });
                    if (this.popupIndex > 1) {
                        this.popupMenu.addSeparator();
                    }
                    this.addPopupItem(this.menuItemFloatingCopy);
                    break;
                }
                case 14: {
                    this.menuItemPDF = new JMenuItemFormatted(configed.getResourceValue("FGeneralDialog.pdf"), de.uib.configed.Globals.createImageIcon("images/acrobat_reader16.png", ""));
                    this.menuItemPDF.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                hashMap.put("header", PanelGenEditTable.this.title);
                                hashMap.put("subject", "report of table");
                                hashMap.put("keywords", "");
                                PanelGenEditTable.this.tableToPDF = new DocumentToPdf(null, hashMap);
                                PanelGenEditTable.this.tableToPDF.createContentElement("table", PanelGenEditTable.this.theTable);
                                PanelGenEditTable.this.tableToPDF.setPageSizeA4_Landscape();
                                PanelGenEditTable.this.tableToPDF.toPDF();
                            }
                            catch (Exception exception) {
                                logging.debugOut(1, "pdf printing error " + exception);
                            }
                        }
                    });
                    this.addPopupItem(this.menuItemPDF);
                }
            }
        }
    }

    public void addPopupItem(JMenuItem jMenuItem) {
        if (jMenuItem == null) {
            return;
        }
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.theTable.addMouseListener(new PopupMouseListener(this.popupMenu));
            this.scrollpane.addMouseListener(new PopupMouseListener(this.popupMenu));
        }
        this.popupMenu.add(jMenuItem);
        ++this.popupIndex;
        if (this.popupIndex == this.generalPopupPosition) {
            this.addPopupStandard();
        }
    }

    public void setSortOrder(LinkedHashMap<Integer, SortOrder> linkedHashMap) {
        this.sortDescriptor = linkedHashMap;
    }

    protected List<RowSorter.SortKey> buildSortkeysFromColumns() {
        logging.debug(this, "buildSortkeysFromColumns,  sortDescriptor " + this.sortDescriptor);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        if (this.tableModel.getColumnCount() == 0) {
            return null;
        }
        if (this.sortDescriptor == null) {
            this.sortDescriptor = new LinkedHashMap();
            if (this.tableModel.getKeyCol() > -1) {
                try {
                    arrayList.add(new RowSorter.SortKey(this.tableModel.getKeyCol(), SortOrder.ASCENDING));
                    this.sortDescriptor.put(this.tableModel.getKeyCol(), SortOrder.ASCENDING);
                }
                catch (Exception exception) {
                    logging.debug(this, "sortkey problem " + exception);
                }
            } else if (this.tableModel.getFinalCols() != null && this.tableModel.getFinalCols().size() > 0) {
                for (Integer n : this.tableModel.getFinalCols()) {
                    arrayList.add(new RowSorter.SortKey(n, SortOrder.ASCENDING));
                    this.sortDescriptor.put(n, SortOrder.ASCENDING);
                }
            } else {
                arrayList = null;
            }
        } else {
            for (Integer n : this.sortDescriptor.keySet()) {
                arrayList.add(new RowSorter.SortKey(n, this.sortDescriptor.get(n)));
            }
        }
        return arrayList;
    }

    private void setSorter() {
        logging.info(this, "setSorter");
        if (this.tableModel == null) {
            return;
        }
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>((TableModel)this.tableModel){

            @Override
            protected boolean useToString(int n) {
                try {
                    return super.useToString(n);
                }
                catch (Exception exception) {
                    logging.info(this, "column " + n + " ------------------- no way to string");
                    return false;
                }
            }

            @Override
            public Comparator<?> getComparator(int n) {
                try {
                    logging.debug(this, " comparator for col " + n + " is " + super.getComparator(n));
                    return super.getComparator(n);
                }
                catch (Exception exception) {
                    logging.warning(this, "column " + n + " ------------------- not getting comparator ");
                    return null;
                }
            }
        };
        if (tableRowSorter instanceof DefaultRowSorter) {
            for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                if (this.comparators[i] != null) {
                    tableRowSorter.setComparator(i, this.comparators[i]);
                    continue;
                }
                if (!this.tableModel.getClassNames().get(i).equals("java.lang.Integer")) continue;
                tableRowSorter.setComparator(i, new IntComparatorForStrings());
            }
        }
        this.theTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
        List<RowSorter.SortKey> list = this.buildSortkeysFromColumns();
        if (list != null && list.size() > 0) {
            tableRowSorter.setSortKeys(list);
        }
    }

    public void setTableModel(GenTableModel genTableModel) {
        this.theTable.setRowSorter(null);
        this.theTable.setModel(genTableModel);
        this.tableModel = genTableModel;
        this.comparators = new Comparator[genTableModel.getColumnCount()];
        this.setSorter();
        this.setDataChanged(false);
        this.setCellRenderers();
    }

    public void setComparator(String string, Comparator comparator) {
        int n = this.tableModel.getColumnNames().indexOf(string);
        if (n < 0) {
            logging.warning(this, "invalid column name");
            return;
        }
        DefaultRowSorter defaultRowSorter = (DefaultRowSorter)this.theTable.getRowSorter();
        if (defaultRowSorter == null) {
            logging.warning(this, "no sorter");
        }
        defaultRowSorter.setComparator(n, comparator);
    }

    public void setSearchColumns(Integer[] integerArray) {
        if (!this.withSearchPane) {
            logging.debug(this, "setSearchColumns: no search panel");
            return;
        }
        this.searchPane.setSearchFields(integerArray);
    }

    public void setSearchColumnsAll() {
        if (!this.withSearchPane) {
            logging.debug(this, "setSearchColumns: no search panel");
            return;
        }
        this.searchPane.setSearchFieldsAll();
    }

    public void setSearchMode(int n) {
        this.searchPane.setSearchMode(n);
    }

    public void setSearchSelectMode(boolean bl) {
        this.searchPane.setSelectMode(bl);
    }

    public void setMapping(String string, Mapping<Integer, String> mapping) {
        this.searchPane.setMapping(string, mapping);
    }

    public void setSelectedSearchField(String string) {
        this.searchPane.setSelectedSearchField(string);
    }

    public void setEmphasizedColumns(int[] nArray) {
        if (nArray == null) {
            return;
        }
        if (this.theTable.getColumnModel().getColumns().hasMoreElements()) {
            for (int i = 0; i < nArray.length; ++i) {
                this.theTable.getColumnModel().getColumn(nArray[i]).setCellRenderer(new TableCellRendererConfigured(null, Globals.lightBlack, Globals.defaultTableCellBgColor1, Globals.defaultTableCellBgColor2, this.backgroundColorSelected, this.backgroundColorEditFieldsSelected));
            }
        }
    }

    protected void setTimestampRenderer(String string, TableColumn tableColumn) {
        if (string.equals("java.sql.Timestamp")) {
            tableColumn.setCellRenderer(new TableCellRendererDate());
        }
    }

    protected void setBigDecimalRenderer(String string, TableColumn tableColumn) {
        if (string.equals("java.math.BigDecimal")) {
            tableColumn.setCellRenderer(new TableCellRendererCurrency());
        }
    }

    protected void setBooleanRenderer(String string, TableColumn tableColumn) {
        if (string.equals("java.lang.Boolean")) {
            tableColumn.setCellRenderer(new TableCellRendererByBoolean());
        }
    }

    protected void setCellRenderers() {
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            Class<?> clazz = this.tableModel.getColumnClass(i);
            String string = this.tableModel.getColumnName(i);
            TableColumn tableColumn = this.theTable.getColumn(string);
            String string2 = this.tableModel.getClassNames().get(i);
            this.setTimestampRenderer(string2, tableColumn);
            this.setBigDecimalRenderer(string2, tableColumn);
            this.setBooleanRenderer(string2, tableColumn);
        }
    }

    public void setDataChanged(boolean bl) {
        this.dataChanged = bl;
        this.buttonCommit.setEnabled(bl);
        if (this.menuItemSave != null) {
            this.menuItemSave.setEnabled(bl);
        }
        this.buttonCancel.setEnabled(bl);
        if (this.menuItemCancel != null) {
            this.menuItemCancel.setEnabled(bl);
        }
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void stopCellEditing() {
        if (this.theTable.getCellEditor() != null) {
            logging.info(this, "we are editing a cell");
            this.theTable.getCellEditor().stopCellEditing();
        } else {
            logging.info(this, "no cell editing");
        }
    }

    protected void commit() {
        this.stopCellEditing();
        if (this.myController == null) {
            return;
        }
        if (this.myController.saveChanges()) {
            this.setDataChanged(false);
        }
    }

    protected void cancel() {
        if (this.myController == null) {
            return;
        }
        if (this.myController.cancelChanges()) {
            this.setDataChanged(false);
        }
    }

    protected void deleteCurrentRow() {
        if (this.getSelectedRowCount() > 0) {
            this.tableModel.deleteRow(this.getSelectedRowInModelTerms());
        }
    }

    public void setTableColumnInvisible(int n) {
        TableColumn tableColumn = null;
        try {
            tableColumn = this.theTable.getColumnModel().getColumn(n);
        }
        catch (Exception exception) {
            logging.info(this, "setTableColumnInvisible  " + exception);
        }
        if (tableColumn != null) {
            logging.info(this, "setTableColumnInvisible col " + n);
            tableColumn.setWidth(0);
            tableColumn.setMaxWidth(100);
            tableColumn.setMinWidth(0);
            tableColumn.setPreferredWidth(0);
            tableColumn.setResizable(true);
            this.theTable.getTableHeader().resizeAndRepaint();
        }
    }

    public JTable getTheTable() {
        return this.theTable;
    }

    public GenTableModel getTableModel() {
        return this.tableModel;
    }

    public TableColumnModel getColumnModel() {
        return this.theTable.getColumnModel();
    }

    public ListSelectionModel getListSelectionModel() {
        return this.theTable.getSelectionModel();
    }

    public void setListSelectionMode(int n) {
        this.theTable.setSelectionMode(n);
    }

    public int getSelectedRowCount() {
        return this.theTable.getSelectedRowCount();
    }

    public int getSelectedRow() {
        return this.theTable.getSelectedRow();
    }

    public void setSelectedRow(int n) {
        this.theTable.setRowSelectionInterval(n, n);
        this.showSelectedRow();
    }

    public void showSelectedRow() {
        int n = this.getSelectedRow();
        if (n != -1) {
            this.theTable.scrollRectToVisible(this.theTable.getCellRect(n, 0, false));
        }
    }

    public int getSelectedRowInModelTerms() {
        return this.theTable.convertRowIndexToModel(this.theTable.getSelectedRow());
    }

    public void setSelectedRowFromModel(int n) {
        this.theTable.setRowSelectionInterval(this.theTable.convertRowIndexToView(n), this.theTable.convertRowIndexToView(n));
        this.theTable.scrollRectToVisible(this.theTable.getCellRect(this.theTable.convertRowIndexToView(n), 0, true));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.theTable.convertRowIndexToModel(n), this.theTable.convertColumnIndexToModel(n2));
    }

    public Object getValueAt(int n, int n2) {
        try {
            return this.tableModel.getValueAt(this.theTable.convertRowIndexToModel(n), this.theTable.convertColumnIndexToModel(n2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void selectedRowChanged() {
    }

    public void setAwareOfSelectionListener(boolean bl) {
        this.awareOfSelectionListener = bl;
    }

    public List<String> getSelectedKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tableModel.getKeyCol() < 0) {
            return arrayList;
        }
        for (int i = 0; i < this.theTable.getSelectedRows().length; ++i) {
            arrayList.add(this.tableModel.getValueAt(this.theTable.convertRowIndexToModel(this.theTable.getSelectedRows()[i]), this.tableModel.getKeyCol()).toString());
        }
        return arrayList;
    }

    public void setSelectedValues(List<String> list, int n) {
        this.getListSelectionModel().clearSelection();
        if (list == null || list.size() == 0) {
            return;
        }
        this.setListSelectionMode(2);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = this.findViewRowFromValue(iterator.next(), n);
            this.getListSelectionModel().addSelectionInterval(n2, n2);
        }
    }

    protected int findViewRowFromValue(int n, Object object, int n2) {
        logging.debug(this, "findViewRowFromValue startviewrow, value, col " + n + ", " + object + ", " + n2);
        if (object == null) {
            return -1;
        }
        String string = object.toString();
        boolean bl = false;
        int n3 = 0;
        if (n > 0) {
            n3 = n;
        }
        while (!bl && n3 < this.tableModel.getRowCount()) {
            Object object2 = this.tableModel.getValueAt(this.theTable.convertRowIndexToModel(n3), n2);
            if (object2 == null) {
                if (string == null || string.equals("")) {
                    bl = true;
                }
            } else {
                String string2 = object2.toString();
                if (string.equals(string2)) {
                    bl = true;
                }
            }
            if (bl) continue;
            ++n3;
        }
        if (bl) {
            return n3;
        }
        return -1;
    }

    public int findViewRowFromValue(Object object, int n) {
        return this.findViewRowFromValue(0, object, n);
    }

    public boolean moveToValue(String string, int n) {
        return this.moveToValue(string, n, true);
    }

    public boolean moveToValue(String string, int n, boolean bl) {
        logging.info(this, "moveToValue " + string + " col " + n + " selecting " + bl);
        int n2 = this.findViewRowFromValue(string, n);
        this.theTable.scrollRectToVisible(this.theTable.getCellRect(n2, n, false));
        if (n2 == -1) {
            return false;
        }
        if (bl) {
            this.setSelectedRow(n2);
        }
        return true;
    }

    public boolean moveToKeyValue(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        if (this.tableModel.getKeyCol() > -1) {
            bl = this.moveToValue(string, this.tableModel.getKeyCol());
        } else {
            int n = 0;
            while (!bl && n < this.tableModel.getRowCount()) {
                String[] stringArray = new String[this.tableModel.getFinalCols().size()];
                for (int i = 0; i < this.tableModel.getFinalCols().size(); ++i) {
                    stringArray[i] = this.tableModel.getValueAt(this.theTable.convertRowIndexToModel(n), this.tableModel.getFinalCols().get(i)).toString();
                }
                if (string.equals(Globals.pseudokey(stringArray))) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                this.setSelectedRow(n);
            } else {
                bl = this.moveToValue(string, 0);
            }
        }
        return bl;
    }

    public void moveToRow(int n) {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        if (this.getSelectedRowCount() != 1) {
            return;
        }
        if (n < 0 || n >= this.theTable.getRowCount()) {
            return;
        }
        this.theTable.scrollRectToVisible(this.theTable.getCellRect(n, 0, true));
        this.theTable.setRowSelectionInterval(n, n);
    }

    public void moveToModelRow(int n) {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        if (this.getSelectedRowCount() != 1) {
            return;
        }
        if (n < 0 || n >= this.theTable.getRowCount()) {
            return;
        }
        this.theTable.scrollRectToVisible(this.theTable.getCellRect(this.theTable.convertRowIndexToView(n), 0, true));
        this.theTable.setRowSelectionInterval(this.theTable.convertRowIndexToView(n), this.theTable.convertRowIndexToView(n));
    }

    public boolean canNavigate() {
        return this.tableModel.getRowCount() > 0 && this.getSelectedRowCount() == 1;
    }

    public boolean isFirstRow() {
        return this.getSelectedRow() == 0;
    }

    public boolean isLastRow() {
        return this.getSelectedRow() == this.tableModel.getRowCount() - 1;
    }

    public void moveToLastRow() {
        this.moveToRow(this.tableModel.getRowCount() - 1);
    }

    public void moveToFirstRow() {
        this.moveToRow(0);
    }

    public void moveRowBy(int n) {
        if (this.getSelectedRowCount() != 1) {
            return;
        }
        int n2 = this.theTable.getSelectedRow();
        if (n > 0) {
            if (n2 + n < this.theTable.getRowCount()) {
                n2 += n;
            }
        } else if (n < 0 && n2 + n >= 0) {
            n2 += n;
        }
        this.moveToRow(n2);
    }

    public RowSorter getRowSorter() {
        return this.theTable.getRowSorter();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setDataChanged(true);
        if (this.tableModel != null && this.oldrowcount != this.tableModel.getRowCount()) {
            this.oldrowcount = this.tableModel.getRowCount();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonCommit) {
            this.commit();
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.cancel();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.theTable && keyEvent.getKeyCode() == 127) {
            this.deleteCurrentRow();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (this.awareOfSelectionListener) {
            this.setDataChanged(true);
        }
        if (listSelectionModel.isSelectionEmpty()) {
            logging.debug(this, "no rows selected");
            if (this.menuItemDeleteRelation != null) {
                this.menuItemDeleteRelation.setEnabled(false);
            }
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            if (this.followSelectionListener) {
                this.selectedRowChanged();
            }
            if (this.menuItemDeleteRelation != null) {
                this.menuItemDeleteRelation.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.showSelectedRow();
    }

    protected void floatExternal() {
        PanelGenEditTable panelGenEditTable = new PanelGenEditTable(this.title, this.maxTableWidth, false);
        panelGenEditTable.setTableModel(this.tableModel);
        GeneralFrame generalFrame = new GeneralFrame(null, "hallo", false);
        generalFrame.addPanel(panelGenEditTable);
        generalFrame.setup();
        generalFrame.setSize(this.getSize());
        generalFrame.centerOn(de.uib.configed.Globals.mainFrame);
        generalFrame.setVisible(true);
    }
}

