/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.type.ConfigOption;
import de.uib.configed.type.HWAuditClientEntry;
import de.uib.configed.type.OpsiPackage;
import de.uib.configed.type.OpsiProductInfo;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.configed.type.SWAuditEntry;
import de.uib.configed.type.licences.AuditSoftwareXLicencePool;
import de.uib.configed.type.licences.LicenceContractEntry;
import de.uib.configed.type.licences.LicenceEntry;
import de.uib.configed.type.licences.LicencePoolXOpsiProduct;
import de.uib.configed.type.licences.LicenceUsableForEntry;
import de.uib.configed.type.licences.LicenceUsageEntry;
import de.uib.configed.type.licences.LicencepoolEntry;
import de.uib.configed.type.licences.Table_LicenceContracts;
import de.uib.opsicommand.JSONReMapper;
import de.uib.opsidatamodel.DataStub;
import de.uib.opsidatamodel.Object2Product2VersionList;
import de.uib.opsidatamodel.OpsiserviceNOMPersistenceController;
import de.uib.opsidatamodel.productstate.ActionRequest;
import de.uib.utilities.Globals;
import de.uib.utilities.logging.TimeCheck;
import de.uib.utilities.logging.logging;
import de.uib.utilities.table.ListCellOptions;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.json.JSONArray;

public class DataStubNOM
extends DataStub {
    OpsiserviceNOMPersistenceController controller;
    protected Map<String, Map<String, OpsiProductInfo>> product2versionInfo2infos;
    protected Object2Product2VersionList depot2LocalbootProducts;
    protected Object2Product2VersionList depot2NetbootProducts;
    protected Vector<Vector<Object>> productRows;
    protected Map<String, TreeSet<OpsiPackage>> depot2Packages;
    protected Map<String, Map<String, List<String>>> product2VersionInfo2Depots;
    protected Map<String, Map<String, Map<String, ListCellOptions>>> depot2Product2PropertyDefinitions;
    protected Map<String, Map<String, List<Map<String, String>>>> depot2product2dependencyInfos;
    protected List<Map<String, Object>> productPropertyStates;
    protected List<Map<String, Object>> productPropertyDepotStates;
    protected Set<String> hostsWithProductProperties;
    protected TreeMap<String, List<HWAuditClientEntry>> client2hwAuditHostEntries;
    protected TreeMap<String, Map<String, List<HWAuditClientEntry>>> client2hwType2hwAuditHostEntries;
    protected TreeMap<String, SWAuditEntry> installedSoftwareInformation;
    protected LinkedList<String> softwareList;
    protected List<Map<String, Object>> softwareAuditOnClients;
    protected Map<String, List<SWAuditClientEntry>> client2software;
    protected Map<String, Set<String>> softwareIdent2clients;
    protected Time SOFTWARE_CONFIG_last_entry = null;
    protected AuditSoftwareXLicencePool auditSoftwareXLicencePool;
    protected Map<String, Map<String, Object>> hostConfigs;
    protected Time CONFIG_STATE_last_entry = null;
    protected TreeMap<String, LicencepoolEntry> licencepools;
    protected Map<String, LicenceContractEntry> licenceContracts;
    protected Table_LicenceContracts tableLicenceContracts;
    protected Map<String, LicenceEntry> licences;
    protected List<LicenceUsableForEntry> licenceUsabilities;
    protected List<LicenceUsageEntry> licenceUsages;
    protected LicencePoolXOpsiProduct licencePoolXOpsiProduct;

    public DataStubNOM(OpsiserviceNOMPersistenceController opsiserviceNOMPersistenceController) {
        this.controller = opsiserviceNOMPersistenceController;
    }

    @Override
    public void productDataRequestRefresh() {
        this.product2versionInfoRequestRefresh();
        this.productsAllDepotsRequestRefresh();
        this.productPropertyDefinitionsRequestRefresh();
        this.productPropertyStatesRequestRefresh();
        this.productPropertyDepotStatesRequestRefresh();
        this.productDependenciesRequestRefresh();
    }

    @Override
    public boolean test() {
        return true;
    }

    @Override
    public void product2versionInfoRequestRefresh() {
        this.product2versionInfo2infos = null;
    }

    @Override
    public Map<String, Map<String, OpsiProductInfo>> getProduct2versionInfo2infos() {
        this.retrieveProductInfos();
        return this.product2versionInfo2infos;
    }

    protected void retrieveProductInfos() {
        if (this.product2versionInfo2infos == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : OpsiPackage.SERVICE_KEYS) {
                arrayList.add(object2);
            }
            arrayList.remove("productId");
            arrayList.add("id");
            for (String string : ActionRequest.getScriptKeys()) {
                arrayList.add(string);
            }
            arrayList.add("userLoginScript");
            arrayList.add("priority");
            arrayList.remove("productType");
            arrayList.add("advice");
            arrayList.add("name");
            arrayList.add("description");
            String[] stringArray = arrayList.toArray(new String[0]);
            logging.debug(this, "retrieveProductInfos callAttributes " + Arrays.asList(stringArray));
            HashMap hashMap = new HashMap();
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " product");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "product_getObjects");
            this.product2versionInfo2infos = new HashMap<String, Map<String, OpsiProductInfo>>();
            for (Map<String, Object> map : list) {
                String string = "" + map.get("id");
                String string2 = OpsiPackage.produceVersionInfo("" + map.get("productVersion"), "" + map.get("packageVersion"));
                OpsiProductInfo opsiProductInfo = new OpsiProductInfo(map);
                Map<String, OpsiProductInfo> map2 = this.product2versionInfo2infos.get(string);
                if (map2 == null) {
                    map2 = new HashMap<String, OpsiProductInfo>();
                    this.product2versionInfo2infos.put(string, map2);
                }
                map2.put(string2, opsiProductInfo);
            }
            logging.debug(this, "retrieveProductInfos " + this.product2versionInfo2infos);
            this.controller.notifyDataRefreshedObservers("product");
        }
    }

    @Override
    public void productsAllDepotsRequestRefresh() {
        this.depot2LocalbootProducts = null;
    }

    @Override
    public Map<String, TreeSet<OpsiPackage>> getDepot2Packages() {
        this.retrieveProductsAllDepots();
        return this.depot2Packages;
    }

    @Override
    public Vector<Vector<Object>> getProductRows() {
        this.retrieveProductsAllDepots();
        return this.productRows;
    }

    @Override
    public Map<String, Map<String, List<String>>> getProduct2VersionInfo2Depots() {
        this.retrieveProductsAllDepots();
        return this.product2VersionInfo2Depots;
    }

    @Override
    public Object2Product2VersionList getDepot2LocalbootProducts() {
        this.retrieveProductsAllDepots();
        return this.depot2LocalbootProducts;
    }

    @Override
    public Object2Product2VersionList getDepot2NetbootProducts() {
        this.retrieveProductsAllDepots();
        return this.depot2NetbootProducts;
    }

    protected void retrieveProductsAllDepots() {
        logging.debug(this, "retrieveProductsAllDepots ? depot2LocalbootProducts " + this.depot2LocalbootProducts + "\n" + "depot2NetbootProducts " + this.depot2NetbootProducts);
        this.retrieveProductInfos();
        if (this.depot2NetbootProducts == null || this.depot2LocalbootProducts == null || this.productRows == null || this.depot2Packages == null) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " productOnDepot");
            String[] stringArray = new String[]{};
            HashMap hashMap = new HashMap();
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "productOnDepot_getObjects");
            this.depot2LocalbootProducts = new Object2Product2VersionList();
            this.depot2NetbootProducts = new Object2Product2VersionList();
            this.product2VersionInfo2Depots = new HashMap<String, Map<String, List<String>>>();
            this.productRows = new Vector();
            this.depot2Packages = new HashMap<String, TreeSet<OpsiPackage>>();
            for (Map<String, Object> map : list) {
                List<String> list2;
                String string = "" + map.get("depotId");
                OpsiPackage opsiPackage = new OpsiPackage(map);
                logging.debug(this, "retrieveProductsAllDepots, opsi package " + opsiPackage);
                if (opsiPackage.isNetbootProduct()) {
                    this.depot2NetbootProducts.addPackage(string, opsiPackage.getProductId(), opsiPackage.getVersionInfo());
                } else if (opsiPackage.isLocalbootProduct()) {
                    this.depot2LocalbootProducts.addPackage(string, opsiPackage.getProductId(), opsiPackage.getVersionInfo());
                }
                Map<String, List<String>> map2 = this.product2VersionInfo2Depots.get(opsiPackage.getProductId());
                if (map2 == null) {
                    map2 = new HashMap<String, List<String>>();
                    this.product2VersionInfo2Depots.put(opsiPackage.getProductId(), map2);
                }
                if ((list2 = map2.get(opsiPackage.getVersionInfo())) == null) {
                    list2 = new ArrayList<String>();
                    map2.put(opsiPackage.getVersionInfo(), list2);
                }
                list2.add(string);
                TreeSet<OpsiPackage> treeSet = this.depot2Packages.get(string);
                if (treeSet == null) {
                    treeSet = new TreeSet();
                    this.depot2Packages.put(string, treeSet);
                }
                treeSet.add(opsiPackage);
                Vector<Object> vector = new Vector<Object>();
                vector.add(opsiPackage.getProductId());
                String string2 = null;
                try {
                    string2 = this.product2versionInfo2infos.get(opsiPackage.getProductId()).get(opsiPackage.getVersionInfo()).getProductName();
                    vector.add(string2);
                    opsiPackage.appendValues(vector);
                    if (list2.size() != 1) continue;
                    this.productRows.add(vector);
                }
                catch (Exception exception) {
                    logging.warning("retrieveProductsAllDepots exception " + exception);
                    logging.warning("retrieveProductsAllDepots exception for package  " + opsiPackage);
                    logging.warning("retrieveProductsAllDepots exception productId  " + opsiPackage.getProductId());
                    logging.warning("retrieveProductsAllDepots exception for product2versionInfo2infos: " + this.product2versionInfo2infos);
                    logging.warning("retrieveProductsAllDepots exception for product2versionInfo2infos.get(p.getProductId()) " + this.product2versionInfo2infos.get(opsiPackage.getProductId()));
                    if (this.product2versionInfo2infos.get(opsiPackage.getProductId()) != null) continue;
                    logging.warning("retrieveProductsAllDepots : product " + opsiPackage.getProductId() + " seems not to exist in product table");
                }
            }
            this.controller.notifyDataRefreshedObservers("productOnDepot");
        }
        logging.debug(this, "getRowsOfProducts " + this.productRows);
    }

    @Override
    public void productPropertyDefinitionsRequestRefresh() {
        this.depot2Product2PropertyDefinitions = null;
    }

    @Override
    public Map<String, Map<String, Map<String, ListCellOptions>>> getDepot2Product2PropertyDefinitions() {
        this.retrieveAllProductPropertyDefinitions();
        return this.depot2Product2PropertyDefinitions;
    }

    protected void retrieveAllProductPropertyDefinitions() {
        this.retrieveProductsAllDepots();
        if (this.depot2Product2PropertyDefinitions == null) {
            this.depot2Product2PropertyDefinitions = new HashMap<String, Map<String, Map<String, ListCellOptions>>>();
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " product property");
            String[] stringArray = new String[]{};
            HashMap hashMap = new HashMap();
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "productProperty_getObjects");
            for (Map<String, Object> map : list) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>(map);
                for (String string : map.keySet()) {
                    hashMap2.put(string, JSONReMapper.deriveStandard(map.get(string)));
                }
                ConfigOption object2 = new ConfigOption((Map<String, Object>)hashMap2);
                String string = (String)map.get("propertyId");
                String string2 = (String)map.get("productId");
                String string3 = (String)map.get("productVersion");
                String string4 = (String)map.get("packageVersion");
                String string5 = string3 + Globals.ProductPackageVersionSeparator.forKey() + string4;
                if (this.product2VersionInfo2Depots.get(string2) == null || this.product2VersionInfo2Depots.get(string2).get(string5) == null) {
                    logging.debug(this, "retrieveAllProductPropertyDefinitions: no depot for " + string2 + " version " + string5 + "  product2VersionInfo2Depots.get(productId) " + this.product2VersionInfo2Depots.get(string2));
                    continue;
                }
                for (String string6 : this.product2VersionInfo2Depots.get(string2).get(string5)) {
                    Map<String, ListCellOptions> map2;
                    Map<String, Map<String, ListCellOptions>> map3 = this.depot2Product2PropertyDefinitions.get(string6);
                    if (map3 == null) {
                        map3 = new HashMap<String, Map<String, ListCellOptions>>();
                        this.depot2Product2PropertyDefinitions.put(string6, map3);
                    }
                    if ((map2 = map3.get(string2)) == null) {
                        map2 = new HashMap<String, ListCellOptions>();
                        map3.put(string2, map2);
                    }
                    map2.put(string, object2);
                }
            }
            logging.debug(this, "retrieveAllProductPropertyDefinitions ");
            this.controller.notifyDataRefreshedObservers("productProperty");
        }
    }

    @Override
    public void productDependenciesRequestRefresh() {
        this.depot2product2dependencyInfos = null;
    }

    @Override
    public Map<String, Map<String, List<Map<String, String>>>> getDepot2product2dependencyInfos() {
        this.retrieveAllProductDependencies();
        return this.depot2product2dependencyInfos;
    }

    protected void retrieveAllProductDependencies() {
        this.retrieveProductsAllDepots();
        if (this.depot2product2dependencyInfos == null) {
            this.depot2product2dependencyInfos = new HashMap<String, Map<String, List<Map<String, String>>>>();
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " product dependency");
            String[] stringArray = new String[]{};
            HashMap hashMap = new HashMap();
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "productDependency_getObjects");
            for (Map<String, Object> map : list) {
                String string = "" + map.get("productId");
                String string2 = "" + map.get("productVersion");
                String string3 = "" + map.get("packageVersion");
                String string4 = string2 + Globals.ProductPackageVersionSeparator.forKey() + string3;
                String string5 = "" + map.get("productAction");
                String string6 = "";
                if (map.get("requirementType") != null) {
                    string6 = "" + map.get("requirementType");
                }
                String string7 = "" + map.get("requiredProductId");
                String string8 = "";
                if (map.get("requiredAction") != null) {
                    string8 = "" + map.get("requiredAction");
                }
                String string9 = "";
                if (map.get("requiredInstallationStatus") != null) {
                    string9 = "" + map.get("requiredInstallationStatus");
                }
                if (this.product2VersionInfo2Depots == null || this.product2VersionInfo2Depots.get(string) == null || this.product2VersionInfo2Depots.get(string).get(string4) == null) {
                    logging.warning(this, "unexpected null for product2VersionInfo2Depots productId, versionInfo   " + string + ", " + string4);
                    continue;
                }
                for (String string10 : this.product2VersionInfo2Depots.get(string).get(string4)) {
                    List<Map<String, String>> list2;
                    Map<String, List<Map<String, String>>> map2 = this.depot2product2dependencyInfos.get(string10);
                    if (map2 == null) {
                        map2 = new HashMap<String, List<Map<String, String>>>();
                        this.depot2product2dependencyInfos.put(string10, map2);
                    }
                    if ((list2 = map2.get(string)) == null) {
                        list2 = new ArrayList<Map<String, String>>();
                        map2.put(string, list2);
                    }
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap2.put("action", string5);
                    hashMap2.put("requiredProductId", string7);
                    hashMap2.put("requiredAction", string8);
                    hashMap2.put("requiredInstallationStatus", string9);
                    hashMap2.put("requirementType", string6);
                    list2.add(hashMap2);
                }
            }
            this.controller.notifyDataRefreshedObservers("productDependency");
        }
    }

    @Override
    public void productPropertyStatesRequestRefresh() {
        logging.info(this, "productPropertyStatesRequestRefresh");
        this.productPropertyStates = null;
        this.hostsWithProductProperties = null;
    }

    @Override
    public List<Map<String, Object>> getProductPropertyStates() {
        this.retrieveProductPropertyStates();
        return this.productPropertyStates;
    }

    protected void productPropertyDepotStatesRequestRefresh() {
        logging.info(this, "productPropertyDepotStatesRequestRefresh");
        this.productPropertyDepotStates = null;
    }

    @Override
    public List<Map<String, Object>> getProductPropertyDepotStates(Set<String> set) {
        this.retrieveProductPropertyDepotStates(set);
        return this.productPropertyDepotStates;
    }

    @Override
    public void fillProductPropertyStates(Collection<String> collection) {
        logging.info(this, "fillProductPropertyStates for " + collection);
        if (this.productPropertyStates == null) {
            this.productPropertyStates = this.produceProductPropertyStates(collection, this.hostsWithProductProperties);
        } else {
            this.productPropertyStates.addAll(this.produceProductPropertyStates(collection, this.hostsWithProductProperties));
        }
    }

    protected void retrieveProductPropertyStates() {
        this.produceProductPropertyStates(null, this.hostsWithProductProperties);
    }

    protected void retrieveProductPropertyDepotStates(Set<String> set) {
        logging.info(this, "retrieveProductPropertyDepotStates for depots " + set + " depotStates == null " + (this.productPropertyDepotStates == null));
        if (this.productPropertyDepotStates == null) {
            this.productPropertyDepotStates = this.produceProductPropertyStates(set, null);
        }
        logging.info(this, "retrieveProductPropertyDepotStates ready  size " + this.productPropertyDepotStates.size());
    }

    protected List<Map<String, Object>> produceProductPropertyStates(Collection<String> collection, Set<String> set) {
        logging.info(this, "produceProductPropertyStates new hosts " + collection + " old hosts " + set);
        ArrayList<Object> arrayList = null;
        arrayList = collection == null ? new ArrayList() : new ArrayList<String>(collection);
        if (set == null) {
            set = new HashSet<String>();
        } else {
            arrayList.removeAll(set);
        }
        List<Map<String, Object>> list = null;
        if (arrayList.size() == 0) {
            list = new ArrayList<Map<String, Object>>();
        } else {
            set.addAll(arrayList);
            logging.info(this, "produceProductPropertyStates, all hosts " + set);
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " product property state");
            String[] stringArray = new String[]{};
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("objectId", this.controller.exec.jsonArray(arrayList));
            list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "productPropertyState_getObjects");
        }
        logging.info(this, "produceProductPropertyStates for hosts " + set + " : ");
        return list;
    }

    @Override
    public void installedSoftwareInformationRequestRefresh() {
        this.installedSoftwareInformation = null;
    }

    @Override
    public LinkedList<String> getSoftwareList() {
        this.retrieveInstalledSoftwareInformation();
        return this.softwareList;
    }

    @Override
    public String getSWident(Integer n) {
        this.retrieveInstalledSoftwareInformation();
        if (this.softwareList == null || this.softwareList.size() < n + 1) {
            boolean bl = false;
            int n2 = 1;
            n2 = JOptionPane.showOptionDialog(de.uib.configed.Globals.mainFrame, configed.getResourceValue("DataStub.reloadSoftwareInformation.text"), configed.getResourceValue("DataStub.reloadSoftwareInformation.title"), 0, 3, null, null, null);
            if (n2 == 0) {
                this.installedSoftwareInformationRequestRefresh();
                this.retrieveInstalledSoftwareInformation();
                if (this.softwareList.size() >= n + 1) {
                    bl = true;
                }
            }
            if (!bl) {
                logging.warning(this, "missing softwareList entry " + n + " " + this.softwareList);
                return null;
            }
        }
        return this.softwareList.get(n);
    }

    @Override
    public TreeMap<String, SWAuditEntry> getInstalledSoftwareInformation() {
        this.retrieveInstalledSoftwareInformation();
        return this.installedSoftwareInformation;
    }

    protected void retrieveInstalledSoftwareInformation() {
        if (this.installedSoftwareInformation == null) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " software");
            String[] stringArray = new String[]{SWAuditEntry.key2serverKey.get("name"), SWAuditEntry.key2serverKey.get("version"), SWAuditEntry.key2serverKey.get("subVersion"), SWAuditEntry.key2serverKey.get("language"), SWAuditEntry.key2serverKey.get("architecture"), SWAuditEntry.key2serverKey.get("windowsSoftwareID")};
            HashMap hashMap = new HashMap();
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "auditSoftware_getHashes");
            Iterator<Map<String, Object>> iterator = list.iterator();
            this.installedSoftwareInformation = new TreeMap();
            while (iterator.hasNext()) {
                Map<String, Object> map = iterator.next();
                SWAuditEntry sWAuditEntry = new SWAuditEntry(map);
                this.installedSoftwareInformation.put(sWAuditEntry.getIdent(), sWAuditEntry);
            }
            this.softwareList = new LinkedList<String>(this.installedSoftwareInformation.keySet());
            logging.info(this, "retrieveInstalledSoftwareInformation produced softwarelist with entries " + this.softwareList.size());
            this.controller.notifyDataRefreshedObservers("software");
        }
    }

    @Override
    public void softwareAuditOnClientsRequestRefresh() {
        logging.info(this, "softwareAuditOnClientsRequestRefresh");
        this.softwareAuditOnClients = null;
        this.client2software = null;
        this.softwareIdent2clients = null;
    }

    @Override
    public void fillClient2Software(String string) {
        logging.info(this, "fillClient2Software " + string);
        if (this.client2software == null) {
            this.retrieveSoftwareAuditOnClients(string);
            return;
        }
        if (this.client2software.get(string) == null) {
            this.retrieveSoftwareAuditOnClients(string);
        }
    }

    @Override
    public void fillClient2Software(List<String> list) {
        logging.info(this, "fillClient2Software " + list);
        this.retrieveSoftwareAuditOnClients(list);
    }

    @Override
    public Map<String, List<SWAuditClientEntry>> getClient2Software() {
        logging.info(this, "getClient2Software  ============= ");
        return this.client2software;
    }

    @Override
    public Map<String, Set<String>> getSoftwareIdent2clients() {
        for (String string : this.softwareIdent2clients.keySet()) {
        }
        return this.softwareIdent2clients;
    }

    protected void retrieveSoftwareAuditOnClients() {
        this.retrieveSoftwareAuditOnClients(new ArrayList<String>());
    }

    protected void retrieveSoftwareAuditOnClients(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.retrieveSoftwareAuditOnClients(arrayList);
    }

    protected void retrieveSoftwareAuditOnClients(List<String> list) {
        logging.info(this, "retrieveSoftwareAuditOnClients used memory on start " + Globals.usedMemory());
        this.retrieveInstalledSoftwareInformation();
        logging.info(this, "retrieveSoftwareAuditOnClients client2Software null " + (this.client2software == null) + "  clients count ======  " + list.size());
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (this.client2software != null) {
            logging.info(this, "retrieveSoftwareAuditOnClients client2Software.keySet size    +++  " + this.client2software.keySet().size());
            arrayList.removeAll(this.client2software.keySet());
        }
        logging.info(this, "retrieveSoftwareAuditOnClients client2Software null " + (this.client2software == null) + "  new clients count  ====== " + arrayList.size());
        int n = 100;
        if (this.client2software == null || this.softwareIdent2clients == null || arrayList.size() > 0) {
            int n2 = 1;
            while (arrayList.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                for (int i = 0; i < n && i < arrayList.size(); ++i) {
                    arrayList2.add(arrayList.get(i));
                }
                arrayList.removeAll(arrayList2);
                if (this.client2software == null) {
                    this.client2software = new HashMap<String, List<SWAuditClientEntry>>();
                }
                if (this.softwareIdent2clients == null) {
                    this.softwareIdent2clients = new HashMap<String, Set<String>>();
                }
                this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " software config, step " + n2);
                logging.info(this, "retrieveSoftwareAuditOnClients, start a request");
                String[] stringArray = new String[]{};
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("state", 1);
                if (arrayList != null) {
                    hashMap.put("clientId", this.controller.exec.jsonArray(arrayList2));
                }
                List<Map<String, Object>> list2 = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "auditSoftwareOnClient_getHashes");
                logging.info(this, "retrieveSoftwareAuditOnClients, finished a request, map size " + list2.size());
                if (list2 == null) {
                    logging.warning(this, "no auditSoftwareOnClient");
                } else {
                    for (String string : arrayList2) {
                        this.client2software.put(string, new LinkedList());
                    }
                    for (Map map : list2) {
                        SWAuditClientEntry sWAuditClientEntry = new SWAuditClientEntry(map, this.controller);
                        String string = sWAuditClientEntry.getClientId();
                        String string2 = sWAuditClientEntry.getSWident();
                        Set<String> set = this.softwareIdent2clients.get(string2);
                        if (set == null) {
                            set = new HashSet<String>();
                            this.softwareIdent2clients.put(string2, set);
                        }
                        set.add(string);
                        if (string == null) continue;
                        List<SWAuditClientEntry> list3 = this.client2software.get(string);
                        list3.add(sWAuditClientEntry);
                    }
                }
                logging.info(this, "retrieveSoftwareAuditOnClients client2software ");
                list2 = null;
                ++n2;
            }
            logging.info(this, "retrieveSoftwareAuditOnClients used memory on end " + Globals.usedMemory());
            System.gc();
            logging.info(this, "retrieveSoftwareAuditOnClients used memory on end " + Globals.usedMemory());
            this.controller.notifyDataRefreshedObservers("softwareConfig");
        }
    }

    @Override
    public void auditSoftwareXLicencePoolRequestRefresh() {
        logging.info(this, "auditSoftwareXLicencePoolRequestRefresh");
        this.auditSoftwareXLicencePool = null;
    }

    @Override
    public AuditSoftwareXLicencePool getAuditSoftwareXLicencePool() {
        this.retrieveAuditSoftwareXLicencePool();
        return this.auditSoftwareXLicencePool;
    }

    protected void retrieveAuditSoftwareXLicencePool() {
        if (this.auditSoftwareXLicencePool != null) {
            return;
        }
        logging.info(this, "retrieveAuditSoftwareXLicencePool");
        this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " AUDIT_SOFTWARE_TO_LICENSE_POOL");
        List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(AuditSoftwareXLicencePool.SERVICE_ATTRIBUTES, new HashMap(), "auditSoftwareToLicensePool_getObjects");
        this.auditSoftwareXLicencePool = new AuditSoftwareXLicencePool(this.getSoftwareList());
        for (Map<String, Object> map : list) {
            this.auditSoftwareXLicencePool.integrateRaw(map);
        }
        logging.info(this, "retrieveAuditSoftwareXLicencePool retrieved ");
    }

    @Override
    public void hostConfigsRequestRefresh() {
        logging.info(this, "hostConfigsRequestRefresh");
        this.hostConfigs = null;
    }

    @Override
    public Map<String, Map<String, Object>> getConfigs() {
        this.retrieveHostConfigs();
        return this.hostConfigs;
    }

    protected void retrieveHostConfigs() {
        if (this.hostConfigs != null) {
            return;
        }
        logging.info(this, "retrieveHostConfigs");
        this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " config state");
        TimeCheck timeCheck = new TimeCheck(this, " retrieveHostConfigs");
        timeCheck.start();
        String[] stringArray = new String[]{};
        HashMap hashMap = new HashMap();
        List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, hashMap, "configState_getObjects");
        this.hostConfigs = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> map : list) {
            Object object = map.get("objectId");
            if (object == null || !(object instanceof String) || object.equals("")) continue;
            String string = (String)object;
            Map<String, Object> map2 = this.hostConfigs.get(object);
            if (map2 == null) {
                map2 = new HashMap<String, Object>();
                this.hostConfigs.put(string, map2);
            }
            logging.debug(this, "retrieveHostConfigs objectId,  element " + object + ": " + map);
            if (map.get("values") == null) {
                map2.put((String)map.get("configId"), new ArrayList());
                continue;
            }
            String string2 = (String)map.get("configId");
            map2.put(string2, ((JSONArray)map.get("values")).toList());
        }
        timeCheck.stop();
        logging.info(this, "retrieveHostConfigs retrieved " + this.hostConfigs.keySet());
        this.controller.notifyDataRefreshedObservers("configState");
    }

    @Override
    public void licencepoolsRequestRefresh() {
        logging.info(this, "licencepoolsRequestRefresh");
        this.licencepools = null;
    }

    @Override
    public Map<String, LicencepoolEntry> getLicencepools() {
        this.retrieveLicencepools();
        return this.licencepools;
    }

    protected void retrieveLicencepools() {
        if (this.licencepools != null) {
            return;
        }
        this.licencepools = new TreeMap();
        if (this.controller.withLicenceManagement) {
            String[] stringArray = new String[]{"id", "description"};
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " licence pool");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(stringArray, new HashMap(), "licensePool_getObjects");
            for (Map<String, Object> map : list) {
                LicencepoolEntry licencepoolEntry = new LicencepoolEntry(map);
                this.licencepools.put(licencepoolEntry.getLicencepoolId(), licencepoolEntry);
            }
        }
    }

    @Override
    public void licenceContractsRequestRefresh() {
        logging.info(this, "licenceContractsRequestRefresh");
        this.tableLicenceContracts = null;
        this.licenceContracts = null;
    }

    @Override
    public Map<String, LicenceContractEntry> getLicenceContracts() {
        this.retrieveLicenceContracts();
        return this.licenceContracts;
    }

    protected void retrieveLicenceContracts() {
        if (this.licenceContracts != null) {
            return;
        }
        this.licenceContracts = new HashMap<String, LicenceContractEntry>();
        if (this.controller.withLicenceManagement) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " software license");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM("licenseContract_getObjects");
            for (Map<String, Object> map : list) {
                LicenceContractEntry licenceContractEntry = new LicenceContractEntry(map);
                this.licenceContracts.put(licenceContractEntry.getId(), licenceContractEntry);
            }
        }
    }

    @Override
    public void licencesRequestRefresh() {
        logging.info(this, "licencesRequestRefresh");
        this.licences = null;
    }

    @Override
    public Map<String, LicenceEntry> getLicences() {
        this.retrieveLicences();
        return this.licences;
    }

    protected void retrieveLicences() {
        if (this.licences != null) {
            return;
        }
        this.licences = new HashMap<String, LicenceEntry>();
        if (this.controller.withLicenceManagement) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " software license");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM("softwareLicense_getObjects");
            for (Map<String, Object> map : list) {
                LicenceEntry licenceEntry = new LicenceEntry(map);
                this.licences.put(licenceEntry.getId(), licenceEntry);
            }
        }
    }

    @Override
    public void licenceUsabilitiesRequestRefresh() {
        logging.info(this, "licenceUsabilitiesRequestRefresh");
        this.licenceUsabilities = null;
    }

    @Override
    public List<LicenceUsableForEntry> getLicenceUsabilities() {
        this.retrieveLicenceUsabilities();
        return this.licenceUsabilities;
    }

    protected void retrieveLicenceUsabilities() {
        if (this.licenceUsabilities != null) {
            return;
        }
        this.licenceUsabilities = new ArrayList<LicenceUsableForEntry>();
        if (this.controller.withLicenceManagement) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " software_license_TO_license_pool");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM("softwareLicenseToLicensePool_getObjects");
            for (Map<String, Object> map : list) {
                LicenceUsableForEntry licenceUsableForEntry = LicenceUsableForEntry.produceFrom(map);
                this.licenceUsabilities.add(licenceUsableForEntry);
            }
        }
    }

    @Override
    public void licenceUsagesRequestRefresh() {
        logging.info(this, "licenceUsagesRequestRefresh");
        this.licenceUsages = null;
    }

    @Override
    public List<LicenceUsageEntry> getLicenceUsages() {
        this.retrieveLicenceUsages();
        return this.licenceUsages;
    }

    protected void retrieveLicenceUsages() {
        logging.info(this, "retrieveLicenceUsages");
        if (this.licenceUsages != null) {
            return;
        }
        this.licenceUsages = new ArrayList<LicenceUsageEntry>();
        if (this.controller.withLicenceManagement) {
            this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " license_on_client");
            List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM("licenseOnClient_getObjects");
            for (Map<String, Object> map : list) {
                LicenceUsageEntry licenceUsageEntry = new LicenceUsageEntry(map);
                this.licenceUsages.add(licenceUsageEntry);
            }
        }
    }

    @Override
    public void licencePoolXOpsiProductRequestRefresh() {
        logging.info(this, "licencePoolXOpsiProductRequestRefresh");
        this.licencePoolXOpsiProduct = null;
    }

    @Override
    public LicencePoolXOpsiProduct getLicencePoolXOpsiProduct() {
        this.retrieveLicencePoolXOpsiProduct();
        return this.licencePoolXOpsiProduct;
    }

    protected void retrieveLicencePoolXOpsiProduct() {
        if (this.licencePoolXOpsiProduct != null) {
            return;
        }
        logging.info(this, "retrieveLicencePoolXOpsiProduct");
        this.controller.notifyDataLoadingObservers(configed.getResourceValue("LoadingObserver.loadtable") + " PRODUCT_ID_TO_LICENSE_POOL");
        List<Map<String, Object>> list = this.controller.retrieveListOfMapsNOM(LicencePoolXOpsiProduct.SERVICE_ATTRIBUTES_asArray, new HashMap(), "licensePool_getObjects");
        this.licencePoolXOpsiProduct = new LicencePoolXOpsiProduct();
        for (Map<String, Object> map : list) {
            this.licencePoolXOpsiProduct.integrateRawFromService(map);
        }
    }
}

