/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.configed.gui.ssh.SSHConnectionOutputDialog;
import de.uib.opsicommand.sshcommand.List_Commands;
import de.uib.opsicommand.sshcommand.SSHCommand;
import de.uib.opsicommand.sshcommand.SSHConnect;
import de.uib.opsicommand.sshcommand.SSHMultiCommand;
import de.uib.utilities.logging.logging;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.SwingWorker;

public class SSHConnectExec
extends SSHConnect {
    SSHConnectionOutputDialog outputDialog = null;

    public SSHConnectExec(ConfigedMain configedMain, SSHCommand sSHCommand) {
        super(configedMain);
        this.main = configedMain;
        if (this.main != null) {
            this.connect(sSHCommand);
        }
        logging.info(this, "SSHConnectExec main " + this.main);
        logging.info(this, "SSHConnectExec sshcommand " + sSHCommand.getCommand());
        try {
            if (sSHCommand.isMultiCommand()) {
                this.exec_list((SSHMultiCommand)((Object)sSHCommand));
            } else {
                this.exec(sSHCommand);
            }
        }
        catch (Exception exception) {
            logging.error(this, "SSHConnectExec Exception " + exception);
            exception.printStackTrace();
        }
        this.disconnect();
    }

    public SSHConnectExec(SSHCommand sSHCommand) {
        this(null, sSHCommand);
    }

    public SSHConnectExec() {
        super(null);
        this.connect();
    }

    public SSHConnectionOutputDialog getDialog() {
        if (this.outputDialog != null) {
            return this.outputDialog;
        }
        return null;
    }

    public void setDialog(SSHConnectionOutputDialog sSHConnectionOutputDialog) {
        this.outputDialog = sSHConnectionOutputDialog;
    }

    public void exec_list(SSHMultiCommand sSHMultiCommand) {
        this.exec_list(sSHMultiCommand, true, null, false);
    }

    public void exec_list(SSHMultiCommand sSHMultiCommand, boolean bl) {
        this.exec_list(sSHMultiCommand, true, null, bl);
    }

    public void exec_list(SSHMultiCommand sSHMultiCommand, SSHConnectionExecDialog sSHConnectionExecDialog, boolean bl) {
        this.exec_list(sSHMultiCommand, true, sSHConnectionExecDialog, bl);
    }

    public void exec_list(final SSHMultiCommand sSHMultiCommand, final boolean bl, SSHConnectionExecDialog sSHConnectionExecDialog, final boolean bl2) {
        logging.debug(this, "exec_list commands[" + ((List_Commands)sSHMultiCommand).getName() + "] withGui[" + bl + "] sequential[" + bl2 + "] dialog[" + sSHConnectionExecDialog + "]");
        SSHConnectionExecDialog sSHConnectionExecDialog2 = null;
        sSHConnectionExecDialog2 = sSHConnectionExecDialog != null ? sSHConnectionExecDialog : new SSHConnectionExecDialog();
        final SSHConnectionExecDialog sSHConnectionExecDialog3 = sSHConnectionExecDialog2;
        if (Globals.ssh_always_exec_in_background) {
            sSHConnectionExecDialog2.setVisible(true);
        }
        try {
            new Thread(){

                @Override
                public void run() {
                    for (SSHCommand sSHCommand : sSHMultiCommand.getCommands()) {
                        SSHConnectExec.this.exec(sSHCommand, bl, sSHConnectionExecDialog3, bl2);
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String exec(SSHCommand sSHCommand) {
        return this.exec(sSHCommand, true, null, false);
    }

    public String exec(SSHCommand sSHCommand, boolean bl) {
        return this.exec(sSHCommand, bl, null, false);
    }

    public String exec(SSHCommand sSHCommand, boolean bl, SSHConnectionOutputDialog sSHConnectionOutputDialog) {
        return this.exec(sSHCommand, bl, sSHConnectionOutputDialog, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String exec(SSHCommand sSHCommand, boolean bl, SSHConnectionOutputDialog sSHConnectionOutputDialog, boolean bl2) {
        Object var5_5 = null;
        logging.info(this, "exec command " + sSHCommand.getCommand());
        logging.info(this, "exec withGui " + bl);
        logging.info(this, "exec dialog " + sSHConnectionOutputDialog);
        logging.info(this, "exec isConnected " + this.isConnected());
        if (sSHCommand.needUserRoot()) {
            this.disconnect();
            if (!this.connect(sSHCommand)) return "error";
            if (sSHCommand != null && sSHCommand.getDialog() != null) {
                logging.debug(this, "exec ssh_always_exec_in_background " + Globals.ssh_always_exec_in_background);
                if (Globals.ssh_always_exec_in_background) {
                    sSHCommand.getDialog().setVisible(true);
                    sSHCommand.getDialog().show();
                }
            }
        } else if (!this.isConnected()) {
            this.connect(sSHCommand);
        }
        if (bl) {
            this.outputDialog = sSHConnectionOutputDialog != null ? sSHConnectionOutputDialog : new SSHConnectionExecDialog(sSHCommand);
            this.outputDialog.setTitle(configed.getResourceValue("SSHConnection.Exec.title") + " \"" + sSHCommand.getCommand() + "\" (" + user + "@" + host + ")");
        }
        try {
            logging.info(this, "exec isConnected " + this.isConnected());
            SshCommandWorker sshCommandWorker = new SshCommandWorker(sSHCommand, this.outputDialog, bl);
            sshCommandWorker.execute();
            logging.info(this, "execute was called");
            if (bl2) {
                return (String)sshCommandWorker.get();
            }
            if (!bl) return (String)sshCommandWorker.get();
            return "finish";
        }
        catch (Exception exception) {
            logging.error(this, "Exception " + exception);
            return null;
        }
    }

    private class SshCommandWorker
    extends SwingWorker<String, String> {
        SSHCommand command;
        SSHConnectionOutputDialog outputDialog;
        boolean withGui;
        int retriedTimes = 1;

        SshCommandWorker(SSHCommand sSHCommand, SSHConnectionOutputDialog sSHConnectionOutputDialog, boolean bl) {
            this.command = sSHCommand;
            this.outputDialog = sSHConnectionOutputDialog;
            this.withGui = bl;
            this.retriedTimes = 1;
            this.publish("\n---------------------------------------------------------------------------------------------------------------------------------------------------");
            this.publish("\nexec: >>> " + this.command.getCommand() + " <<<");
            this.publish("\n---------------------------------------------------------------------------------------------------------------------------------------------------\n");
        }

        private void checkExitCode(int n, boolean bl) {
            String string = "checkExitCode " + n;
            logging.debug(this, "publish " + string);
            this.publish(string);
            if (n == 127) {
                logging.info(this, "exec exit code 127 (command does not exists).");
                logging.debug(configed.getResourceValue("SSHConnection.Exec.exit127"));
                if (bl) {
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exit127"));
                    logging.info(this, "2. publish");
                }
            } else if (n != 0) {
                logging.info(this, "exec exit code " + n + ".");
                logging.debug(this, configed.getResourceValue("SSHConnection.Exec.exitError") + configed.getResourceValue("SSHConnection.Exec.exitCode") + " " + n);
                if (bl) {
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exitError") + configed.getResourceValue("SSHConnection.Exec.exitCode") + " " + n);
                }
            } else if (n == 0) {
                logging.info(this, "exec exit code 0");
                logging.debug(this, configed.getResourceValue("SSHConnection.Exec.exitNoError"));
                logging.debug(this, configed.getResourceValue("SSHConnection.Exec.exitPlsCheck"));
                if (bl) {
                    this.publish("\n");
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exitNoError"));
                    this.publish("\n");
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exitPlsCheck"));
                }
            } else {
                logging.debug(this, configed.getResourceValue("SSHConnection.Exec.exitUnknown"));
                logging.debug(this, configed.getResourceValue("SSHConnection.Exec.exitPlsCheck"));
                if (bl) {
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exitUnknown"));
                    this.publish("\n");
                    this.publish(configed.getResourceValue("SSHConnection.Exec.exitPlsCheck"));
                    this.publish("\n");
                }
            }
        }

        @Override
        public String doInBackground() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                logging.info(this, "doInBackground getSession " + SSHConnectExec.this.getSession());
                if (!SSHConnectExec.this.isConnected()) {
                    SSHConnectExec.this.connect();
                }
                Channel channel = SSHConnectExec.this.getSession().openChannel("exec");
                ((ChannelExec)channel).setErrStream(System.err);
                ((ChannelExec)channel).setCommand(this.command.getCommand());
                OutputStream outputStream = channel.getOutputStream();
                InputStream inputStream = channel.getInputStream();
                channel.connect();
                logging.info(this, "doInBackground start waiting for answer");
                int n = 0x100000;
                byte[] byArray = new byte[n];
                int n2 = 0;
                if (this.command.needSudo()) {
                    logging.info(this, "doInBackground command.needSudo");
                    outputStream.write((SSHConnectExec.this.getSudoPass(this.outputDialog, true) + "\n").getBytes());
                    outputStream.flush();
                }
                while (true) {
                    if (inputStream.available() > 0) {
                        int n3 = inputStream.read(byArray, 0, n);
                        logging.debug(this, "doInBackground i " + n3);
                        if (n3 >= 0) {
                            String string = new String(byArray, 0, n3);
                            if (this.command.needSudo() && string.equals(configed.getResourceValue("SSHConnection.sudoFailedText"))) {
                                logging.debug(this, "doInBackground if needSudo " + this.command.needSudo());
                                logging.debug(this, "doInBackground if str " + string);
                                outputStream.write((SSHConnectExec.this.getSudoPass(this.outputDialog, true) + "\n").getBytes());
                                outputStream.flush();
                            } else if (string.trim().equals("Das hat nicht funktioniert, bitte nochmal probieren.")) {
                                logging.debug(this, "doInBackground if str " + string);
                                outputStream.write((SSHConnectExec.this.getSudoPass(this.outputDialog, true) + "\n").getBytes());
                                outputStream.flush();
                            } else if (this.withGui) {
                                logging.info(this, "doInBackground withGui true");
                                for (String string2 : string.split("\n")) {
                                    logging.debug(this, " doInBackground publish " + n2 + ": " + string2);
                                    this.publish(new String(string2));
                                    ++n2;
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            stringBuffer.append(string);
                            continue;
                        }
                    }
                    if (channel.isClosed() && inputStream.available() <= 0) break;
                }
                this.checkExitCode(channel.getExitStatus(), this.withGui);
                if (channel.getExitStatus() != 0) {
                    logging.info(this, "exec ready (1)");
                    if (this.outputDialog != null) {
                        this.outputDialog.setStatusFinish();
                    }
                    return null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SSHConnectExec.this.setDialog(this.outputDialog);
                logging.info(this, "exec ready (2)");
            }
            catch (JSchException jSchException) {
                if (this.retriedTimes >= 2) {
                    this.retriedTimes = 1;
                    logging.warning(this, "jsch exception " + jSchException);
                    logging.logTrace(jSchException);
                    this.publish(jSchException.toString());
                    return "";
                }
                logging.warning(this, "jsch exception " + jSchException);
                ++this.retriedTimes;
                this.doInBackground();
            }
            catch (Exception exception) {
                logging.warning(this, "ssh exception " + exception);
                logging.logTrace(exception);
                this.publish(exception.toString());
            }
            if (this.outputDialog != null) {
                this.outputDialog.setStatusFinish();
            }
            return stringBuffer.toString();
        }

        @Override
        protected void process(List<String> list) {
            logging.debug(this, "chunks " + list.size());
            if (this.outputDialog != null) {
                for (String string : list) {
                    this.outputDialog.append(string);
                    this.outputDialog.append("\n");
                }
            }
        }

        @Override
        protected void done() {
            logging.info(this, "done");
        }
    }
}

