/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.ssh.SSHConnectionOutputDialog;
import de.uib.opsicommand.sshcommand.SSHConnectTerminal;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class SSHConnectionTerminalDialog
extends SSHConnectionOutputDialog {
    private JLabel lbl_userhost = new JLabel();
    private JTextField tf_command;
    private JCheckBox cb_privat;
    private JButton btn_exec;
    private SSHConnectTerminal terminal;
    private ArrayList<String> commandHistory = new ArrayList();
    private int historyAddIndex = 0;
    private int historyGetIndex = 0;

    public SSHConnectionTerminalDialog(String string, SSHConnectTerminal sSHConnectTerminal) {
        super(string);
        this.setSize(700, 400);
        this.setVisible(true);
        this.terminal = sSHConnectTerminal;
        this.initGUI();
        this.setDefaultCloseOperation(2);
        this.centerOn(Globals.mainFrame);
        logging.info(this, "SSHConnectionTerminalDialog build ");
    }

    public SSHConnectionTerminalDialog(String string) {
        this(string, null);
    }

    public JTextField getInputField() {
        if (this.tf_command == null) {
            return null;
        }
        return this.tf_command;
    }

    public boolean getPrivateStatus() {
        return this.cb_privat.isSelected();
    }

    public void setPrivate(boolean bl) {
        this.cb_privat.setSelected(bl);
        if (bl) {
            this.changeEchoChar('*');
        } else {
            this.changeEchoChar('\u0000');
        }
    }

    public void addToHistory(String string) {
        this.commandHistory.add(this.historyAddIndex, string);
        ++this.historyAddIndex;
        this.historyGetIndex = this.historyAddIndex;
    }

    public String getPrevCommand_up() {
        if (this.historyGetIndex - 1 < 0) {
            this.historyGetIndex = 0;
            return this.commandHistory.get(this.historyGetIndex);
        }
        --this.historyGetIndex;
        return this.commandHistory.get(this.historyGetIndex);
    }

    public String getPrevCommand_down() {
        if (this.historyGetIndex + 1 >= this.commandHistory.size()) {
            this.historyGetIndex = this.commandHistory.size();
            return "";
        }
        ++this.historyGetIndex;
        return this.commandHistory.get(this.historyGetIndex);
    }

    public JTextPane getOutputField() {
        if (this.output == null) {
            return null;
        }
        return this.output;
    }

    private void initGUI() {
        this.tf_command = new JPasswordField(){

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocusInWindow();
            }
        };
        this.tf_command.setText("");
        ((Component)this.tf_command).requestFocusInWindow();
        this.tf_command.requestFocus();
        this.tf_command.setCaretPosition(0);
        this.cb_privat = new JCheckBox();
        this.cb_privat.setText(configed.getResourceValue("SSHConnection.Config.hideText"));
        this.cb_privat.setSelected(false);
        this.changeEchoChar('\u0000');
        this.cb_privat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SSHConnectionTerminalDialog.this.changeEchoChar('*');
                } else {
                    SSHConnectionTerminalDialog.this.changeEchoChar('\u0000');
                }
            }
        });
        this.createLayout();
    }

    protected void createLayout() {
        int n = -2;
        int n2 = Short.MAX_VALUE;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        int n3 = 10;
        int n4 = 10;
        this.konsolePanelLayout.setVerticalGroup(this.konsolePanelLayout.createSequentialGroup().addGap(n3).addComponent(this.jScrollPane).addGap(n3).addGroup(this.konsolePanelLayout.createParallelGroup(alignment).addGap(n3).addGroup(this.konsolePanelLayout.createSequentialGroup().addGap(5).addComponent(this.cb_privat, n, n, n)).addComponent(this.tf_command, n, n, n).addGap(n4).addComponent(this.btn_close, n, n, n).addGap(n3)).addGap(n3));
        this.konsolePanelLayout.setHorizontalGroup(this.konsolePanelLayout.createParallelGroup(alignment).addGroup(this.konsolePanelLayout.createSequentialGroup().addGap(n4).addComponent(this.jScrollPane).addGap(n4)).addGroup(this.konsolePanelLayout.createSequentialGroup().addGap(n4).addComponent(this.cb_privat).addGap(n4).addComponent(this.tf_command).addGap(n4).addComponent(this.btn_close).addGap(n4)));
        this.mainPanelLayout.setVerticalGroup(this.mainPanelLayout.createSequentialGroup().addComponent(this.inputPanel));
        this.mainPanelLayout.setHorizontalGroup(this.mainPanelLayout.createParallelGroup(alignment).addGroup(this.mainPanelLayout.createSequentialGroup().addComponent(this.inputPanel)));
    }

    public void changeEchoChar(char c) {
        ((JPasswordField)this.tf_command).setEchoChar(c);
    }
}

