/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.FGeneralDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class SSHConnectionOutputDialog
extends FGeneralDialog {
    protected JTextPane output;
    protected JScrollPane jScrollPane;
    protected JButton btn_close;
    protected boolean buildFrame = false;
    protected JPanel mainPanel = new JPanel();
    protected JPanel inputPanel = new JPanel();
    protected GroupLayout konsolePanelLayout;
    protected GroupLayout mainPanelLayout;
    String ansiCodeGreen = "\u001b[0;32;40m";
    String ansiCodeRed = "\u001b[1;31;40m";
    String ansiCodeEnd = "\u001b[0;0;0m";
    String ansiCodeWhite = "\u001b[1;37;40m";
    String ansiCodeGrey = "\u001b[0;37;40m";
    public boolean showResult = true;

    public SSHConnectionOutputDialog(String string) {
        super((Frame)null, string, false);
        this.initOutputGui();
        this.setSize(700, 400);
        this.centerOn(Globals.mainFrame);
        this.setDefaultCloseOperation(2);
    }

    public void append(String string, Component component) {
        this.append(string);
        component.requestFocusInWindow();
        ((JTextField)component).requestFocus();
        ((JTextField)component).setCaretPosition(0);
    }

    public void append(String string) {
        Color color = Color.BLACK;
        if (Globals.ssh_colored_output) {
            if (string.startsWith(this.ansiCodeGreen)) {
                color = Globals.okGreen;
            } else if (string.startsWith(this.ansiCodeRed)) {
                color = Globals.actionRed;
            } else if (string.startsWith(this.ansiCodeWhite)) {
                color = Globals.blueGrey;
            }
        }
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Alignment, 3);
        this.output.setCaretPosition(this.output.getDocument().getLength());
        this.output.setCharacterAttributes(attributeSet, false);
        try {
            StyledDocument styledDocument = this.output.getStyledDocument();
            styledDocument.insertString(styledDocument.getLength(), string, attributeSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initOutputGui() {
        try {
            this.inputPanel.setBackground(Globals.backLightBlue);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanelLayout = new GroupLayout(this.mainPanel);
            this.konsolePanelLayout = new GroupLayout(this.inputPanel);
            this.inputPanel.setLayout(this.konsolePanelLayout);
            this.mainPanel.setLayout(this.mainPanelLayout);
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(22);
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.output = new JTextPane();
            this.output.setEditable(false);
            this.output.setBackground(Color.GREEN);
            this.output.setContentType("text/rtf");
            StyledDocument styledDocument = (StyledDocument)this.output.getDocument();
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            Style style2 = styledDocument.addStyle("readonlyStyle", style);
            StyleConstants.setBackground(style2, Color.GREEN);
            Style style3 = styledDocument.addStyle("StyleName", null);
            StyleConstants.setForeground(style2, Color.RED);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(styledDocument.getStyle("readonlyStyle"));
            simpleAttributeSet.addAttribute("readonly", true);
            ((AbstractDocument)((Object)styledDocument)).setDocumentFilter(new InputFilter(this.output));
            DefaultCaret defaultCaret = (DefaultCaret)this.output.getCaret();
            defaultCaret.setUpdatePolicy(2);
            this.jScrollPane.setViewportView(this.output);
            this.output.setText("");
            this.btn_close = new JButton();
            this.btn_close.setText(configed.getResourceValue("SSHConnection.buttonClose"));
            this.btn_close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SSHConnectionOutputDialog.this.cancel();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setVisibility(boolean bl) {
        this.setVisible(bl);
    }

    public void setStatusFinish() {
        if (this.showResult) {
            this.setVisibility(true);
        } else {
            this.cancel();
        }
    }

    public void cancel() {
        this.buildFrame = false;
        this.setVisible(false);
        this.dispose();
    }

    class InputFilter
    extends DocumentFilter {
        JTextPane editor;

        public InputFilter(JTextPane jTextPane) {
            this.editor = jTextPane;
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (!this.isReadOnly()) {
                super.remove(filterBypass, n, n2);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!this.isReadOnly()) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }

        private boolean isReadOnly() {
            AttributeSet attributeSet = this.editor.getCharacterAttributes();
            return attributeSet != null && attributeSet.getAttribute("readonly") != null;
        }
    }
}

