/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.Globals;
import de.uib.configed.clientselection.SelectionManager;
import de.uib.configed.configed;
import de.uib.configed.type.SavedSearch;
import de.uib.opsidatamodel.SavedSearches;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEditList;
import de.uib.utilities.swing.JMenuItemFormatted;
import de.uib.utilities.swing.list.ListCellRendererByIndex;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;

public class SavedSearchesDialog
extends FEditList {
    private SelectionManager manager;
    private List<String> result;
    private DefaultListModel model;
    private List<Object> saveSelValue;

    public SavedSearchesDialog() {
        this.setTitle(configed.getResourceValue("SavedSearchesDialog.title") + " (" + "opsi config editor" + ")");
        this.setModal(false);
        this.setLeaveOnCommit(false);
        this.manager = new SelectionManager(null);
        this.result = new LinkedList<String>();
        this.model = new DefaultListModel();
        this.setEditable(true);
        this.setListModel(this.model);
        this.resetModel();
        this.buttonAdd.setVisible(true);
        this.buttonRemove.setVisible(false);
        this.extraField.setVisible(false);
    }

    public void start() {
        this.buttonAdd.setEnabled(true);
        this.resetModel();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.buttonCommit.setToolTipText(configed.getResourceValue("SavedSearchesDialog.ExecuteButtonTooltip"));
        this.buttonCommit.setIcon(Globals.createImageIcon("images/execute.png", ""));
        this.buttonCommit.setSelectedIcon(Globals.createImageIcon("images/execute_over.png", ""));
        this.buttonCommit.setDisabledIcon(Globals.createImageIcon("images/execute_disabled.png", ""));
        this.buttonCommit.setPreferredSize(new Dimension(this.buttonWidth, 24));
        this.buttonCancel.setToolTipText(configed.getResourceValue("SavedSearchesDialog.CancelButtonTooltip"));
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "actionPerformed");
                SavedSearchesDialog.this.removeSelectedEntry();
            }
        });
        this.buttonRemove.setToolTipText(configed.getResourceValue("SavedSearchesDialog.RemoveButtonTooltip"));
        this.buttonAdd.setEnabled(true);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "actionPerformed on buttonAdd ");
                SavedSearchesDialog.this.addElement();
            }
        });
        JMenuItemFormatted jMenuItemFormatted = new JMenuItemFormatted();
        jMenuItemFormatted.setText(configed.getResourceValue("ConfigedMain.reloadTable"));
        jMenuItemFormatted.setIcon(Globals.createImageIcon("images/reload16.png", ""));
        jMenuItemFormatted.setFont(Globals.defaultFont);
        jMenuItemFormatted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "------------- reload action");
                SavedSearchesDialog.this.reloadAction();
            }
        });
        this.popup.add(jMenuItemFormatted);
        JMenuItemFormatted jMenuItemFormatted2 = new JMenuItemFormatted();
        jMenuItemFormatted2.setText(configed.getResourceValue("SavedSearchesDialog.RemoveButtonTooltip"));
        jMenuItemFormatted2.setFont(Globals.defaultFont);
        jMenuItemFormatted2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "------------- remove action");
                SavedSearchesDialog.this.removeSelectedEntry();
            }
        });
        this.popup.add(jMenuItemFormatted2);
        JMenuItemFormatted jMenuItemFormatted3 = new JMenuItemFormatted();
        jMenuItemFormatted3.setText(configed.getResourceValue("SavedSearchesDialog.EditSearchMenu"));
        jMenuItemFormatted3.setFont(Globals.defaultFont);
        jMenuItemFormatted3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SavedSearchesDialog.this.editSearch(SavedSearchesDialog.this.visibleList.getSelectedValue().toString());
            }
        });
        this.popup.add(jMenuItemFormatted3);
    }

    @Override
    public void setVisible(boolean bl) {
        logging.debug(this, "setVisible " + bl);
        super.setVisible(bl);
    }

    @Override
    public void setDataChanged(boolean bl) {
        boolean bl2 = this.buttonCommit.isEnabled();
        super.setDataChanged(bl);
        this.buttonCommit.setEnabled(bl2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        logging.debug(this, "SavedSearchesDialog ListSelectionListener valueChanged " + listSelectionEvent);
        super.valueChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.buttonCommit.setEnabled(this.getSelectedList().size() > 0);
    }

    @Override
    public Object getValue() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commit() {
        this.result = null;
        this.buttonCommit.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        WaitCursor waitCursor = new WaitCursor((Component)this, "SavedSearchesDialog.commit");
        try {
            List list = this.getSelectedList();
            if (!list.isEmpty()) {
                this.manager.loadSearch((String)list.get(0));
                this.result = this.manager.selectClients();
            }
            super.commit();
        }
        finally {
            this.buttonCommit.setEnabled(true);
            this.buttonCancel.setEnabled(true);
            waitCursor.stop();
        }
    }

    @Override
    protected void cancel() {
        this.result = null;
        super.cancel();
    }

    private void removeSelectedEntry() {
        int n = this.visibleList.getSelectedIndex();
        logging.debug(this, "remove selected Entry, list index " + n);
        if (n == -1) {
            return;
        }
        logging.debug(this, "remove entry at " + n);
        this.removeSavedSearch((String)this.model.get(n));
        this.model.remove(n);
    }

    protected void removeSavedSearch(String string) {
        this.manager.removeSearch(string);
    }

    protected void reloadAction() {
    }

    protected void addElement() {
    }

    protected void editSearch(String string) {
    }

    public void resetModel() {
        logging.debug(this, "resetModel");
        this.model.removeAllElements();
        SavedSearches savedSearches = this.manager.getSavedSearches();
        TreeSet<String> treeSet = new TreeSet<String>(this.manager.getSavedSearchesNames());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string : treeSet) {
            this.model.addElement(string);
            hashMap.put(string, string);
            hashMap2.put(string, ((SavedSearch)savedSearches.get(string)).getDescription());
        }
        this.setCellRenderer(new ListCellRendererByIndex(hashMap, hashMap2, null, -1, false, ""));
        this.initSelection();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.commit();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

