/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.LogPane;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.ClippedTitleTabbedPane;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PanelTabbedDocuments
extends ClippedTitleTabbedPane {
    LogPane[] textPanes;
    String[] idents;
    final List<String> identsList;
    protected JFileChooser chooser;
    protected File chooserDirectory;

    public PanelTabbedDocuments(final String[] stringArray, String string) {
        this.idents = stringArray;
        this.identsList = Arrays.asList(stringArray);
        this.setProportionOfTotalWidth(0.5);
        this.setForeground(de.uib.utilities.Globals.blue);
        this.textPanes = new LogPane[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            LogPane logPane;
            final String string2 = stringArray[i];
            this.textPanes[i] = logPane = new LogPane(string){

                @Override
                protected void reload() {
                    super.reload();
                    PanelTabbedDocuments.this.loadDocument(string2);
                }

                @Override
                protected void save() {
                    String string = string2;
                    if (this.getInfo() != null) {
                        string = this.getInfo().replace('.', '_') + "___" + string2 + ".log";
                    }
                    logging.debug(this, "save with filename " + string);
                    String string22 = PanelTabbedDocuments.this.openFile(string + ".log");
                    if (string22 != null && !string22.equals("")) {
                        PanelTabbedDocuments.this.saveToFile(string22, this.lines);
                    }
                }

                @Override
                protected void saveAsZip() {
                    String string;
                    logging.info(this, "saveAsZip");
                    String string22 = string2;
                    if (this.getInfo() != null) {
                        string22 = this.getInfo().replace('.', '_') + "___" + string2;
                    }
                    if ((string = PanelTabbedDocuments.this.openFile(string22 + ".zip")) != null && !string.equals("")) {
                        PanelTabbedDocuments.this.saveToZipFile(string, string22, this.lines);
                    }
                }

                @Override
                protected void saveAllAsZip(boolean bl) {
                    logging.info(this, "saveAllAsZip got ident " + string2 + " loadMissingDocs " + bl);
                    String string = string2;
                    if (this.getInfo() != null) {
                        string = this.getInfo().replace('.', '_') + "_all";
                    }
                    logging.info(this, "saveAllAsZip, start getting pathname");
                    String string22 = PanelTabbedDocuments.this.openFile(string + ".zip");
                    if (string22 != null && !string22.equals("")) {
                        logging.info(this, "saveAllAsZip, got pathname");
                        if (bl) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (PanelTabbedDocuments.this.textPanes[i].lines.length <= 1) {
                                    PanelTabbedDocuments.this.loadDocument(stringArray[i]);
                                }
                                logging.info(this, "saveAllAsZip textPanes[" + i + "].lines.length " + PanelTabbedDocuments.this.textPanes[i].lines.length);
                            }
                        }
                        PanelTabbedDocuments.this.saveAllToZipFile(string22);
                    }
                }
            };
            this.addTab(string2, this.textPanes[i]);
        }
    }

    public void loadDocument(String string) {
        logging.debug(this, "loadDocument ident " + string);
    }

    private void setDocument(int n, String string, String string2) {
        logging.info(this, "setDocument " + n + " document == null " + (string == null));
        if (n < 0 || n >= this.idents.length) {
            return;
        }
        if (string == null) {
            this.textPanes[n].setText("");
            this.textPanes[n].setTitle("");
            return;
        }
        this.textPanes[n].setTitle(this.idents[n] + "  " + string2);
        this.textPanes[n].setInfo(string2);
        this.textPanes[n].setText(string);
    }

    private void setDocument(String string, String string2, String string3) {
        int n = this.identsList.indexOf(string);
        this.setDocument(n, string2, string3);
    }

    public void setDocuments(Map<String, String> map, String string) {
        logging.info(this, " ------------------------------  idents.length " + this.idents.length + " info: " + string);
        for (int i = 0; i < this.idents.length; ++i) {
            this.setDocument(this.idents[i], map.get(this.idents[i]), string);
        }
    }

    private void setFileChooser(String string) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(string);
            this.chooser.setFileSelectionMode(0);
            this.chooser.setFileFilter(new FileNameExtensionFilter("logfiles: .log, .zip, .gz, .7z", "log", "zip", "gz", "7z"));
            this.chooser.setApproveButtonText("O.K.");
            this.chooser.setDialogType(1);
            this.chooser.setDialogTitle("opsi config editor " + configed.getResourceValue("PanelTabbedDocument.saveFileChooser"));
        }
    }

    private String openFile(String string) {
        String string2 = null;
        if (this.chooser == null) {
            this.setFileChooser("");
            this.chooserDirectory = this.chooser.getCurrentDirectory();
        }
        File file = new File(this.chooserDirectory, string);
        this.chooser.setSelectedFile(file);
        int n = this.chooser.showSaveDialog(Globals.frame1);
        if (n == 0) {
            if (this.chooser != null) {
                string2 = this.chooser.getSelectedFile().getAbsolutePath();
                this.chooserDirectory = this.chooser.getCurrentDirectory();
            } else {
                logging.error("Not a valid filename: " + string2);
            }
        }
        return string2;
    }

    private void saveToFile(String string, String[] stringArray) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (IOException iOException) {
            logging.error("Error opening file: " + string + "\n --- " + iOException);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fileWriter.write(stringArray[i] + "\n");
                continue;
            }
            catch (IOException iOException) {
                logging.error("Error writing file: " + string + "\n --- " + iOException);
            }
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            logging.error("Error closing file: " + string + "\n --- " + iOException);
        }
    }

    private void saveAllToZipFile(String string) {
        ZipOutputStream zipOutputStream = null;
        byte[] byArray = new byte[1024];
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            zipOutputStream.setMethod(8);
            for (int i = 0; i < this.idents.length; ++i) {
                if (this.textPanes[i].lines.length > 1) {
                    ZipEntry zipEntry = new ZipEntry(this.textPanes[i].title.replace(" ", "_").replace(".", "_") + ".log");
                    zipOutputStream.putNextEntry(zipEntry);
                    for (int j = 0; j < this.textPanes[i].lines.length; ++j) {
                        try {
                            byArray = this.textPanes[i].lines[j].getBytes();
                            zipOutputStream.write(byArray, 0, this.textPanes[i].lines[j].length());
                            continue;
                        }
                        catch (IOException iOException) {
                            logging.error("Error writing zip file: " + string + "\n --- " + iOException);
                        }
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            logging.error("Error writing zip file: " + string + "\n --- " + iOException);
        }
        try {
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            logging.error("Error closing zip file: " + string + "\n --- " + iOException);
        }
    }

    private void saveToZipFile(String string, String string2, String[] stringArray) {
        ZipOutputStream zipOutputStream = null;
        byte[] byArray = new byte[1024];
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            zipOutputStream.setMethod(8);
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    byArray = stringArray[i].getBytes();
                    zipOutputStream.write(byArray, 0, stringArray[i].length());
                    continue;
                }
                catch (IOException iOException) {
                    logging.error("Error writing zip file: " + string2 + "\n --- " + iOException);
                }
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            logging.error("Error writing zip file: " + string2 + "\n --- " + iOException);
        }
        try {
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            logging.error("Error closing zip file: " + string2 + "\n --- " + iOException);
        }
    }
}

