/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.FGeneralDialog;
import de.uib.configed.gui.IconButton;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.RunningInstances;
import de.uib.utilities.swing.ProgressBarPainter;
import de.uib.utilities.thread.WaitingSleeper;
import de.uib.utilities.thread.WaitingWorker;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.UIDefaults;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;

public class FStartWakeOnLan
extends FGeneralDialog
implements WaitingSleeper {
    public static RunningInstances<FStartWakeOnLan> runningInstances = new RunningInstances(FStartWakeOnLan.class, configed.getResourceValue("RunningInstances.askStop.text"));
    String scheduleTitleStarter;
    private LinkedHashMap<String, Integer> labelledDelays;
    JSpinner spinnerDelay;
    JSpinner spinnerHour;
    JSpinner spinnerMinute;
    JLabel labelStarttime;
    JTextField fieldTaskname;
    JTextField fieldClientCount;
    JTextField fieldInvolvedDepotsCount;
    JLabel labelTimeYetToWait;
    IconButton buttonRefreshTime;
    IconButton buttonSetNew;
    Calendar cal;
    long startActionMillis;
    long waitingMillis;
    int stepsTotal;
    boolean waitingMode = false;
    LinkedList<String> oneDayHours;
    LinkedList<String> minutes;
    String nullDelayValue;
    Map<String, List<String>> hostSeparationByDepots;
    Set<String> usedDepots;
    int clientCount;
    String[] currentlySelectedClients;
    private WaitingWorker waitingTask;
    String scheduleTitle;
    ConfigedMain main;

    public FStartWakeOnLan(Frame frame, String string, ConfigedMain configedMain) {
        super(null, string, false, new Object[]{configed.getResourceValue("FStartWakeOnLan.start"), configed.getResourceValue("FStartWakeOnLan.cancel")}, 750, 310);
        this.main = configedMain;
        this.setCalToNow();
        this.centerOn(Globals.frame1);
    }

    public void setPredefinedDelays(LinkedHashMap<String, Integer> linkedHashMap) {
        this.labelledDelays = linkedHashMap;
        LinkedList<String> linkedList = new LinkedList<String>(linkedHashMap.keySet());
        this.spinnerDelay.setModel(new SpinnerListModel(linkedList));
        this.nullDelayValue = linkedList.get(0);
        ((JSpinner.ListEditor)this.spinnerDelay.getEditor()).getTextField().setEditable(false);
    }

    public void setClients() {
        this.hostSeparationByDepots = this.main.getPersistenceController().getHostSeparationByDepots(this.main.getSelectedClients());
        this.usedDepots = this.hostSeparationByDepots.keySet();
        this.currentlySelectedClients = this.main.getSelectedClients();
        this.clientCount = this.main.getSelectedClients() != null ? this.main.getSelectedClients().length : 0;
        logging.info(this, "clients count " + this.clientCount + ", used depots " + this.usedDepots.size());
        this.fieldClientCount.setText("" + this.clientCount);
        this.fieldInvolvedDepotsCount.setText("" + this.usedDepots.size());
    }

    protected void disableSettingOfTimes() {
        this.jButton1.setEnabled(false);
        this.spinnerDelay.setEnabled(false);
        this.spinnerDelay.setEnabled(false);
        this.buttonRefreshTime.setEnabled(false);
        this.buttonSetNew.setEnabled(false);
        this.spinnerHour.setEnabled(false);
        this.spinnerMinute.setEnabled(false);
    }

    private String formatNaturalNumber(long l) {
        if (l < 10L) {
            return "0" + l;
        }
        return "" + l;
    }

    private String readTime(Calendar calendar) {
        String string = " (" + calendar.get(1) + "-" + this.formatNaturalNumber(calendar.get(2) + 1) + "-" + this.formatNaturalNumber(calendar.get(5)) + ") " + this.formatNaturalNumber(calendar.get(11)) + ":" + this.formatNaturalNumber(calendar.get(12));
        logging.info(this, "readTime " + string);
        return string;
    }

    private void setCalToNow() {
        this.cal = new GregorianCalendar();
    }

    private void produceTargetTime(int n, int n2) {
        this.cal.set(n, n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (this.cal.before(gregorianCalendar)) {
            this.cal = gregorianCalendar;
        }
        int n3 = this.cal.get(12);
        int n4 = this.cal.get(11);
        if (n3 != Integer.valueOf(this.spinnerMinute.getValue().toString())) {
            this.spinnerMinute.setValue(this.cal.get(12));
        }
        if (n4 != Integer.valueOf(this.spinnerHour.getValue().toString())) {
            this.spinnerHour.setValue(this.cal.get(11));
        }
        this.labelStarttime.setText(this.readTime(this.cal));
    }

    protected void setNowTimeAsTarget() {
        this.setCalToNow();
        if (this.scheduleTitleStarter == null) {
            this.scheduleTitleStarter = configed.getResourceValue("FStartWakeOnLan.creation");
        }
        this.fieldTaskname.setText(this.scheduleTitleStarter + " " + this.readTime(this.cal));
        this.spinnerHour.setValue(this.cal.get(11));
        this.spinnerMinute.setValue(this.cal.get(12));
    }

    @Override
    protected void initComponents() {
        Serializable serializable;
        super.initComponents();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Globals.backLightBlue);
        this.scrollpane = new JScrollPane();
        this.scrollpane.setViewportView(jPanel);
        this.labelTimeYetToWait = new JLabel(de.uib.utilities.Globals.giveTimeSpan(0L), 4);
        this.labelTimeYetToWait.setToolTipText(configed.getResourceValue("FStartWakeOnLan.timeLeft.toolTip"));
        this.waitingProgressBar = new JProgressBar();
        this.waitingProgressBar.setToolTipText(configed.getResourceValue("FStartWakeOnLan.timeElapsed.toolTip"));
        this.waitingProgressBar.setValue(0);
        this.waitingProgressBar.setEnabled(true);
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ProgressBar[Enabled].foregroundPainter", new ProgressBarPainter(Globals.opsiLogoBlue));
        uIDefaults.put("ProgressBar[Enabled].backgroundPainter", new ProgressBarPainter(Globals.opsiLogoLightBlue));
        this.waitingProgressBar.putClientProperty("Nimbus.Overrides", uIDefaults);
        this.fieldTaskname = new JTextField();
        this.fieldTaskname.getDocument().addDocumentListener(new DocumentListener(){

            private void actOnChange() {
                logging.info(this, "changed text");
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.actOnChange();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.actOnChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.actOnChange();
            }
        });
        this.fieldClientCount = new JTextField();
        this.fieldClientCount.setEditable(false);
        this.fieldInvolvedDepotsCount = new JTextField();
        this.fieldInvolvedDepotsCount.setEditable(false);
        int n = 100;
        this.spinnerHour = new JSpinner();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.spinnerHour.getEditor()).getTextField();
        jFormattedTextField.setEditable(false);
        this.spinnerMinute = new JSpinner();
        JFormattedTextField jFormattedTextField2 = ((JSpinner.DefaultEditor)this.spinnerMinute.getEditor()).getTextField();
        jFormattedTextField2.setEditable(false);
        try {
            serializable = new InternationalFormatter(new DecimalFormat("00"));
            ((DefaultFormatterFactory)jFormattedTextField.getFormatterFactory()).setDefaultFormatter((JFormattedTextField.AbstractFormatter)serializable);
            ((DefaultFormatterFactory)jFormattedTextField2.getFormatterFactory()).setDefaultFormatter((JFormattedTextField.AbstractFormatter)serializable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buttonSetNew = new IconButton(configed.getResourceValue("FStartWakeOnLan.buttonSetNew"), "images/reload16.png", "images/reload16_over.png", "images/reload16_disabled.png");
        this.buttonSetNew.setToolTipText(configed.getResourceValue("FStartWakeOnLan.buttonSetNew.tooltip"));
        this.buttonSetNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "actionPerformed");
                FStartWakeOnLan.this.setClients();
            }
        });
        this.buttonRefreshTime = new IconButton(configed.getResourceValue("FStartWakeOnLan.buttonRefreshTime"), "images/clock16.png", "images/clock16.png", "images/clock16.png");
        this.buttonRefreshTime.setToolTipText("Zeit neu setzen");
        this.buttonRefreshTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "actionPerformed");
                FStartWakeOnLan.this.setNowTimeAsTarget();
            }
        });
        this.setNowTimeAsTarget();
        serializable = new JLabel(":");
        JLabel jLabel = new JLabel(configed.getResourceValue("FStartWakeOnLan.delay"));
        JLabel jLabel2 = new JLabel(configed.getResourceValue("FStartWakeOnLan.setTime"));
        JLabel jLabel3 = new JLabel(configed.getResourceValue("FStartWakeOnLan.resultingStartTime"));
        JLabel jLabel4 = new JLabel(configed.getResourceValue("FStartWakeOnLan.countOfClients"));
        JLabel jLabel5 = new JLabel(configed.getResourceValue("FStartWakeOnLan.countOfDepots"));
        this.labelStarttime = new JLabel(this.readTime(this.cal));
        this.spinnerDelay = new JSpinner();
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.spinnerHour, 24, 24, 24).addComponent((Component)serializable, 24, 24, 24).addComponent(this.spinnerMinute, 24, 24, 24));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.spinnerHour, 50, 50, 50).addGap(10, 10, 10).addComponent((Component)serializable, 10, 10, 10).addComponent(this.spinnerMinute, 50, 50, 50));
        this.spinnerHour.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FStartWakeOnLan.this.produceTargetTime(11, Integer.valueOf(FStartWakeOnLan.this.spinnerHour.getValue().toString()));
            }
        });
        this.spinnerMinute.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FStartWakeOnLan.this.produceTargetTime(12, Integer.valueOf(FStartWakeOnLan.this.spinnerMinute.getValue().toString()));
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(jPanel3);
        jPanel3.setLayout(groupLayout2);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup().addComponent(this.spinnerDelay, 24, 24, 24));
        groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addComponent(this.spinnerDelay, 100, 100, 100));
        GroupLayout groupLayout3 = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout3);
        groupLayout3.setVerticalGroup(groupLayout3.createSequentialGroup().addGap(10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fieldTaskname, 24, 24, 24)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.buttonRefreshTime, 24, 24, 24).addComponent(this.buttonSetNew, 24, 24, 24)).addGap(10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 28, 28, 28).addComponent(jPanel3, 28, 28, 28)).addGap(10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jPanel2, 28, 28, 28).addComponent(jLabel2, 28, 28, 28)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel3, 28, 28, 28).addComponent(this.labelStarttime, 28, 28, 28)).addGap(10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4, 28, 28, 28).addComponent(this.fieldClientCount, 28, 28, 28).addComponent(jLabel5, 28, 28, 28).addComponent(this.fieldInvolvedDepotsCount, 28, 28, 28)).addGap(10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.waitingProgressBar, 10, 10, 10).addComponent(this.labelTimeYetToWait, 28, 28, 28)));
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup().addGroup(groupLayout3.createSequentialGroup().addGap(5, 10, Short.MAX_VALUE).addComponent(this.fieldTaskname, 280, 420, 420).addGap(5, 10, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGap(5, 10, Short.MAX_VALUE).addGap(280, 420, 420).addComponent(this.buttonSetNew, 70, 70, 70).addComponent(this.buttonRefreshTime, 70, 70, 70).addGap(5, 10, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGap(10, 10, 10).addComponent(jPanel3, 140, 140, 140).addGap(10, 10, 10).addComponent(jLabel, 280, 280, 420).addGap(10, 10, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGap(10, 10, 10).addComponent(jPanel2, 140, 140, 140).addGap(10, 10, 10).addComponent(jLabel2, -2, -2, -2)).addGroup(groupLayout3.createSequentialGroup().addGap(10, 10, 10).addGap(140, 140, 140).addGap(10, 10, 10).addComponent(jLabel3, -2, -2, -2).addGap(10, 10, 10).addComponent(this.labelStarttime, 140, 280, 280).addGap(10, 10, Short.MAX_VALUE)).addGroup(groupLayout3.createSequentialGroup().addGap(10).addGap(140).addGap(10).addComponent(jLabel4, -2, -2, -2).addGap(5).addComponent(this.fieldClientCount, n, n, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(jLabel5, -2, -2, -2).addGap(5).addComponent(this.fieldInvolvedDepotsCount, n, n, Short.MAX_VALUE).addGap(10)).addGroup(groupLayout3.createSequentialGroup().addGap(10).addComponent(this.waitingProgressBar, 280, 280, Short.MAX_VALUE).addGap(10).addComponent(this.labelTimeYetToWait, 140, 140, 140).addGap(10)));
    }

    private void startAction() {
        this.waitingMode = false;
        if (this.spinnerDelay.getValue() == this.nullDelayValue) {
            this.main.wakeUp(this.currentlySelectedClients, this.scheduleTitle);
        } else {
            this.main.wakeUpWithDelay(this.labelledDelays.get((String)this.spinnerDelay.getValue()), this.currentlySelectedClients, this.scheduleTitle);
        }
        this.leave();
    }

    private void startWaiting() {
        if (this.waitingTask != null) {
            this.waitingTask.stop();
        }
        this.waitingMode = true;
        logging.info(this, "startWaiting " + runningInstances);
        runningInstances.add(this, this.scheduleTitle);
        this.waitingTask = new WaitingWorker(this);
        this.waitingTask.execute();
    }

    @Override
    public void actAfterWaiting() {
        this.startAction();
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.waitingProgressBar;
    }

    @Override
    public JLabel getLabel() {
        return this.labelTimeYetToWait;
    }

    @Override
    public long getStartActionMillis() {
        return this.startActionMillis;
    }

    @Override
    public long getWaitingMillis() {
        return this.waitingMillis;
    }

    @Override
    public long getOneProgressBarLengthWaitingMillis() {
        return this.waitingMillis;
    }

    @Override
    public String setLabellingStrategy(long l) {
        return " " + configed.getResourceValue("FStartWakeOnLan.timeLeft") + "  " + de.uib.utilities.Globals.giveTimeSpan(this.getWaitingMillis() - l);
    }

    @Override
    public void doAction1() {
        logging.info(this, "doAction1");
        if (this.currentlySelectedClients == null || this.currentlySelectedClients.length == 0) {
            JOptionPane.showMessageDialog(this, configed.getResourceValue("FStartWakeOnLan.noClientsSelected.text"), configed.getResourceValue("FStartWakeOnLan.noClientsSelected.title"), 1);
            return;
        }
        this.disableSettingOfTimes();
        this.scheduleTitle = this.fieldTaskname.getText();
        if (this.scheduleTitle.startsWith(this.scheduleTitleStarter)) {
            this.scheduleTitle = this.scheduleTitle.substring(this.scheduleTitleStarter.length());
        }
        this.scheduleTitle = "  scheduler" + this.scheduleTitle;
        this.startActionMillis = new GregorianCalendar().getTimeInMillis();
        this.waitingMillis = this.cal.getTimeInMillis() - this.startActionMillis;
        if (this.waitingMillis < 0L) {
            this.waitingMillis = 0L;
        }
        if (this.waitingMillis < 100L) {
            this.startAction();
        } else {
            this.startWaiting();
        }
    }

    @Override
    public void leave() {
        boolean bl = true;
        logging.info(this, "leave  with runningInstances " + runningInstances);
        logging.info(this, "leave  waitingMode  " + this.waitingMode);
        if (this.waitingMode) {
            int n = 1;
            n = JOptionPane.showOptionDialog(this, configed.getResourceValue("FStartWakeOnLan.allowClose"), configed.getResourceValue("FStartWakeOnLan.allowClose.title"), 0, 3, null, null, null);
            bl = n == 0;
        }
        logging.info(this, "leave  reallyLeave  " + bl);
        if (bl) {
            logging.info(this, "waitingTask != null " + (this.waitingTask != null));
            if (this.waitingTask != null) {
                this.waitingTask.stop();
            }
            runningInstances.forget(this);
            super.leave();
        }
    }

    @Override
    public void doAction2() {
        logging.info(this, "doAction2");
        this.leave();
    }
}

