/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.backends.opsidatamodel.operations;

import de.uib.configed.clientselection.Client;
import de.uib.configed.clientselection.ExecutableOperation;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.backends.opsidatamodel.OpsiDataClient;
import de.uib.configed.clientselection.operations.BigIntGreaterOrEqualOperation;
import de.uib.utilities.logging.logging;
import java.util.Map;

public class OpsiDataBigIntGreaterOrEqualOperation
extends BigIntGreaterOrEqualOperation
implements ExecutableOperation {
    private String map;
    private String key;
    private long data;

    public OpsiDataBigIntGreaterOrEqualOperation(String string, String string2, long l, SelectElement selectElement) {
        super(selectElement);
        this.map = string;
        this.key = string2;
        this.data = l;
    }

    @Override
    public boolean doesMatch(Client client) {
        OpsiDataClient opsiDataClient = (OpsiDataClient)client;
        Map map = opsiDataClient.getMap(this.map);
        if (!map.containsKey(this.key) || map.get(this.key) == null) {
            logging.debug(this, "key " + this.key + " not found!");
            return false;
        }
        Object v = map.get(this.key);
        if (v instanceof Long) {
            if ((Long)v >= this.data) {
                return true;
            }
        } else if (v instanceof Integer) {
            if ((long)((Integer)v).intValue() >= this.data) {
                return true;
            }
        } else {
            logging.error(this, "data is no BigInteger!" + v);
        }
        return false;
    }
}

