/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table;

import de.uib.utilities.Mapping;
import de.uib.utilities.logging.logging;
import de.uib.utilities.table.ChainedTableModelFilter;
import de.uib.utilities.table.KeyRepresenter;
import de.uib.utilities.table.RowMap;
import de.uib.utilities.table.RowStringMap;
import de.uib.utilities.table.TableModelFilter;
import de.uib.utilities.table.TableModelFilterCondition;
import de.uib.utilities.table.TableModelFunctions;
import de.uib.utilities.table.provider.TableProvider;
import de.uib.utilities.table.updates.TableUpdateCollection;
import de.uib.utilities.table.updates.TableUpdateItemFactory;
import de.uib.utilities.thread.ReadyFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class GenTableModel
extends AbstractTableModel
implements TableModelFunctions {
    protected int rowsLength;
    protected int colsLength;
    protected Vector<String> columnNames;
    protected Vector<String> classNames;
    protected Vector<Vector<Object>> rows;
    protected Vector<Integer> addedRows;
    protected Vector<Integer> updatedRows;
    protected Vector<Integer> finalCols;
    protected boolean[] colEditable;
    protected int keyCol = -1;
    protected TableUpdateCollection updates;
    protected String tableName = this.tableName;
    protected boolean modelDataValid;
    protected boolean modelStructureValid;
    protected TableProvider tableProvider;
    protected TableUpdateItemFactory itemFactory;
    protected int saveUpdatesSize;
    protected final ChainedTableModelFilter chainedFilter;
    protected final TableModelFilter emptyFilter;
    private TableModelFilter workingFilter;
    public static final String DEFAULT_FILTER_NAME = "default";
    protected KeyRepresenter<Integer> keyRepresenter;
    protected Map<TableModelFunctions.PairOfInt, Map<Object, List<Object>>> functions;
    protected Map<Integer, RowStringMap> primarykey2Rowmap;
    protected Map<Integer, String> primarykeyTranslation;
    protected Mapping<Integer, String> primarykeyRepresentation;
    protected Map<TableModelFunctions.PairOfInt, Map<Integer, Mapping<Integer, String>>> xFunctions;

    public GenTableModel(TableUpdateItemFactory tableUpdateItemFactory, TableProvider tableProvider, int n, int[] nArray, TableModelListener tableModelListener, TableUpdateCollection tableUpdateCollection) {
        this.keyCol = n;
        this.updates = tableUpdateCollection;
        this.tableProvider = tableProvider;
        this.itemFactory = tableUpdateItemFactory;
        this.initColumns();
        this.rows = tableProvider.getRows();
        this.addedRows = new Vector();
        this.updatedRows = new Vector();
        this.finalCols = new Vector();
        if (nArray == null) {
            if (n > -1) {
                this.finalCols.add(n);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.finalCols.add(nArray[i]);
            }
        }
        this.modelDataValid = false;
        this.modelStructureValid = true;
        this.rowsLength = this.rows == null ? 0 : this.rows.size();
        if (tableModelListener != null) {
            this.addTableModelListener(tableModelListener);
        }
        this.chainedFilter = new ChainedTableModelFilter();
        this.emptyFilter = new TableModelFilter();
        this.setFilter(this.chainedFilter);
    }

    public GenTableModel(TableUpdateItemFactory tableUpdateItemFactory, TableProvider tableProvider, int n, TableModelListener tableModelListener, TableUpdateCollection tableUpdateCollection) {
        this(tableUpdateItemFactory, tableProvider, n, null, tableModelListener, tableUpdateCollection);
    }

    public void clear() {
        this.colsLength = 0;
        this.rowsLength = 0;
        this.colEditable = new boolean[0];
        if (this.columnNames != null) {
            this.columnNames.clear();
        }
        if (this.classNames != null) {
            this.classNames.clear();
        }
        if (this.rows != null) {
            this.rows.clear();
        }
        this.clearUpdates();
        this.fireTableStructureChanged();
    }

    protected void initColumns() {
        this.columnNames = this.tableProvider.getColumnNames();
        logging.debug(this, "initColumns " + this.columnNames);
        this.classNames = this.tableProvider.getClassNames();
        this.colsLength = this.columnNames == null ? 0 : this.columnNames.size();
        this.colEditable = new boolean[this.colsLength];
    }

    public Vector<String> getColumnNames() {
        this.columnNames = this.tableProvider.getColumnNames();
        this.colsLength = this.columnNames.size();
        return this.columnNames;
    }

    public Vector<String> getClassNames() {
        this.classNames = this.tableProvider.getClassNames();
        return this.classNames;
    }

    public int getKeyCol() {
        return this.keyCol;
    }

    public void setKeyCol(int n) {
        this.keyCol = n;
    }

    public Vector<Integer> getFinalCols() {
        return this.finalCols;
    }

    public void invalidate() {
        this.tableProvider.requestReturnToOriginal();
        this.modelDataValid = false;
        this.requestRefreshDerivedMaps();
    }

    public boolean isReloadRequested() {
        return !this.modelDataValid;
    }

    public void requestReload() {
        this.modelDataValid = false;
        this.requestRefreshDerivedMaps();
        this.tableProvider.requestReloadRows();
    }

    public void structureChanged() {
        this.tableProvider.structureChanged();
        this.modelStructureValid = false;
        this.requestReload();
    }

    public void startWithCurrentData() {
        this.tableProvider.setWorkingCopyAsNewOriginalRows();
        this.invalidate();
    }

    public void removeUpdates() {
        int n = this.updates.size();
        for (int i = n - 1; i >= this.saveUpdatesSize; --i) {
            this.updates.remove(i);
        }
        this.updatedRows.clear();
        this.invalidate();
    }

    public void setFilter(TableModelFilter tableModelFilter) {
        this.workingFilter = tableModelFilter;
    }

    public void setFilterCondition(TableModelFilterCondition tableModelFilterCondition) {
        this.clearFilter();
        this.chainedFilter.add(DEFAULT_FILTER_NAME, new TableModelFilter(tableModelFilterCondition));
    }

    public void clearFilter() {
        this.chainedFilter.clear();
    }

    public GenTableModel chainFilter(String string, TableModelFilter tableModelFilter) {
        this.chainedFilter.add(string, tableModelFilter);
        return this;
    }

    public Set<Object> getExistingKeys() {
        int n = this.getKeyCol();
        if (n < 0) {
            return null;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, n) == null) continue;
            treeSet.add(this.getValueAt(i, n));
        }
        return treeSet;
    }

    protected void produceRows() {
        logging.info(this, " ---  produce rows");
        this.rows = this.tableProvider.getRows();
        logging.debug(this, "produceRows(): count  " + this.rows.size());
        this.rowsLength = this.rows.size();
        this.getColumnNames();
        logging.debug(this, " ---  rows produced, columnNames: " + this.columnNames);
        logging.debug(this, " --- using workingfilter  " + this.workingFilter);
        if (this.workingFilter != null && this.workingFilter.isInUse()) {
            Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
            for (Vector<Object> vector2 : this.rows) {
                if (!this.workingFilter.test(vector2)) continue;
                vector.add(vector2);
            }
            this.rows = vector;
            this.rowsLength = this.rows.size();
        }
    }

    protected void refresh() {
        if (!this.modelDataValid) {
            this.produceRows();
            if (!this.modelStructureValid) {
                this.initColumns();
                this.fireTableStructureChanged();
                this.modelStructureValid = true;
            }
            this.fireTableDataChanged();
            this.modelDataValid = true;
        }
    }

    public boolean isUsingFilter(String string) {
        return this.chainedFilter.getElement(string).isInUse();
    }

    public void setUsingFilter(String string, boolean bl) {
        logging.debug(this, "setUsingFilter " + string + " to " + bl);
        if (this.isUsingFilter(string) != bl) {
            this.invalidate();
            this.chainedFilter.getElement(string).setInUse(bl);
            this.reset();
        }
    }

    public void toggleFilter(String string) {
        this.setUsingFilter(string, !this.isUsingFilter(string));
    }

    private void clearUpdates() {
        this.addedRows.clear();
        this.updatedRows.clear();
        this.saveUpdatesSize = this.updates == null ? 0 : this.updates.size();
    }

    public void threadedReset(final ReadyFlag readyFlag) {
        new Thread(){

            @Override
            public void run() {
                GenTableModel.this.reset();
                readyFlag.ready = true;
            }
        }.start();
    }

    public void reset() {
        logging.info(this, "reset()");
        this.requestRefreshDerivedMaps();
        this.refresh();
        this.clearUpdates();
    }

    public void setEditableColumns(int[] nArray) {
        int n;
        for (n = 0; n < this.colsLength; ++n) {
            this.colEditable[n] = false;
        }
        if (nArray == null) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            this.colEditable[nArray[n]] = true;
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.colsLength;
    }

    @Override
    public int getRowCount() {
        return this.rowsLength;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.rows.get(n).get(n2);
    }

    public Vector<Object> getRow(int n) {
        return this.rows.get(n);
    }

    public RowStringMap getRowStringMap(int n) {
        RowStringMap rowStringMap = new RowStringMap();
        for (int i = 0; i < this.getColumnNames().size(); ++i) {
            rowStringMap.put(this.getColumnName(i), "" + this.getValueAt(n, i));
        }
        return rowStringMap;
    }

    public RowMap<String, Object> getRowMap(int n) {
        RowMap<String, Object> rowMap = new RowMap<String, Object>();
        for (int i = 0; i < this.getColumnNames().size(); ++i) {
            Object object = this.getValueAt(n, i);
            object = object == null ? "" : "" + object;
            rowMap.put(this.getColumnName(i), object);
        }
        return rowMap;
    }

    public Vector<Object> getColumn(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.rowsLength; ++i) {
            vector.add(this.getValueAt(i, n));
        }
        return vector;
    }

    public Vector<String> getOrderedColumn(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.rowsLength; ++i) {
            treeSet.add((String)this.getValueAt(i, n));
        }
        Vector<String> vector = new Vector<String>(treeSet);
        return vector;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.addedRows.indexOf(n) == -1 && this.finalCols.indexOf(n2) > -1) {
            return false;
        }
        return this.colEditable[n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = "" + this.rows.get(n).get(n2);
        String string2 = "" + object;
        boolean bl = (this.rows.get(n).get(n2) != null || object != null && !object.equals("")) && !string.equals(string2);
        if (bl) {
            if (this.addedRows.indexOf(n) == -1 && this.updatedRows.indexOf(n) == -1) {
                Vector vector = (Vector)this.rows.get(n).clone();
                this.rows.get(n).setElementAt(object, n2);
                if (this.itemFactory == null) {
                    logging.info("update item factory missing");
                } else if (this.updates == null) {
                    logging.info("updates not initialized");
                } else {
                    this.updates.add(this.itemFactory.produceUpdateItem(vector, this.rows.get(n)));
                }
                this.updatedRows.add(n);
            }
            if (this.addedRows.indexOf(n) == -1 && this.finalCols.indexOf(n2) > -1) {
                logging.debugOut(2, "key column cannot be edited after saving the data");
                JOptionPane.showMessageDialog(null, "values in this column are fixed after saving the data", "Information", 0);
                return;
            }
            this.rows.get(n).setElementAt(object, n2);
            this.fireTableCellUpdated(n, n2);
            this.requestRefreshDerivedMaps();
        }
    }

    public void updateRowValues(int n, Map<String, Object> map) {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            Object object = map.get(this.getColumnName(i));
            if (object == null) continue;
            this.setValueAt(object, n, i);
        }
    }

    public void setRow(int n, Object[] objectArray) {
        int n2 = 0;
        if (this.colsLength != objectArray.length) {
            logging.info("update row values less than than row elements");
        }
        while (n2 < this.colsLength && n2 < objectArray.length) {
            this.setValueAt(objectArray[n2], n, n2);
            ++n2;
        }
    }

    public void addRow(Vector<Object> vector) {
        logging.debug(this, "--- addRow size, row " + vector.size() + ", " + vector);
        this.rows.add(vector);
        this.addedRows.add(this.rowsLength);
        this.updates.add(this.itemFactory.produceInsertItem(vector));
        this.requestReload();
        ++this.rowsLength;
        try {
            this.fireTableRowsInserted(this.rowsLength - 1, this.rowsLength - 1);
        }
        catch (Exception exception) {
            logging.logTrace(exception);
            logging.info(this, "addRow exception " + exception + " row " + vector);
        }
        this.requestRefreshDerivedMaps();
    }

    public void addRow(Object[] objectArray) {
        int n;
        Vector<Object> vector = new Vector<Object>();
        for (n = 0; n < this.colsLength; ++n) {
            vector.add(null);
        }
        for (n = 0; n < objectArray.length; ++n) {
            vector.set(n, objectArray[n]);
        }
        this.addRow(vector);
    }

    public Vector<Object> produceValueRowFromSomeEntries(RowMap rowMap) {
        logging.debug(this, "produceValueRowFromSomeEntries " + rowMap);
        Vector<Object> vector = new Vector<Object>();
        for (String string : this.columnNames) {
            if (rowMap.get(string) != null) {
                vector.add(rowMap.get(string));
                continue;
            }
            vector.add(null);
        }
        return vector;
    }

    private boolean checkDeletionOfAddedRow(int n) {
        if (this.addedRows.indexOf(n) > -1) {
            logging.info(this, "no deletion of added rows");
            JOptionPane.showMessageDialog(null, "no deletion of added rows, please save or cancel editing", "Information", 0);
            return false;
        }
        return true;
    }

    public void deleteRows(int[] nArray) {
        int n;
        logging.debug(this, "deleteRows " + Arrays.toString(nArray));
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Arrays.sort(nArray);
        logging.debug(this, "deleteRows, sorted " + Arrays.toString(nArray));
        if (this.updates == null) {
            logging.info(this, "updates not initialized");
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (this.checkDeletionOfAddedRow(nArray[n])) continue;
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            Vector vector = (Vector)this.rows.get(nArray[n]).clone();
            logging.debug(this, "deleteRow values " + vector);
            this.updates.add(this.itemFactory.produceDeleteItem(vector));
            if (this.updatedRows.indexOf(nArray[n]) <= -1) continue;
            logging.debug(this, "deleteRows, remove from updatedRows  " + this.updatedRows.indexOf(n));
            this.updatedRows.remove(this.updatedRows.indexOf(nArray[n]));
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            this.rows.remove(nArray[n]);
            --this.rowsLength;
            this.fireTableRowsDeleted(nArray[n], nArray[n]);
        }
        this.requestRefreshDerivedMaps();
    }

    public void deleteRow(int n) {
        logging.debug(this, "deleteRow " + n);
        if (this.rows.get(n) == null) {
            logging.info(this, "delete row null ");
            return;
        }
        if (this.updates == null) {
            logging.info(this, "updates not initialized");
            return;
        }
        if (!this.checkDeletionOfAddedRow(n)) {
            return;
        }
        Vector vector = (Vector)this.rows.get(n).clone();
        logging.debug(this, "deleteRow values " + vector);
        this.updates.add(this.itemFactory.produceDeleteItem(vector));
        if (this.updatedRows.indexOf(n) > -1) {
            logging.debug(this, "deleteRow, remove from updatedRows  " + this.updatedRows.indexOf(n));
            this.updatedRows.remove(this.updatedRows.indexOf(n));
        }
        this.rows.remove(n);
        --this.rowsLength;
        this.fireTableRowsDeleted(n, n);
        this.requestRefreshDerivedMaps();
        logging.debug(this, "deleted row " + vector);
    }

    public boolean isRowAdded(int n) {
        return this.addedRows.indexOf(n) > -1;
    }

    public boolean someRowAdded(int[] nArray) {
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; !bl && i < nArray.length; ++i) {
                if (this.addedRows.indexOf(nArray[i]) <= -1) continue;
                bl = true;
            }
        }
        return bl;
    }

    private Map<Object, List<Object>> buildFunction(int n, int n2, TableModelFilterCondition tableModelFilterCondition) {
        boolean bl;
        HashMap<Object, List<Object>> hashMap = new HashMap<Object, List<Object>>();
        boolean bl2 = bl = this.workingFilter != null && this.workingFilter.isInUse();
        if (tableModelFilterCondition != null) {
            this.setFilter(new TableModelFilter(tableModelFilterCondition));
            this.produceRows();
        } else if (bl) {
            this.setFilter(this.emptyFilter);
            this.produceRows();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object;
            Object object2 = this.getValueAt(i, n);
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(object2, arrayList);
            }
            if (arrayList.indexOf(object = this.getValueAt(i, n2)) != -1) continue;
            arrayList.add(object);
        }
        this.setFilter(this.chainedFilter);
        if (tableModelFilterCondition != null || bl) {
            this.produceRows();
        }
        return hashMap;
    }

    public boolean existsStringValueInCol(String string, int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.getRowCount()) {
            String string2 = "" + this.getValueAt(n2, n);
            if (string2.equals(string)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    public boolean existsValueInCol(Object object, int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.getRowCount()) {
            Object object2 = this.getValueAt(n2, n);
            if (object2.equals(object)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    protected void requestRefreshDerivedMaps() {
        this.functions = null;
        this.primarykey2Rowmap = null;
        this.primarykeyTranslation = null;
        this.primarykeyRepresentation = null;
        this.xFunctions = null;
    }

    @Override
    public Map<Object, List<Object>> getFunction(int n, int n2) {
        return this.getFunction(n, n2, null);
    }

    public Map<Object, List<Object>> getFunction(int n, int n2, TableModelFilterCondition tableModelFilterCondition) {
        Map<Object, List<Object>> map;
        TableModelFunctions.PairOfInt pairOfInt = new TableModelFunctions.PairOfInt(n, n2);
        if (this.functions == null) {
            this.functions = new HashMap<TableModelFunctions.PairOfInt, Map<Object, List<Object>>>();
        }
        if ((map = this.functions.get(pairOfInt)) == null) {
            map = this.buildFunction(pairOfInt.col1, pairOfInt.col2, tableModelFilterCondition);
        }
        return map;
    }

    @Override
    public Map<Integer, RowStringMap> getPrimarykey2Rowmap() {
        if (this.keyCol < 0) {
            return null;
        }
        if (this.primarykey2Rowmap != null) {
            return this.primarykey2Rowmap;
        }
        this.primarykey2Rowmap = new HashMap<Integer, RowStringMap>();
        for (int i = 0; i < this.rows.size(); ++i) {
            Integer n = Integer.valueOf((String)this.getValueAt(i, this.keyCol));
            this.primarykey2Rowmap.put(n, this.getRowStringMap(i));
        }
        return this.primarykey2Rowmap;
    }

    @Override
    public void setKeyRepresenter(KeyRepresenter keyRepresenter) {
        this.keyRepresenter = keyRepresenter;
    }

    @Override
    public Map<Integer, String> getPrimarykeyTranslation() {
        if (this.keyCol < 0) {
            return null;
        }
        if (this.keyRepresenter == null) {
            return null;
        }
        if (this.primarykeyTranslation != null) {
            return this.primarykeyTranslation;
        }
        this.primarykeyTranslation = new HashMap<Integer, String>();
        for (int i = 0; i < this.rows.size(); ++i) {
            try {
                Integer n = Integer.valueOf((String)this.getValueAt(i, this.keyCol));
                String string = this.primarykeyTranslation.put(n, this.keyRepresenter.represents(n, this.getPrimarykey2Rowmap().get(n)));
                continue;
            }
            catch (Exception exception) {
                logging.info(this, "getPrimarykeyTranslation()  " + this.getValueAt(i, this.keyCol) + " " + exception);
            }
        }
        return this.primarykeyTranslation;
    }

    @Override
    public Mapping<Integer, String> getPrimarykeyRepresentation() {
        if (this.getPrimarykeyTranslation() == null) {
            return null;
        }
        if (this.primarykeyRepresentation != null) {
            return this.primarykeyRepresentation;
        }
        this.primarykeyRepresentation = new Mapping<Integer, String>(this.primarykeyTranslation);
        return this.primarykeyRepresentation;
    }

    public Map<Integer, Mapping<Integer, String>> getID2Mapping(int n, int n2, Mapping mapping) {
        Map<Object, List<Object>> map;
        TableModelFunctions.PairOfInt pairOfInt = new TableModelFunctions.PairOfInt(n, n2);
        if (this.xFunctions == null) {
            this.xFunctions = new HashMap<TableModelFunctions.PairOfInt, Map<Integer, Mapping<Integer, String>>>();
        }
        if ((map = this.getFunction(n, n2)) == null) {
            return null;
        }
        Map<Integer, Mapping<Integer, String>> map2 = this.xFunctions.get(pairOfInt);
        if (map2 == null) {
            map2 = new HashMap<Integer, Mapping<Integer, String>>();
            for (Object object : map.keySet()) {
                Integer n3 = (Integer)object;
                map2.put(n3, mapping.restrictedTo(new HashSet<Object>(map.get(object))));
            }
        }
        return map2;
    }
}

